	-- Spider Wing
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_AnubRekhan_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Faerlina_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Maexxna_OnLoad");

	-- Necro Wing
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRNoth_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRHeigan_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRLoatheb_OnLoad");

	-- Deathknight Wing
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRRazuvious_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRGothik_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRHorsemen_OnLoad");

	-- Abomination Wing
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRPatchwerk_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Grobbulus_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRGluth_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_MRThaddius_OnLoad");


-- Anub'Rekhan
function CT_RABoss_AnubRekhan_End()
	CT_RABoss_UnSchedule("CT_RABoss_AnubRekhan_EventHandler");
	CT_RABoss_UnSchedule("CT_RABoss_AnubRekhan_EventHandler");
	CT_RABoss_UnSchedule("CT_RABoss_AnubRekhan_EventHandler");

	CT_RABoss_Mods["阿努布雷坎"]["fight"] = nil;
	CT_RABoss_Mods["阿努布雷坎"]["lastAction"] = nil;

	CT_RABoss_VisualTimer.removeTimer("AnubLocustSwarm");
end

function CT_RABoss_AnubRekhan_OnLoad()
	CT_RABoss_AddMod("阿努布雷坎", CT_RABOSS_ANUBREKHAN_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	
	CT_RABoss_AddEvent("阿努布雷坎", "CHAT_MSG_COMBAT_FRIENDLY_DEATH", CT_RABoss_AnubRekhan_EventHandler);
	CT_RABoss_AddEvent("阿努布雷坎", "CHAT_MSG_COMBAT_HOSTILE_DEATH", CT_RABoss_AnubRekhan_EventHandler);
	CT_RABoss_AddEvent("阿努布雷坎", "CHAT_MSG_MONSTER_YELL", CT_RABoss_AnubRekhan_EventHandler);
	CT_RABoss_AddEvent("阿努布雷坎", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_AnubRekhan_EventHandler);
	CT_RABoss_AddEvent("阿努布雷坎", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_AnubRekhan_EventHandler);
	CT_RABoss_AddEvent("阿努布雷坎", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_AnubRekhan_EventHandler);
 
	CT_RABoss_AddDropDownButton("阿努布雷坎", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("阿努布雷坎", { CT_RABOSS_ANUBREKHAN_DEATH, CT_RABOSS_ANUBREKHAN_DEATH_INFO}, "CT_RABoss_ModInfo", "playerDeath", "CT_RABoss_SetInfo");

	CT_RA_RegisterSlashCmd("/anubstop", CT_RABOSS_CMD_ANUBSTOP, 30, "ANUBSTOP", function()
		CT_RABoss_AnubRekhan_End();
	end, "/anubstop");

	CT_RABoss_Mods["阿努布雷坎"]["fight"] = nil;
	CT_RABoss_Mods["阿努布雷坎"]["lastAction"] = nil;

end

function CT_RABoss_AnubRekhan_LocustSwarm()
	CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SWARM_PREALERT, "90", "100"), CT_RABoss_Mods["阿努布雷坎"]["announce"]);
	CT_RABoss_PlaySound(2);

	CT_RABoss_Mods["阿努布雷坎"]["fight"] = 1;
	CT_RABoss_Mods["阿努布雷坎"]["lastAction"] = GetTime();

	CT_RABoss_Schedule("CT_RABoss_AnubRekhan_EventHandler", 60, "locustSwarmPreWarn30");
	CT_RABoss_Schedule("CT_RABoss_AnubRekhan_EventHandler", 75, "locustSwarmPreWarn15");
	CT_RABoss_Schedule("CT_RABoss_AnubRekhan_EventHandler", 85, "locustSwarmPreWarn5");
end

function CT_RABoss_AnubRekhan_EventHandler(event)
	if ( not CT_RABoss_Mods["阿努布雷坎"] or not CT_RABoss_Mods["阿努布雷坎"]["status"] or not CT_RABoss_Mods["阿努布雷坎"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" and arg2 == CT_RABOSS_NAMES["阿努布雷坎"] ) then
		if ( string.find(arg1, CT_RABOSS_ANUBREKHAN_YELL1_DETECT) or string.find(arg1, CT_RABOSS_ANUBREKHAN_YELL2_DETECT) or string.find(arg1, CT_RABOSS_ANUBREKHAN_YELL3_DETECT) ) then
			CT_RABoss_AnubRekhan_LocustSwarm();
		end

	elseif ( (event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF") and string.find(arg1, CT_RABOSS_ANUBREKHAN_SWARM_CAST_DETECT) ) then
		CT_RABoss_Announce(CT_RABOSS_ANUBREKHAN_SWARM_IMMINENT_ALERT, CT_RABoss_Mods["阿努布雷坎"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_VisualTimer.addTimer("AnubLocustSwarm", 23, CT_RABOSS_ANUBREKHAN_SWARMEND_TIMER);

		CT_RABoss_UnSchedule("CT_RABoss_AnubRekhan_EventHandler", "locustSwarmPreWarn30");
		CT_RABoss_UnSchedule("CT_RABoss_AnubRekhan_EventHandler", "locustSwarmPreWarn15");
		CT_RABoss_UnSchedule("CT_RABoss_AnubRekhan_EventHandler", "locustSwarmPreWarn5");
		CT_RABoss_Schedule("CT_RABoss_AnubRekhan_EventHandler", 13, "locustSwarmEndWarn10");
		CT_RABoss_Schedule("CT_RABoss_AnubRekhan_EventHandler", 20, "locustSwarmEndWarn3");

		CT_RABoss_AnubRekhan_LocustSwarm();

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and string.find(arg1, CT_RABOSS_ANUBREKHAN_SWARM_GAIN_DETECT) ) then
		CT_RABoss_Announce(CT_RABOSS_ANUBREKHAN_SWARM_ALERT, CT_RABoss_Mods["阿努布雷坎"]["announce"]);
		CT_RABoss_Mods["阿努布雷坎"]["lastAction"] = GetTime();
		CT_RABoss_PlaySound(3);

	elseif ( event == "locustSwarmPreWarn30" ) then
		CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SWARM_PREALERT, "30", "40"), CT_RABoss_Mods["阿努布雷坎"]["announce"]);

	elseif ( event == "locustSwarmPreWarn15" ) then
		CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SWARM_PREALERT, "15", "25"), CT_RABoss_Mods["阿努布雷坎"]["announce"]);

	elseif ( event == "locustSwarmPreWarn5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SWARM_PREALERT, "5", "15"), CT_RABoss_Mods["阿努布雷坎"]["announce"]);
		CT_RABoss_PlaySound(1);

	elseif ( event == "locustSwarmEndWarn10" ) then
		CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SWARM_END_PREALERT, "10"), CT_RABoss_Mods["阿努布雷坎"]["announce"]);

	elseif ( event == "locustSwarmEndWarn3" ) then
		CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SWARM_END_PREALERT, "3"), CT_RABoss_Mods["阿努布雷坎"]["announce"]);
		CT_RABoss_PlaySound(1);

	end

	if ( event == "CHAT_MSG_COMBAT_FRIENDLY_DEATH" and CT_RABoss_Mods["阿努布雷坎"]["playerDeath"] and CT_RABoss_Mods["阿努布雷坎"]["fight"] ) then
		if ( not CT_RABoss_Mods["阿努布雷坎"]["lastAction"] or (GetTime() - CT_RABoss_Mods["阿努布雷坎"]["lastAction"] > 120) ) then
			CT_RABoss_AnubRekhan_End();
			return;
		end

		local _, _, nameSelf = string.find(arg1, CT_RABOSS_ANUBREKHAN_DEATHSELF_DETECT);
		local _, _, name = string.find(arg1, CT_RABOSS_ANUBREKHAN_DEATHPLAYER_DETECT);

		if ( name ~= nil ) then
			CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SCARAB_SPAWN_ALERT, name), CT_RABoss_Mods["阿努布雷坎"]["announce"]);

		elseif ( nameSelf == CT_RABOSS_SELF1 ) then
			name = UnitName("player");
			CT_RABoss_Announce(format(CT_RABOSS_ANUBREKHAN_SCARAB_SPAWN_ALERT, name), CT_RABoss_Mods["阿努布雷坎"]["announce"]);
		end
	end

	if ( event == "CHAT_MSG_COMBAT_HOSTILE_DEATH" and string.find(arg1, CT_RABOSS_ANUBREKHAN_DEATH_DETECT) ) then
		CT_RABoss_AnubRekhan_End();
	end

end



-- Grand Widow Faerlina (19/08/2006) - Changed naming.
-- Faerlina
function CT_RABoss_Faerlina_OnLoad()
	CT_RABoss_AddMod("黑女巫法琳娜", CT_RABOSS_FAERLINA_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("黑女巫法琳娜", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Faerlina_EventHandler);
	CT_RABoss_AddEvent("黑女巫法琳娜", "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE", CT_RABoss_Faerlina_EventHandler);

	CT_RABoss_AddDropDownButton("黑女巫法琳娜", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Faerlina_UnSchedule()
	CT_RABoss_UnSchedule("CT_RABoss_Faerlina_EventHandler", "enrage30");
	CT_RABoss_UnSchedule("CT_RABoss_Faerlina_EventHandler", "enrage15");
	CT_RABoss_UnSchedule("CT_RABoss_Faerlina_EventHandler", "enrage5");
	CT_RABoss_UnSchedule("CT_RABoss_Faerlina_EventHandler", "enrageready");
end

function CT_RABoss_Faerlina_EventHandler(event)
	if ( not CT_RABoss_Mods["黑女巫法琳娜"] or not CT_RABoss_Mods["黑女巫法琳娜"]["status"] or not CT_RABoss_Mods["黑女巫法琳娜"].enabled ) then
		return;
	end

	if ( CT_RABoss_Mods["黑女巫法琳娜"]["engaged"] and ( not CT_RABoss_Mods["黑女巫法琳娜"]["lastaction"] or ( time() - CT_RABoss_Mods["黑女巫法琳娜"]["lastaction"] ) > 120 ) ) then
		CT_RABoss_Mods["黑女巫法琳娜"]["engaged"] = false;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( arg1 == CT_RABOSS_FAERLINA_YELL1 or arg1 == CT_RABOSS_FAERLINA_YELL2 or arg1 == CT_RABOSS_FAERLINA_YELL3 or arg1 == CT_RABOSS_FAERLINA_YELL4 ) then
			if ( not CT_RABoss_Mods["黑女巫法琳娜"]["engaged"] ) then
				CT_RABoss_Announce(CT_RABOSS_FAERLINA_ENGAGE, CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
				CT_RABoss_PlaySound(3);
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 30, "enrage30");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 45, "enrage15");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 55, "enrage5");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 60, "enrageready");
				CT_RABoss_VisualTimer.addTimer("FaerlinaEnrage", 60, CT_RABOSS_FAERLINA_ENRAGE_TIMER);
				CT_RABoss_Mods["黑女巫法琳娜"]["engaged"] = true;
				CT_RABoss_Mods["黑女巫法琳娜"]["enraged"] = false;
				CT_RABoss_Mods["黑女巫法琳娜"]["silenced"] = false;
			else
				CT_RABoss_Announce(CT_RABOSS_FAERLINA_ENRAGE_ALERT, CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
				CT_RABoss_PlaySound(2);
				CT_RABoss_Faerlina_UnSchedule()
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 30, "enrage30");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 45, "enrage15");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 55, "enrage5");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 60, "enrageready");
				CT_RABoss_VisualTimer.addTimer("FaerlinaEnrage", 60, CT_RABOSS_FAERLINA_ENRAGE_TIMER);
				CT_RABoss_Mods["黑女巫法琳娜"]["enraged"] = true;
				CT_RABoss_Mods["黑女巫法琳娜"]["silenced"] = false;
				CT_RABoss_Mods["黑女巫法琳娜"]["enragetimer"] = time();
			end
		elseif ( arg1 == CT_RABOSS_FAERLINA_END ) then
			CT_RABoss_Mods["黑女巫法琳娜"]["engaged"] = false;
			CT_RABoss_Faerlina_UnSchedule();
			CT_RABoss_VisualTimer.removeTimer("FaerlinaEnrage");
			CT_RABoss_VisualTimer.removeTimer("FaerlinaSilenced");
		end
		CT_RABoss_Mods["黑女巫法琳娜"]["lastaction"] = time();
	
	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE" and arg1 == CT_RABOSS_FAERLINA_WIDOWEMBRACE_DETECT ) then
		if ( not CT_RABoss_Mods["黑女巫法琳娜"]["silenced"] ) then
			CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 5, "silence");
			CT_RABoss_Mods["黑女巫法琳娜"]["silenced"] = true;
			CT_RABoss_Mods["黑女巫法琳娜"]["engaged"] = true;
			CT_RABoss_Mods["黑女巫法琳娜"]["lastaction"] = time();
			CT_RABoss_VisualTimer.addTimer("FaerlinaSilenced", 30, CT_RABOSS_FAERLINA_SILENCE_TIMER, "orange");
			if ( CT_RABoss_Mods["黑女巫法琳娜"]["enraged"] ) then
				CT_RABoss_Faerlina_UnSchedule();
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 30, "enrage30");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 45, "enrage15");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 55, "enrage5");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 60, "enrageready");
				CT_RABoss_Announce(format(CT_RABOSS_FAERLINA_ENRAGE_PREALERT, "~60"), CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
				CT_RABoss_VisualTimer.removeTimer("FaerlinaEnrage");
				CT_RABoss_VisualTimer.addTimer("FaerlinaEnrage", 60, CT_RABOSS_FAERLINA_ENRAGE_TIMER);
				CT_RABoss_PlaySound(3);
				CT_RABoss_Mods["黑女巫法琳娜"]["enraged"] = false;
			else
				CT_RABoss_Announce(CT_RABOSS_FAERLINA_SILENCE_ALERT, CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
				CT_RABoss_PlaySound(3);	
				CT_RABoss_Faerlina_UnSchedule()
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 15, "enrage15");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 25, "enrage5");
				CT_RABoss_Schedule("CT_RABoss_Faerlina_EventHandler", 30, "enrageready");
			end
		end

	elseif ( event == "silence") then
		CT_RABoss_Mods["黑女巫法琳娜"]["silenced"] = false;

	elseif ( event == "enrage30") then
		CT_RABoss_Announce(format(CT_RABOSS_FAERLINA_ENRAGE_PREALERT, "~30"), CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "enrage15") then
		CT_RABoss_Announce(format(CT_RABOSS_FAERLINA_ENRAGE_PREALERT, "~15"), CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "enrage5") then
		CT_RABoss_Announce(format(CT_RABOSS_FAERLINA_ENRAGE_PREALERT, "~5"), CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "enrageready" ) then
		CT_RABoss_Announce(CT_RABOSS_FAERLINA_ENRAGEEND_ALERT, CT_RABoss_Mods["黑女巫法琳娜"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end

-- Maexxna
function CT_RABoss_Maexxna_Stop()
	CT_RABoss_Mods["迈克斯纳"]["engaged"] = nil;
	CT_RABoss_Mods["迈克斯纳"]["lastAction"] = nil;
	CT_RABoss_Mods["迈克斯纳"]["sPlayers"] = "";
	CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] = 0;

	CT_RABoss_UnSchedule("CT_RABoss_Maexxna_EventHandler");
	CT_RABoss_UnSchedule("CT_RABoss_Maexxna_EventHandler");
end

function CT_RABoss_Maexxna_OnLoad()
	CT_RABoss_AddMod("迈克斯纳", CT_RABOSS_MAEXXNA_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);

	CT_RABoss_AddEvent("迈克斯纳", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Maexxna_EventHandler);
	CT_RABoss_AddEvent("迈克斯纳", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Maexxna_EventHandler);
	CT_RABoss_AddEvent("迈克斯纳", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Maexxna_EventHandler);
	CT_RABoss_AddEvent("迈克斯纳", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Maexxna_EventHandler);
	CT_RABoss_AddEvent("迈克斯纳", "PLAYER_REGEN_DISABLED", CT_RABoss_Maexxna_EventHandler);
	CT_RABoss_AddEvent("迈克斯纳", "UNIT_HEALTH", CT_RABoss_Huhuran_EventHandler);

	CT_RABoss_AddDropDownButton("迈克斯纳", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");

	CT_RABoss_Mods["迈克斯纳"]["engaged"] = nil;
	CT_RABoss_Mods["迈克斯纳"]["lastAction"] = nil;
	CT_RABoss_Mods["迈克斯纳"]["healthLow"] = 33;
	CT_RABoss_Mods["迈克斯纳"]["sPlayers"] = "";
	CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] = 0;

	CT_RA_RegisterSlashCmd("/maexxnastop", "重置迈克斯纳", 30, "MAEXXNARESET", function()
		CT_RABoss_Maexxna_Stop();
	end, "/maexxnastop");

end
	
function CT_RABoss_Maexxna_EventHandler(event)
	if ( not CT_RABoss_Mods["迈克斯纳"] or not CT_RABoss_Mods["迈克斯纳"]["status"] or not CT_RABoss_Mods["迈克斯纳"].enabled ) then
		return;
	end

	if ( event == "PLAYER_REGEN_DISABLED" ) then
		if ( not CT_RABoss_Mods["迈克斯纳"]["engaged"] ) then
			CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 5, "checkStart");
		end

	elseif ( event == "checkStart" ) then
		if ( UnitName("target") and UnitName("target") == CT_RABOSS_NAMES["迈克斯纳"] and UnitAffectingCombat("target") ) then
			CT_RABoss_Mods["迈克斯纳"]["engaged"] = 1;
			CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] = 0;
			CT_RABoss_Mods["迈克斯纳"]["lastAction"] = GetTime();

			CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 5, "webWrapWarn5");
			CT_RABoss_VisualTimer.addTimer("MaexxnaWebWrap", 10, CT_RABOSS_MAEXXNA_WEBWRAP_TIMER, "yellow");
			CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 15, "spiderWarn5");
			CT_RABoss_VisualTimer.addTimer("MaexxnaSpider", 22, CT_RABOSS_MAEXXNA_SPIDER_TIMER, "orange");
			CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 25, "webSprayWarn5");
			CT_RABoss_VisualTimer.addTimer("MaexxnaWebSpray", 32, CT_RABOSS_MAEXXNA_WEBSPRAY_TIMER, "green");
		end
	end

	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) then
		-- Web Spray
		if ( string.find(arg1, CT_RABOSS_MAEXXNA_WEBSPRAY_DETECT) ) then
			if ( not CT_RABoss_Mods["迈克斯纳"]["webSprayTrip"] ) then
				CT_RABoss_Mods["迈克斯纳"]["webSprayTrip"] = 1;
				CT_RABoss_Mods["迈克斯纳"]["lastAction"] = GetTime();

				CT_RABoss_Announce(CT_RABOSS_MAEXXNA_WEBBED_ALERT, CT_RABoss_Mods["迈克斯纳"]["announce"]);

				CT_RABoss_UnSchedule("CT_RABoss_Maexxna_EventHandler", "spiderWarn5");
				CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 25, "spiderWarn5");
				CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 35, "webSprayWarn5");
				CT_RABoss_VisualTimer.addTimer("MaexxnaWebSpray", 40, CT_RABOSS_MAEXXNA_WEBSPRAY_TIMER, "green");
			end
		end


		-- Web Wrap
		local _, _, sPlayer, sType = string.find(arg1, CT_RABOSS_MAEXXNA_WEBWRAP_DETECT);

		if ( sPlayer and sType ) then
			if ( not CT_RABoss_Mods["迈克斯纳"]["webWrapTrip"] ) then
				CT_RABoss_Mods["迈克斯纳"]["sPlayers"] = "";
				CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] = 0;
				CT_RABoss_Mods["迈克斯纳"]["webWrapTrip"] = 1;
				CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 35, "webWrapWarn5");
				CT_RABoss_VisualTimer.addTimer("MaexxnaWebWrap", 40, CT_RABOSS_MAEXXNA_WEBWRAP_TIMER, "yellow");
			end

			CT_RABoss_Mods["迈克斯纳"]["lastAction"] = GetTime();
			CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] = CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] + 1;

			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 )then
				sPlayer = UnitName("player");
			end
			
			CT_RABoss_Mods["迈克斯纳"]["sPlayers"] = CT_RABoss_Mods["迈克斯纳"]["sPlayers"] .. " " .. sPlayer;

			if ( CT_RABoss_Mods["迈克斯纳"]["nbWebWrap"] == 3 ) then
				CT_RABoss_Announce(format(CT_RABOSS_MAEXXNA_WEBWRAP_ALERT, CT_RABoss_Mods["迈克斯纳"]["sPlayers"]), CT_RABoss_Mods["迈克斯纳"]["announce"]);
			end
		end

	elseif ( event == "webWrapWarn5" ) then
		CT_RABoss_Mods["迈克斯纳"]["webWrapTrip"] = nil;
		CT_RABoss_Announce(format(CT_RABOSS_MAEXXNA_WEBWRAP_PREALERT, "5"), CT_RABoss_Mods["迈克斯纳"]["announce"]);

	elseif ( event == "spiderWarn5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MAEXXNA_SPIDER_PREALERT, "5"), CT_RABoss_Mods["迈克斯纳"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 5, "spiderWarn");

	elseif ( event == "spiderWarn" ) then
		CT_RABoss_Announce(CT_RABOSS_MAEXXNA_SPIDERPOP_ALERT, CT_RABoss_Mods["迈克斯纳"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Maexxna_EventHandler", 35, "spiderWarn5");
		CT_RABoss_VisualTimer.addTimer("MaexxnaSpider", 40, CT_RABOSS_MAEXXNA_SPIDER_TIMER, "orange");

	elseif ( event == "webSprayWarn5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MAEXXNA_WEBSPRAY_PREALERT, "5"), CT_RABoss_Mods["迈克斯纳"]["announce"]);
		CT_RABoss_Mods["迈克斯纳"]["webSprayTrip"] = nil;

	end

	-- Enrage pre-alert
	if ( UnitName("target") == CT_RABOSS_NAMES["迈克斯纳"] ) then
		local targetHealth = UnitHealth("target");
		
		-- Alert near Enrage event
		if ( targetHealth <= CT_RABoss_Mods["迈克斯纳"]["healthLow"] and targetHealth > 30 and not CT_RABoss_Mods["迈克斯纳"]["priorWarning"] ) then
			CT_RABoss_Announce(CT_RABOSS_MAEXXNA_ENRAGE_PREALERT, CT_RABoss_Mods["迈克斯纳"]["announce"]);
			CT_RABoss_Mods["迈克斯纳"]["priorWarning"] = true;
		
		-- Enrage pre-alert deactivation
		elseif ( targetHealth <= 30 ) then
			CT_RABoss_Mods["迈克斯纳"]["priorWarning"] = false;
		end

	-- Enrage alert
	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and arg2 == CT_RABOSS_NAMES["迈克斯纳"] and string.find(arg1, CT_RABOSS_MAEXXNA_ENRAGE_DETECT) ) then
		CT_RABoss_Mods["迈克斯纳"]["lastAction"] = GetTime();

		CT_RABoss_Announce(CT_RABOSS_MAEXXNA_ENRAGE_ALERT, CT_RABoss_Mods["迈克斯纳"]["announce"]);
	end

	if ( CT_RABoss_Mods["迈克斯纳"]["lastAction"] and (GetTime() - CT_RABoss_Mods["迈克斯纳"]["lastAction"]) > 60 ) then
		CT_RABoss_Maexxna_Stop();
	end
end



-- Noth The Plaguebringer (19/08/2006) - Changed naming.
function CT_RABoss_MRNoth_OnLoad()
	CT_RABoss_AddMod("瘟疫使者诺斯", CT_RABOSS_MRNOTH_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_MONSTER_YELL", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS", CT_RABoss_MRNoth_EventHandler);
	CT_RABoss_AddEvent("瘟疫使者诺斯", "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS", CT_RABoss_MRNoth_EventHandler);
	
	CT_RABoss_AddDropDownButton("瘟疫使者诺斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("瘟疫使者诺斯", { CT_RABOSS_MRNOTH_CURSE_ALERT, CT_RABOSS_MRNOTH_CURSE_ALERT_INFO }, "CT_RABoss_ModInfo", "enablecurse", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("瘟疫使者诺斯", "enablecurse", 1);
end

function CT_RABoss_MRNoth_EventHandler(event)
	if ( not CT_RABoss_Mods["瘟疫使者诺斯"] or not CT_RABoss_Mods["瘟疫使者诺斯"]["status"] or not CT_RABoss_Mods["瘟疫使者诺斯"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( arg1 == CT_RABOSS_MRNOTH_YELL1 or arg1 == CT_RABOSS_MRNOTH_YELL2 or arg1 == CT_RABOSS_MRNOTH_YELL3 ) then
			CT_RABoss_Announce(CT_RABOSS_MRNOTH_ENGAGED, CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"] = 70;
			CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"] = 90;
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", (CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"]-10), "teleportwarn");
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", (CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"]), "teleport");
			CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] = time()

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["瘟疫使者诺斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRNOTH_TELEPORT, "90", "0*255*0"));
			end

		elseif ( arg1 == CT_RABOSS_MRNOTH_DEAD ) then
			CT_RABoss_UnSchedule("CT_RABoss_MRNoth_EventHandler");
		end
		
	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" ) then
		if ( arg1 == CT_RABOSS_MRNOTH_BLINKSTRING ) then
			CT_RABoss_Announce(CT_RABOSS_MRNOTH_BLINKWARNING, CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", 28, "blinkwarn");
			CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] = time();

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["瘟疫使者诺斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "20", CT_RABOSS_MRNOTH_BLINK, "30", "0*0*255"));
			end
		end

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" )  then
		if ( string.find(arg1, CT_RABOSS_MRNOTH_CURSESTRING) ) then
			if ( CT_RABoss_Mods["瘟疫使者诺斯"]["enablecurse"] and not CT_RABoss_Mods["瘟疫使者诺斯"]["cursetrip"] ) then
				CT_RABoss_Mods["瘟疫使者诺斯"]["cursetrip"] = true;
				CT_RABoss_Announce(CT_RABOSS_MRNOTH_DISPELL, CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
				CT_RABoss_PlaySound(2);
				CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", 5, "precurse");
				CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] = time();
			end
		end

	elseif ( event == "CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS" or event == "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS" or event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS" ) then
		if ( string.find(arg1, CT_RABOSS_MRNOTH_BOSSNAME) or string.find(arg1, CT_RABOSS_MRNOTH_WARRIOR) or string.find(arg1, CT_RABOSS_MRNOTH_CHAMPION) or string.find(arg1, CT_RABOSS_MRNOTH_GUARDIAN) ) then
			CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] = time();
		end	

	elseif ( event == "backinroom" ) then
		if ( not CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] or ( time() - CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] ) > 30 ) then
			return;
		else
			CT_RABoss_Announce(format(CT_RABOSS_MRNOTH_BACK, CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"]), CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", (CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"]-10), "teleportwarn");
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", (CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"]), "teleport");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["瘟疫使者诺斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRNOTH_TELEPORT, CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"], "0*255*0"));
			end
		end

	elseif ( event == "teleport" ) then
		CT_RABoss_UnSchedule("CT_RABoss_MRNoth_EventHandler", "blinkwarn");
		if ( not CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] or ( time() - CT_RABoss_Mods["瘟疫使者诺斯"]["lastaction"] ) > 30 ) then
			return;
		else
			CT_RABoss_Announce(format(CT_RABOSS_MRNOTH_TELEPORTED, CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"]), CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", (CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"]-10), "Plague wing: Nothsoon");
			CT_RABoss_Schedule("CT_RABoss_MRNoth_EventHandler", CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"], "backinroom");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRNOTH_BALCONY, CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"], "255*0*0"));
			end

			if ( CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"] == 70 ) then
				CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"] = 95;
				CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"] = 110;
			elseif ( CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"] == 95 ) then
				CT_RABoss_Mods["瘟疫使者诺斯"]["timeonbalcony"] = 120;
				CT_RABoss_Mods["瘟疫使者诺斯"]["timeinroom"] = 180;
			end
		end

	elseif ( event == "precurse" ) then
		CT_RABoss_Mods["瘟疫使者诺斯"]["cursetrip"] = false;

	elseif ( event == "blinkwarn" ) then
		CT_RABoss_Announce(CT_RABOSS_MRNOTH_BLINKSOON, CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "teleportwarn" ) then
		CT_RABoss_Announce(CT_RABOSS_MRNOTH_TELEPORT_10SEC, CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "Plague wing: Nothsoon" ) then
		CT_RABoss_Announce(CT_RABOSS_MRNOTH_BACK_10SEC, CT_RABoss_Mods["瘟疫使者诺斯"]["announce"]);
		CT_RABoss_PlaySound(3);

	end
end


-- Heigan the Unclean (19/08/2006) - Changed naming.
function CT_RABoss_MRHeigan_OnLoad()
	CT_RABoss_AddMod("肮脏的希尔盖", CT_RABOSS_MRHEIGAN_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("肮脏的希尔盖", "CHAT_MSG_MONSTER_YELL", CT_RABoss_MRHeigan_EventHandler);
	CT_RABoss_AddEvent("肮脏的希尔盖", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_MRHeigan_EventHandler);

	CT_RABoss_AddDropDownButton("肮脏的希尔盖", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_MRHeigan_EventHandler(event)
	if ( not CT_RABoss_Mods["肮脏的希尔盖"] or not CT_RABoss_Mods["肮脏的希尔盖"]["status"] or not CT_RABoss_Mods["肮脏的希尔盖"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( arg1 == CT_RABOSS_MRHEIGAN_PHASE1_YELL1 or arg1 == CT_RABOSS_MRHEIGAN_PHASE1_YELL2 or arg1 == CT_RABOSS_MRHEIGAN_PHASE1_YELL3 ) then
			CT_RABoss_Announce(CT_RABOSS_MRHEIGAN_ENGAGED, CT_RABoss_Mods["肮脏的希尔盖"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_UnSchedule("CT_RABoss_MRHeigan_EventHandler");
			CT_RABoss_Schedule("CT_RABoss_MRHeigan_EventHandler", 80, "teleportwarn");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["肮脏的希尔盖"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRHEIGAN_TELEPORT, "90", "0*255*0"));
			end

		elseif ( arg1 == CT_RABOSS_MRHEIGAN_PHASE2_YELL1 ) then
			CT_RABoss_Announce(CT_RABOSS_MRHEIGAN_TELEPORTED, CT_RABoss_Mods["肮脏的希尔盖"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_UnSchedule("CT_RABoss_MRHeigan_EventHandler", "teleportwarn");
			CT_RABoss_Schedule("CT_RABoss_MRHeigan_EventHandler", 42, "backsoon");
			CT_RABoss_Schedule("CT_RABoss_MRHeigan_EventHandler", 45, "backinroom");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["肮脏的希尔盖"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRHEIGAN_DANCE, "45", "255*0*0"));
			end
		end

	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and arg2 == CT_RABOSS_MRHEIGAN_BOSSNAME ) then
		if ( arg1 == CT_RABOSS_MRHEIGAN_DEAD ) then
			CT_RABoss_UnSchedule("CT_RABoss_MRHeigan_EventHandler");
		end

	elseif ( event == "backinroom" ) then
		CT_RABoss_Announce(CT_RABOSS_MRHEIGAN_BACK, CT_RABoss_Mods["肮脏的希尔盖"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_MRHeigan_EventHandler", 80, "teleportwarn");

		if ( CT_RA_Level >= 1 and CT_RABoss_Mods["肮脏的希尔盖"]["announce"] ) then
			CT_RA_SendMessage("AaO b1 t20 n*Teleport* f90 r0*255*0");
		end

	elseif ( event == "teleportwarn" ) then
		CT_RABoss_Announce(CT_RABOSS_MRHEIGAN_TELEPORT_10SEC, CT_RABoss_Mods["肮脏的希尔盖"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "backsoon" ) then
		CT_RABoss_Announce(CT_RABOSS_MRHEIGAN_BACK_3SEC, CT_RABoss_Mods["肮脏的希尔盖"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end

-- Loatheb (22/08/2006) - Updated to use chat_msg_addon.
function CT_RABoss_MRLoatheb_OnLoad()
	CT_RABoss_AddMod("洛欧塞布", CT_RABOSS_MRLOATHEB_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("洛欧塞布", "PLAYER_REGEN_DISABLED", CT_RABoss_MRLoatheb_EventHandler);
	CT_RABoss_AddEvent("洛欧塞布", "CHAT_MSG_ADDON", CT_RABoss_MRLoatheb_EventHandler);
	CT_RABoss_AddEvent("洛欧塞布", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_MRLoatheb_EventHandler);
	CT_RABoss_AddEvent("洛欧塞布", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_MRLoatheb_EventHandler);
	CT_RABoss_AddEvent("洛欧塞布", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_MRLoatheb_EventHandler);
	CT_RABoss_AddEvent("洛欧塞布", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_MRLoatheb_EventHandler);

	CT_RABoss_AddDropDownButton("洛欧塞布", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("洛欧塞布", { CT_RABOSS_MRLOATHEB_CURSES_ALERT, CT_RABOSS_MRLOATHEB_CURSES_ALERT_INFO }, "CT_RABoss_ModInfo", "enablecurseS", "CT_RABoss_SetInfo");

	CT_RABoss_SetVar("洛欧塞布", "enablecurses", 1);
end

function CT_RABoss_MRLoatheb_Start()
	CT_RABoss_Announce(CT_RABOSS_MRLOATHEB_ENGAGE, CT_RABoss_Mods["洛欧塞布"]["announce"]);
	CT_RABoss_PlaySound(3);	
	CT_RABoss_Mods["洛欧塞布"]["lastaction"] = time();
	CT_RABoss_Mods["洛欧塞布"]["engaged"] = true;
	CT_RABoss_Schedule("CT_RABoss_MRLoatheb_EventHandler", 110, "doom5");

	if ( CT_RA_Level >= 1 and CT_RABoss_Mods["洛欧塞布"]["announce"] ) then
		CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRLOATHEB_DOOM_TIMER, "115", "255*0*0"));
	end
end

function CT_RABoss_MRLoatheb_EventHandler(event)
	if ( not CT_RABoss_Mods["洛欧塞布"] or not CT_RABoss_Mods["洛欧塞布"]["status"] or not CT_RABoss_Mods["洛欧塞布"].enabled ) then
		return;
	end

	if ( CT_RABoss_Mods["洛欧塞布"]["engaged"] and ( not CT_RABoss_Mods["洛欧塞布"]["lastaction"] or ( time() - CT_RABoss_Mods["洛欧塞布"]["lastaction"] ) > 60 ) ) then
		CT_RABoss_Mods["洛欧塞布"]["engaged"] = false;
		CT_RABoss_Mods["洛欧塞布"]["countdoom"] = nil;
	end

	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_MRLOATHEB_DOOM_STRING) and not CT_RABoss_Mods["洛欧塞布"]["doomtrip"] ) then
			CT_RABoss_Announce(CT_RABOSS_MRLOATHEB_DOOM_WARN, CT_RABoss_Mods["洛欧塞布"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_UnSchedule("CT_RABoss_MRLoatheb_EventHandler", "doom5");
			CT_RABoss_Schedule("CT_RABoss_MRLoatheb_EventHandler", 5, "undoom");
			CT_RABoss_Mods["洛欧塞布"]["doomtrip"] = true;
			CT_RABoss_Mods["洛欧塞布"]["engaged"] = true;
			CT_RABoss_Mods["洛欧塞布"]["lastaction"] = time();

			if ( CT_RABoss_Mods["洛欧塞布"]["countdoom"] ) then
				CT_RABoss_Mods["洛欧塞布"]["countdoom"] = CT_RABoss_Mods["洛欧塞布"]["countdoom"]+1;
			else
				CT_RABoss_Mods["洛欧塞布"]["countdoom"] = 0;
			end
			
			if ( CT_RABoss_Mods["洛欧塞布"]["countdoom"] > 7 ) then
				CT_RABoss_Schedule("CT_RABoss_MRLoatheb_EventHandler", 10, "doom5");

				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["洛欧塞布"]["announce"] ) then
					CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRLOATHEB_DOOM_TIMER, "15", "255*0*0"));
				end
			else
				CT_RABoss_Schedule("CT_RABoss_MRLoatheb_EventHandler", 25, "doom5");

				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["洛欧塞布"]["announce"] ) then
					CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRLOATHEB_DOOM_TIMER, "30", "255*0*0"));
				end
			end
		end
		
	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" ) then
		if ( arg1 == CT_RABOSS_MRLOATHEB_CURSE_STRING and CT_RABoss_Mods["洛欧塞布"]["enablecurses"] ) then
			CT_RABoss_Announce(CT_RABOSS_MRLOATHEB_CURSE_WARN, CT_RABoss_Mods["洛欧塞布"]["announce"]);
			CT_RABoss_PlaySound(3);

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["洛欧塞布"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "20", CT_RABOSS_MRLOATHEB_CURSE_TIMER, "30", "0*0*255"));
			end
		end
		
	elseif ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["洛欧塞布"]["engaged"] ) then
		CT_RABoss_Schedule("CT_RABoss_MRLoatheb_EventHandler", 5, "engagecheck");	

	elseif ( event == "CHAT_MSG_ADDON" and arg1 == "CTRA" ) then
		if ( arg2 == "LOATHEBENGSYNC" and not CT_RABoss_Mods["洛欧塞布"]["engaged"] ) then
			CT_RABoss_MRLoatheb_Start();
		end

	elseif ( event == "engagecheck" and not CT_RABoss_Mods["洛欧塞布"]["engaged"] ) then
		if ( UnitName("target") == CT_RABOSS_MRLOATHEB_BOSSNAME and UnitAffectingCombat("target") ) then
			CT_RABoss_MRLoatheb_Start();
			CT_RA_SendMessage("LOATHEBENGSYNC");

		elseif ( UnitName("playertarget") == CT_RABOSS_MRLOATHEB_BOSSNAME and UnitAffectingCombat("playertarget") ) then
			CT_RABoss_MRLoatheb_Start();
			CT_RA_SendMessage("LOATHEBENGSYNC");
		else
			local i
			for i = 1, GetNumRaidMembers(), 1 do
				if ( UnitName("raid"..i.."target") == CT_RABOSS_MRLOATHEB_BOSSNAME and UnitAffectingCombat("raid"..i.."target")) then
					CT_RABoss_MRLoatheb_Start();
					CT_RA_SendMessage("LOATHEBENGSYNC");
					break;
				end
			end
		end

	elseif ( event == "doom5") then
		CT_RABoss_Announce(CT_RABOSS_MRLOATHEB_DOOM_5SEC, CT_RABoss_Mods["洛欧塞布"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "undoom") then
		CT_RABoss_Mods["洛欧塞布"]["doomtrip"] = false;
	end
end


-- Instructor Razuvious (01/09/2006) - Added shieldwall anouncements.
function CT_RABoss_MRRazuvious_OnLoad()
	CT_RABoss_AddMod("教官拉苏维奥斯", CT_RABOSS_MRRAZUVIOUS_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_MONSTER_YELL", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_MRRazuvious_EventHandler);
	CT_RABoss_AddEvent("教官拉苏维奥斯", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", CT_RABoss_MRRazuvious_EventHandler);

	CT_RABoss_AddDropDownButton("教官拉苏维奥斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_MRRazuvious_EventHandler(event)
	if ( not CT_RABoss_Mods["教官拉苏维奥斯"] or not CT_RABoss_Mods["教官拉苏维奥斯"]["status"] or not CT_RABoss_Mods["教官拉苏维奥斯"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( arg1 == CT_RABOSS_MRRAZUVIOUS_YELL1 or arg1 == CT_RABOSS_MRRAZUVIOUS_YELL2 or arg1 == CT_RABOSS_MRRAZUVIOUS_YELL3 or arg1 == CT_RABOSS_MRRAZUVIOUS_YELL4 ) then
			CT_RABoss_Announce(CT_RABOSS_MRRAZUVIOUS_ENGAGED, CT_RABoss_Mods["教官拉苏维奥斯"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_UnSchedule("CT_RABoss_MRRazuvious_EventHandler");
			CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 15.5, "warn10");
			CT_RABoss_Mods["教官拉苏维奥斯"]["lastaction"] = time();

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["教官拉苏维奥斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "25.5", CT_RABOSS_MRRAZUVIOUS_SHOUT, "25.5", "255*0*0"));
			end

		elseif ( arg1 == CT_RABOSS_MRRAZUVIOUS_DEAD_YELL1 ) then
			CT_RABoss_UnSchedule("CT_RABoss_MRRazuvious_EventHandler");
		end

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_MRRAZUVIOUS_SHOUT) and not CT_RABoss_Mods["教官拉苏维奥斯"]["shouttrip"] ) then
			CT_RABoss_UnSchedule("CT_RABoss_MRRazuvious_EventHandler");
			CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 15.5, "warn10");
			CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 5, "preshout");
			CT_RABoss_Mods["教官拉苏维奥斯"]["shouttrip"] = true;
			CT_RABoss_Mods["教官拉苏维奥斯"]["lastaction"] = time();

			if ( not CT_RABoss_Mods["教官拉苏维奥斯"]["shoutwarn"] ) then
				CT_RABoss_Announce(CT_RABOSS_MRRAZUVIOUS_SHOUTNEXT, CT_RABoss_Mods["教官拉苏维奥斯"]["announce"]);
				CT_RABoss_PlaySound(2);
			end

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["教官拉苏维奥斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "25.5", CT_RABOSS_MRRAZUVIOUS_SHOUT, "25.5", "255*0*0"));
			end
		end

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS" or event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" ) then
		if ( arg1 == CT_RABOSS_MRRAZUVIOUS_SHIELDSTRING ) then
			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["教官拉苏维奥斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "20", CT_RABOSS_MRRAZUVIOUS_SHIELDWALL, "20", "0*0*255"));
			end
		end
			
	elseif ( event == "CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS" or event == "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS" or event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS" ) then
		if ( string.find(arg1, CT_RABOSS_MRRAZUVIOUS_BOSSNAME) or string.find(arg1, CT_RABOSS_MRRAZUVIOUS_STUDENT) ) then
			CT_RABoss_Mods["教官拉苏维奥斯"]["lastaction"] = time();
		end	

	elseif ( event == "preshout" ) then
		CT_RABoss_Mods["教官拉苏维奥斯"]["shouttrip"] = false;

	elseif ( event == "warn10" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRRAZUVIOUS_SHOUTWARN, "10"), CT_RABoss_Mods["教官拉苏维奥斯"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 5, "warn5");
		CT_RABoss_Mods["教官拉苏维奥斯"]["shoutwarn"] = false;

	elseif ( event == "warn5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRRAZUVIOUS_SHOUTWARN, "5"), CT_RABoss_Mods["教官拉苏维奥斯"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 2, "warn3");

	elseif ( event == "warn3" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRRAZUVIOUS_SHOUTWARN, "3"), CT_RABoss_Mods["教官拉苏维奥斯"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 3, "shoutcast");

	elseif ( event == "shoutcast" ) then
		if ( not CT_RABoss_Mods["教官拉苏维奥斯"]["lastaction"] or ( time() - CT_RABoss_Mods["教官拉苏维奥斯"]["lastaction"] ) > 30 ) then
			return;
		else
			CT_RABoss_Mods["教官拉苏维奥斯"]["shoutwarn"] = true;
			CT_RABoss_Announce(CT_RABOSS_MRRAZUVIOUS_SHOUTNEXT, CT_RABoss_Mods["教官拉苏维奥斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRRazuvious_EventHandler", 15, "warn10");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["教官拉苏维奥斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "25", CT_RABOSS_MRRAZUVIOUS_SHOUT, "25", "255*0*0"));
			end
		end
	end
end


-- Gothik the Harvester (19/08/2006) - Changed naming.
function CT_RABoss_MRGothik_OnLoad()
	CT_RABoss_AddMod("收割者戈提克", CT_RABOSS_MRGOTHIK_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("收割者戈提克", "CHAT_MSG_MONSTER_YELL", CT_RABoss_MRGothik_EventHandler);
	CT_RABoss_AddEvent("收割者戈提克", "CHAT_MSG_COMBAT_HOSTILE_DEATH", CT_RABoss_MRGothik_EventHandler);

	CT_RABoss_AddDropDownButton("收割者戈提克", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_MRGothik_EventHandler(event)
	if ( not CT_RABoss_Mods["收割者戈提克"] or not CT_RABoss_Mods["收割者戈提克"]["status"] or not CT_RABoss_Mods["收割者戈提克"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( string.find(arg1, CT_RABOSS_MRGOTHIK_PHASE1_YELL1) ) then
			CT_RABoss_Announce(CT_RABOSS_MRGOTHIK_ENGAGED, CT_RABoss_Mods["收割者戈提克"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 34, "inctimer");
			CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 24, "inctrainee");
			CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 74, "incknight");
			CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 134, "incrider");
			CT_RABoss_Mods["收割者戈提克"]["timeleft"] = 4;
			CT_RABoss_Mods["收割者戈提克"]["stoptimer"] = false;
			CT_RABoss_Mods["收割者戈提克"]["lastaction"] = time();

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["收割者戈提克"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRGOTHIK_TRAINEES, "20", "0*255*0"));
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "20", CT_RABOSS_MRGOTHIK_KNIGHTS, "70", "0*0*255"));
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "3", "20", CT_RABOSS_MRGOTHIK_RIDERS, "130", "255*0*0"));
			end

		elseif ( arg1 == CT_RABOSS_MRGOTHIK_PHASE2_YELL1 ) then
			CT_RABoss_Announce(CT_RABOSS_MRGOTHIK_INC, CT_RABoss_Mods["收割者戈提克"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Mods["收割者戈提克"]["stoptimer"] = true;
		end
	
	elseif ( event == "CHAT_MSG_COMBAT_HOSTILE_DEATH" ) then
		if ( string.find(arg1, CT_RABOSS_MRGOTHIK_TRAINEE) ) then
			CT_RABoss_Mods["收割者戈提克"]["lastaction"] = time();

		elseif ( string.find(arg1, CT_RABOSS_MRGOTHIK_KNIGHT) ) then
			CT_RABoss_Announce(CT_RABOSS_MRGOTHIK_KNIGHT_DEAD, CT_RABoss_Mods["收割者戈提克"]["announce"]);
			CT_RABoss_Mods["收割者戈提克"]["lastaction"] = time();

		elseif ( string.find(arg1, CT_RABOSS_MRGOTHIK_RIDER) ) then
			CT_RABoss_Announce(CT_RABOSS_MRGOTHIK_RIDER_DEAD, CT_RABoss_Mods["收割者戈提克"]["announce"]);
			CT_RABoss_Mods["收割者戈提克"]["lastaction"] = time();
		end

	elseif ( event == "inctimer") then
		if ( not CT_RABoss_Mods["收割者戈提克"]["lastaction"] or ( time() - CT_RABoss_Mods["收割者戈提克"]["lastaction"] ) > 45 ) then
			CT_RABoss_Mods["收割者戈提克"]["stoptimer"] = true;

		elseif ( CT_RABoss_Mods["收割者戈提克"]["timeleft"] == 0.5 ) then
			CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 20, "inc10");
			CT_RABoss_Announce(format(CT_RABOSS_MRGOTHIK_SECWARN, "30"), CT_RABoss_Mods["收割者戈提克"]["announce"]);
			CT_RABoss_PlaySound(3);
		else
			if ( CT_RABoss_Mods["收割者戈提克"]["timeleft"] == 1 ) then
				CT_RABoss_Announce(CT_RABOSS_MRGOTHIK_1MINWARN, CT_RABoss_Mods["收割者戈提克"]["announce"]);
			else
				CT_RABoss_Announce(format(CT_RABOSS_MRGOTHIK_WARN, CT_RABoss_Mods["收割者戈提克"]["timeleft"]), CT_RABoss_Mods["收割者戈提克"]["announce"]);
			end

			CT_RABoss_Mods["收割者戈提克"]["timeleft"] = CT_RABoss_Mods["收割者戈提克"]["timeleft"]-0.5;
			CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 30, "inctimer");
			CT_RABoss_PlaySound(3);
		end

	elseif ( event == "inctrainee" and not CT_RABoss_Mods["收割者戈提克"]["stoptimer"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRGOTHIK_ADD_INC, CT_RABOSS_MRGOTHIK_TRAINEES), CT_RABoss_Mods["收割者戈提克"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 20, "inctrainee");

		if ( CT_RA_Level >= 1 and CT_RABoss_Mods["收割者戈提克"]["announce"] ) then
			CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRGOTHIK_TRAINEES, "20", "0*255*0"));
		end

	elseif ( event == "incknight" and not CT_RABoss_Mods["收割者戈提克"]["stoptimer"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRGOTHIK_ADD_INC, CT_RABOSS_MRGOTHIK_KNIGHTS), CT_RABoss_Mods["收割者戈提克"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 25, "incknight");

		if ( CT_RA_Level >= 1 and CT_RABoss_Mods["收割者戈提克"]["announce"] ) then
			CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "25", CT_RABOSS_MRGOTHIK_KNIGHTS, "25", "0*0*255"));
		end

	elseif ( event == "incrider" and not CT_RABoss_Mods["收割者戈提克"]["stoptimer"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRGOTHIK_ADD_INC, CT_RABOSS_MRGOTHIK_RIDERS), CT_RABoss_Mods["收割者戈提克"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_MRGothik_EventHandler", 30, "incrider");

		if ( CT_RA_Level >= 1 and CT_RABoss_Mods["收割者戈提克"]["announce"] ) then
			CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "3", "30", CT_RABOSS_MRGOTHIK_RIDERS, "30", "255*0*0"));
		end

	elseif ( event == "inc10" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRGOTHIK_SECWARN, "10"), CT_RABoss_Mods["收割者戈提克"]["announce"]);
		CT_RABoss_PlaySound(3);

	end
end

-- The Four Horsemen (02/09/2006) - New code.
function CT_RABoss_MRHorsemen_OnLoad()
	CT_RABoss_AddMod("死亡骑士", CT_RABOSS_MRHORSEMEN_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("死亡骑士", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_MRHorsemen_EventHandler);
	CT_RABoss_AddEvent("死亡骑士", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_MRHorsemen_EventHandler);
	CT_RABoss_AddEvent("死亡骑士", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_MRHorsemen_EventHandler);
	CT_RABoss_AddEvent("死亡骑士", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_MRHorsemen_EventHandler);
	CT_RABoss_AddEvent("死亡骑士", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_MRHorsemen_EventHandler);
	CT_RABoss_AddEvent("死亡骑士", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_MRHorsemen_EventHandler);

	CT_RABoss_AddDropDownButton("死亡骑士", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_MRHorsemen_Start()
	CT_RABoss_Announce(CT_RABOSS_MRHORSEMEN_ENGAGE, CT_RABoss_Mods["死亡骑士"]["announce"]);
	CT_RABoss_PlaySound(3);
	CT_RABoss_Mods["死亡骑士"]["engaged"] = true;
	CT_RABoss_Mods["死亡骑士"]["marks"] = 1;
	CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 7, "mark5");

	if ( CT_RA_Level >= 1 and CT_RABoss_Mods["死亡骑士"]["announce"] ) then
		CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "12", CT_RABOSS_MRHORSEMEN_MARK, "12", "255*0*0"));
	end
end

function CT_RABoss_MRHorsemen_EventHandler(event)
	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_MRHORSEMEN_MARKSTRING) ) then
			CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_MARKNOW, CT_RABoss_Mods["死亡骑士"]["marks"]), CT_RABoss_Mods["死亡骑士"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 7, "mark5");
			CT_RABoss_Mods["死亡骑士"]["engaged"] = true;
			CT_RABoss_Mods["死亡骑士"]["marks"] = CT_RABoss_Mods["死亡骑士"]["marks"] + 1;

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["死亡骑士"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "12", CT_RABOSS_MRHORSEMEN_MARK, "12", "255*0*0"));
			end
		end

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" ) then
		if ( string.find(arg1, CT_RABOSS_MRHORSEMEN_VOIDSTRING) ) then
			CT_RABoss_Announce(CT_RABOSS_MRHORSEMEN_VOIDWARN, CT_RABoss_Mods["死亡骑士"]["announce"]);
			CT_RABoss_PlaySound(3);

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["死亡骑士"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "12", CT_RABOSS_MRHORSEMEN_VOID, "12", "255*0*0"));
			end

		elseif ( string.find(arg1, CT_RABOSS_MRHORSEMEN_METEORSTRING) and not CT_RABoss_Mods["死亡骑士"]["meteortrip"]) then
			CT_RABoss_Announce(CT_RABOSS_MRHORSEMEN_METEORWARN, CT_RABoss_Mods["死亡骑士"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Mods["死亡骑士"]["meteortrip"] = true;
			CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 5, "unmeteor");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["死亡骑士"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "3", "12", CT_RABOSS_MRHORSEMEN_METEOR, "12", "255*0*0"));
			end

		elseif ( string.find(arg1, CT_RABOSS_MRHORSEMEN_WRATHSTRING) and not CT_RABoss_Mods["死亡骑士"]["wrathtrip"] ) then
			CT_RABoss_Announce(CT_RABOSS_MRHORSEMEN_WRATHWARN, CT_RABoss_Mods["死亡骑士"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Mods["死亡骑士"]["wrathtrip"] = true;
			CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 5, "unwrath");

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["死亡骑士"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "4", "12", CT_RABOSS_MRHORSEMEN_WRATH, "12", "255*0*0"));
			end
		end

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" ) then
		if ( string.find(arg1, CT_RABOSS_MRHORSEMEN_SHIELDSTRING) ) then
			if ( string.find(arg1, CT_RABOSS_MRHORSEMEN_THANE) ) then
				CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_SHIELDWARN, CT_RABOSS_MRHORSEMEN_THANE), CT_RABoss_Mods["死亡骑士"]["announce"]);
				CT_RABoss_PlaySound(2);
				CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 20, "shieldover"..CT_RABOSS_MRHORSEMEN_THANE);

			elseif ( string.find(arg1, CT_RABOSS_MRHORSEMEN_MOGRAINE) ) then
				CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_SHIELDWARN, CT_RABOSS_MRHORSEMEN_MOGRANE), CT_RABoss_Mods["死亡骑士"]["announce"]);
				CT_RABoss_PlaySound(2);
				CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 20, "shieldover"..CT_RABOSS_MRHORSEMEN_MOGRANE);	

			elseif ( string.find(arg1, CT_RABOSS_MRHORSEMEN_ZELIEK) ) then
				CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_SHIELDWARN, CT_RABOSS_MRHORSEMEN_ZELIEK), CT_RABoss_Mods["死亡骑士"]["announce"]);
				CT_RABoss_PlaySound(2);
				CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 20, "shieldover"..CT_RABOSS_MRHORSEMEN_ZELIEK);

			elseif ( string.find(arg1, CT_RABOSS_MRHORSEMEN_BLAUMEUX) ) then
				CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_SHIELDWARN, CT_RABOSS_MRHORSEMEN_BLAUMEUX), CT_RABoss_Mods["死亡骑士"]["announce"]);
				CT_RABoss_PlaySound(2);
				CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 20, "shieldover"..CT_RABOSS_MRHORSEMEN_BLAUMEUX);
			end
		end

	elseif ( strsub( event, 1, 10 ) == "shieldover" ) then
		local bossname = strsub( event, 11 );
		CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_SHIELDOVER, bossname), CT_RABoss_Mods["死亡骑士"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["死亡骑士"]["engaged"] ) then
		CT_RABoss_Schedule("CT_RABoss_MRHorsemen_EventHandler", 5, "engagecheck");	

	elseif ( event == "CHAT_MSG_ADDON" and arg1 == "CTRA" ) then
		if ( arg2 == "HORSEMENENGSYNC" and not CT_RABoss_Mods["死亡骑士"]["engaged"] ) then
			CT_RABoss_MRHorsemen_Start();
		end

	elseif ( event == "engagecheck" and not CT_RABoss_Mods["死亡骑士"]["engaged"] ) then
		if ( ( UnitName("target") == CT_RABOSS_MRHORSEMEN_THANE or UnitName("target") == CT_RABOSS_MRHORSEMEN_MOGRAINE or UnitName("target") == CT_RABOSS_MRHORSEMEN_ZELIEK or UnitName("target") == CT_RABOSS_MRHORSEMEN_BLAUMEUX ) and UnitAffectingCombat("target") ) then
			CT_RABoss_MRHorsemen_Start();
			CT_RA_SendMessage("HORSEMENENGSYNC");

		elseif ( ( UnitName("playertarget") == CT_RABOSS_MRHORSEMEN_THANE or UnitName("playertarget") == CT_RABOSS_MRHORSEMEN_MOGRAINE or UnitName("playertarget") == CT_RABOSS_MRHORSEMEN_ZELIEK or UnitName("playertarget") == CT_RABOSS_MRHORSEMEN_BLAUMEUX ) and UnitAffectingCombat("playertarget") ) then
			CT_RABoss_MRHorsemen_Start();
			CT_RA_SendMessage("HORSEMENENGSYNC");
		else
			local i
			for i = 1, GetNumRaidMembers(), 1 do
				if ( ( UnitName("raid"..i.."target") == CT_RABOSS_MRHORSEMEN_THANE or UnitName("raid"..i.."target") == CT_RABOSS_MRHORSEMEN_MOGRAINE or UnitName("raid"..i.."target") == CT_RABOSS_MRHORSEMEN_ZELIEK or UnitName("raid"..i.."target") == CT_RABOSS_MRHORSEMEN_BLAUMEUX ) and UnitAffectingCombat("raid"..i.."target") ) then
					CT_RABoss_MRMHorsemen_Start();
					CT_RA_SendMessage("HORSEMENENGSYNC");
					break;
				end
			end
		end

	elseif ( event == "mark5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRHORSEMEN_MARKWARN, CT_RABoss_Mods["死亡骑士"]["marks"]), CT_RABoss_Mods["死亡骑士"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "unmeteor" ) then
		CT_RABoss_Mods["死亡骑士"]["meteortrip"] = false;

	elseif ( event == "unwrath" ) then
		CT_RABoss_Mods["死亡骑士"]["wrathtrip"] = false;

	end
end


-- Patchwerk - (19/08/2006) - Changed naming.
function CT_RABoss_MRPatchwerk_OnLoad()
	CT_RABoss_AddMod("帕奇维克", CT_RABOSS_MRPATCHWERK_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("帕奇维克", "CHAT_MSG_MONSTER_YELL", CT_RABoss_MRPatchwerk_EventHandler);
	CT_RABoss_AddEvent("帕奇维克", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_MRPatchwerk_EventHandler);
	CT_RABoss_AddEvent("帕奇维克", "CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS", CT_RABoss_MRPatchwerk_EventHandler);
	CT_RABoss_AddEvent("帕奇维克", "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS", CT_RABoss_MRPatchwerk_EventHandler);
	CT_RABoss_AddEvent("帕奇维克", "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS", CT_RABoss_MRPatchwerk_EventHandler);

	CT_RABoss_AddDropDownButton("帕奇维克", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_MRPatchwerk_EventHandler(event)
	if ( not CT_RABoss_Mods["帕奇维克"] or not CT_RABoss_Mods["帕奇维克"]["status"] or not CT_RABoss_Mods["帕奇维克"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( arg1 == CT_RABOSS_MRPATCHWERK_YELL1 or arg1 == CT_RABOSS_MRPATCHWERK_YELL2 ) then
			CT_RABoss_Announce(CT_RABOSS_MRPATCHWERK_ENGAGED, CT_RABoss_Mods["帕奇维克"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Schedule("CT_RABoss_MRPatchwerk_EventHandler", 30, "enragetimer");
			CT_RABoss_Mods["帕奇维克"]["enrageleft"] = 6.5;
			CT_RABoss_Mods["帕奇维克"]["lastaction"] = time();

		elseif ( arg1 == CT_RABOSS_MRPATCHWERK_DEAD ) then
			CT_RABoss_UnSchedule("CT_RABoss_MRPatchwerk_EventHandler");
		end
	
	elseif ( event == "enragetimer") then
		if ( not CT_RABoss_Mods["帕奇维克"]["lastaction"] or ( time() - CT_RABoss_Mods["帕奇维克"]["lastaction"] ) > 30 ) then
			return;

		elseif ( CT_RABoss_Mods["帕奇维克"]["enrageleft"] == 0.5 ) then
			CT_RABoss_Schedule("CT_RABoss_MRPatchwerk_EventHandler", 15, "enrage15");
			CT_RABoss_Schedule("CT_RABoss_MRPatchwerk_EventHandler", 25, "enrage5");
			CT_RABoss_Announce(format(CT_RABOSS_MRPATCHWERK_SECWARN, "30"), CT_RABoss_Mods["帕奇维克"]["announce"]);
			CT_RABoss_PlaySound(3);
		else
			if ( CT_RABoss_Mods["帕奇维克"]["enrageleft"] == 1 ) then
				CT_RABoss_Announce(CT_RABOSS_MRPATCHWERK_1MINWARN, CT_RABoss_Mods["帕奇维克"]["announce"]);
			else
				CT_RABoss_Announce(format(CT_RABOSS_MRPATCHWERK_WARN, CT_RABoss_Mods["帕奇维克"]["enrageleft"]), CT_RABoss_Mods["帕奇维克"]["announce"]);
			end

			CT_RABoss_Mods["帕奇维克"]["enrageleft"] = CT_RABoss_Mods["帕奇维克"]["enrageleft"]-0.5;
			CT_RABoss_Schedule("CT_RABoss_MRPatchwerk_EventHandler", 30, "enragetimer");
			CT_RABoss_PlaySound(3);
		end

	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and arg2 == CT_RABOSS_MRPATCHWERK_BOSSNAME ) then
		if ( arg1 == CT_RABOSS_MRPATCHWERK_ENRAGESTRING ) then
			CT_RABoss_Announce(CT_RABOSS_MRPATCHWERK_ENRAGEWARNING, CT_RABoss_Mods["帕奇维克"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Mods["帕奇维克"]["lastaction"] = time();

		elseif ( arg1 == CT_RABOSS_MRPATCHWERK_BERSERKSTRING ) then
			CT_RABoss_Announce(CT_RABOSS_MRPATCHWERK_BERSERKWARNING, CT_RABoss_Mods["帕奇维克"]["announce"]);
			CT_RABoss_PlaySound(1);
			CT_RABoss_UnSchedule("CT_RABoss_MRPatchwerk_EventHandler");
		end

	elseif ( event == "CHAT_MSG_COMBAT_CREATURE_VS_CREATURE_HITS" or event == "CHAT_MSG_COMBAT_CREATURE_VS_PARTY_HITS" or event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS" ) then
		if ( string.find(arg1, CT_RABOSS_MRPATCHWERK_BOSSNAME) ) then
			CT_RABoss_Mods["帕奇维克"]["lastaction"] = time();
		end	

	elseif ( event == "enrage15" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRPATCHWERK_SECWARN, "15"), CT_RABoss_Mods["帕奇维克"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "enrage5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRPATCHWERK_SECWARN, "5"), CT_RABoss_Mods["帕奇维克"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Grobbulus - (19/08/2006) - Changed naming.
function CT_RABoss_Grobbulus_OnLoad()
	CT_RABoss_AddMod("格罗布鲁斯", CT_RABOSS_GROBBULUS_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("格罗布鲁斯", "PLAYER_REGEN_DISABLED", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_CHANNEL", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE", CT_RABoss_Grobbulus_EventHandler);
	CT_RABoss_AddEvent("格罗布鲁斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Grobbulus_EventHandler);

	CT_RABoss_AddDropDownButton("格罗布鲁斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("格罗布鲁斯", { CT_RABOSS_GROBBULUS_ALERT, CT_RABOSS_GROBBULUS_ALERT_INFO }, "CT_RABoss_ModInfo", "alertnearby", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("格罗布鲁斯", { CT_RABOSS_GROBBULUS_TELL, CT_RABOSS_GROBBULUS_TELL_INFO }, "CT_RABoss_ModInfo", "sendtell", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("格罗布鲁斯", "alertnearby", 1);
end

function CT_RABoss_Grobbulus_EventHandler(event)
	if ( not CT_RABoss_Mods["格罗布鲁斯"] or not CT_RABoss_Mods["格罗布鲁斯"]["status"] or not CT_RABoss_Mods["格罗布鲁斯"].enabled ) then
		return;
	end

	if ( CT_RABoss_Mods["格罗布鲁斯"]["engaged"] and ( not CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] or ( time() - CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] ) > 60 ) ) then
		CT_RABoss_Mods["格罗布鲁斯"]["engaged"] = false;
	end

	if ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["格罗布鲁斯"]["engaged"] ) then
		if ( UnitExists("target") and UnitName("target") == CT_RABOSS_NAMES["格罗布鲁斯"] and UnitAffectingCombat("target") ) then
			CT_RABoss_Mods["格罗布鲁斯"]["engaged"] = true;
			CT_RABoss_Announce(CT_RABOSS_GROBBULUS_ENGAGED, CT_RABoss_Mods["格罗布鲁斯"]["announce"]);
			CT_RABoss_Schedule("CT_RABoss_Grobbulus_EventHandler", 20, "sspray5sec");
			CT_RABoss_VisualTimer.addTimer("GrobbulusSSpray", 25, CT_RABOSS_GROBBULUS_SSPRAY_TIMER);
			if ( CT_RA_Level >= 1 ) then
				CT_RA_SendMessage("GROBBULUSSTARTSYNC", 1);
			end
			CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] = time();
		end

	elseif ( event == "CHAT_MSG_CHANNEL" and CT_RA_Channel and arg9 and strlower(arg9) == strlower(CT_RA_Channel) ) then
		if ( arg1 == "GROBBULUSSTARTSYNC" and not CT_RABoss_Mods["格罗布鲁斯"]["engaged"] ) then
			CT_RABoss_Mods["格罗布鲁斯"]["engaged"] = true;
			CT_RABoss_Schedule("CT_RABoss_Grobbulus_EventHandler", 20, "sspray5sec");
			CT_RABoss_VisualTimer.addTimer("GrobbulusSSpray", 25, CT_RABOSS_GROBBULUS_SSPRAY_TIMER);	
			CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] = time();
		elseif ( arg1 == "GROBBULUSSSPRAYSYNC" and not CT_RABoss_Mods["格罗布鲁斯"]["SSprayTrip"] ) then
			CT_RABoss_Mods["格罗布鲁斯"]["SSprayTrip"] = true;
			CT_RABoss_Announce(CT_RABOSS_GROBBULUS_SSPRAY_WARN);
			CT_RABoss_Schedule("CT_RABoss_Grobbulus_EventHandler", 27, "sspray5sec");
			CT_RABoss_VisualTimer.addTimer("GrobbulusSSpray", 32, CT_RABOSS_GROBBULUS_SSPRAY_TIMER);
			CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] = time();
		end

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE" or  event == "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" ) then
		if ( not CT_RABoss_Mods["格罗布鲁斯"]["SSprayTrip"] and string.find(arg1, CT_RABOSS_GROBBULUS_SSPRAY_DETECT) ) then
			CT_RABoss_Mods["格罗布鲁斯"]["SSprayTrip"] = true;
			CT_RABoss_Announce(CT_RABOSS_GROBBULUS_SSPRAY_WARN, CT_RABoss_Mods["格罗布鲁斯"]["announce"]);
			CT_RABoss_Schedule("CT_RABoss_Grobbulus_EventHandler", 27, "sspray5sec");
			CT_RABoss_VisualTimer.addTimer("GrobbulusSSpray", 32, CT_RABOSS_GROBBULUS_SSPRAY_TIMER);
			if ( CT_RA_Level >= 1 ) then
				CT_RA_SendMessage("GROBBULUSSSPRAYSYNC", 1);
			end
			CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] = time();
		end
		
	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or ( ( event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) and CT_RABoss_Mods["格罗布鲁斯"]["alertnearby"] ) ) then
		local _, _, playername = string.find(arg1, CT_RABOSS_GROBBULUS_MIEXP);
		if ( playername ) then
			CT_RABoss_Mods["格罗布鲁斯"]["lastaction"] = time();
			if ( playername == CT_RABOSS_SELF1 ) then
				playername = UnitName("player");
				CT_RABoss_Announce(CT_RABOSS_GROBBULUS_AFFLICTED_YOU);
				CT_RABoss_Announce(CT_RABOSS_GROBBULUS_AFFLICTED_YOU);
				CT_RABoss_PlaySound(2);
			elseif ( CT_RABoss_Mods["格罗布鲁斯"]["alertnearby"] or CT_RABoss_Mods["格罗布鲁斯"]["sendtell"] ) then
				if ( CT_RABoss_Mods["格罗布鲁斯"]["sendtell"] ) then
					SendChatMessage(CT_RABOSS_GROBBULUS_AFFLICTED_YOU, "WHISPER", nil, playername);
				end
				if ( CT_RABoss_Mods["格罗布鲁斯"]["alertnearby"] ) then
					CT_RABoss_Announce(format(CT_RABOSS_GROBBULUS_AFFLICTED, playername), CT_RABoss_Mods["格罗布鲁斯"]["announce"]);
					CT_RABoss_PlaySound(3);
				end
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["格罗布鲁斯"]["announce"] ) then
					CT_RA_AddMessage("MS " .. format(CT_RABOSS_GROBBULUS_AFFLICTED, playername));
					local i, RaidID;
					for i = 1, GetNumRaidMembers() do
						if UnitName("raid"..i) == playername then
							RaidID = i;
						end
					end
					if ( RaidID and (GetRaidTargetIndex("raid"..RaidID) ~= 8) ) then
						SetRaidTarget("raid"..RaidID, 8);
					end
				end
			end
		end

	elseif ( event == "sspray5sec" ) then
		CT_RABoss_Mods["格罗布鲁斯"]["SSprayTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_GROBBULUS_SSPRAY_5SEC, CT_RABoss_Mods["格罗布鲁斯"]["announce"]);
	end
end


-- Gluth - (22/08/2006) - Changed over to chat_msg_addon.
function CT_RABoss_MRGluth_OnLoad()
	CT_RABoss_AddMod("格拉斯", CT_RABOSS_MRGLUTH_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "CHAT_MSG_ADDON", CT_RABoss_MRGluth_EventHandler);
	CT_RABoss_AddEvent("格拉斯", "PLAYER_REGEN_DISABLED", CT_RABoss_MRGluth_EventHandler);

	CT_RABoss_AddDropDownButton("格拉斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("格拉斯", { CT_RABOSS_MRGLUTH_FRENZY_ALERT, CT_RABOSS_MRGLUTH_FRENZY_ALERT_INFO }, "CT_RABoss_ModInfo", "frenzyalert", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("格拉斯", { CT_RABOSS_MRGLUTH_FEAR_ALERT, CT_RABOSS_MRGLUTH_FEAR_ALERT_INFO }, "CT_RABoss_ModInfo", "fearalert", "CT_RABoss_SetInfo");

	CT_RABoss_SetVar("格拉斯", "frenzyalert", 1);
	CT_RABoss_SetVar("格拉斯", "fearalert", 1);
end

function CT_RABoss_MRGluth_Start()
	CT_RABoss_Announce(CT_RABOSS_MRGLUTH_ENGAGED, CT_RABoss_Mods["格拉斯"]["announce"]);
	CT_RABoss_PlaySound(3);
	CT_RABoss_Schedule("CT_RABoss_MRGluth_EventHandler", 100, "decimatewarn");
	CT_RABoss_Mods["格拉斯"]["lastaction"] = time();
	CT_RABoss_Mods["格拉斯"]["engaged"] = true;

	if ( CT_RA_Level >= 1 and CT_RABoss_Mods["格拉斯"]["announce"] ) then
		CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRGLUTH_DECIMATESTRING, "105", "255*0*0"));
	end
end

function CT_RABoss_MRGluth_EventHandler(event)
	if ( not CT_RABoss_Mods["格拉斯"] or not CT_RABoss_Mods["格拉斯"]["status"] or not CT_RABoss_Mods["格拉斯"].enabled ) then
		return;
	end

	if ( CT_RABoss_Mods["格拉斯"]["engaged"] and ( not CT_RABoss_Mods["格拉斯"]["lastaction"] or ( time() - CT_RABoss_Mods["格拉斯"]["lastaction"] ) > 60 ) ) then
		CT_RABoss_Mods["格拉斯"]["engaged"] = false;
	end

	if ( event == "CHAT_MSG_MONSTER_EMOTE" and arg2 == CT_RABOSS_MRGLUTH_BOSSNAME ) then
		if ( string.find(arg1, CT_RABOSS_MRGLUTH_FRENZYSTRING) and CT_RABoss_Mods["格拉斯"]["frenzyalert"] ) then
			CT_RABoss_Announce(CT_RABOSS_MRGLUTH_FRENZYWARNING, CT_RABoss_Mods["格拉斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Mods["格拉斯"]["lastaction"] = time();
		end

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_MRGLUTH_DECIMATESTRING) and not CT_RABoss_Mods["格拉斯"]["decimated"] ) then
			CT_RABoss_Mods["格拉斯"]["decimated"] = true;
			CT_RABoss_Announce(CT_RABOSS_MRGLUTH_DECIMATEWARNING, CT_RABoss_Mods["格拉斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRGluth_EventHandler", 105, "decimatewarn");
			CT_RABoss_Schedule("CT_RABoss_MRGluth_EventHandler", 5, "undecimate");
			CT_RABoss_Mods["格拉斯"]["lastaction"] = time();

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["格拉斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRGLUTH_DECIMATESTRING, "110", "255*0*0"));
			end
		end

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_MRGLUTH_FEARSTRING) and CT_RABoss_Mods["格拉斯"]["fearalert"] and not CT_RABoss_Mods["格拉斯"]["feartrip"] ) then
			CT_RABoss_Mods["格拉斯"]["feartrip"] = true;
			CT_RABoss_Announce(CT_RABOSS_MRGLUTH_FEARWARNING, CT_RABoss_Mods["格拉斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_MRGluth_EventHandler", 15, "prefear");
			CT_RABoss_Mods["格拉斯"]["lastaction"] = time();

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["格拉斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "2", "20", CT_RABOSS_MRGLUTH_FEAR, "20", "0*0*255"));
			end
		end

	elseif ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["格拉斯"]["engaged"] ) then
		if ( not CT_RABoss_Mods["格拉斯"]["engaged"] ) then
			CT_RABoss_Schedule("CT_RABoss_MRGluth_EventHandler", 5, "engagecheck");
		end

	elseif ( event == "CHAT_MSG_ADDON" and arg1 == "CTRA" ) then
		if ( arg2 == "GLUTHENGSYNC" and not CT_RABoss_Mods["格拉斯"]["engaged"] ) then
			CT_RABoss_MRGluth_Start();
		end

	elseif ( event == "engagecheck" and not CT_RABoss_Mods["格拉斯"]["engaged"] ) then
		if ( UnitName("target") == CT_RABOSS_MRGLUTH_BOSSNAME and UnitAffectingCombat("target") ) then
			CT_RABoss_MRGluth_Start();
			CT_RA_SendMessage("GLUTHENGSYNC");

		elseif ( UnitName("playertarget") == CT_RABOSS_MRGLUTH_BOSSNAME and UnitAffectingCombat("playertarget") ) then
			CT_RABoss_MRGluth_Start();
			CT_RA_SendMessage("GLUTHENGSYNC");
		else
			local i
			for i = 1, GetNumRaidMembers(), 1 do
				if ( UnitName("raid"..i.."target") == CT_RABOSS_MRGLUTH_BOSSNAME and UnitAffectingCombat("raid"..i.."target")) then
					CT_RABoss_MRGluth_Start();
					CT_RA_SendMessage("GLUTHENGSYNC");
					break;
				end
			end
		end

	elseif ( event == "undecimate" ) then
		CT_RABoss_Mods["格拉斯"]["decimated"] = false;

	elseif ( event == "decimatewarn" ) then
		CT_RABoss_Announce(CT_RABOSS_MRGLUTH_DECIMATESOON, CT_RABoss_Mods["格拉斯"]["announce"]);
		CT_RABoss_PlaySound(2);

	elseif ( event == "prefear" ) then
		CT_RABoss_Mods["格拉斯"]["feartrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_MRGLUTH_FEAR5SEC, CT_RABoss_Mods["格拉斯"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Thaddius - (23/08/2006) - Updated charge checking script.
function CT_RABoss_MRThaddius_OnLoad()
	CT_RABoss_AddMod("塔迪乌斯", CT_RABOSS_MRTHADDIUS_INFO, 1, CT_RABOSS_LOCATIONS_NAXXRAMAS);
	CT_RABoss_AddEvent("塔迪乌斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_MRThaddius_EventHandler);
	CT_RABoss_AddEvent("塔迪乌斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_MRThaddius_EventHandler);
	CT_RABoss_AddEvent("塔迪乌斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_MRThaddius_EventHandler);
	CT_RABoss_AddEvent("塔迪乌斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_MRThaddius_EventHandler);
	CT_RABoss_AddEvent("塔迪乌斯", "CHAT_MSG_MONSTER_YELL", CT_RABoss_MRThaddius_EventHandler);
	CT_RABoss_AddEvent("塔迪乌斯", "PLAYER_AURAS_CHANGED", CT_RABoss_MRThaddius_EventHandler);

	CT_RABoss_AddDropDownButton("塔迪乌斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("塔迪乌斯", { CT_RABOSS_MRTHADDIUS_SURGE_ALERT, CT_RABOSS_MRTHADDIUS_SURGE_ALERT_INFO }, "CT_RABoss_ModInfo", "surgealert", "CT_RABoss_SetInfo");

	CT_RABoss_SetVar("塔迪乌斯", "surgealert", 1);
end

function CT_RABoss_MRThaddius_EventHandler(event)
	if ( not CT_RABoss_Mods["塔迪乌斯"] or not CT_RABoss_Mods["塔迪乌斯"]["status"] or not CT_RABoss_Mods["塔迪乌斯"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" ) then
		if ( arg1 == CT_RABOSS_MRTHADDIUS_PHASE1_YELL1 or arg1 == CT_RABOSS_MRTHADDIUS_PHASE1_YELL2 ) then
			if ( not CT_RABoss_Mods["塔迪乌斯"]["firstyell"] ) then
				CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_PHASE1, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
				CT_RABoss_PlaySound(3);
				CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 15, "throw5");
				CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 20, "throw");
				CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 5, "yellreset");
				CT_RABoss_Mods["塔迪乌斯"]["firstyell"] = true;
				CT_RABoss_Mods["塔迪乌斯"]["lastaction"] = time();
			end

		elseif ( arg1 == CT_RABOSS_MRTHADDIUS_PHASE2_YELL1 or arg1 == CT_RABOSS_MRTHADDIUS_PHASE2_YELL2 or arg1 == CT_RABOSS_MRTHADDIUS_PHASE2_YELL3 ) then
			CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_PHASE2, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_UnSchedule("CT_RABoss_MRThaddius_EventHandler", "throw5");
			CT_RABoss_UnSchedule("CT_RABoss_MRThaddius_EventHandler", "throw");
			CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 30, "enragetimer");
			CT_RABoss_Mods["塔迪乌斯"]["enrageleft"] = 4.5;
			CT_RABoss_Mods["塔迪乌斯"]["lastaction"] = time();

		elseif ( arg1 == CT_RABOSS_MRTHADDIUS_DEAD ) then
			CT_RABoss_UnSchedule("CT_RABoss_MRThaddius_EventHandler");
		end

	elseif ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" ) then
		if ( arg1 == CT_RABOSS_MRTHADDIUS_SURGESTRING and CT_RABoss_Mods["塔迪乌斯"]["surgealert"] ) then
			CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_SURGE, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_PlaySound(2);
			CT_RABoss_Mods["塔迪乌斯"]["lastaction"] = time();
		end

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" ) then
		if ( arg1 == CT_RABOSS_MRTHADDIUS_POLARITYSTRING ) then
			CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_POLARITYWARN, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Mods["塔迪乌斯"]["lastaction"] = time();

		elseif ( arg1 == CT_RABOSS_MRTHADDIUS_SHIFTSTRING ) then
			CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_SHIFTWARN, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_PlaySound(1);
			CT_RABoss_Mods["塔迪乌斯"]["lastaction"] = time();
			CT_RABoss_Mods["塔迪乌斯"]["debuffcheck"] = true;

			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["塔迪乌斯"]["announce"] ) then
				CT_RA_SendMessage(format(CT_RABOSS_MRMUKKA_STRING, "1", "20", CT_RABOSS_MRTHADDIUS_POLARITY, "30", "255*0*0"));
			end
		end

	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and arg2 == CT_RABOSS_MRTHADDIUS_BOSSNAME ) then
		if ( arg1 == CT_RABOSS_MRTHADDIUS_BERSERKSTRING ) then
			CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_BERSERKWARNING, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_PlaySound(1);
			CT_RABoss_UnSchedule("CT_RABoss_MRThaddius_EventHandler", "enragetimer");
			CT_RABoss_UnSchedule("CT_RABoss_MRThaddius_EventHandler", "enrage15");
			CT_RABoss_UnSchedule("CT_RABoss_MRThaddius_EventHandler", "enrage5");
			CT_RABoss_Mods["塔迪乌斯"]["lastaction"] = time();
		end

	elseif ( event == "PLAYER_AURAS_CHANGED" and CT_RABoss_Mods["塔迪乌斯"]["debuffcheck"] ) then
		local i = 1;
		local charge = nil;
		while UnitDebuff("player", i) do
			local t,a = UnitDebuff("player", i);
			if ( t == CT_RABOSS_MRTHADDIUS_POSITIVE or t == CT_RABOSS_MRTHADDIUS_NEGATIVE ) then
				if ( a > 1 ) then
					return;
				end

				charge = t;
			end
			i = i + 1;
		end
	
		if ( charge == nil ) then
			return;
		elseif ( charge ) then
			CT_RABoss_Mods["塔迪乌斯"]["debuffcheck"] = false;
			if ( charge == oldcharge ) then
				CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_NOCHANGEWARN);
			elseif ( charge == CT_RABOSS_MRTHADDIUS_POSITIVE ) then
				CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_POSITIVEWARN);
			elseif ( charge == CT_RABOSS_MRTHADDIUS_NEGATIVE ) then
				CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_NEGATIVEWARN);
			end
		end
		local oldcharge = charge;

	elseif ( event == "enragetimer") then
		if ( not CT_RABoss_Mods["塔迪乌斯"]["lastaction"] or ( time() - CT_RABoss_Mods["塔迪乌斯"]["lastaction"] ) > 60 ) then
			return;

		elseif ( CT_RABoss_Mods["塔迪乌斯"]["enrageleft"] == 0.5 ) then
			CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 15, "enrage15");
			CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 25, "enrage5");
			CT_RABoss_Announce(format(CT_RABOSS_MRTHADDIUS_SECWARN, "30"), CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_PlaySound(3);
		else
			if ( CT_RABoss_Mods["塔迪乌斯"]["enrageleft"] == 1 ) then
				CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_1MINWARN, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			else
				CT_RABoss_Announce(format(CT_RABOSS_MRTHADDIUS_WARN, CT_RABoss_Mods["塔迪乌斯"]["enrageleft"]), CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			end

			CT_RABoss_Mods["塔迪乌斯"]["enrageleft"] = CT_RABoss_Mods["塔迪乌斯"]["enrageleft"]-0.5;
			CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 30, "enragetimer");
			CT_RABoss_PlaySound(3);
		end
	
	elseif ( event == "throw5" ) then
		CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_THROWMSG5, CT_RABoss_Mods["塔迪乌斯"]["announce"]);

	elseif ( event == "throw" ) then
		if ( not CT_RABoss_Mods["塔迪乌斯"]["lastaction"] or ( time() - CT_RABoss_Mods["塔迪乌斯"]["lastaction"] ) > 60 ) then
			return;
		else
			CT_RABoss_Announce(CT_RABOSS_MRTHADDIUS_THROWMSG, CT_RABoss_Mods["塔迪乌斯"]["announce"]);
			CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 16, "throw5");
			CT_RABoss_Schedule("CT_RABoss_MRThaddius_EventHandler", 21, "throw");
		end

	elseif ( event == "yellreset" ) then
		CT_RABoss_Mods["塔迪乌斯"]["firstyell"] = false;

	elseif ( event == "enrage15" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRTHADDIUS_SECWARN, "15"), CT_RABoss_Mods["塔迪乌斯"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "enrage5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_MRTHADDIUS_SECWARN, "5"), CT_RABoss_Mods["塔迪乌斯"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end