local revision = tonumber(string.sub("$Revision: 18625 $", 12, -3))
if revision > Cartographer.revision then
	Cartographer.version = "r" .. revision
	Cartographer.revision = revision
	Cartographer.date = string.sub("$Date: 2006-12-02 16:13:35 +0300 (Сб, 02 дек 2006) $", 8, 17)
end

local L = AceLibrary("AceLocale-2.2"):new("Cartographer_InstanceNotes")
local BB = AceLibrary("Babble-Boss-2.2")

Cartographer_InstanceNotes.notes = {
	["The Stockade"] = {
		[562278] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Hamhock"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[418065] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Kam Deepfury"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[365861] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Targorr the Dread"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[741235] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[618410] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Bazil Thredd"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[409687] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Dextren Ward"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[549883] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Bruegal Ironknuckle"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Razorfen Downs"] = {
		[647958] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Glutton"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[260472] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[488220] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Mordresh Fire Eye"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[375889] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Tuten'kash"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[284947] = {
			["titleB"] = 0,
			["info2"] = L["Teaches recipes for Goldthorn Tea & Mighty Troll's Blood Potion"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Henry Stern"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s %s"], 36, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[669114] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Ragglesnout"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[598993] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Amnennar the Coldbringer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Ruins of Ahn'Qiraj"] = {
		[53647] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[722091] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ossirian the Unscarred"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[326597] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Moam"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[318848] = {
			["titleB"] = 0,
			["info2"] = L["Level ?? Elite Boss"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Kurinnaxx"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[511056] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["General Rajaxx"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[893495] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ayamiss the Hunter"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[700292] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Safe Room"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[550256] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Buru the Gorger"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Lower Blackrock Spire"] = {
		[279716] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Bannok Grimaxe"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 59, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[349598] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Warlord's Command'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Highlord Omokk"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[618288] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Warlord's Command'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["War Master Voone"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[509195] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'The lost tablets of Mosh'aru'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Fifth Mosh'aru Tablet"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[516922] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Crystal Fang"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 60, L["Beast"]),
			["titleR"] = 0.9,
		},
		[594265] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'The lost tablets of Mosh'aru'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Sixth Mosh'aru Tablet"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[320685] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Urok Doomhowl"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 60, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[934230] = {
			["titleB"] = 0,
			["info2"] = L["Spawns Gizrul the Slavener when killed"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Halycon"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 59, L["Beast"]),
			["titleR"] = 0.9,
		},
		[137345] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[851199] = {
			["titleB"] = 0,
			["info2"] = L["Spawned by killing Halycon"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Gizrul the Slavener"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 60, L["Beast"]),
			["titleR"] = 0.9,
		},
		[342957] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Urok Doomhowl'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Roughshod Pike"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[573091] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Mothers Milk'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Mother Smolderweb"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 59, L["Beast"]),
			["titleR"] = 0.9,
		},
		[627086] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Warlord's Command' and 'General Drakkisath's Command'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Overlord Wyrmthalak"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Dragon"]),
			["titleR"] = 0.9,
		},
		[920424] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Quartermaster Zigris"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 59, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[67375] = {
			["titleB"] = 0,
			["info2"] = L["Requires the Seal of Ascension"],
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Upper Blackrock Spire"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[179691] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Urok Doomhowl'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Warosh"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s %s"], 60, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[166541] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Seal of Ascension'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Vaelan"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 55, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[485171] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Shadow Hunter Vosh'gajin"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Humanoid"]),
			["titleR"] = 0.9,
		},
	},
	["Uldaman"] = {
		[620156] = {
			["titleB"] = 0,
			["info2"] = L["Master Enchanter"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Annora"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[727309] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Revelosh"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[737157] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Ironaya"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[333651] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Galgann Firehammer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[729478] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Front Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[637221] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Remains of a Paladin"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[629969] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Obsidian Sentinel"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[902543] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Baelog"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[704014] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Rear Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[454983] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Ancient Stone Keeper"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[98528] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Ancient Treasure"],
			["titleG"] = 0,
			["info"] = L["Lower level"],
			["titleR"] = 0.9,
		},
		[223506] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Grimlok"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[70510] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["The Discs of Norgannon"],
			["titleG"] = 0,
			["info"] = L["Upper level"],
			["titleR"] = 0.9,
		},
		[168639] = {
			["titleB"] = 0,
			["info2"] = L["Lower level"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] =L["Archaedas"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["The Deadmines"] = {
		[417954] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Defias Gunpowder"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[373071] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Cookie"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[507940] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Miner Johnson"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[450254] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Exit"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[582900] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Rhahk'Zor"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[758183] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Sneed"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[413074] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Captain Greenskin"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[555039] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Gilnid"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[254518] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[330998] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Mr. Smite"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[390068] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Edwin VanCleef"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Blackwing Lair"] = {
		[637016] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Vaelastrasz the Corrupt"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[655160] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Razorgore the Untamed"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[170761] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Nefarian"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[302628] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Flamegor"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[382777] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Chromaggus"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[447705] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Firemaw"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[293541] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ebonroc"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[713324] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[423653] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Broodlord Lashlayer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[938360] = {
			["titleB"] = 0,
			["icon"] = "Triangle",
			["manual"] = false,
			["title"] = "A",
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[651275] = {
			["titleB"] = 0,
			["icon"] = "Triangle",
			["manual"] = false,
			["title"] = "A",
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[524805] = {
			["titleB"] = 0,
			["icon"] = "Moon",
			["manual"] = false,
			["title"] = "B",
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[508000] = {
			["titleB"] = 0,
			["icon"] = "Moon",
			["manual"] = false,
			["title"] = "B",
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Ahn'Qiraj"] = {
		[380668] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[443761] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["The Prophet Skeram"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[507846] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["C'Thun"],
			["titleG"] = 0,
			["info"] = L["Eye of C'Thun"],
			["titleR"] = 0.9,
		},
		[849178] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ouro"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[556895] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Meritha of the Dream"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[498943] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Princess Huhuran"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[324762] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Battleguard Sartura"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[465805] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Kandrostrasz"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[549878] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Arygos"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[456810] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Vethsera"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[537808] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lord Kri"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[528815] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Vem"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[671307] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Twin Emperors"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[549834] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Princess Yauj"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[100802] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Viscidus"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[565893] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Caelestrasz"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[165773] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Fankriss the Unyielding"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[449789] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Andorgos"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Scholomance"] = {
		[370631] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Deed to Tarren Mill"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[430787] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Vectus"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[430772] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Marduk Blackpool"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[541005] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lorekeeper Polkelt"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[925390] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Instructor Malicia"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[352862] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Blood Steward of Kirtonos"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[275804] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Deed to Southshore"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[739532] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lord Alexei Barov"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[750075] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Deed to Brill"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[316646] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[737397] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Darkmaster Gandling"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[664935] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Alchemy Lab"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[830127] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ras Frostwhisper"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[403648] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Rattlegore"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[386749] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Secret Chest"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[543200] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lady Illucia Barov"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[63438] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Kirtonos the Herald"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[714507] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Deed to Caer Darrow"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[112896] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Jandice Barov"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[734330] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Doctor Theolen Krastinov"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[209957] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Torch Lever"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[932589] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["The Ravenian"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Ragefire Chasm"] = {
		[69670] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[593997] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Taragaman the Hungerer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[548182] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Maur Grimtotem"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[886304] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Bazzalan"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[841174] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Jergosh the Invoker"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Naxxramas"] = {
		[752996] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Sir Zeliek"],
			["titleG"] = 0,
			["info"] = L["Deathknight Wing"],
			["titleR"] = 0.9,
		},
		[237562] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Gluth"],
			["titleG"] = 0,
			["info"] = L["Abomination Wing"],
			["titleR"] = 0.9,
		},
		[239709] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Anub'Rekhan"],
			["titleG"] = 0,
			["info"] = L["Spider Wing"],
			["titleR"] = 0.9,
		},
		[420868] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[636114] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Noth the Plaguebringer"],
			["titleG"] = 0,
			["info"] = L["Necro Wing"],
			["titleR"] = 0.9,
		},
		[581880] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Instructor Razuvious"],
			["titleG"] = 0,
			["info"] = L["Deathknight Wing"],
			["titleR"] = 0.9,
		},
		[482179] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Loatheb"],
			["titleG"] = 0,
			["info"] = L["Necro Wing"],
			["titleR"] = 0.9,
		},
		[85739] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Maexxna"],
			["titleG"] = 0,
			["info"] = L["Spider Wing"],
			["titleR"] = 0.9,
		},
		[187723] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Grand Widow Faerlina"],
			["titleG"] = 0,
			["info"] = L["Spider Wing"],
			["titleR"] = 0.9,
		},
		[376703] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Patchwerk"],
			["titleG"] = 0,
			["info"] = L["Abomination Wing"],
			["titleR"] = 0.9,
		},
		[311704] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Grobbulus"],
			["titleG"] = 0,
			["info"] = L["Abomination Wing"],
			["titleR"] = 0.9,
		},
		[775000] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Highlord Mograine"],
			["titleG"] = 0,
			["info"] = L["Deathknight Wing"],
			["titleR"] = 0.9,
		},
		[777434] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Kel'Thuzad"],
			["titleG"] = 0,
			["info"] = L["Frostwyrm Lair"],
			["titleR"] = 0.9,
		},
		[750961] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lady Blaumeux"],
			["titleG"] = 0,
			["info"] = L["Deathknight Wing"],
			["titleR"] = 0.9,
		},
		[632046] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Gothik the Harvester"],
			["titleG"] = 0,
			["info"] = L["Deathknight Wing"],
			["titleR"] = 0.9,
		},
		[734960] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Thane Korth'azz"],
			["titleG"] = 0,
			["info"] = L["Deathknight Wing"],
			["titleR"] = 0.9,
		},
		[578138] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Heigan the Unclean"],
			["titleG"] = 0,
			["info"] = L["Necro Wing"],
			["titleR"] = 0.9,
		},
		[78299] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Thaddius"],
			["titleG"] = 0,
			["info"] = L["Abomination Wing"],
			["titleR"] = 0.9,
		},
		[887619] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Sapphiron"],
			["titleG"] = 0,
			["info"] = L["Frostwyrm Lair"],
			["titleR"] = 0.9,
		},
	},
	["Blackfathom Deeps"] = {
		[405854] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Gelihast"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 25, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[757268] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Baron Aquanis'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Baron Aquanis"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 28, L["Elemental"]),
			["titleR"] = 0.9,
		},
		[438757] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Ghamoo-ra"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 25, L["Giant Turtle"]),
			["titleR"] = 0.9,
		},
		[475976] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lorgus Jett"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 26, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[312645] = {
			["titleB"] = 0,
			["info2"] = L["Found in a chest in the water near the central island. Required for 'Knowledge of the Deeps' quest."],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Lorgalis Manuscript"],
			["titleG"] = 0,
			["info"] = L["Quest Item"],
			["titleR"] = 0.9,
		},
		[722302] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Old Serra'Kis"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 26, L["Beast"]),
			["titleR"] = 0.9,
		},
		[804390] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Twilight Lord Kelris"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 27, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[519780] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'In search of Thaelrid'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Argent Guard Thaelrid"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s %s"], 20, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[309511] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lady Sarevess"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 25, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[830613] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'The essence of Aku'mai'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Aku'Mai"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 29, L["Beast (Hydra)"]),
			["titleR"] = 0.9,
		},
		[135530] = {
			["titleB"] = 0,
			["info2"] = L["Dive into the water at temple entrance, under the arch and swim up to dry land inside."],
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Wailing Caverns"] = {
		[530096] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lord Serpentis"],
			["titleG"] = 0,
			["info"] = L["Upper level"],
			["titleR"] = 0.9,
		},
		[580039] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[364082] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lord Pythas"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[431901] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Kresh"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[480010] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Verdan the Everliving"],
			["titleG"] = 0,
			["info"] = L["Upper level"],
			["titleR"] = 0.9,
		},
		[690457] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Skum"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[556830] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lord Cobrahn"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[366786] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lady Anacondra"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[515981] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Disciple of Naralex"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[268652] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Mutanus the Devourer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[263661] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Naralex"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Shadowfang Keep"] = {
		[753379] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Sorcerer Ashcrombe"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[674330] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[608953] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Razorclaw the Butcher"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[339014] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Wolf Master Nandos"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[683069] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Commander Springvale"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[837375] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Odo the Blindwatcher"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[746348] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Rethilgore"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[707333] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Deathstalker Adamant"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[370885] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Fenrus the Devourer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[827098] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Baron Silverlaine"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[853458] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Deathsworn Captain"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[130834] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Archmage Arugal"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Zul'Gurub"] = {
		[345916] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Muddy Churning Waters"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[493980] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Muddy Churning Waters"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[428826] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Muddy Churning Waters"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[338787] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Muddy Churning Waters"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[354954] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Gahz'ranka"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[471119] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Hazza'rah, the Dreamweaver"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[489123] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Renataki of the Thousand Blades"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[181488] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Jin'do the Hexxer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[400937] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Hakkar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[505756] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[711371] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Bloodlord Mandokir"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[835310] = {
			["titleB"] = 0,
			["info2"] = L["Summons Spider adds"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["High Priestess Mar'li"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[471107] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Gri'lek of the Iron Blood"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[489136] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Wushoolay the Storm Witch"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[581180] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Zanza the Restless"],
			["titleG"] = 0,
			["info"] = L["ZG head & leg enchants"],
			["titleR"] = 0.9,
		},
		[184680] = {
			["titleB"] = 0,
			["info2"] = L["Summons swarms of Panther adds"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["High Priestess Arlokk"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[464023] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Muddy Churning Waters"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[345730] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Muddy Churning Waters"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[809180] = {
			["titleB"] = 0,
			["info2"] = L["Summons Bat adds"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["High Priestess Jeklik"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[331028] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["High Priest Thekal"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[588117] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["High Priest Venoxis"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Maraudon"] = {
		[329052] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance (Purple)"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[837230] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Princess Theradras"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[338862] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lord Vyletongue"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[565975] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance (Portal)"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[358743] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Celebras the Cursed"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[144780] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance (Orange)"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[166582] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Razorlash"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[727283] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Tinkerer Gizlock"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[105667] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Veng"],
			["titleG"] = 0,
			["info"] = L["The Fifth Khan"],
			["titleR"] = 0.9,
		},
		[809274] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Rotgrip"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[609122] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Landslide"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[288901] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Maraudos"],
			["titleG"] = 0,
			["info"] = L["The Fourth Khan"],
			["titleR"] = 0.9,
		},
		[63580] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Noxxion"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[331782] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Meshlok the Harvester"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Dire Maul (East)"] = {
		[319524] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Exit"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[797239] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Hydrospawn"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[359616] = {
			["titleB"] = 0,
			["info2"] = L["Talking to him begins a chase, resulting in obtaining the kep for other parts of Dire Maul"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Pusillin Start"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Demon"]),
			["titleR"] = 0.9,
		},
		[177631] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Alzzin the Wildshaper"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[533872] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Old Ironbark"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[687948] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[828369] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Zevrim Thornhoof"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[490272] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[463921] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lethtendris"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[448100] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Pusillin End"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[468696] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Dire Maul (West)"] = {
		[258623] = {
			["titleB"] = 0,
			["icon"] = "Diamond",
			["manual"] = false,
			["title"] = L["Pylon"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[197665] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Prince Tortheldrin"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[299000] = {
			["titleB"] = 0,
			["icon"] = "Diamond",
			["manual"] = false,
			["title"] = L["Pylon"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[849418] = {
			["titleB"] = 0,
			["icon"] = "Diamond",
			["manual"] = false,
			["title"] = L["Pylon"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[207736] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Tsu'zee"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[590159] = {
			["titleB"] = 0,
			["icon"] = "Diamond",
			["manual"] = false,
			["title"] = L["Pylon"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[397181] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[867360] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Illyanna Ravenoak"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[354904] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Tendris Warpwood"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[416734] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Immol'thar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[496024] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Magister Kalendris"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[151665] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Library"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[717330] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Shen'dralar Ancient"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[578943] = {
			["titleB"] = 0,
			["icon"] = "Diamond",
			["manual"] = false,
			["title"] = L["Pylon"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[95697] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Dire Maul (North)"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Scarlet Monastery"] = {
		[93747] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Herod"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[641061] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Cathedral Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[76409] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["High Inquisitor Whitemane"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[902683] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Arcanist Doan"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[648171] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Armoury Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[144524] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["High Inquisitor Fairbanks"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[939475] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Graveyard Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[722263] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Library Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[860176] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Ironspine"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[790014] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Fallen Champion"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[934539] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Houndmaster Loksey"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[154487] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Scarlet Commander Mograine"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[865086] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Azshir the Sleepless"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[768973] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Bloodmage Thalnos"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Razorfen Kraul"] = {
		[344773] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Willix the Importer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[398912] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Earthcaller Halmgar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[404185] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Death Speaker Jargba"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[490229] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Aggem Thorncurse"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[349691] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Charlga Razorflank"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[352590] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Blind Hunter"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[392007] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Roogug"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[656912] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Agathelos the Raging"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[706378] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[319885] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Overlord Ramtusk"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["The Temple of Atal'Hakkar"] = {
		[294046] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ogom the Wretched"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[438034] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Troll Miniboss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[639198] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Morphaz"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[292025] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Jammal'an the Prophet"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[347841] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Troll Miniboss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[98668] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[707019] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Atal'alarion"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[677951] = {
			["titleB"] = 0,
			["info2"] = L["Snake statues are activated in a specific sequence. When all are activated correctly, it will summon Atal'alarion"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Statue (North-West)"],
			["titleG"] = 0,
			["info"] = L["Sequence No: 5"],
			["titleR"] = 0.9,
		},
		[622199] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Hazzas"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[258788] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Troll Miniboss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[438967] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Troll Miniboss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[352888] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Dreamscythe"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[676048] = {
			["titleB"] = 0,
			["info2"] = L["Snake statues are activated in a specific sequence. When all are activated correctly, it will summon Atal'alarion"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Statue (North-East)"],
			["titleG"] = 0,
			["info"] = L["Sequence No: 6"],
			["titleR"] = 0.9,
		},
		[256854] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Troll Miniboss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[344744] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Avatar of Hakkar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[725046] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Altar of Hakkar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[636959] = {
			["titleB"] = 0,
			["info2"] = L["Snake statues are activated in a specific sequence. When all are activated correctly, it will summon Atal'alarion"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Statue (North)"],
			["titleG"] = 0,
			["info"] = L["Sequence No: 2"],
			["titleR"] = 0.9,
		},
		[764137] = {
			["titleB"] = 0,
			["info2"] = L["Snake statues are activated in a specific sequence. When all are activated correctly, it will summon Atal'alarion"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Statue (South-East)"],
			["titleG"] = 0,
			["info"] = L["Sequence No: 4"],
			["titleR"] = 0.9,
		},
		[588296] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Essence Font"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[765037] = {
			["titleB"] = 0,
			["info2"] = L["Snake statues are activated in a specific sequence. When all are activated correctly, it will summon Atal'alarion"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Statue (South-West)"],
			["titleG"] = 0,
			["info"] = L["Sequence No: 3"],
			["titleR"] = 0.9,
		},
		[349984] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Troll Miniboss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[807128] = {
			["titleB"] = 0,
			["info2"] = L["Snake statues are activated in a specific sequence. When all are activated correctly, it will summon Atal'alarion"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Statue (South)"],
			["titleG"] = 0,
			["info"] = L["Sequence No: 1"],
			["titleR"] = 0.9,
		},
		[367918] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Weaver"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[625308] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Shade of Eranikus"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Gnomeregan"] = {
		[448060] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Matrix Punchograph 3005-B"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[407984] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Clean Zone"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[305937] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Viscous Fallout"],
			["titleG"] = 0,
			["info"] = L["Lower level"],
			["titleR"] = 0.9,
		},
		[529762] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Dark Iron Ambassador"],
			["titleG"] = 0,
			["info"] = L["Rare spawn"],
			["titleR"] = 0.9,
		},
		[400651] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Mekgineer Thermaplugg"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[445800] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Matrix Punchograph 3005-C"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[557281] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Back Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[118824] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Front Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[406197] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Grubbis"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[737215] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Matrix Punchograph 3005-D"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[440810] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Electrocutioner 6000"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[762231] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Crowd Pummeler 9-60"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Dire Maul (North)"] = {
		[573056] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Guard Fengus"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[839119] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Library"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[407691] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Guard Slip'kik"],
			["titleG"] = 0,
			["info"] = L["Drops the Inner Gordok key"],
			["titleR"] = 0.9,
		},
		[109425] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Cho'Rush the Observer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[543239] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Guard Mol'dar"],
			["titleG"] = 0,
			["info"] = L["Drops the key to Library"],
			["titleR"] = 0.9,
		},
		[709372] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[326655] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Captain Kromcrush"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[939136] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Dire Maul (West)"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[467088] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Stomper Kreeg"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[373671] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Knot Thimblejack"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[121460] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["King Gordok"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[576076] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Chest"],
			["titleG"] = 0,
			["info"] = L["Contains the Outer Gordok key"],
			["titleR"] = 0.9,
		},
		[144483] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Tribute chest"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Zul'Farrak"] = {
		[260781] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Witch Doctor Zum'rah"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[890509] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[437830] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Hydromancer Velratha"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[279689] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Nekrum Gutchewer"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[421953] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Ruuzlu"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[275623] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Sergeant Bly"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[437959] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Chief Ukorz Sandscalp"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[483053] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn - Wanders"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Zerillis"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[288792] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Zul'Farrak Dead Hero"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[368971] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Theka the Martyr"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[381072] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Antu'sul"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[466879] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Gahz'rilla"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Onyxia's Lair"] = {
		[774274] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Onyxian Warder"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[411119] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Whelp Eggs"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[520203] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Whelp Eggs"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[151387] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[697141] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Onyxian Warder"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[407893] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Whelp Eggs"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[529037] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Whelp Eggs"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[410757] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Onyxian Warder"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[552919] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Onyxian Warder"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[251851] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Onyxia"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Stratholme"] = {
		[645007] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Crusaders' Square Postbox"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[780245] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn - Wanders"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Skul"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[710914] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Cannon Master Willey"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[219912] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Maleki the Pallid"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[223702] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Baron Rivendare"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[790240] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Fras Siabi"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[807252] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Fras Siabi's Postbox"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[875158] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Balnazzar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[433111] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Stonespine"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[640331] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Elders' Square Postbox"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[752431] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Service Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[626013] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Timmy the Cruel"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[569002] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Market Row Postbox"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[833156] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Archivist Galford"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[726222] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["King's Square Postbox"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[422166] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Baroness Anastari"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[909416] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Front Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[576075] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Hearthsinger Forresten"],
			["titleG"] = 0,
			["info"] = L["Rare spawn - location varies"],
			["titleR"] = 0.9,
		},
		[187802] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Magistrate Barthilas"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[609308] = {
			["titleB"] = 0,
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Aurius"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[813273] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Stratholme Courier"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[595128] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Festival Lane Postbox"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[573117] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["The Unforgiven"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[223751] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ramstein the Gorger"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[419025] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Nerub'enkan"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Blackrock Depths"] = {
		[772247] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Dark Iron Legacy'."],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Franclorn Forgewright Monument"],
			["titleG"] = 0,
			["info"] = L["Used to forge the BRD key"],
			["titleR"] = 0.9,
		},
		[848307] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Kharan Mighthammer'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Kharan Mighthammer"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 53, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[706095] = {
			["titleB"] = 0,
			["info2"] = L["Needs to be activated to open the gates to BRD"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Shadowforge Lock"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[881323] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Commander Gor'shak'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Commander Gor'shak"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 54, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[818146] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[486976] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Incendius!'. The Black Anvil is also located here."],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lord Incendius"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 56, L["Elemental"]),
			["titleR"] = 0.9,
		},
		[925392] = {
			["titleB"] = 0,
			["info2"] = L["Part of the lengthy Onyxia quest chain."],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Marshal Windsor"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 52, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[426960] = {
			["titleB"] = 0,
			["info2"] = L["Drops the hammer for the quest 'Dark Iron Legacy'."],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Fineous Darkvire"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 54, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[792210] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Lord Roccor"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 51, L["Elemental"]),
			["titleR"] = 0.9,
		},
		[725172] = {
			["titleB"] = 0,
			["info2"] = L["Defeating the mobs in here will turn the hostile spectators on upper level to neutral."],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Ring of Law"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[758242] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Pyromancer Loregrain"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[622881] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'A taste of flame'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Bael'Gar"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Giant"]),
			["titleR"] = 0.9,
		},
		[550039] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Warder Stilgiss"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[510949] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["The Grim Guzzler"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[223800] = {
			["titleB"] = 0,
			["info2"] = L["Used to smelt Dark Iron"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["The Black Forge"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[659998] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quests 'A shred of hope' and 'Operation: Death to Angerforge'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["General Angerforge"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[531046] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["The Vault"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[116790] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Magmus"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Giant"]),
			["titleR"] = 0.9,
		},
		[927351] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["High Interrogator Gerstahn"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 52, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[396872] = {
			["titleB"] = 0,
			["info2"] = L["Calls forth many Flame adds during fight"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ambassador Flamelash"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[310896] = {
			["titleB"] = 0,
			["info2"] = L["Opposite the entrance can be found the object for the quest 'Attunement to the core'."],
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["The Molten Core"],
			["titleG"] = 0,
			["info"] = L["Entrance to the Molten Core"],
			["titleR"] = 0.9,
		},
		[121687] = {
			["titleB"] = 0,
			["info2"] = L["Fight through fast spawning mobs and pick up 2 torches to light the flames which open the doors to t"],
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["The Lyceum"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[316766] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Panzor the Invincible"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Elemental"]),
			["titleR"] = 0.9,
		},
		[515855] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'A shred of hope' and 'The rise of the machines'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Golem Lord Argelmach"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 58, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[212680] = {
			["titleB"] = 0,
			["info2"] = L["Defeat the 7 dwarves to gain access to the rest of BRD, as well as a chest of goodies."],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Summoner's Tomb"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[118883] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'A royal rescue' to free Princess Moira Bronzebeard"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Emperor Dagran Thaurissan"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 59, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[825133] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Overmaster Pyron' and 'Disharmony of flame'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Overmaster Pyron"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 52, L["Elemental"]),
			["titleR"] = 0.9,
		},
	},
	["Molten Core"] = {
		[465733] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Gehennas"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[202825] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Magmadar"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[797540] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Sulfuron Harbinger"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[232439] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[365943] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Lucifron"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[680932] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Garr"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[613215] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Golemagg the Incinerator"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[616373] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Majordomo Executus"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[828277] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Shazzrah"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[751224] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Baron Geddon"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[534013] = {
			["titleB"] = 0,
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Ragnaros"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
	["Upper Blackrock Spire"] = {
		[516793] = {
			["titleB"] = 0,
			["info2"] = L["Lower level - Linked to the quest 'The Eye of the Emberseer'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Pyroguard Emberseer"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Elemental"]),
			["titleR"] = 0.9,
		},
		[695232] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'The Matron Protectorate'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Awbee"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 57, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[540869] = {
			["titleB"] = 0,
			["info2"] = L["Rare spawn"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = L["Jed Runewatcher"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 59, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[467002] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'For the Horde!'. Comes mounted on Gyth, a Lvl ?? Elite Dragon"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Warchief Rend Blackhand"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[692084] = {
			["titleB"] = 0,
			["icon"] = "Circle",
			["manual"] = false,
			["title"] = L["Father Flame"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[580958] = {
			["titleB"] = 0,
			["info2"] = L["Requires the Seal of Ascension"],
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Entrance"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
		[664426] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Breastplate of Bloodthirst'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["The Beast"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Beast"]),
			["titleR"] = 0.9,
		},
		[737079] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Doomrigger's Clasp'"],
			["icon"] = "Square",
			["manual"] = false,
			["title"] = L["Doomrigger's Clasp"],
			["titleG"] = 0,
			["info"] = L["Quest item"],
			["titleR"] = 0.9,
		},
		[508752] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'The Demon Forge'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["Goraluk Anvilcrack"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], 61, L["Humanoid"]),
			["titleR"] = 0.9,
		},
		[797109] = {
			["titleB"] = 0,
			["info2"] = L["Linked to the quest 'Drakefire Amulet', 'Blood of the Black Dragon Champion' & 'General Drakkisath's Demise'"],
			["icon"] = "Skull",
			["manual"] = false,
			["title"] = BB["General Drakkisath"],
			["titleG"] = 0,
			["info"] = string.format(L["Lvl %s Elite %s"], "??", L["Dragon"]),
			["titleR"] = 0.9,
		},
		[347975] = {
			["titleB"] = 0,
			["icon"] = "Star",
			["manual"] = false,
			["title"] = L["Blackwing Lair"],
			["titleG"] = 0,
			["titleR"] = 0.9,
		},
	},
}
