--[[---------------------------------------------------------------------------
    phRaid by pherl <pherl@live.com>
-----------------------------------------------------------------------------]]

local L = AceLibrary("AceLocale-2.0"):new("phRaid")
local phRAggro = phRaid:NewModule("phRaidAggro",
    "AceEvent-2.0",
    "AceConsole-2.0",
    "AceDebug-2.0"
)

function phRAggro:OnInitialize()
    self.aggro = {}
    phRaid.db.defaults.profile["Aggro"] = {
        time = 1.0,
    }
end

function phRAggro:OnEnable()
    self.enabled = true
    self:RegisterEvent("PHRAID_ROSTER_UPDATE")
    self:PHRAID_ROSTER_UPDATE()
    self:ScheduleRepeatingEvent("phRaidAggroCheck", self.AggroCheck, phRaid.db.profile.Aggro.time, self)
end

function phRAggro:OnDisable()
    self.enabled = false
    self:AggroCheck()
end

function phRAggro:PHRAID_ROSTER_UPDATE()
    self.rosterNames = {}
    for i, v in phRaid.visible do
        self.rosterNames[UnitName(i)] = i
    end
end

function phRAggro:AggroCheck()
    local visible = phRaid.visible
    local frames = phRaid.frames
    local aggro = self.aggro
    local rosterNames = self.rosterNames

    if not self.enabled then
        for i, v in pairs(visible) do
            frames[i].Aggro:Hide()
        end
        return
    end

    for i, v in pairs(visible) do
        -- From BanzaiLib. Will this buffered result be more acceptable?
        local unitName = UnitName(i)
        if not unitName then return end
        if not aggro[unitName] then aggro[unitName] = 0 end
        aggro[unitName] = aggro[unitName] - 5

        local target = i .. "target"
        local totName = UnitName(target .. "target")
        if rosterNames[totName] and UnitCanAttack("player", target) and UnitCanAttack(target, "player") then
            if not aggro[totName] then aggro[totName] = 0 end
            aggro[totName] = aggro[totName] + 10
        end
    
        aggro[unitName] = math.max(aggro[unitName], 0)
        aggro[unitName] = math.min(aggro[unitName], 25)

        if aggro[unitName] > 15 then
            frames[i].Aggro:Show()
        else
            frames[i].Aggro:Hide()
        end
    end
end

function phRAggro:CreateOptions(opt)
    self.options = opt
    local options = opt:AddOptionsTab("fphROptionsAggro", L["Aggro"])

    local encheck = opt:CreateCheck("EnableAggro", L["Enable"]..L["Aggro"], options, function () 
        local b = phRaid:ToggleModuleActive("phRaidAggro")
    end)
    encheck:SetChecked(self.enabled)
    encheck:SetPoint("TOPLEFT", options, "TOPLEFT", 10, -10)
    encheck:Show()
    local rate = opt:CreateSlider("AggroRate", L["RefreshRate"], 0.2, 5, 0.2, options, function()
        this.Current:SetText(string.format("%.2f", arg1))
        phRaid.db.profile.Aggro.time = arg1
        self:CancelScheduledEvent("phRaidAggroCheck")
        if self.enabled then
            self:ScheduleRepeatingEvent("phRaidAggroCheck", self.AggroCheck, arg1, self)
        end
    end)
    rate:SetValue(phRaid.db.profile.Aggro.time)
    rate:SetPoint("TOPLEFT", encheck, "BOTTOMLEFT", 0, -20)
end
