--[[---------------------------------------------------------------------------
    Name: phRaid
    Author: pherl <pherl@live.com>
-----------------------------------------------------------------------------]]

local L = AceLibrary("AceLocale-2.2"):new("phRaid")
local phRTargets = phRaid:NewModule("phRaidTargets",
    "AceEvent-2.0",
    "AceConsole-2.0",
    "AceDebug-2.0"
)

function phRTargets:OnInitialize()
    self.aggro = {}
    phRaid.db.defaults.profile["Targets"] = {
        Time = 1.0,
        ShowAggro = true,
        ShowRaidTargets = true,
    }
    phRaid.options.args.targets = {
        name = L["TargetsCheck"],
        desc = L["TargetsCheck"],
        type = "group",
        order = 400,
        args = {
            enable = {
                name = L["Enable"],
                type = "toggle",
                desc = L["TargetsCheck"],
                get = function() return phRaid:IsModuleActive("phRaidTargets") end,
                set = function() phRaid:ToggleModuleActive("phRaidTargets") end,
                order = 1,
            },
            time = {
                name = L["RefreshRate"],
                type = "range",
                min = 0.2,
                max = 5,
                step = 0.2,
                desc = L["RefreshRate"],
                get = function() return phRaid.db.profile.Targets.Time end,
                set = function(value)
                    phRaid.db.profile.Targets.Time = value
                    local self = phRaid:GetModule("phRaidTargets")
                    self:CancelScheduledEvent("phRaidTargetsCheck")
                    self:ScheduleRepeatingEvent("phRaidTargetsCheck", self.TargetsCheck, value, self)
                end,
                disabled = function() return not phRaid:IsModuleActive("phRaidTargets") end,
            },
            aggro = {
                name = L["Aggro"],
                type = "toggle",
                desc = "toggle",
                get = function() return phRaid.db.profile.Targets.ShowAggro end,
                set = function(value)
                    phRaid.db.profile.Targets.ShowAggro = value
                    for i,v in pairs(phRaid.frames) do
                        v.Aggro:Hide()
                    end
                end,
                disabled = function() return not phRaid:IsModuleActive("phRaidTargets") end,
            },
            raidTargets = {
                name = L["RaidTargets"],
                type = "toggle",
                desc = "toggle",
                get = function() return phRaid.db.profile.Targets.ShowRaidTargets end,
                set = function(value)
                    phRaid.db.profile.Targets.ShowRaidTargets = value
                end,
                disabled = function() return not phRaid:IsModuleActive("phRaidTargets") end,
            },
        }
    }
end

function phRTargets:OnEnable()
    self.enabled = true
    self:ScheduleRepeatingEvent("phRaidTargetsCheck", self.TargetsCheck, phRaid.db.profile.Targets.Time, self)
end

function phRTargets:OnDisable()
    self.enabled = false
    self:TargetsCheck()
end

function phRTargets:TargetsCheck()
    local visible = phRaid.visible
    local frames = phRaid.frames
    local aggro = self.aggro
    local rosterNames = phRaid.rosterNames

    if not self.enabled then
        for i, v in pairs(visible) do
            frames[i].Aggro:Hide()
            frames[i].Mark:Hide()
            frames[i].Mark.index = nil
        end
        return
    end

    for i, v in pairs(visible) do
        -- From BanzaiLib. Will this buffered result be more acceptable?
        local unitName = UnitName(i)
        if not unitName then return end


        local target = i .. "target"
        local index = nil
        if UnitExists(target) then index = GetRaidTargetIndex(target) end
        if frames[i].Mark.index and (not index or not phRaid.db.profile.Targets.ShowRaidTargets) then
            frames[i].Mark:Hide()
            frames[i].Mark.index = nil        
        elseif phRaid.db.profile.Targets.ShowRaidTargets and frames[i].Mark.index ~= index then
            SetRaidTargetIconTexture(frames[i].Mark, index)
            frames[i].Mark:Show()
            frames[i].Mark.index = index
        end
        if phRaid.db.profile.Targets.ShowAggro then
            if not aggro[unitName] then aggro[unitName] = 0 end
            aggro[unitName] = aggro[unitName] - 5
            
            local totName = UnitName(target .. "target")
            if rosterNames[totName] and UnitCanAttack("player", target) and UnitCanAttack(target, "player") then
                if not aggro[totName] then aggro[totName] = 0 end
                aggro[totName] = aggro[totName] + 21
            end
        
            aggro[unitName] = math.max(aggro[unitName], 0)
            aggro[unitName] = math.min(aggro[unitName], 25)

            if aggro[unitName] > 15 then
                frames[i].Aggro:Show()
            else
                frames[i].Aggro:Hide()
            end
        end
    end
end

--~ function phRTargets:CreateOptions(opt)
--~     self.options = opt
--~     local options = opt:AddOptionsTab("fphROptionsTargets", L["TargetsCheck"])

--~     local encheck = opt:CreateCheck("EnableTargets", L["Enable"] .. L["TargetsCheck"], options, function () 
--~         local b = phRaid:ToggleModuleActive("phRaidTargets")
--~     end)
--~     encheck:SetChecked(self.enabled)
--~     encheck:SetPoint("TOPLEFT", options, "TOPLEFT", 10, -10)
--~     encheck:Show()
--~     local rate = opt:CreateSlider("TargetsRefreshRate", L["RefreshRate"], 0.2, 5, 0.2, options, function()
--~         this.Current:SetText(string.format("%.2f", arg1))
--~         phRaid.db.profile.Targets.Time = arg1
--~         self:CancelScheduledEvent("phRaidTargetsCheck")
--~         if self.enabled then
--~             self:ScheduleRepeatingEvent("phRaidTargetsCheck", self.TargetsCheck, arg1, self)
--~         end
--~     end)
--~     rate:SetValue(phRaid.db.profile.Targets.Time)
--~     rate:SetPoint("TOPLEFT", encheck, "BOTTOMLEFT", 0, -20)
--~     
--~     local chkEnAggro = opt:CreateCheck("EnableAggro", L["Enable"] .. L["Aggro"], options, function()
--~         phRaid.db.profile.Targets.ShowAggro = not phRaid.db.profile.Targets.ShowAggro
--~     end)
--~     chkEnAggro:SetChecked(phRaid.db.profile.Targets.ShowAggro)
--~     chkEnAggro:SetPoint("TOPLEFT", rate, "BOTTOMLEFT", 0, -10)
--~     chkEnAggro:Show()
--~     
--~     local chkEnRaidTargets = opt:CreateCheck("EnableRaidTargets", L["Enable"] .. L["RaidTargets"], options, function()
--~         phRaid.db.profile.Targets.ShowRaidTargets = not phRaid.db.profile.Targets.ShowRaidTargets
--~     end)
--~     chkEnRaidTargets:SetChecked(phRaid.db.profile.Targets.ShowRaidTargets)
--~     chkEnRaidTargets:SetPoint("TOPLEFT", chkEnAggro, "BOTTOMLEFT")
--~     chkEnRaidTargets:Show()
--~ end
