/*
 * Decompiled with CFR 0.152.
 */
package com.malcolmhardie.jdbcjni;

import com.malcolmhardie.jdbcjni.DelegatingDriver;
import com.malcolmhardie.jdbcjni.JDBCLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class JDBCConnection {
    Connection dbConnection;

    public void openConnection(String string, String string2, Properties properties) throws SQLException, ClassNotFoundException {
        try {
            JDBCLoader jDBCLoader = JDBCLoader.JDBCLoader();
            Driver driver = (Driver)Class.forName(string, true, jDBCLoader).newInstance();
            DriverManager.registerDriver(new DelegatingDriver(driver));
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            throw new SQLException("InstantiationException:" + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("IllegalAccessException:" + illegalAccessException);
            throw new SQLException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            System.out.println("java.library.path: " + System.getProperty("java.library.path"));
            System.out.println("java.lang.classpath: " + System.getProperty("java.class.path"));
            throw classNotFoundException;
        }
        this.dbConnection = DriverManager.getConnection(string2, properties);
        System.out.println("connection open");
    }

    public void closeConnection() throws SQLException {
        this.dbConnection.close();
    }

    public Statement createStatement() throws SQLException {
        return this.dbConnection.createStatement();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.dbConnection.getMetaData();
    }
}

