/*
 * Decompiled with CFR 0.152.
 */
package com.malcolmhardie.jdbcjni;

import com.malcolmhardie.jdbcjni.DelegatingDriver;
import com.malcolmhardie.jdbcjni.DriverTestElement;
import com.malcolmhardie.jdbcjni.JDBCLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.Vector;

public class JDBCDiscoveryManager {
    Vector driverList;
    Vector missingList;
    Vector testList;

    public JDBCDiscoveryManager() {
        System.out.println("creating JDBC DiscoveryManager");
        this.testList = new Vector();
        this.missingList = new Vector();
        this.addTestClassPath("com.mysql.jdbc.Driver", "mysql", "MySQL");
        this.addTestClassPath("org.postgresql.Driver", "postgresql", "PostgreSQL");
        this.addTestClassPath("com.malcolmhardie.jdbctest.MHDriver", "mh", "MalcolmHardie JDBC Test");
        this.addTestClassPath("oracle.jdbc.OracleDriver", "oracle:thin", "Oracle");
        this.addTestClassPath("org.sqlite.JDBC", "sqlite", "SQLite");
        this.addTestClassPath("SQLite.JDBCDriver", "sqlite", "SQLite");
        this.addTestClassPath("com.openbase.jdbc.ObDriver", "openbase", "OpenBase");
        this.addTestClassPath("com.microsoft.sqlserver.jdbc.SQLServerDriver", "sqlserver", "SQLServer");
        this.addTestClassPath("com.filemaker.jdbc.Driver", "filemaker", "Filemaker");
        this.driverList = new Vector();
    }

    public void addTestClassPath(String string, String string2, String string3) {
        this.testList.add(new DriverTestElement(string, string2, string3));
    }

    public boolean driverFound(String string, ClassLoader classLoader) {
        boolean bl = false;
        try {
            Driver driver = (Driver)Class.forName(string, true, classLoader).newInstance();
            DriverManager.registerDriver(new DelegatingDriver(driver));
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            System.err.println("Cannot use driver: " + string + " incompatible java version (needs 1.4, driver is 1.5)\n" + unsupportedClassVersionError);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return bl;
    }

    public void discover() {
        JDBCLoader jDBCLoader = JDBCLoader.JDBCLoader();
        for (DriverTestElement driverTestElement : this.testList) {
            if (this.driverFound(driverTestElement.getClasspath(), jDBCLoader)) {
                this.driverList.add(driverTestElement);
                continue;
            }
            this.missingList.add(driverTestElement);
        }
    }

    Vector discoverList() {
        this.discover();
        System.out.println("discovery complete " + this.driverList.size());
        return this.driverList;
    }

    public void printList() {
        System.out.println("Driver List\n" + this.driverList.toString() + "\nmissing\n" + this.missingList.toString());
    }

    public Iterator getIterator() {
        return this.driverList.iterator();
    }

    public static void main(String[] stringArray) {
        JDBCDiscoveryManager jDBCDiscoveryManager = new JDBCDiscoveryManager();
        jDBCDiscoveryManager.discover();
        jDBCDiscoveryManager.printList();
    }

    class directoryJarFilter
    implements FilenameFilter {
        directoryJarFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".jar");
        }
    }
}

