/*
 * Decompiled with CFR 0.152.
 */
package com.malcolmhardie.jdbcjni;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

class JDBCLoader
extends URLClassLoader {
    static JDBCLoader sharedLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDBCLoader JDBCLoader() {
        Class<JDBCLoader> clazz = JDBCLoader.class;
        synchronized (JDBCLoader.class) {
            if (null == sharedLoader) {
                URL[] uRLArray = new URL[]{};
                sharedLoader = new JDBCLoader(uRLArray);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedLoader;
        }
    }

    public JDBCLoader(URL[] uRLArray) {
        super(uRLArray);
        this.loadJarFiles();
    }

    protected void addFile(String string) throws MalformedURLException {
        String string2 = "jar:file://" + string + "!/";
        this.addURL(new URL(string2));
    }

    public void loadJarFiles() {
        this.loadJarFiles("/Library/Application Support/SQLEditor/JDBC Drivers/");
    }

    public void loadJarFiles(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Note: JDBC Driver directory not found");
            return;
        }
        if (!file.isDirectory()) {
            System.out.println("Note: JDBC Driver directory not a directory");
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                String string2 = fileArray[i].getCanonicalPath();
                if (!string2.endsWith(".jar")) continue;
                this.addFile(string2);
                System.out.println(string2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Note: internal URL for driver specified \n" + malformedURLException);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Note: IOException during driver loading \n" + iOException);
            }
        }
    }
}

