//
//  MHPGDatabaseMetaData.h
//  MHPostgresDB
//
//  Created by Angus Hardie on 07/04/2013.
//  Copyright (c) 2013 MalcolmHardie Solutions. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <PGSQLKit/PGSQLKit.h>
@interface MHPGDatabaseMetaData : NSObject
{
    
    PGSQLConnection* db;
    
    
    NSMutableDictionary* properties;
    
    int INDEX_MAX_KEYS_;
    
}

- (id)initWithDatabase:(id)theDatabase;

- (id)getDriverName;
- (id)getTables:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getColumns:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;


- (id)getExportedKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getImportedKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getPrimaryKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;

- (id)getIndexInfo:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;

- (BOOL)supportsAlterTableWithDropColumn;
- (BOOL)supportsAlterTableWithAddColumn;

- (NSString*)getDatabaseProductVersion;
- (NSString*)getDatabaseProductName;

- (short)tableIndexStatistic;
@end
