//
//  MHDrizzleResultSet.h
//  libdrizzle-5.1
//
//  Created by Angus Hardie on 17/02/2013.
//  Copyright (c) 2013 MalcolmHardie Solutions. All rights reserved.
//

#import <Foundation/Foundation.h>
#include <PGSQLKit/PGSQLKit.h>


@interface MHPGResultSet : NSObject
{
    
	PGSQLRecordset* resultSet;
	
	NSUInteger rowPosition;
    
    id <GenDBRecord> row;
    
    NSUInteger columnCount;
    
    NSMutableArray* columnNames;
    
    NSMutableArray* flagsForColumns;
    
    BOOL isOpen;
    
    NSString* userDescription;
    
    id database;
}

@property (assign) NSString* userDescription;

- (id)initWithResultSet:(PGSQLRecordset*)theResultSet database:(id)db;

- (BOOL)next;
- (NSUInteger)currentRow;
- (NSString*)getString:(NSString*)key;
- (NSString*)getStringForColumnIndex:(NSUInteger)key;
- (NSInteger)getInt:(NSString*)key;
- (BOOL)getBoolean:(NSString*)key;


- (void)close;

- (NSUInteger)columnCount;
- (NSArray*)columnNames;
- (NSArray*)columnFlags;

- (PGSQLRecordset*)rawResultSet;
@end
