//
//  MHSqliteNativeDatabaseMetaData.h
//  SQLEditor-17
//
//  Created by Angus Hardie on 23/03/2012.
//  Copyright 2012 MalcolmHardie Solutions Limited. All rights reserved.
//

#import <Foundation/Foundation.h>


@class FMDatabase;

@interface MHSqliteNativeDatabaseMetaData : NSObject {

	FMDatabase* db;
    
    BOOL caseSensitive;
    BOOL caseSensitiveColumns;

}

@property (assign) BOOL caseSensitive;
@property (assign) BOOL caseSensitiveColumns;

- (id)initWithDatabase:(id)theDatabase;

- (id)getDriverName;
- (id)getTables:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getColumns:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;


- (id)getExportedKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getImportedKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getPrimaryKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;

- (id)getIndexInfo:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;

- (BOOL)supportsAlterTableWithDropColumn;
- (BOOL)supportsAlterTableWithAddColumn;

- (NSString*)getDatabaseProductVersion;
- (NSString*)getDatabaseProductName;

- (short)tableIndexStatistic;
@end
