//
//  MHSourceNode.h
//  SQLEditor-17
//
//  Created by Angus Hardie on 17/07/2014.
//  Copyright (c) 2014 MalcolmHardie Solutions Limited. All rights reserved.
//

#import <Foundation/Foundation.h>

@class SQLExportDialect;

typedef NS_ENUM(NSUInteger, MHSourceNodeType) {
    MHSourceNodeStandard,
    MHSourceNodeQuoted,
    MHSourceNodeDefaultValue,
    MHSourceNodeIdentifier,
    MHSourceNodeString
};

@interface MHSourceNode : NSObject
{
    

    
}
@property (copy) NSString* elementId;

@property (copy) NSString* prefixValue;
@property (copy) NSString* value;
@property (copy) NSString* postfixValue;
@property (copy) NSString* infixValue;
@property (retain) NSMutableArray* children;

@property (copy) NSString* spaceBefore;
@property (copy) NSString* spaceAfter;
@property (copy) NSString* spaceBeforeChildren;
@property (copy) NSString* spaceAfterChildren;

@property (copy) NSString* quoteString;

@property (copy) NSString* childQuoteString;

@property (assign) BOOL quoteChildren;


@property (copy) NSString* openCommentString;
@property (copy) NSString* closeCommentString;
@property (assign) BOOL removeInfixSeparator;

@property (assign) BOOL alwaysVisible;


@property (copy) NSString* infixSpaceAfter;
@property (copy) NSString* childSpaceBefore;

@property (assign) BOOL trimChildren;

@property (copy) NSString* objectUid;


@property (assign) MHSourceNode* parentNode;

@property (assign) id exporter;

@property (assign) MHSourceNodeType type;

@property (copy) NSString* nodeComment;

@property (readonly) BOOL isVisible;

+ (MHSourceNode*)node;
+ (MHSourceNode*)nodeWithValue:(NSString *)value spaceAfter:(NSString*)theSpaceAfter;
+ (MHSourceNode*)nodeWithValue:(NSString *)value spaceBefore:(NSString*)spaceBefore spaceAfter:(NSString*)theSpaceAfter;
+ (MHSourceNode*)nodeWithValue:(NSString*)value;
+ (MHSourceNode*)nodeWithStringFormat:(NSString*)format, ... NS_FORMAT_FUNCTION(1,2);
+ (MHSourceNode*)bracketBlock;
+ (MHSourceNode*)commentBlockWithStringValue:(NSString*)value;

- (NSArray*)flatten;

- (MHSourceNode*)addChild:(MHSourceNode*)child;
- (MHSourceNode*)addChildWithValue:(NSString*)value;
- (MHSourceNode*)addChildWithValue:(NSString*)newValue spaceAfter:(NSString*)theSpaceAfter;
- (MHSourceNode*)addChildWithValue:(NSString*)newValue spaceBefore:(NSString*)theSpaceBefore spaceAfter:(NSString*)theSpaceAfter;
- (MHSourceNode*)addChildNode;

- (MHSourceNode*)insertChild:(MHSourceNode*)child atIndex:(NSUInteger)index;
- (MHSourceNode*)insertChildValue:(NSString*)value atIndex:(NSUInteger)index;

- (void)addChildren:(NSArray*)children;

- (void)removeChild:(MHSourceNode*)child;

- (MHSourceNode*)childWithId:(NSString*)identity;

- (NSUInteger)indexOfChild:(MHSourceNode*)child;

- (NSString*)string;
@end
