/*
 *  SQLConnectableObject.h
 *  SQLEditorUniversal
 *
 *  Created by Angus Hardie on 07/05/2009.
 *  Copyright 2009 MalcolmHardie Solutions Limited and Angus W Hardie. All rights reserved.
 *
 */

@class SQLField;
@class SQLTable;



typedef NS_ENUM(NSUInteger, SQLUpdateOrDeleteActionType) {
    SQLReferenceActionNone = 0,
    SQLReferenceActionCascade,
    SQLReferenceActionRestrict,
    SQLReferenceActionSetNull,
    SQLReferenceActionNoAction,
    SQLReferenceActionSetDefault
};


typedef NS_ENUM(NSUInteger, SQLCardinalityType) {
    SQLCardinalityNone = 0,
    SQLCardinalityOne = 1,
    SQLCardinalityZeroOrOne = 2,
    SQLCardinalityOneOrMore = 3,
    SQLCardinalityZeroPlus = 4,
    SQLCardinalityMany = 5

};

typedef NS_ENUM(NSUInteger, SQLConnectorLineStyle) {
    
    SQLConnectorLineStyleSolid = 0,
    SQLConnectorLineStyleDashed = 1,
    SQLConnectorLineStyleDotted = 2
};



typedef NS_OPTIONS(NSUInteger, SQLForeignKeyError) {
    SQLForeignKeyNoError = 1 << 0,
    SQLForeignKeyNoTargetTable = 1 << 1,
    SQLForeignKeyMismatchedColumns = 1 << 2,
    SQLForeignKeyEmpty = 1 << 3,
};

@protocol SQLConnectable

@property (assign) SQLCardinalityType sourceCardinality;
@property (assign) SQLCardinalityType destinationCardinality;

@property (assign) SQLUpdateOrDeleteActionType updateAction;
@property (assign) SQLUpdateOrDeleteActionType deleteAction;

@property (retain) SQLField* fkField;

@property (readonly) NSString* foreignKeyName;


- (void)setDefaultCardinalityForImport;
- (void)setDefaultCardinalityForCreatedKey;



- (NSArray*)targetFieldNameList;
- (NSArray*)sourceFieldNameList;

- (NSString*)foreignKeyName;

- (SQLTable*)targetTable;

- (SQLTable*)parentTable;


- (BOOL)isFKFieldValid:(SQLForeignKeyError*)errorState;


@end

