/*
 *  SQLConstraint.h
 *  SQLEditorUniversal
 *
 *  Created by Angus W Hardie on 12/02/2008.
 *  Copyright 2008 MalcolmHardie Solutions Ltd. All rights reserved.
 *
 */

#import <Cocoa/Cocoa.h>
#import "SQLDeferrable.h"
#import "SQLIndex.h"

/**
 Interface for SQLModel.SQLConstraint
 **/
EXPORT_SYMBOL_EXTERNAL
@interface SQLConstraint : SQLIndex <SQLDeferrable>{
	
}

@property (readonly) BOOL isCheckConstraint;
@property (copy) NSString* checkConstraintExpression;
@property (copy) NSString* constraintType;

+ (SQLConstraint*)constraint;

- (void)setCheckConstraintExpressionFromSQL:(NSString *)expression;


- (BOOL)isEqualToConstraint:(SQLConstraint*)object;
@end