//
//  SQLField.h
//  SQLParser
//
//  Created by Angus W Hardie on Sun Nov 02 2003.
//  Copyright (c) 2003 Malcolmhardie.com. All rights reserved.
//
#import <Cocoa/Cocoa.h>


#import "SQLTableComponent.h"
#import "SQLConnectable.h"
#import "SQLDeferrable.h"
#import "SQLCheckConstraintSupported.h"

@class SQLDocumentInfo;



//#define ONE  0 
//#define ONE_OR_MORE  1 
//#define ZERO_PLUS  2 
//#define ZERO_OR_ONE  3 
//#define MANY  4 


#define FK_COMPOUND_ADDITIONAL 3
#define FK_COMPOUND 2 
#define FK_SIMPLE 1 
#define FK_NONE 0 

@class SQLTable;

EXPORT_SYMBOL_EXTERNAL
@interface SQLField : SQLTableComponent <SQLConnectable,SQLDeferrable,SQLCheckConstraintSupported>
{
    
	
	
	
    
    NSString* _type;
    NSString* _typeSize;
    
    BOOL _primaryKey;
     
    SQLUpdateOrDeleteActionType _deleteAction;
	SQLUpdateOrDeleteActionType _updateAction;
	
    SQLCardinalityType _sourceCardinality;
    SQLCardinalityType _destinationCardinality;
    
    NSString* _referencesField;
    NSString* _referencesTable;
    


    SQLField* _fkField;
    
    SQLField* _sourceForeignKey;
    
    BOOL _compoundForeignKey;
    
	NSMutableArray* _dependentFieldList;

    
    NSMutableArray* _indexList;
    
    
    NSString* _referencesTableUID;
    NSString* _referencesFieldUID;
	
    id observingFkTable;
	
	
}

@property (retain) id observingFkTable;

@property (retain) NSString* foreignKeyName;

@property (retain) NSMutableArray* connectedObjects;

+ (SQLField*)fieldWithName:(NSString*)name type:(NSString*)type;
+ (SQLField*)field;

- (id)initWithName:(NSString*)newName type:(NSString*)newType;

- (void)setType:(NSString*)type;
- (NSString*)getType;
- (NSString*) getDataType;
- (NSString*) getDataTypeSize;
- (void)setDataType:(NSString*)newType;

- (BOOL) hasTypeSize;

- (NSString *)typeSize;
- (void)setTypeSize:(NSString *)value;

-(NSString*) getFullTypeString;



- (void)setFkField:(SQLField*)field;

- (NSString*)getLabel;

- (NSString*)getClassType;

- (NSString*)exportToSQL;
//- (NSString*)exportToXML;

- (SQLField*) getFkField;
- (SQLField*)fkField;

- (SQLCardinalityType) getSourceCardinality;
- (void) setSourceCardinality:(SQLCardinalityType) cardinality;
- (SQLCardinalityType) getDestinationCardinality;
- (void) setDestinationCardinality:(SQLCardinalityType) cardinality;


- (NSString*)getDefaultValue;
- (NSString *)defaultValue;
- (BOOL)getPrimaryKey;
- (BOOL)getAutoIncrement;



- (void)setDefaultValue:(NSString*)defaultValueSetting;
- (void)setDefaultValueFromParsedString:(NSString *)defaultValueSetting;

- (void)setPrimaryKey:(BOOL)primaryKeySetting;

- (void)setAutoIncrement:(BOOL)autoIncrementSetting;



- (NSString*) getReferenceInformationString;
- (NSString*) getReferences;
- (NSString*) getReferencesString;
- (NSString*) getReferenceName;

- (int)foreignKeyMode;

- (BOOL)getNotNull;
- (void)setNotNull:(BOOL)notNull;

- (void)setUnique:(BOOL)value;
- (BOOL)isUnique;

- (BOOL)getFkTypeMismatch;
- (NSString*)getOriginalType;
- (BOOL)fieldMatchesType:(NSString*)targetType targetField:(SQLField*)targetField;


- (BOOL)isForcedUnsigned;
- (BOOL) getForcedUnsigned;

- (void)setReferenceLinkName:(NSString*)referenceLinkName;
- (NSString*)getReferenceLinkName;




- (id) getReferencesField;
- (void)setReferencesFieldUID:(NSString *)newReferencesFieldUID;
- (void)setReferencesField:(NSString *)newReferencesField;
- (NSString *)getReferencesFieldUID;

- (void)setReferencesTable:(NSString *)newReferencesTable;

- (NSString*) getReferencesTable;
- (NSString *)getReferencesTableUID;
- (void)setReferencesTableUID:(NSString *)newReferencesTableUID;

- (NSString*) getReferenceId;
- (void) setReferenceId:(NSString*) referenceIdString;

- (void) setReferences:(NSString*) table :(NSString*) field;

- (NSArray*) getDependentCompoundKeyFields;

- (void) setSourceForeignKey:(SQLField*) sourceForeignKey ;
- (SQLField*) getSourceForeignKey ;

- (NSString*) exportSQLForeignKey:(NSString*) tableName ;

- (id)indexList ;

- (BOOL)hasWarnings;



@end
