/*
 *  SQLForeignKey.h
 *  SQLEditorXC3b
 *
 *  Created by Angus Hardie on 11/1/2009.
 *  Copyright 2009 MalcolmHardie Solutions Ltd. All rights reserved.
 *
 */

#import <Cocoa/Cocoa.h>

#import "SQLTableComponent.h"

//#import "SQLIterator.h"
#import "SQLConnectable.h"
#import "SQLDeferrable.h"

@class SQLForeignKeyEntry;
@class SQLIterator;

/**
 Interface for SQLModel.SQLForeignKey
 **/
EXPORT_SYMBOL_EXTERNAL
@interface SQLForeignKey : SQLTableComponent <SQLConnectable,SQLDeferrable>
{
	
	SQLTable* _targetTable;
    
    NSMutableArray* _fieldPairList;
    
    SQLUpdateOrDeleteActionType _deleteAction;
    SQLUpdateOrDeleteActionType _updateAction;
    
    SQLCardinalityType _sourceCardinality;
    SQLCardinalityType _destinationCardinality;
    
	    SQLField* _fkField;
}

- (NSString*) getLabel;

- (SQLForeignKeyEntry*)getKeyPairAtIndex:(NSInteger)index;


- (void)addFieldPair:(SQLField*) source :(SQLField*) target;

- (void)addForeignKeyEntry:(SQLForeignKeyEntry*)entry;
- (void)removeFieldPairAtIndex:(NSInteger)index;

- (SQLForeignKeyEntry*)createEntryObject;


- (NSString*) getComparisonString;

- (SQLTable*)targetTable;
- (SQLTable*)getTargetTable;
- (void)setTargetTable:(SQLTable*)targetTable;
- (void)setTargetTableByName:(NSString*) targetTableName;
- (NSString*)getTargetTableName;


- (NSUInteger)getKeyPairCount;

- (NSArray*) targetFieldObjectList;

- (SQLIterator*)keyPairIterator;
- (NSArray*)fieldPairList;

- (NSArray*) getSourceList;
- (NSArray*) getTargetList;


- (void)updateWithChangedModel;

- (void)setDefaultCardinalityForImport;

@end
