//
//  SQLField.h
//  SQLParser
//
//  Created by Angus W Hardie on Sun Nov 02 2003.
//  Copyright (c) 2003 Malcolmhardie.com. All rights reserved.
//
#import <Cocoa/Cocoa.h>

#import "SQLObjectPeer.h"
#import "SQLObjectContainer.h"
#import "SQLTableFieldObserver.h"
#import "SQLCheckConstraintSupported.h"

@class SQLField;
@class SQLIterator;
@class SQLDocumentInfo;
@class SQLTableComponent;


@class SQLIndex;



/**
 Interface for SQLModel.SQLTable
 **/
EXPORT_SYMBOL_EXTERNAL
@interface SQLTable : SQLObjectPeer <SQLObjectContainer,SQLCheckConstraintSupported>{
	
	
	
    
    NSMutableArray* _fields;
	
    NSString* _tableType;
	NSString* _schemaName;
	NSInteger _sortPosition;
    NSString* _otherOptions;
	
    NSMutableArray* _targetTableForFKList;
    
    NSString* indexPrefix;
    
    //NSMutableArray* primaryKeyObjectList;
	NSMutableArray* primaryKeyNameList;
    
    NSMutableArray* observingForeignKeys;
    
    NSMutableArray* fieldObservers;
}

@property (copy) NSString* indexPrefix;
@property (copy) NSString* primaryKeyConstraintName;

@property (retain) NSMutableDictionary* uidFieldMap;


+ (SQLTable*)tableWithName:(NSString*)name;
+ (SQLTable*)table;
+ (SQLTable*)tableForImportWithName:(NSString*)name;

- (id)init;
- (id) initWithName:(NSString*)name tableType:(NSString*)type schemaName:(NSString*)schemaName;
- (id) initWithName:(NSString*)name tableType:(NSString*)tableType;
- (id) initWithName:(NSString*)name;




- (void)createNewUid;
- (void)updateLinksWithNewUid;
- (void)setSortPosition:(NSInteger)pos ;
- (NSInteger)getSortPosition;
+ (void)resetPosition;

- (NSString*)getClassType;


- (void)postLoadProcess;

- (NSUInteger)fieldCount;

- (NSArray*)foreignKeyFieldsInTable;

- (NSArray*)foreignKeyObjectsInTable;

- (NSArray*)indexObjectsInTable;
- (BOOL)isIndexSoleIndexOnColumn:(SQLIndex*)index column:(SQLField*)field;





- (void)add:(SQLTableComponent*)object ;

- (void)addComponent:(SQLTableComponent*)field ;

- (void)addWithRenaming:(SQLTableComponent*)field ;
- (void)addWithRenaming:(SQLTableComponent *)field didRename:(BOOL*)didRename;


- (int)getFieldPosition:(SQLTableComponent*)curField ;
- (void)reorder:(SQLTableComponent*)newField position:(NSUInteger)position ;
- (NSUInteger)indexOfField:(SQLTableComponent*)curField;

- (NSString*)getValidNameForObject:(SQLTableComponent*)field :(NSString*)originalName ;
- (NSString*)getValidName:(NSString*)originalName ;
- (BOOL)isObjectNamePresent:(NSString*)name ;
- (BOOL)isFieldNamePresent:(NSString*)name ;
- (BOOL)isFieldNamePresent:(NSString*)name :(BOOL)ignoreCase ;
- (BOOL)isFieldNamePresent:(NSString*)name :(BOOL)ignoreCase :(Class)objectClass;


- (NSMutableArray*)getFields;
- (NSMutableArray*) fields;
- (void)setFields:(NSMutableArray*)fields ;

- (SQLTableComponent*)getNextObject:(SQLTableComponent*)object ;
- (SQLTableComponent*)getPreviousObject:(SQLTableComponent*)object ;
- (SQLField*)getColumn:(int)number DEPRECATED_V3;
- (SQLTableComponent*)objectOfClass:(Class)class atIndex:(NSUInteger)index;
- (NSArray*)fieldArrayOfClass:(Class)class;

- (SQLTableComponent*)getField:(NSInteger)position ;


- (BOOL)contains:(SQLTableComponent*)field ;
- (void)remove:(SQLTableComponent*)field ;

- (NSString*)fullyQualifiedNameForIndexNames;
- (NSString*)fullyQualifiedName;
- (void)setFullyQualifiedName:(NSString*)newName;

- (NSString*)displayName;
- (void)setDisplayName:(NSString*)name;

- (NSString*)getBaseName;
- (void)setBaseName:(NSString*)baseName ;
- (NSString*)getName;
- (void)setName:(NSString*)name ;
- (NSString*)schema;
- (NSString*)getSchemaName;
- (void)setSchemaName:(NSString*)schemaName ;
- (NSString*)getSchema;
- (void)setSchema:(NSString*)schemaName ;
- (NSString*)getTableType;
- (void)setTableType:(NSString*)tableType ;
- (void)setType:(NSString*)type ;
- (NSString*)getType;
- (NSString*)getComment;
- (void)setComment:(NSString*)comment ;
- (void)setOtherOptions:(NSString*)otherOptions ;
- (NSString*)getOtherOptions;
- (SQLIterator*)listIterator DEPRECATED_V3;
- (SQLIterator*)iterator DEPRECATED_V3;


- (NSString*)exportToXMLWithWrapper;
- (NSString*)toString;

- (NSString*)getNameForSQL;
- (NSString*)exportToSQL;
- (NSString*)exportToSQL:(BOOL)showReferencesInline documentInfo:(SQLDocumentInfo*)documentInfo ;
- (NSString*)exportSQLForeignKey;
- (SQLTableComponent*)getNextField:(SQLTableComponent*)curField ;
- (SQLTableComponent*)getPreviousField:(SQLTableComponent*)curField ;
- (NSArray*)primaryKeyList;
- (NSArray*)primaryKeyObjectList;
- (BOOL)hasPrimaryKey;

- (void)setPrimaryKeyToFieldNames:(NSArray*)fieldNames;


- (SQLTableComponent*) getFieldByName:(NSString*) namel;
- (SQLTableComponent*) getFieldByTypeAndName:(Class) type :(NSString*) name;
- (SQLTableComponent*) getFieldByTypeAndName:(Class) type :(NSString*) name :(BOOL) ignoreCase;
- (SQLTableComponent*)getObjectByName:(NSString*)name ;

- (SQLTableComponent*)getFieldByUID:(NSString*)uid ;



- (void) addTableToTargetList:(SQLTable*) table;
- (void) clearTargetTableList;
- (NSArray*)getTargetTableForFKList;


- (NSString*)getFieldNameListString;

-(BOOL)validateDisplayName:(id *)ioValue error:(NSError **)outError;

- (void)updatePrimaryKeyList;



- (void)stopObservingTableForForeignKey:(SQLField*)observingField;
- (void)observeTableForForeignKey:(SQLField*)observingField;

- (NSString*)primaryKeyConstraintName;

- (BOOL)fieldIsIndexed:(SQLField*)field;
- (BOOL)fieldIsIndexedNotUnique:(SQLField*)field;
// field observers
- (void)addObserverForFieldList:(id<SQLTableFieldObserver>)observer;
- (void)removeObserverForFieldList:(id<SQLTableFieldObserver>)observer;
- (void)notifyFieldObservers;




- (NSArray*)foreignKeysReferencingPrimaryKey;
@end
