/*
 *  SQLTableComponent.h
 *  SQLEditorU
 *
 *  Created by Angus Hardie on 12/02/2006.
 *  Copyright 2006 MalcolmHardie Solutions Ltd. All rights reserved.
 *
 */

#import "SQLObjectPeer.h"
@class SQLTable;
@class SQLDocumentInfo;


@interface SQLTableComponent : SQLObjectPeer {
    

    
}
- (void)setName:(NSString*)name;
- (NSString*)getName;
- (NSString*)name;
- (NSString*)exportToXMLWithWrapper;

- (void)setParent:(id) parent;
- (id)getParent DEPRECATED_V3;
- (id)parent;
- (SQLTable*)parentTable;
- (SQLContainer*)topLevelContainer;

- (NSString*) getLabel;

- (id)fkField; // stub method only


- (NSString*) exportToSQL:(BOOL) showReferencesInline documentInfo:(SQLDocumentInfo*) documentInfo;


- (void) clearIncompleteReferenceTargetTable;
- (void) setIncompleteReferenceTargetTable:(NSString*) referencesTable 
							referenceField:(NSString*) referencesField;
- (void) reconnectIncompleteReference;


// for prefixing name of constraints
- (BOOL)supportsNamePrefixing;
- (BOOL) shouldPrefixIndexNameOnInsert:(SQLTable*)table;
- (NSString*)prefixedName:(NSString*)newName inTable:(SQLTable*)table;
@end