//
//  SQLView.h
//  SQLEditorUniversal2
//
//  Created by Angus W Hardie on 22/06/2008.
//  Copyright 2008 MalcolmHardie Solutions Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "SQLTable.h"

@class SQLSelectStatement;

@interface SQLView : SQLTable {
    SQLSelectStatement* _queryObject;
	
	NSMutableArray* columns;
	NSMutableArray* tableList;
	NSMutableArray* selectColumns;
	
	BOOL hasParsed;
}


+ (SQLView*)viewWithName:(NSString*)name;
- (id)initWithName:(NSString*)name;


- (SQLSelectStatement *)queryObject;
- (void)setQueryObject:(SQLSelectStatement *)value;


- (void)setQueryString:(NSString*)queryString;
- (NSString*)queryString;

- (void)addColumn:(NSString*)columnName;




- (void)addTableEntry:(NSString*)tableName;
- (void)addTableEntry:(NSString *)tableName asAlias:(NSString*)alias;

- (NSMutableArray*)columns;
- (NSMutableArray*)tableList;


- (void)addSelectColumn:(NSString*)columnName;

- (NSMutableArray*)selectColumns;

- (void)updateFieldList;
@end
