//
//  MHDrizzleConnection.h
//  libdrizzle-5.1
//
//  Created by Angus Hardie on 17/02/2013.
//  Copyright (c) 2013 MalcolmHardie Solutions. All rights reserved.
//

#import <Foundation/Foundation.h>
#include <libdrizzle-5.1/libdrizzle.h>

@interface MHDrizzleConnection : NSObject
{
    
    drizzle_st *connection;
}

- (void)openTCPConnection:(NSString*)server
                     port:(NSUInteger)port
                 username:(NSString*)username
                 password:(NSString*)password
                 database:(NSString*)database;

- (void)openUDSConnection:(NSString*)udsPath
                 username:(NSString*)username
                 password:(NSString*)password
                 database:(NSString*)database;

- (void)close;
- (drizzle_st *)connection;
- (id)createStatement;
- (id) getMetaData;
@end
