//
//  MHDrizzleDatabaseMetaData.h
//  libdrizzle-5.1
//
//  Created by Angus Hardie on 03/03/2013.
//  Copyright (c) 2013 MalcolmHardie Solutions. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MHDrizzleConnection.h"

@interface MHDrizzleDatabaseMetaData : NSObject
{
    
    MHDrizzleConnection* db;
}

- (id)initWithDatabase:(id)theDatabase;

- (id)getDriverName;
- (id)getTables:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getColumns:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;


- (id)getExportedKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getImportedKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;
- (id)getPrimaryKeys:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;

- (id)getIndexInfo:(NSString*)catalog schemaPattern:(NSString*)schemaPattern tableNamePattern:(NSString*)tableNamePattern;

- (BOOL)supportsAlterTableWithDropColumn;
- (BOOL)supportsAlterTableWithAddColumn;

- (NSString*)getDatabaseProductVersion;
- (NSString*)getDatabaseProductName;

- (short)tableIndexStatistic;
@end
