//
//  MHDrizzleResultSet.h
//  libdrizzle-5.1
//
//  Created by Angus Hardie on 17/02/2013.
//  Copyright (c) 2013 MalcolmHardie Solutions. All rights reserved.
//

#import <Foundation/Foundation.h>
#include <libdrizzle-5.1/libdrizzle.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <inttypes.h>

@interface MHDrizzleResultSet : NSObject
{
    
	drizzle_result_st* resultSet;
	
	NSUInteger rowPosition;
    
    drizzle_row_t row;
    
    NSUInteger columnCount;
    
    NSMutableArray* columnNamesUppercase;
    NSMutableArray* columnNames;
    
    NSMutableArray* flagsForColumns;
    
    BOOL isOpen;
    
    NSString* userDescription;
    
}

@property (assign) NSString* userDescription;

- (id)initWithResultSet:(drizzle_result_st*)theResultSet;

- (BOOL)next;
- (NSUInteger)currentRow;
- (NSString*)getString:(NSString*)key;
- (NSString*)getStringForColumnIndex:(NSUInteger)key;
- (NSInteger)getInt:(NSString*)key;
- (BOOL)getBoolean:(NSString*)key;


- (void)close;

- (NSUInteger)columnCount;
- (NSArray*)columnNames;
- (NSArray*)columnFlags;

- (drizzle_result_st*)rawResultSet;

- (id)getMetaData;
@end
