#INCLUDE "wzweb.h"
		
*--------------------------------------
DEFINE CLASS HTMLEngine AS WizEngineAll
*--------------------------------------
	
	cWizTitle=""
	cWebStyle=""
	cWebLayout=""
	cStyleSheet=""
	cBodyColor=""
	cBodyImage=""
	
	DIMENSION aCustomTags[1,14]
	aCustomTags=""

	DIMENSION aWebStyles[1]
	aWebStyles=""
	
	PROCEDURE ProcessOutput
		*- the ProcessOutput method of the sample wizard will call this function

		LOCAL cValue, i, lnNumFields, lnAction, lcSortText, lcFieldText, oNewTag
		lnNumFields = ALEN(THIS.aWizFields,1)
		lcFieldText = ""
		FOR i = 1 TO lnNumFields
			lcFieldText = lcFieldText + THIS.aWizFields[m.i,1]+;
				IIF(m.i=lnNumFields,"",",")
		ENDFOR

		*- if the user selected a sort order, implement that here
		lnNumFields = ALEN(THIS.aWizSorts,1)
		lcSortText = ""

		IF THIS.lHasSortTag
			i = 1
			DO WHILE !EMPTY(KEY(m.i))
				IF 	UPPER(TAG(m.i)) == UPPER(THIS.aWizSorts[1])
					THIS.aWizSorts[1] = KEY(m.i)
					EXIT
				ENDIF
			ENDDO
		ENDIF
		
		IF !EMPTY(THIS.aWizSorts[1])
			lcSortText = "ORDER BY "
			FOR i = 1 TO lnNumFields
				lcSortText = lcSortText + THIS.aWizSorts[m.i,1]+;
					IIF(m.i=m.lnNumFields,"",",")
			ENDFOR
			lcSortText = m.lcSortText + IIF(!THIS.lSortAscend," DESC","")	
		ENDIF
		
		SELECT &lcFieldText. FROM DBF() &lcSortText. INTO CURSOR wzweb_query
			
		lnAction=4
		DO (_GENHTML) WITH THIS.cOutFile,ALIAS(),lnAction,,THIS.cWebLayout

		* Add style sheet
		IF !EMPTY(THIS.cStyleSheet)
			oNewTag = _oHTML.Head.AddTag("Style")
			oNewTag.AddItem([@import URL("] + THIS.cStyleSheet + [");])
		ENDIF

		THIS.AddCustomTags(1)	&&add header custom tags
		THIS.AddCustomTags(2)	&&add before body custom tags
		THIS.AddCustomTags(3)	&&add after body custom tags

		* Add custom body settings
		IF !EMPTY(THIS.cWizTitle)
			_oHTML.Head.Title.Item = THIS.cWizTitle
		ENDIF
		IF !EMPTY(THIS.cBodyColor)
			_oHTML.Body.bgColor = THIS.cBodyColor
		ENDIF
		IF !EMPTY(THIS.cBodyImage)
			_oHTML.Body.background = THIS.cBodyImage
		ENDIF

		USE

		DO CASE
			CASE THIS.nWizAction = 2
				*- create and open HTML file in a browser
				_oHTML.Show()
			CASE THIS.nWizAction = 3
				*- create and open HTML file in a text editor
				_oHTML.ViewSource()
			CASE THIS.nWizAction = 4
				*- create script
				lnAction = 1
			OTHERWISE
				*- create HTML file only
				lnAction = 0
		ENDCASE

		RELEASE _oHTML

	PROCEDURE AddCustomTags(nTagPosition)

		LOCAL i,oHTML2,oHTMLNewTag,lnTagType,lcHeading 
		IF EMPTY(THIS.aCustomTags[1])
			RETURN 
		ENDIF
		
		DO CASE
		CASE nTagPosition = 1
			oHTML2 = _oHTML.Head
		CASE nTagPosition = 2
	
* Fix when GENHTML fixed.
			oHTML2 = _oHTML.Head
			* oHTML2 = _oHTML.Body
		CASE nTagPosition = 3
			oHTML2 = _oHTML.Body		
		ENDCASE

* Add for before body data		
* FOR i = ALEN(THIS.aCustomTags,1) TO 1 STEP -1
		FOR i = 1 TO ALEN(THIS.aCustomTags,1)
			IF THIS.aCustomTags[m.i,2]#nTagPosition
				LOOP
			ENDIF
			lnTagType = THIS.aCustomTags[m.i,14] 
			
			DO CASE
			CASE lnTagType = 1		&&text
				lcHeading = THIS.GetHeading(THIS.aCustomTags[m.i,6])
				IF !EMPTY(lcHeading)
					oHTMLNewTag = oHTML2.AddTag(lcHeading)
				ELSE
					oHTMLNewTag = oHTML2.AddTag("P")
				ENDIF
				oHTMLNewTag.Align = THIS.GetAlign(THIS.aCustomTags[m.i,13])
				IF !EMPTY(lcHeading)
				ENDIF				
				oHTMLNewTag.AddItem(THIS.aCustomTags[m.i,5])
			CASE lnTagType = 2		&&hyperlink
				IF !EMPTY(THIS.aCustomTags[m.i,11])
					oHTMLNewTag = oHTML2.AddTag("A")
					oHTMLNewTag.HREF = THIS.GetHREF(THIS.aCustomTags[m.i,11])
					lcHeading = THIS.GetHeading(THIS.aCustomTags[m.i,6])
					IF !EMPTY(lcHeading)
						oHTMLNewTag = oHTMLNewTag.AddTag(lcHeading)
						oHTMLNewTag.Align = THIS.GetAlign(THIS.aCustomTags[m.i,13])
					ENDIF
					oHTMLNewTag.AddItem(IIF(EMPTY(THIS.aCustomTags[m.i,5]),;
					  THIS.aCustomTags[m.i,11],THIS.aCustomTags[m.i,5]))
				ENDIF
			CASE lnTagType = 3		&&image
				IF !EMPTY(THIS.aCustomTags[m.i,11])
					oHTMLNewTag = oHTML2.AddTag("IMG")
					oHTMLNewTag.SRC = THIS.aCustomTags[m.i,11]
				ENDIF
			CASE lnTagType = 4		&&marquee
				oHTMLNewTag = oHTML2.AddTag("Marquee")
				IF !EMPTY(THIS.aCustomTags[m.i,12])
					oHTMLNewTag.BgColor = THIS.aCustomTags[m.i,12]
				ENDIF
				lcHeading = THIS.GetHeading(THIS.aCustomTags[m.i,6])
				IF !EMPTY(lcHeading)
					oHTMLNewTag = oHTMLNewTag.AddTag(lcHeading)
				ENDIF
				oHTMLNewTag.AddItem(THIS.aCustomTags[m.i,5])
			CASE lnTagType = 5		&&horizontal rule
				oHTMLNewTag = oHTML2.AddTag("HR")
				oHTMLNewTag.Align = THIS.GetAlign(THIS.aCustomTags[m.i,13])
				IF !EMPTY(THIS.aCustomTags[m.i,12])
					oHTMLNewTag.Color = THIS.aCustomTags[m.i,12]
				ENDIF
			CASE lnTagType = 6		&&line break
				oHTMLNewTag = oHTML2.AddTag("BR")
			CASE lnTagType = 7		&&tag
				oHTML2.AddItem(THIS.aCustomTags[m.i,5])
			ENDCASE
			
			* Add Class attribute
			IF !EMPTY(THIS.aCustomTags[m.i,4]) AND !INLIST(lnTagType,1,7)
				oHTMLNewTag.Class = THIS.aCustomTags[m.i,4]
			ENDIF
		ENDFOR
	ENDPROC
	
	FUNCTION GetAlign(lnAlignCode)
		DO CASE
		CASE lnAlignCode = 2
			RETURN "right"
		CASE lnAlignCode = 3
			RETURN "center"
		OTHERWISE
			RETURN "left"
		ENDCASE
	ENDPROC

	FUNCTION GetHeading(lnHeadingCode)
		IF lnHeadingCode=1
			RETURN ""
		ELSE
			RETURN "H"+TRANS(lnHeadingCode-1)
		ENDIF
	ENDPROC

	FUNCTION GetHREF(lcHRef)
		IF ATC("://",lcHRef)#0
			RETURN lcHREF
		ENDIF
		IF ATC("www.",lcHRef)#0
			RETURN "http://"+lcHREF
		ENDIF
		RETURN lcHREF
	ENDPROC

ENDDEFINE
