/*
 * Decompiled with CFR 0.152.
 */
package subaraki.umbralux.entity;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import scala.actors.threadpool.Arrays;
import subaraki.umbralux.block.UmbraLuxBlocks;
import subaraki.umbralux.entity.damage.DamageSourcePaladin;
import subaraki.umbralux.entity.minion.IMinion;

public class EntitySwordSpecial
extends EntityLivingBase {
    private ItemStack[] inventory = new ItemStack[1];
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityTameable.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntitySwordSpecial(World worldIn) {
        super(worldIn);
    }

    public boolean func_180431_b(DamageSource source) {
        return true;
    }

    public void func_70012_b(double posx, double posy, double posz, float yaw, float pitch) {
        super.func_70012_b(posx, posy, posz, yaw, pitch);
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70170_p.func_175623_d(pos)) {
            this.field_70170_p.func_175656_a(pos, UmbraLuxBlocks.airLuminence.func_176223_P());
        }
    }

    public void func_70636_d() {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        super.func_70636_d();
        this.attackSurroundingEntities();
        this.spawnParticles();
        if (this.field_70173_aa > 250 || this.getOwner() == null) {
            this.func_70106_y();
            this.removeSword();
        }
    }

    private void attackSurroundingEntities() {
        List enemiesInRange = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(5.0, 2.0, 5.0));
        for (EntityLivingBase elb : enemiesInRange) {
            if (elb instanceof IMinion) {
                if (elb.field_70173_aa % 5 != 0) continue;
                elb.func_70097_a(DamageSourcePaladin.causeHolySwordDamage(this), 12.0f);
                elb.func_70015_d(20);
                continue;
            }
            if (elb instanceof EntityMob) {
                if (elb.field_70173_aa % 5 != 0) continue;
                elb.func_70097_a(DamageSourcePaladin.causeHolySwordDamage(this), 5.0f);
                if (!((EntityMob)elb).func_70668_bt().equals((Object)EnumCreatureAttribute.UNDEAD)) continue;
                elb.func_70015_d(10);
                continue;
            }
            if (!(elb instanceof EntityPlayer) || ((EntityPlayer)elb).equals((Object)this.getOwner()) || elb.field_70173_aa % 5 != 0) continue;
            elb.func_70015_d(5);
            elb.func_70097_a(DamageSourcePaladin.causeHolySwordDamage(this), 4.0f);
        }
    }

    private void spawnParticles() {
        if (this.field_70173_aa == 5) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 1.0f, 1.0f, true);
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70173_aa > 5) {
            Vec3d vec;
            float f;
            this.field_70759_as += 2.0f;
            for (f = 0.0f; f < 360.0f; f += 45.0f) {
                vec = this.func_174806_f(0.0f, f + this.field_70759_as);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 0.4, this.field_70161_v, vec.field_72450_a / 5.0, 0.0, vec.field_72449_c / 5.0, new int[0]);
            }
            for (f = 0.0f; f < 360.0f; f += 2.0f) {
                vec = this.func_174806_f(0.0f, f + this.field_70759_as);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + vec.field_72450_a * 8.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70161_v + vec.field_72449_c * 8.0, this.field_70146_Z.nextDouble() / 50.0, 0.1, this.field_70146_Z.nextDouble() / 50.0, new int[0]);
            }
        }
    }

    private void removeSword() {
        BlockPos pos;
        if (this.getOwner() == null && this.inventory[0] != null && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.inventory[0].func_77946_l()));
        }
        if (this.getOwner() != null && this.inventory[0] != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.getOwner().field_71071_by.func_70441_a(this.inventory[0].func_77946_l());
            }
            this.getOwner().func_184811_cZ().func_185145_a(this.inventory[0].func_77973_b(), 250);
        }
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)) != 0 && this.field_70170_p.func_180495_p(pos).equals(UmbraLuxBlocks.airLuminence.func_176223_P())) {
            this.field_70170_p.func_175698_g(pos);
        }
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Arrays.asList((Object[])this.inventory);
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return this.inventory[0];
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.inventory[0] = stack.func_77946_l();
    }

    public EnumHandSide func_184591_cq() {
        return null;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        String uuid = "";
        if (compound.func_150297_b("OwnerUUID", 8)) {
            uuid = compound.func_74779_i("OwnerUUID");
        }
        if (!uuid.isEmpty()) {
            this.setOwnerId(UUID.fromString(uuid));
        }
        NBTTagCompound stacktag = new NBTTagCompound();
        if (this.inventory[0] != null) {
            this.inventory[0].func_77955_b(stacktag);
            compound.func_74782_a("stack", (NBTBase)stacktag);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
        if (compound.func_74764_b("stack")) {
            NBTTagCompound stackTag = compound.func_74775_l("stack");
            this.inventory[0] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID owner) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)owner));
    }

    public EntityPlayer getOwner() {
        UUID uuid = this.getOwnerId();
        return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }
}

