/*
 * Decompiled with CFR 0.152.
 */
package subaraki.umbralux.entity.minion;

import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import subaraki.umbralux.entity.damage.DamageSourceMinion;
import subaraki.umbralux.entity.minion.EntityMinionZombie;
import subaraki.umbralux.entity.minion.IMinion;
import subaraki.umbralux.entity.minion.MinionRegistry;

public class EntityMinionSkeleton
extends EntityTameable
implements IMob,
IMinion,
IRangedAttackMob {
    private EntityPlayer owner;
    boolean field_83001_bt = false;
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityMinionSkeleton.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMinionSkeleton(World world) {
        super(world);
        this.func_70105_a(0.7f, 1.7f);
        this.func_70661_as().func_75484_a((Path)null, 0.0);
        this.Following();
        this.func_70624_b(null);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 0.5, 15, 10.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 0.5, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity target) {
                if (target instanceof IMinion) {
                    return false;
                }
                if (target instanceof IMob) {
                    return true;
                }
                if (target instanceof EntityPlayer) {
                    return !target.equals((Object)EntityMinionSkeleton.this.owner);
                }
                return false;
            }
        }));
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof EntityMinionZombie || entityIn instanceof EntityMinionSkeleton;
    }

    public void func_184754_b(UUID theUUID) {
        EntityPlayer player = this.field_70170_p.func_152378_a(theUUID);
        if (player != null) {
            MinionRegistry.addMinionForPlayer(player, this);
        }
        super.func_184754_b(theUUID);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(AGE, (Object)0);
    }

    @Override
    public void Harvest() {
        this.func_70097_a(DamageSourceMinion.causeMinionAgeDamage(this), 10.0f);
        if (this.getMaster() != null) {
            this.getMaster().func_70691_i(1.0f);
        }
    }

    private EntityPlayer getMaster() {
        return this.func_70902_q() instanceof EntityPlayer ? (EntityPlayer)this.func_70902_q() : null;
    }

    @Override
    public void setInvulnerable(boolean val) {
        this.field_83001_bt = val;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70652_k(Entity victim) {
        return victim.func_70097_a(DamageSourceMinion.causeMinionDamage(this), 5.0f);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        Entity source = damageSource.func_76346_g();
        if (source != null && !(source instanceof EntityPlayer) && !(source instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, amount);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70654_ax() {
        return (Integer)this.func_184212_Q().func_187225_a(AGE);
    }

    public void setAge(int time) {
        this.func_184212_Q().func_187227_b(AGE, (Object)time);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.field_83001_bt;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        MinionRegistry.removeMinion(this.getMaster(), this);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70638_az() instanceof IMinion) {
            this.func_70624_b(null);
        }
        if (this.getMaster() != null) {
            int age = this.func_70654_ax();
            if (age >= 0 && age < 1000) {
                this.setAge(++age);
            } else if (age >= 1000) {
                this.func_70097_a(DamageSourceMinion.causeMinionAgeDamage(this), this.func_110143_aJ() * 5.0f);
                age = 0;
                MinionRegistry.removeMinion(this.getMaster(), this);
            }
        } else {
            this.func_70097_a(DamageSourceMinion.causeMinionAgeDamage(this), this.func_110143_aJ() * 5.0f);
            this.setAge(0);
        }
    }

    private void Following() {
        float distanceToMaster = 18.0f;
        if (this.func_70638_az() == null && this.getMaster() != null) {
            distanceToMaster = this.func_70032_d((Entity)this.getMaster());
            if (distanceToMaster > 3.0f && distanceToMaster < 18.0f) {
                Path var2 = this.func_70661_as().func_75494_a((Entity)this.owner);
                this.func_70661_as().func_75484_a(var2, (double)(this.func_70689_ay() * 1.5f));
            } else {
                this.func_70661_as().func_75484_a(null, 0.0);
            }
        }
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entitytippedarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entitytippedarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.5f);
        DifficultyInstance difficultyinstance = this.field_70170_p.func_175649_E(new BlockPos((Entity)this));
        entitytippedarrow.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitytippedarrow);
    }
}

