/*
 * Decompiled with CFR 0.152.
 */
package subaraki.umbralux.entity.minion;

import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import subaraki.umbralux.entity.damage.DamageSourceMinion;
import subaraki.umbralux.entity.minion.EntityMinionSkeleton;
import subaraki.umbralux.entity.minion.IMinion;
import subaraki.umbralux.entity.minion.MinionRegistry;

public class EntityMinionZombie
extends EntityTameable
implements IMob,
IMinion {
    private EntityPlayer owner;
    boolean field_83001_bt = false;
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityMinionZombie.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMinionZombie(World world) {
        super(world);
        this.func_70105_a(0.7f, 1.7f);
        this.func_70661_as().func_75484_a((Path)null, 0.0);
        this.Following();
        this.func_70624_b(null);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 0.5, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, Entity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity target) {
                if (target instanceof IMinion) {
                    return false;
                }
                if (target instanceof IMob) {
                    return true;
                }
                if (target instanceof EntityPlayer) {
                    return !target.equals((Object)EntityMinionZombie.this.owner);
                }
                return false;
            }
        }));
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof EntityMinionSkeleton;
    }

    public void func_184754_b(UUID theUUID) {
        EntityPlayer player = this.field_70170_p.func_152378_a(theUUID);
        if (player != null) {
            MinionRegistry.addMinionForPlayer(player, this);
        }
        super.func_184754_b(theUUID);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(AGE, (Object)0);
    }

    @Override
    public void Harvest() {
        this.func_70097_a(DamageSourceMinion.causeMinionAgeDamage(this), 10.0f);
        if (this.getMaster() != null) {
            this.getMaster().func_70691_i(1.0f);
        }
    }

    private EntityPlayer getMaster() {
        return this.func_70902_q() instanceof EntityPlayer ? (EntityPlayer)this.func_70902_q() : null;
    }

    @Override
    public void setInvulnerable(boolean val) {
        this.field_83001_bt = val;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70652_k(Entity victim) {
        return victim.func_70097_a(DamageSourceMinion.causeMinionDamage(this), 5.0f);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        Entity source = damageSource.func_76346_g();
        if (source != null && !(source instanceof EntityPlayer) && !(source instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, amount);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70654_ax() {
        return (Integer)this.func_184212_Q().func_187225_a(AGE);
    }

    public void setAge(int time) {
        this.func_184212_Q().func_187227_b(AGE, (Object)time);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.field_83001_bt;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        MinionRegistry.removeMinion(this.getMaster(), this);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getMaster() != null) {
            int age = this.func_70654_ax();
            if (age >= 0 && age < 1000) {
                this.setAge(++age);
            } else if (age >= 1000) {
                this.func_70097_a(DamageSourceMinion.causeMinionAgeDamage(this), this.func_110143_aJ() * 5.0f);
                age = 0;
                MinionRegistry.removeMinion(this.getMaster(), this);
            }
        } else {
            this.func_70097_a(DamageSourceMinion.causeMinionAgeDamage(this), this.func_110143_aJ() * 5.0f);
            this.setAge(0);
        }
    }

    private void Following() {
        float distanceToMaster = 18.0f;
        if (this.func_70638_az() == null && this.getMaster() != null) {
            distanceToMaster = this.func_70032_d((Entity)this.getMaster());
            if (distanceToMaster > 3.0f && distanceToMaster < 18.0f) {
                Path var2 = this.func_70661_as().func_75494_a((Entity)this.owner);
                this.func_70661_as().func_75484_a(var2, (double)(this.func_70689_ay() * 1.5f));
            } else {
                this.func_70661_as().func_75484_a(null, 0.0);
            }
        }
    }
}

