--==========================================================================================================================
-- Districts
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,												Kind)
VALUES	('TRAIT_LEADER_DISTRICT_ANT_SUMMER_PALACE',			'KIND_TRAIT');
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,											Name,										Description)
VALUES	('TRAIT_LEADER_DISTRICT_ANT_SUMMER_PALACE',			'LOC_DISTRICT_ANT_SUMMER_PALACE_NAME',		'LOC_DISTRICT_ANT_SUMMER_PALACE_DESCRIPTION');

-------------------------------------
-- LeaderTraits
-------------------------------------	
INSERT INTO LeaderTraits	
		(TraitType,											LeaderType)
VALUES	('TRAIT_LEADER_DISTRICT_ANT_SUMMER_PALACE',			'LEADER_ANT_QIANLONG');
-------------------------------------
-- Types
-------------------------------------
INSERT INTO Types	
		(Type,												Kind)
VALUES	('DISTRICT_ANT_SUMMER_PALACE',						'KIND_DISTRICT');
-------------------------------------
-- Districts
-------------------------------------
INSERT INTO Districts
			(DistrictType,						Name,										Description,										TraitType,										Cost,		PrereqCivic,					Aqueduct,		PlunderType,			PlunderAmount,		AdvisorType,		CostProgressionModel,		CostProgressionParam1,		RequiresPlacement,		RequiresPopulation,		NoAdjacentCity,		InternalOnly,		ZOC,		CaptureRemovesBuildings,		CaptureRemovesCityDefenses,		MilitaryDomain,		TravelTime,		CityStrengthModifier,	Housing,	Entertainment,	OnePerCity, Appeal)
SELECT		'DISTRICT_ANT_SUMMER_PALACE',		'LOC_DISTRICT_ANT_SUMMER_PALACE_NAME',		'LOC_DISTRICT_ANT_SUMMER_PALACE_DESCRIPTION',		'TRAIT_LEADER_DISTRICT_ANT_SUMMER_PALACE',		Cost/2,		'CIVIC_CIVIL_ENGINEERING',		Aqueduct,		'PLUNDER_CULTURE',		PlunderAmount,		AdvisorType,		CostProgressionModel,		CostProgressionParam1,		RequiresPlacement,		RequiresPopulation,		NoAdjacentCity,		InternalOnly,		0,			CaptureRemovesBuildings,		CaptureRemovesCityDefenses,		MilitaryDomain,		TravelTime,		CityStrengthModifier,	0,			1,				1,			2
FROM Districts WHERE DistrictType = 'DISTRICT_NEIGHBORHOOD';
-------------------------------------
-- DistrictReplaces
-------------------------------------
-------------------------------------
-- District_GreatPersonPoints
-------------------------------------
-----------------------------------------------------------------------------------
-- District_CitizenYieldChanges
-----------------------------------------------------------------------------------
-------------------------------------
-- District_TradeRouteYields
-------------------------------------
-----------------------------------------------------------------------------------
-- District_Adjacencies
-----------------------------------------------------------------------------------
INSERT INTO District_Adjacencies
			(DistrictType,						YieldChangeId)
VALUES		('DISTRICT_ANT_SUMMER_PALACE',		'District_Culture');
-----------------------------------------------------------------------------------
-- Adjacency_YieldChanges
-----------------------------------------------------------------------------------
-------------------------------------
-- District_CitizenYieldChanges
-------------------------------------
-------------------------------------
-- District_ValidTerrains
-------------------------------------
INSERT INTO District_ValidTerrains
			(DistrictType,						TerrainType)
VALUES		('DISTRICT_ANT_SUMMER_PALACE',		'TERRAIN_GRASS'),
			('DISTRICT_ANT_SUMMER_PALACE',		'TERRAIN_GRASS_HILLS'),
			('DISTRICT_ANT_SUMMER_PALACE',		'TERRAIN_PLAINS'),
			('DISTRICT_ANT_SUMMER_PALACE',		'TERRAIN_PLAINS_HILLS');
-------------------------------------
-- DistrictModifiers
-------------------------------------
INSERT INTO DistrictModifiers
			(DistrictType,						ModifierId)
VALUES		('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_SCULPTURE_CULTURE'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_SCULPTURE_TOURISM'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_PORTRAIT_CULTURE'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_PORTRAIT_TOURISM'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_LANDSCAPE_CULTURE'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_LANDSCAPE_TOURISM'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_RELIGIOUS_CULTURE'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_RELIGIOUS_TOURISM'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_ARTIFACT_CULTURE'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_ARTIFACT_TOURISM'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_SCULPTURE_CULTURE_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_SCULPTURE_TOURISM_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_PORTRAIT_CULTURE_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_PORTRAIT_TOURISM_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_LANDSCAPE_CULTURE_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_LANDSCAPE_TOURISM_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_RELIGIOUS_CULTURE_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_RELIGIOUS_TOURISM_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_ARTIFACT_CULTURE_AIRPORT'),
			('DISTRICT_ANT_SUMMER_PALACE',		'ANT_SUMMER_PALACE_ARTIFACT_TOURISM_AIRPORT');
--==========================================================================================================================
-- Modifiers
--==========================================================================================================================
-- Modifiers
-------------------------------------
INSERT INTO Modifiers	
		(ModifierId,										ModifierType,																SubjectRequirementSetId)
VALUES	('ANT_SUMMER_PALACE_SCULPTURE_CULTURE',				'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_SCULPTURE_TOURISM',				'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE',				'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_PORTRAIT_TOURISM',				'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE',				'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_LANDSCAPE_TOURISM',				'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE',				'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_RELIGIOUS_TOURISM',				'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE',				'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_ARTIFACT_TOURISM',				'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_NO_AIRPORT'),
		('ANT_SUMMER_PALACE_SCULPTURE_CULTURE_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_SCULPTURE_TOURISM_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_PORTRAIT_TOURISM_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_LANDSCAPE_TOURISM_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_RELIGIOUS_TOURISM_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_GREATWORK_YIELD',								'ANT_CITY_HAS_AIRPORT'),
		('ANT_SUMMER_PALACE_ARTIFACT_TOURISM_AIRPORT',		'MODIFIER_SINGLE_CITY_ADJUST_TOURISM',										'ANT_CITY_HAS_AIRPORT');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,								Value)
VALUES	('ANT_SUMMER_PALACE_SCULPTURE_CULTURE',				'GreatWorkObjectType',				'GREATWORKOBJECT_SCULPTURE'),
		('ANT_SUMMER_PALACE_SCULPTURE_CULTURE',				'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_SCULPTURE_CULTURE',				'ScalingFactor',					150),
		('ANT_SUMMER_PALACE_SCULPTURE_TOURISM',				'GreatWorkObjectType',				'GREATWORKOBJECT_SCULPTURE'),
		('ANT_SUMMER_PALACE_SCULPTURE_TOURISM',				'ScalingFactor',					150),

		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE',				'GreatWorkObjectType',				'GREATWORKOBJECT_PORTRAIT'),
		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE',				'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE',				'ScalingFactor',					150),
		('ANT_SUMMER_PALACE_PORTRAIT_TOURISM',				'GreatWorkObjectType',				'GREATWORKOBJECT_PORTRAIT'),
		('ANT_SUMMER_PALACE_PORTRAIT_TOURISM',				'ScalingFactor',					150),

		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE',				'GreatWorkObjectType',				'GREATWORKOBJECT_LANDSCAPE'),
		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE',				'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE',				'ScalingFactor',					150),
		('ANT_SUMMER_PALACE_LANDSCAPE_TOURISM',				'GreatWorkObjectType',				'GREATWORKOBJECT_LANDSCAPE'),
		('ANT_SUMMER_PALACE_LANDSCAPE_TOURISM',				'ScalingFactor',					150),

		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE',				'GreatWorkObjectType',				'GREATWORKOBJECT_RELIGIOUS'),
		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE',				'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE',				'ScalingFactor',					150),
		('ANT_SUMMER_PALACE_RELIGIOUS_TOURISM',				'GreatWorkObjectType',				'GREATWORKOBJECT_RELIGIOUS'),
		('ANT_SUMMER_PALACE_RELIGIOUS_TOURISM',				'ScalingFactor',					150),

		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE',				'GreatWorkObjectType',				'GREATWORKOBJECT_ARTIFACT'),
		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE',				'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE',				'ScalingFactor',					150),
		('ANT_SUMMER_PALACE_ARTIFACT_TOURISM',				'GreatWorkObjectType',				'GREATWORKOBJECT_ARTIFACT'),
		('ANT_SUMMER_PALACE_ARTIFACT_TOURISM',				'ScalingFactor',					150),
		
		('ANT_SUMMER_PALACE_SCULPTURE_CULTURE_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_SCULPTURE'),
		('ANT_SUMMER_PALACE_SCULPTURE_CULTURE_AIRPORT',		'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_SCULPTURE_CULTURE_AIRPORT',		'ScalingFactor',					200),
		('ANT_SUMMER_PALACE_SCULPTURE_TOURISM_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_SCULPTURE'),
		('ANT_SUMMER_PALACE_SCULPTURE_TOURISM_AIRPORT',		'ScalingFactor',					200),

		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_PORTRAIT'),
		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE_AIRPORT',		'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_PORTRAIT_CULTURE_AIRPORT',		'ScalingFactor',					200),
		('ANT_SUMMER_PALACE_PORTRAIT_TOURISM_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_PORTRAIT'),
		('ANT_SUMMER_PALACE_PORTRAIT_TOURISM_AIRPORT',		'ScalingFactor',					200),

		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_LANDSCAPE'),
		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE_AIRPORT',		'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_LANDSCAPE_CULTURE_AIRPORT',		'ScalingFactor',					200),
		('ANT_SUMMER_PALACE_LANDSCAPE_TOURISM_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_LANDSCAPE'),
		('ANT_SUMMER_PALACE_LANDSCAPE_TOURISM_AIRPORT',		'ScalingFactor',					200),

		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_RELIGIOUS'),
		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE_AIRPORT',		'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_RELIGIOUS_CULTURE_AIRPORT',		'ScalingFactor',					200),
		('ANT_SUMMER_PALACE_RELIGIOUS_TOURISM_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_RELIGIOUS'),
		('ANT_SUMMER_PALACE_RELIGIOUS_TOURISM_AIRPORT',		'ScalingFactor',					200),

		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_ARTIFACT'),
		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE_AIRPORT',		'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_ARTIFACT_CULTURE_AIRPORT',		'ScalingFactor',					200),
		('ANT_SUMMER_PALACE_ARTIFACT_TOURISM_AIRPORT',		'GreatWorkObjectType',				'GREATWORKOBJECT_ARTIFACT'),
		('ANT_SUMMER_PALACE_ARTIFACT_TOURISM_AIRPORT',		'ScalingFactor',					200);
-------------------------------------
-- Types
-------------------------------------
-------------------------------------
-- DynamicModifiers
-------------------------------------
-------------------------------------
-- ModifierStrings
-------------------------------------
--==========================================================================================================================
-- Requirements
--==========================================================================================================================
-- RequirementSets
-------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,												RequirementSetType)
VALUES	('ANT_CITY_HAS_AIRPORT',										'REQUIREMENTSET_TEST_ALL'),
		('ANT_CITY_HAS_NO_AIRPORT',										'REQUIREMENTSET_TEST_ALL');
-------------------------------------
-- RequirementSetRequirements
-------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,												RequirementId)
VALUES	('ANT_CITY_HAS_AIRPORT',										'REQUIRES_ANT_CITY_HAS_AIRPORT'),
		('ANT_CITY_HAS_NO_AIRPORT',										'REQUIRES_ANT_CITY_HAS_NO_AIRPORT');
-------------------------------------
-- Requirements
-------------------------------------
INSERT INTO Requirements
		(RequirementId, 												RequirementType,						Inverse)
VALUES	('REQUIRES_ANT_CITY_HAS_AIRPORT',								'REQUIREMENT_CITY_HAS_BUILDING',		0),
		('REQUIRES_ANT_CITY_HAS_NO_AIRPORT',							'REQUIREMENT_CITY_HAS_BUILDING',		1);
-------------------------------------
-- RequirementArguments
-------------------------------------
INSERT INTO RequirementArguments
		(RequirementId, 												Name,					Value)
VALUES	('REQUIRES_ANT_CITY_HAS_AIRPORT',								'BuildingType',			'BUILDING_AIRPORT'),
		('REQUIRES_ANT_CITY_HAS_NO_AIRPORT',							'BuildingType',			'BUILDING_AIRPORT');
--==========================================================================================================================
--==========================================================================================================================