/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import java.util.HashMap;

public class StAXManager {
    protected static final String STAX_NOTATIONS = "javax.xml.stream.notations";
    protected static final String STAX_ENTITIES = "javax.xml.stream.entities";
    HashMap features = new HashMap();
    public static final int CONTEXT_READER = 1;
    public static final int CONTEXT_WRITER = 2;

    public StAXManager() {
    }

    public StAXManager(int n) {
        switch (n) {
            case 1: {
                this.initConfigurableReaderProperties();
                break;
            }
            case 2: {
                this.initWriterProps();
            }
        }
    }

    public StAXManager(StAXManager stAXManager) {
        HashMap hashMap = stAXManager.getProperties();
        this.features.putAll(hashMap);
    }

    private HashMap getProperties() {
        return this.features;
    }

    private void initConfigurableReaderProperties() {
        this.features.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.features.put("javax.xml.stream.isValidating", Boolean.FALSE);
        this.features.put("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.features.put("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        this.features.put("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.features.put("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.features.put("javax.xml.stream.reporter", null);
        this.features.put("javax.xml.stream.resolver", null);
        this.features.put("javax.xml.stream.allocator", null);
        this.features.put(STAX_NOTATIONS, null);
    }

    private void initWriterProps() {
        this.features.put("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
    }

    public boolean containsProperty(String string) {
        return this.features.containsKey(string);
    }

    public Object getProperty(String string) {
        this.checkProperty(string);
        return this.features.get(string);
    }

    public void setProperty(String string, Object object) {
        this.checkProperty(string);
        if (string.equals("javax.xml.stream.isValidating") && Boolean.TRUE.equals(object)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.validationNotSupported") + CommonResourceBundle.getInstance().getString("support_validation"));
        }
        if (string.equals("javax.xml.stream.isSupportingExternalEntities") && Boolean.TRUE.equals(object)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.externalEntities") + CommonResourceBundle.getInstance().getString("resolve_external_entities_"));
        }
        this.features.put(string, object);
    }

    public void checkProperty(String string) {
        if (!this.features.containsKey(string)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.propertyNotSupported", new Object[]{string}));
        }
    }

    public String toString() {
        return this.features.toString();
    }
}

