/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodRef;
import java.beans.ParameterDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor
extends FeatureDescriptor {
    private final MethodRef methodRef = new MethodRef();
    private String[] paramNames;
    private List params;
    private ParameterDescriptor[] parameterDescriptors;

    public MethodDescriptor(Method method) {
        this(method, null);
    }

    public MethodDescriptor(Method method, ParameterDescriptor[] parameterDescriptorArray) {
        this.setName(method.getName());
        this.setMethod(method);
        this.parameterDescriptors = parameterDescriptorArray;
    }

    public synchronized Method getMethod() {
        Method method = this.methodRef.get();
        if (method == null) {
            Class clazz = this.getClass0();
            String string = this.getName();
            if (clazz != null && string != null) {
                Class[] classArray = this.getParams();
                if (classArray == null) {
                    for (int i = 0; i < 3 && (method = Introspector.findMethod(clazz, string, i, null)) == null; ++i) {
                    }
                } else {
                    method = Introspector.findMethod(clazz, string, classArray.length, classArray);
                }
                this.setMethod(method);
            }
        }
        return method;
    }

    private synchronized void setMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.setParams(MethodDescriptor.getParameterTypes(this.getClass0(), method));
        this.methodRef.set(method);
    }

    private synchronized void setParams(Class[] classArray) {
        if (classArray == null) {
            return;
        }
        this.paramNames = new String[classArray.length];
        this.params = new ArrayList(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            this.paramNames[i] = classArray[i].getName();
            this.params.add(new WeakReference<Class>(classArray[i]));
        }
    }

    String[] getParamNames() {
        return this.paramNames;
    }

    private synchronized Class[] getParams() {
        Class[] classArray = new Class[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            Reference reference = (Reference)this.params.get(i);
            Class clazz = (Class)reference.get();
            if (clazz == null) {
                return null;
            }
            classArray[i] = clazz;
        }
        return classArray;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    MethodDescriptor(MethodDescriptor methodDescriptor, MethodDescriptor methodDescriptor2) {
        super(methodDescriptor, methodDescriptor2);
        Method method = methodDescriptor2.methodRef.get();
        this.methodRef.set(null != method ? method : methodDescriptor.methodRef.get());
        this.params = methodDescriptor.params;
        if (methodDescriptor2.params != null) {
            this.params = methodDescriptor2.params;
        }
        this.paramNames = methodDescriptor.paramNames;
        if (methodDescriptor2.paramNames != null) {
            this.paramNames = methodDescriptor2.paramNames;
        }
        this.parameterDescriptors = methodDescriptor.parameterDescriptors;
        if (methodDescriptor2.parameterDescriptors != null) {
            this.parameterDescriptors = methodDescriptor2.parameterDescriptors;
        }
    }

    MethodDescriptor(MethodDescriptor methodDescriptor) {
        super(methodDescriptor);
        this.methodRef.set(methodDescriptor.getMethod());
        this.params = methodDescriptor.params;
        this.paramNames = methodDescriptor.paramNames;
        if (methodDescriptor.parameterDescriptors != null) {
            int n = methodDescriptor.parameterDescriptors.length;
            this.parameterDescriptors = new ParameterDescriptor[n];
            for (int i = 0; i < n; ++i) {
                this.parameterDescriptors[i] = new ParameterDescriptor(methodDescriptor.parameterDescriptors[i]);
            }
        }
    }

    @Override
    void appendTo(StringBuilder stringBuilder) {
        MethodDescriptor.appendTo(stringBuilder, "method", this.methodRef.get());
        if (this.parameterDescriptors != null) {
            stringBuilder.append("; parameterDescriptors={");
            for (ParameterDescriptor parameterDescriptor : this.parameterDescriptors) {
                stringBuilder.append(parameterDescriptor).append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append("}");
        }
    }
}

