/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String propertyName = "sun.tools.ToolProvider";
    private static final String loggerName = "javax.tools";
    private static final String defaultJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static ToolProvider instance;
    private Map<String, Reference<Class<?>>> toolClasses = new HashMap();
    private Reference<ClassLoader> refToolClassLoader = null;
    private static final String[] defaultToolsLocation;

    static <T> T trace(Level level, Object object) {
        try {
            if (System.getProperty(propertyName) != null) {
                Object object2;
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                String string = "???";
                String string2 = ToolProvider.class.getName();
                if (stackTraceElementArray.length > 2) {
                    object2 = stackTraceElementArray[2];
                    string = String.format((Locale)null, "%s(%s:%s)", ((StackTraceElement)object2).getMethodName(), ((StackTraceElement)object2).getFileName(), ((StackTraceElement)object2).getLineNumber());
                    string2 = ((StackTraceElement)object2).getClassName();
                }
                object2 = Logger.getLogger(loggerName);
                if (object instanceof Throwable) {
                    ((Logger)object2).logp(level, string2, string, object.getClass().getName(), (Throwable)object);
                } else {
                    ((Logger)object2).logp(level, string2, string, String.valueOf(object));
                }
            }
        }
        catch (SecurityException securityException) {
            System.err.format((Locale)null, "%s: %s; %s%n", ToolProvider.class.getName(), object, securityException.getLocalizedMessage());
        }
        return null;
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.instance().getSystemTool(JavaCompiler.class, defaultJavaCompilerName);
    }

    public static ClassLoader getSystemToolClassLoader() {
        try {
            Class<JavaCompiler> clazz = ToolProvider.instance().getSystemToolClass(JavaCompiler.class, defaultJavaCompilerName);
            return clazz.getClassLoader();
        }
        catch (Throwable throwable) {
            return (ClassLoader)ToolProvider.trace(Level.WARNING, throwable);
        }
    }

    private static synchronized ToolProvider instance() {
        if (instance == null) {
            instance = new ToolProvider();
        }
        return instance;
    }

    private ToolProvider() {
    }

    private <T> T getSystemTool(Class<T> clazz, String string) {
        Class<T> clazz2 = this.getSystemToolClass(clazz, string);
        try {
            return clazz2.asSubclass(clazz).newInstance();
        }
        catch (Throwable throwable) {
            ToolProvider.trace(Level.WARNING, throwable);
            return null;
        }
    }

    private <T> Class<? extends T> getSystemToolClass(Class<T> clazz, String string) {
        Class<?> clazz2;
        Reference<Class<?>> reference = this.toolClasses.get(string);
        Class<?> clazz3 = clazz2 = reference == null ? null : reference.get();
        if (clazz2 == null) {
            try {
                clazz2 = this.findSystemToolClass(string);
            }
            catch (Throwable throwable) {
                return (Class)ToolProvider.trace(Level.WARNING, throwable);
            }
            this.toolClasses.put(string, new WeakReference(clazz2));
        }
        return clazz2.asSubclass(clazz);
    }

    private Class<?> findSystemToolClass(String string) throws MalformedURLException, ClassNotFoundException {
        try {
            return Class.forName(string, false, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader;
            ToolProvider.trace(Level.FINE, classNotFoundException);
            ClassLoader classLoader2 = classLoader = this.refToolClassLoader == null ? null : this.refToolClassLoader.get();
            if (classLoader == null) {
                File file = new File(System.getProperty("java.home"));
                if (file.getName().equalsIgnoreCase("jre")) {
                    file = file.getParentFile();
                }
                for (String string2 : defaultToolsLocation) {
                    file = new File(file, string2);
                }
                if (!file.exists()) {
                    throw classNotFoundException;
                }
                Object[] objectArray = new URL[]{file.toURI().toURL()};
                ToolProvider.trace(Level.FINE, ((URL)objectArray[0]).toString());
                classLoader = URLClassLoader.newInstance((URL[])objectArray);
                this.refToolClassLoader = new WeakReference<ClassLoader>(classLoader);
            }
            return Class.forName(string, false, classLoader);
        }
    }

    static {
        defaultToolsLocation = new String[]{"lib", "tools.jar"};
    }
}

