CONTAINER Trfcollider
{
	NAME Trfcollider;
  INCLUDE Texpression;
  
  GROUP RF_COLLIDER_PROPERTIES
  {
    GROUP RF_COLLIDER_COLLISION_PROPERTIES
    {
      DEFAULT 1;

      BOOL RF_COLLIDER_ENABLE_COLLISION {}
      REAL RF_COLLIDER_COLLISION_DISTANCE { UNIT METER; MINEX; MIN 0.0; }
		  LONG RF_COLLIDER_GEOMETRY_DETAIL
		  {
			  CYCLE
			  {
				  RF_COLLIDER_GEOMETRY_DETAIL_LOW;
				  RF_COLLIDER_GEOMETRY_DETAIL_LOW_MEDIUM;
				  RF_COLLIDER_GEOMETRY_DETAIL_MEDIUM;
				  RF_COLLIDER_GEOMETRY_DETAIL_MEDIUM_HIGH;
				  RF_COLLIDER_GEOMETRY_DETAIL_HIGH;
			  }
		  }

      GROUP
      {
        COLUMNS 2;  
        BOOL RF_COLLIDER_CCD {}
        BOOL RF_COLLIDER_CCD_AUTO { ANIM OFF; }
      }      
    }

    GROUP RF_COLLIDER_INTERACTION_PROPERTIES
    {
      DEFAULT 1; 

      REAL RF_COLLIDER_FRICTION { MIN 0.0; MAX 1; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }
      REAL RF_COLLIDER_BOUNCE { MIN 0.0; MAX 1; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }
      REAL RF_COLLIDER_STICKY { MIN -500.0; MAX 500; MINSLIDER -50; MAXSLIDER 50; STEP 0.2; CUSTOMGUI REALSLIDER; SCALE_H; }
      REAL RF_COLLIDER_ROUGHNESS { MIN 0.0; MAX 1.0; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }
      REAL RF_COLLIDER_INTERACT_FACTOR { MIN 0.0; MAX 10.0; MINSLIDER 0.0; MAXSLIDER 5.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }

      SEPARATOR { LINE; }

      GROUP
      {
        COLUMNS 2;  
        REAL RF_COLLIDER_INTERACT_DISTANCE { UNIT METER; MINEX; MIN 0.0; }
        BOOL RF_COLLIDER_INTERACT_DISTANCE_AUTO { ANIM OFF; }
      }
    }

    GROUP RF_COLLIDER_VOLUME_PROPERTIES
    {
      DEFAULT 1; COLUMNS 2;

      REAL RF_COLLIDER_CELL_SIZE { UNIT METER; MINEX; MIN 0.0; }
      BOOL RF_COLLIDER_CELL_SIZE_AUTO { ANIM OFF; }
      REAL RF_COLLIDER_SURFACE_OFFSET { UNIT METER; }  
      BOOL RF_COLLIDER_SURFACE_OFFSET_AUTO { ANIM OFF; }
      REAL RF_COLLIDER_DOMAIN_OFFSET { UNIT METER; MINEX; MIN 0.0; }      
      BOOL RF_COLLIDER_DOMAIN_OFFSET_AUTO { ANIM OFF; }

      LONG RF_COLLIDER_IMPLICIT_SURFACE_TYPE
      {
        ANIM OFF;

        CYCLE
        {
          RF_COLLIDER_IMPLICIT_SURFACE_TYPE_SOLID_INSIDE;
          RF_COLLIDER_IMPLICIT_SURFACE_TYPE_SOLID_OUTSIDE;
          RF_COLLIDER_IMPLICIT_SURFACE_TYPE_SHELL;
        }
      }
      BOOL RF_COLLIDER_IMPLICIT_SURFACE_TYPE_AUTO { ANIM OFF; }
    }

    STATICTEXT { NEWLINE; }
    SEPARATOR {LINE;}
    BUTTON RF_COLLIDER_HELP_PROPERTIES {}
  }

  GROUP RF_WETMAP_PROPERTIES
  {
    BOOL RF_WETMAP_ENABLE {}
    LONG RF_WETMAP_RESOLUTION {}
    LONG RF_WETMAP_FILTER_LOOPS { MIN 0; }
    REAL RF_WETMAP_FILTER_STRENGTH { MIN 0.0; MAX 1; MINSLIDER 0.0; MAXSLIDER 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; SCALE_H; }
    LONG RF_WETMAP_PIXEL_STRENGTH {}
    REAL RF_WETMAP_AGEING { MIN 0.0; MAX 50; MINSLIDER 0.0; MAXSLIDER 50.0; STEP 0.1; CUSTOMGUI REALSLIDER; SCALE_H; }

    STATICTEXT { NEWLINE; }
    SEPARATOR {LINE;}
    BUTTON RF_COLLIDER_HELP_WETMAP {}
  }

  GROUP RF_COLLIDER_DISPLAY_PROPERTIES
  {
    BOOL RF_COLLIDER_DISPLAY_COLLISION_GEOMETRY {}
    BOOL RF_COLLIDER_DISPLAY_COLLISION_VELOCITY {}

    STATICTEXT { NEWLINE; }
    SEPARATOR {LINE;}
    BUTTON RF_COLLIDER_HELP_DISPLAY {}
  }
}
