﻿U1RegisterAddon("TidyPlates", {
    title = "美化姓名版",
    defaultEnable = 0,
    load = "NORMAL",
    optionsAfterLogin = 1,
    minimap = "LibDBIcon10_TidyPlatesIcon",

    tags = { TAG_INTERFACE, TAG_BIG, },
    icon = [[Interface\AddOns\TidyPlates\media\TidyPlatesIcon]],
    desc = "強大到爆的多功能姓名版美化插件。``设置口令：/tidyplates",
    nopic = 1,

    toggle = function(name, info, enable, justload)
        if justload and IsLoggedIn() then
            for i, frame in ipairs(C_NamePlate.GetNamePlates()) do
                Export163_OnNewNameplate(frame)
            end
        end
        return true
    end,

    {
        text = "小地图按钮",
        type = "checkbox",
        var = "minimap",
        default = true,
        callback = function(cfg, v, loading)
            TidyPlatesOptions._EnableMiniButton = v
            if v then
                if not LibDBIcon10_TidyPlatesIcon then
                    TidyPlatesUtility:CreateMinimapButton()
                end
                TidyPlatesUtility:ShowMinimapButton()
            else
                if LibDBIcon10_TidyPlatesIcon then LibDBIcon10_TidyPlatesIcon:Hide() end
            end
        end
    },
    {
        text = "配置选项",
        callback = function(cfg, v, loading) slash_TidyPlates() end
    },
    {
        text = "重置所有控制台设定",
        callback = function(cfg, v, loading)
            TidyPlatesOptions = nil;
            TidyPlatesHubCache = nil;
            TidyPlatesHubGlobal = nil;
            TidyPlatesHubSettings = nil;
            TidyPlatesWidgetData = nil; 
            ReloadUI();
        end,
    },

});

U1RegisterAddon("TidyPlatesWidgets", { protected = 1, load = "NORMAL" })
U1RegisterAddon("TidyPlatesHub", { protected = 1, load = "NORMAL" })
