--print("|cff00dfff[BigDebuffs-v4.9]|r原作者|c00FF9900Curse:Jordon|r,由|c00FF9900NGA:伊甸外|r于7.23日翻译修改,输入|cff33ff99/bd|r设置.")
--翻译汉化修改：NGA  @伊甸外  barristan@sina.com  http://bbs.ngacn.cc/nuke.php?func=ucp&uid=7350579
-- BigDebuffs by Jordon

BigDebuffs = LibStub("AceAddon-3.0"):NewAddon("BigDebuffs", "AceEvent-3.0", "AceHook-3.0")

-- Defaults
local defaults = {
	profile = {
		raidFrames = {
			maxDebuffs = 2,
			anchor = "INNER",
			enabled = true,
			cooldownCount = false,
			hideBliz = true,
			redirectBliz = true,
			increaseBuffs = true,
			cc = 60,
			dispellable = {
				cc = 60,
				roots = 50,
			},
			roots = 40,
			warning = 30,
			default = 30,
			special = 30,
			pve = 50,
			warningList = {
				[212183] = true, -- Smoke Bomb
				[81261] = true, -- Solar Beam
				[30108] = true, -- Unstable Affliction
				[34914] = true, -- Vampiric Touch
			},
		},
		unitFrames = {
			enabled = true,
			cooldownCount = true,
			tooltips = true,
			player = {
				enabled = true,
				anchor = "auto",
				size = 50,
			},
			focus = {
				enabled = true,
				anchor = "auto",
				size = 50,
			},
			target = {
				enabled = true,
				anchor = "auto",
				size = 50,
			},
			pet = {
				enabled = true,
				anchor = "auto",
				size = 50,
			},
			party = {
				enabled = true,
				anchor = "auto",
				size = 50,
			},
			arena = {
				enabled = true,
				anchor = "auto",
				size = 50,
			},
			cc = true,
			immunities = true,
			immunities_spells = true,
			buffs_defensive = true,
			buffs_offensive = true,
			buffs_other = true,
			roots = true,
		},
		priority = {
			immunities = 80,
			immunities_spells = 70,
			cc = 60,
			buffs_defensive = 40,
			buffs_offensive = 30,
			buffs_other = 20,
			roots = 50,
			special = 10,
		},
		spells = {},
	}
}

-- Show one of these when a big debuff is displayed
BigDebuffs.WarningDebuffs = {
	212183, -- Smoke Bomb
	81261, -- Solar Beam
	30108, -- Unstable Affliction
	34914, -- Vampiric Touch
}

BigDebuffs.Spells = {

	-- Death Knight

	[47476] = { type = "cc" }, -- Strangulate 
	[48707] = { type = "immunities_spells" }, -- Anti-Magic Shell
	[48792] = { type = "buffs_defensive" }, -- Icebound Fortitude
	[55233] = { type = "buffs_defensive" },  -- Vampiric Blood
	[77606] = { type = "buffs_other" }, -- Dark Simulacrum
	[91797] = { type = "cc" }, -- Monstrous Blow
	[91800] = { type = "cc" }, -- Gnaw
	[108194] = { type = "cc" }, -- Asphyxiate
	[152279] = { type = "buffs_offensive" }, -- Breath of Sindragosa
	[194679] = { type = "buffs_defensive" }, -- Rune Tap
	[207167] = { type = "cc" }, -- Blinding Sleet
	[207256] = { type = "buffs_offensive" }, -- Obliteration
	[207319] = { type = "buffs_defensive" }, -- Corpse Shield
	[212552] = { type = "buffs_defensive" }, -- Wraith Walk
	[221527] = { type = "cc" }, -- Imprison
	[223929] = { type = "buffs_other" }, -- Necrotic Wound

	-- Monk

	[115078] = { type = "cc" }, -- Paralysis
	[116844] = { type = "buffs_offensive" }, -- Ring of Peace
	[116849] = { type = "buffs_defensive" }, -- Life Cocoon
	[119381] = { type = "cc" }, -- Leg Sweep
	[122278] = { type = "buffs_defensive" }, -- Dampen Harm
	[122783] = { type = "buffs_defensive" }, -- Diffuse Magic
	[137639] = { type = "buffs_defensive" }, -- Storm, Earth, and Fire
	[201325] = { type = "buffs_defensive" }, -- Zen Meditation
	[202162] = { type = "buffs_defensive" }, -- Guard
	[216113] = { type = "buffs_defensive" }, -- Way of the Crane

	-- Rogue

	[408] = { type = "cc" }, -- Kidney Shot
	[1330] = { type = "cc" }, -- Garrote - Silence
	[1776] = { type = "cc" }, -- Gouge
	[1833] = { type = "cc" }, -- Cheap Shot
	[2094] = { type = "cc" }, -- Blind
		[199743] = { type = "cc", parent = 2094 }, -- Parley
	[5277] = { type = "buffs_defensive" }, -- Evasion
	[6770] = { type = "cc" }, -- Sap
	[31224] = { type = "immunities_spells" }, -- Cloak of Shadows
	[51690] = { type = "buffs_offensive" }, -- Killing Spree
	[79140] = { type = "buffs_offensive" }, -- Vendetta
	[13750] = { type = "buffs_offensive" }, -- Adrenaline Rush
	[121471] = { type = "buffs_offensive" }, -- Shadow Blades
	[199754] = { type = "buffs_defensive" }, -- Riposte
	[199804] = { type = "cc" }, -- Between the Eyes
	[207736] = { type = "buffs_offensive" }, -- Shadowy Duel
	[212183] = { type = "cc" }, -- Smoke Bomb

	-- Mage

	[66] = { type = "buffs_offensive" }, -- Invisibility
		[110959] = { type = "buffs_offensive", parent = 66 }, -- Greater Invisibility
	[118] = { type = "cc" }, -- Polymorph
		[61305] = { type = "cc", parent = 118 }, -- Polymorph Black Cat
		[28272] = { type = "cc", parent = 118 }, -- Polymorph Pig
		[61721] = { type = "cc", parent = 118 }, -- Polymorph Rabbit
		[61780] = { type = "cc", parent = 118 }, -- Polymorph Turkey
		[28271] = { type = "cc", parent = 118 }, -- Polymorph Turtle
		[161353] = { type = "cc", parent = 118 }, -- Polymorph Polar Bear Cub
	[122] = { type = "roots" }, -- Frost Nova
	[11426] = { type = "buffs_defensive" }, -- Ice Barrier
	[12042] = { type = "buffs_offensive" }, -- Arcane Power
	[12051] = { type = "buffs_offensive" }, -- Evocation
	[12472] = { type = "buffs_offensive" }, -- Icy Veins
		[198144] = { type = "buffs_offensive", parent = 12472 }, -- Ice Form
	[31661] = { type = "cc" }, -- Dragon's Breath
	[45438] = { type = "immunities" }, -- Ice Block
	[80353] = { type = "buffs_offensive" }, -- Time Warp
	[108839] = { type = "buffs_offensive" }, -- Ice Floes
	[198111] = { type = "buffs_defensive" }, -- Temporal Shield
	[157997] = { type = "roots" }, -- Ice Nova
	[190319] = { type = "buffs_offensive" }, -- Combustion
	[198158] = { type = "buffs_offensive" }, -- Mass Invisibility
	[205025] = { type = "buffs_offensive" }, -- Presence of Mind

	-- Hunter

	[136] = { type = "buffs_defensive" }, -- Mend Pet
	[3355] = { type = "cc" }, -- Freezing Trap
	[5384] = { type = "buffs_defensive" }, -- Feign Death
	[19386] = { type = "cc" }, -- Wyvern Sting
	[19574] = { type = "buffs_offensive" }, -- Bestial Wrath
	[19577] = { type = "cc" }, -- Intimidation
	[131894] = { type = "buffs_offensive" }, -- A Murder of Crows (Beast Mastery, Marksmanship)
		[206505] = { type = "buffs_offensive", parent = 131894 }, -- A Murder of Crows (Survival)
	[186265] = { type = "buffs_defensive" }, -- Aspect of the Turtle
	[186289] = { type = "buffs_offensive" }, -- Aspect of the Eagle
	[186387] = { type = "cc" }, -- Bursting Shot
	[193526] = { type = "buffs_offensive" }, -- Trueshot
	[193530] = { type = "buffs_offensive" }, -- Aspect of the Wild
	[199483] = { type = "buffs_defensive" }, -- Camouflage
	[209997] = { type = "buffs_defensive" }, -- Play Dead
	[213691] = { type = "cc" }, -- Scatter Shot

	-- Shaman

	[2825] = { type = "buffs_offensive" }, -- Bloodlust
		[32182] = { type = "buffs_offensive", parent = 2825 }, -- Heroism
	[51514] = { type = "cc" }, -- Hex
		[211015] = { type = "cc", parent = 51514 }, -- Hex (Cockroach)
		[210873] = { type = "cc", parent = 51514 }, -- Hex (Compy)
		[211004] = { type = "cc", parent = 51514 }, -- Hex (Spider)
		[211010] = { type = "cc", parent = 51514 }, -- Hex (Snake)
		[196932] = { type = "cc", parent = 51514 }, -- Voodoo Totem
	[79206] = { type = "buffs_defensive" }, -- Spiritwalker's Grace 60 * OTHER
	[108271] = { type = "buffs_defensive" }, -- Astral Shift
		[210918] = { type = "buffs_defensive", parent = 108271 }, -- Ethereal Form
	[108281] = { type = "buffs_defensive" }, -- Ancestral Guidance
	[114050] = { type = "buffs_defensive" }, -- Ascendance (Elemental)
		[114051] = { type = "buffs_offensive", parent = 114050 }, -- Ascendance (Enhancement)
		[114052] = { type = "buffs_defensive", parent = 114050 }, -- Ascendance (Restoration)
	[118905] = { type = "cc" }, -- Static Charge
	[197214] = { type = "cc" }, -- Sundering
	[204293] = { type = "buffs_defensive" }, -- Spirit Link
	[204366] = { type = "buffs_offensive" }, -- Thundercharge
	[204945] = { type = "buffs_offensive" }, -- Doom Winds

	-- Warlock

	[5484] = { type = "cc" }, -- Howl of Terror
	[6358] = { type = "cc" }, -- Seduction
		[115268] = { type = "cc", parent = 6358 }, -- Mesmerize
	[6789] = { type = "cc" }, -- Mortal Coil
	[20707] = { type = "buffs_defensive" }, -- Soulstone
	[30283] = { type = "cc" }, -- Shadowfury
	[89751] = { type = "buffs_offensive" }, -- Felstorm
		[115831] = { type = "buffs_offensive", parent = 89751 }, -- Wrathstorm
	[89766] = { type = "cc" }, -- Axe Toss
	[104773] = { type = "immunities_spells" }, -- Unending Resolve
	[108416] = { type = "buffs_defensive" }, -- Dark Pact
	[171017] = { type = "cc" }, -- Meteor Strike
	[196098] = { type = "buffs_offensive" }, -- Soul Harvest
	[212284] = { type = "buffs_offensive" }, -- Firestone
	[212295] = { type = "immunities_spells" }, -- Nether Ward

	-- Warrior

	[871] = { type = "buffs_defensive" }, -- Shield Wall
	[1719] = { type = "buffs_offensive" }, -- Battle Cry
	[5246] = { type = "cc" }, -- Intimidating Shout
	[12975] = { type = "buffs_defensive" }, -- Last Stand
	[18499] = { type = "buffs_other" }, -- Berserker Rage
	[23920] = { type = "immunities_spells" }, -- Spell Reflection
		[213915] = { type = "immunities_spells", parent = 23920 }, -- Mass Spell Reflection
		[216890] = { type = "immunities_spells", parent = 23920 }, -- Spell Reflection (Arms, Fury)
	[46968] = { type = "cc" }, -- Shockwave
	[107574] = { type = "buffs_offensive" }, -- Avatar
	[132169] = { type = "cc" }, -- Storm Bolt
	[118038] = { type = "buffs_defensive" }, -- Die by the Sword
	[184364] = { type = "buffs_defensive" }, -- Enraged Regeneration
	[197690] = { type = "buffs_defensive" }, -- Defensive Stance
	[213871] = { type = "buffs_defensive" }, -- Bodyguard
	[227847] = { type = "immunities" }, -- Bladestorm (Arms)
		[46924] = { type = "immunities", parent = 227847 }, -- Bladestorm (Fury)
		[152277] = { type = "immunities", parent = 227847 }, -- Ravager
	[228920] = { type = "buffs_defensive" }, -- Ravager

	-- Druid

	[99] = { type = "cc" }, -- Incapacitating Roar
	[339] = { type = "roots" }, -- Entangling Roots
	[740] = { type = "buffs_defensive" }, -- Tranquility
	[1850] = { type = "buffs_other" }, -- Dash
	[5211] = { type = "cc" }, -- Mighty Bash
	[5217] = { type = "buffs_offensive" }, -- Tiger's Fury
	[22812] = { type = "buffs_defensive" }, -- Barkskin
	[22842] = { type = "buffs_defensive" }, -- Frenzied Regeneration
	[29166] = { type = "buffs_offensive" }, -- Innervate
	[33891] = { type = "buffs_offensive" }, -- Incarnation: Tree of Life
	[61336] = { type = "buffs_defensive" }, -- Survival Instincts
	[81261] = { type = "cc" }, -- Solar Beam
	[102342] = { type = "buffs_defensive" }, -- Ironbark
	[102359] = { type = "roots" }, -- Mass Entanglement
	[102543] = { type = "buffs_offensive" }, -- Incarnation: King of the Jungle
	[102558] = { type = "buffs_offensive" }, -- Incarnation: Guardian of Ursoc
	[102560] = { type = "buffs_offensive" }, -- Incarnation: Chosen of Elune
	[106951] = { type = "buffs_offensive" }, -- Berserk
	[194223] = { type = "buffs_offensive" }, -- Celestial Alignment
	[200851] = { type = "buffs_defensive" }, -- Rage of the Sleeper
	[202425] = { type = "buffs_offensive" }, -- Warrior of Elune
	[209753]  = { type = "cc", priority = true }, -- Cyclone
		[33786] = { type = "cc", parent = 209753 }, -- Cyclone

	-- Warlock

	[179057] = { type = "cc" }, -- Chaos Nova
	[187827] = { type = "buffs_defensive" }, -- Metamorphosis
	[188499] = { type = "buffs_defensive" }, -- Blade Dance
	[188501] = { type = "buffs_offensive" }, -- Spectral Sight
	[196364] = { type = "cc" }, -- Unstable Affliction (Silence)
	[205629] = { type = "buffs_defensive" }, -- Demonic Trample
	[205630] = { type = "cc" }, -- Illidan's Grasp
	[206649] = { type = "buffs_other" }, -- Eye of Leotheras
	[207810] = { type = "buffs_defensive" }, -- Nether Bond
	[211048] = { type = "buffs_offensive" }, -- Chaos Blades
	[211881] = { type = "cc" }, -- Fel Eruption
	[212800] = { type = "buffs_defensive" }, -- Blur
		[196555] = { type = "buffs_defensive" }, -- Netherwalk
	[218256] = { type = "buffs_defensive" }, -- Empower Wards
	[227225] = { type = "buffs_defensive" }, -- Soul Barrier

	-- Priest

	[586] = { type = "buffs_defensive" }, -- Fade
		[213602] = { type = "buffs_defensive" }, -- Greater Fade
	[605] = { type = "cc", priority = true }, -- Mind Control
	[8122] = { type = "cc" }, -- Psychic Scream
	[9484] = { type = "cc" }, -- Shackle Undead
	[33206] = { type = "buffs_defensive" }, -- Pain Suppression
	[10060] = { type = "buffs_offensive" }, -- Power Infusion
	[15487] = { type = "cc" }, -- Silence
		[199683] = { type = "cc", parent = 15487 }, -- Last Word
	[47536] = { type = "buffs_defensive" }, -- Rapture
	[47585] = { type = "buffs_defensive" }, -- Dispersion
	[47788] = { type = "buffs_defensive" }, -- Guardian Spirit
	[64843] = { type = "buffs_defensive" }, -- Divine Hymn
	[87204] = { type = "cc" }, -- Sin and Punishment
	[193223] = { type = "buffs_offensive" }, -- Surrender to Madness
	[194249] = { type = "buffs_offensive" }, -- Voidform
	[196762] = { type = "buffs_defensive" }, -- Inner Focus
	[197268] = { type = "buffs_defensive" }, -- Ray of Hope
	[197862] = { type = "buffs_defensive" }, -- Archangel
	[197871] = { type = "buffs_offensive" }, -- Dark Archangel
	[200183] = { type = "buffs_defensive" }, -- Apotheosis
	[200196] = { type = "cc" }, -- Holy Word: Chastise
		[200200] = { type = "cc", parent = 200196 }, -- Holy Word: Chastise (Stun)
	[205369] = { type = "cc" }, -- Mind Bomb
		[226943] = { type = "cc", parent = 205369 }, -- Mind Bomb (Stun)
	[213610] = { type = "buffs_defensive" }, -- Holy Ward
	[215769] = { type = "buffs_defensive" }, -- Spirit of Redemption
	[221660] = { type = "immunities_spells" }, -- Holy Concentration

	-- Paladin

	[498] = { type = "buffs_defensive" }, -- Divine Protection
	[642] = { type = "immunities" }, -- Divine Shield
	[853] = { type = "cc" }, -- Hammer of Justice
	[1022] = { type = "buffs_defensive" }, -- Blessing of Protection
		[204018] = { type = "buffs_defensive" }, -- Blessing of Spellwarding
	[1044] = { type = "buffs_defensive" }, -- Blessing of Freedom
	[6940] = { type = "buffs_defensive" }, -- Blessing of Sacrifice
	[20066] = { type = "cc" }, -- Repentance
	[31821] = { type = "buffs_defensive" }, -- Aura Mastery
	[31850] = { type = "buffs_defensive" }, -- Ardent Defender
	[31884] = { type = "buffs_offensive" }, -- Avenging Wrath
	[31935] = { type = "cc" }, -- Avenger's Shield
	[86659] = { type = "buffs_defensive" }, -- Guardian of Ancient Kings
		[228049] = { type = "buffs_defensive" }, -- Guardian of the Forgotten Queen
	[105809] = { type = "buffs_offensive" }, -- Holy Avenger
	[115750] = { type = "cc" }, -- Blinding Light 90 * cc get spellID
	[152262] = { type = "buffs_offensive" }, -- Seraphim
	[184662] = { type = "buffs_defensive" }, -- Shield of Vengeance
	[204150] = { type = "buffs_defensive" }, -- Aegis of Light
	[205191] = { type = "buffs_defensive" }, -- Eye for an Eye
	[210256] = { type = "buffs_defensive" }, -- Blessing of Sanctuary
	[210294] = { type = "immunities_spells" }, -- Divine Favor
	[215652] = { type = "buffs_offensive" }, -- Shield of Virtue

	-- Other

	[20549]  = { type = "cc" }, -- War Stomp
	[107079] = { type = "cc" }, -- Quaking Palm
	[129597] = { type = "cc" }, -- Arcane Torrent
		[28730]  = { type = "cc", parent = 129597 }, -- Arcane Torrent
		[25046]  = { type = "cc", parent = 129597 }, -- Arcane Torrent
		[50613]  = { type = "cc", parent = 129597 }, -- Arcane Torrent
		[69179]  = { type = "cc", parent = 129597 }, -- Arcane Torrent
		[155145] = { type = "cc", parent = 129597 }, -- Arcane Torrent
		[80483]  = { type = "cc", parent = 129597 }, -- Arcane Torrent
	[192001] = { type = "buffs_other" }, -- Drink
		[167152] = { type = "buffs_other", parent = 192001 }, -- Refreshment

	-- Legacy (may be deprecated)

	[24394]  = { type = "cc", parent = 19577 }, -- Intimidation
	[132168] = { type = "cc", parent = 46968 }, -- Shockwave
	[77505]  = { type = "cc" }, -- Earthquake
	[118345] = { type = "cc" }, -- Pulverize
	[31661]  = { type = "cc" }, -- Dragon's Breath
	[82691]  = { type = "cc" }, -- Ring of Frost
	[710]    = { type = "cc" }, -- Banish
	[5484]   = { type = "cc" }, -- Howl of Terror
	[6358]   = { type = "cc" }, -- Seduction
	[6789]   = { type = "cc" }, -- Mortal Coil
	[22703]  = { type = "cc" }, -- Infernal Awakening
	[30283]  = { type = "cc" }, -- Shadowfury
	[89766]  = { type = "cc" }, -- Axe Toss
	[115268] = { type = "cc" }, -- Mesmerize
	[118699] = { type = "cc" }, -- Fear
		[130616] = { type = "cc", parent = 118699 }, -- Fear (Glyph of Fear)
	[115078] = { type = "cc" }, -- Paralysis
	[119381] = { type = "cc" }, -- Leg Sweep
	[120086] = { type = "cc" }, -- Fists of Fury
	[99]     = { type = "cc" }, -- Incapacitating Roar
	[5211]   = { type = "cc" }, -- Mighty Bash
	[22570]  = { type = "cc" }, -- Maim
		[203123]  = { type = "cc", parent = 22570 }, -- Maim
	[163505] = { type = "cc" }, -- Rake

	-- Defensive Buffs
	[871]    = { type = "buffs_defensive" }, -- Shield Wall
	[108271] = { type = "buffs_defensive" }, -- Astral Shift
	[33206]  = { type = "buffs_defensive" }, -- Pain Suppression
	[116849] = { type = "buffs_defensive" }, -- Life Cocoon
	[47788]  = { type = "buffs_defensive" }, -- Guardian Spirit
	[47585]  = { type = "buffs_defensive" }, -- Dispersion
	[122783] = { type = "buffs_defensive" }, -- Diffuse Magic
	[178858] = { type = "buffs_defensive" }, -- Contender
	[61336]  = { type = "buffs_defensive" }, -- Survival Instincts
	[98007]  = { type = "buffs_defensive" }, -- Spirit Link
	[118038] = { type = "buffs_defensive" }, -- Die by the Sword
	[74001]  = { type = "buffs_defensive" }, -- Combat Readiness
	[5277]   = { type = "buffs_defensive" }, -- Evasion
	[49039]  = { type = "buffs_defensive" }, -- Lichborne
	[117679] = { type = "buffs_defensive" }, -- Incarnation: Tree of Life
	[102342] = { type = "buffs_defensive" }, -- Ironbark
	[22812]  = { type = "buffs_defensive" }, -- Barkskin
	[122278] = { type = "buffs_defensive" }, -- Dampen Harm
	[53480]  = { type = "buffs_defensive" }, -- Roar of Sacrifice
	[12975]  = { type = "buffs_defensive" }, -- Last Stand
	[1966]   = { type = "buffs_defensive" }, -- Feint
	[6940]   = { type = "buffs_defensive" }, -- Hand of Sacrifice
	[97463]  = { type = "buffs_defensive" }, -- Rallying Cry
	[115176] = { type = "buffs_defensive", parent = 201325 }, -- Zen Meditation
	[120954] = { type = "buffs_defensive" }, -- Fortifying Brew
	[81782]  = { type = "buffs_defensive" }, -- Power Word: Barrier
	[155835] = { type = "buffs_defensive" }, -- Bristling Fur
	[1022]   = { type = "buffs_defensive" }, -- Hand of Protection
	[48743]  = { type = "buffs_defensive" }, -- Death Pact
	[31850]  = { type = "buffs_defensive" }, -- Ardent Defender
	[114030] = { type = "buffs_defensive" }, -- Vigilance
	[498]    = { type = "buffs_defensive" }, -- Divine Protection
	[122470] = { type = "buffs_defensive" }, -- Touch of Karma
	[48792]  = { type = "buffs_defensive" }, -- Icebound Fortitude
	[55233]  = { type = "buffs_defensive" }, -- Vampiric Blood
	[86659]  = { type = "buffs_defensive" }, -- Guardian of Ancient Kings
	[108416] = { type = "buffs_defensive" }, -- Sacrificial Pact
	[186265] = { type = "buffs_defensive" }, -- Aspect of the Turtle
	[33702]  = { type = "buffs_offensive" }, -- Bestial Wrath
	[131894] = { type = "buffs_offensive" }, -- A Murder of Crows
	[152151] = { type = "buffs_offensive" }, -- Shadow Reflection
	[31842]  = { type = "buffs_offensive", parent = 31884 }, -- Avenging Wrath
	[79140]  = { type = "buffs_offensive" }, -- Vendetta
	[102560] = { type = "buffs_offensive" }, -- Incarnation: Chosen of Elune
	[102543] = { type = "buffs_offensive" }, -- Incarnation: King of the Jungle
	[124974] = { type = "buffs_offensive" }, -- Nature's Vigil
	[12472]  = { type = "buffs_offensive" }, -- Icy Veins
	[16166]  = { type = "buffs_offensive" }, -- Elemental Mastery
	[114049] = { type = "buffs_offensive" }, -- Ascendance
		[114052] = { type = "buffs_offensive", parent = 114049 }, -- Ascendance (Restoration)
		[114050] = { type = "buffs_offensive", parent = 114049 }, -- Ascendance (Elemental)
		[114051] = { type = "buffs_offensive", parent = 114049 }, -- Ascendance (Enhancement)
	[107574] = { type = "buffs_offensive" }, -- Avatar
	[13750]  = { type = "buffs_offensive" }, -- Adrenaline Rush
	[1719]   = { type = "buffs_offensive" }, -- Recklessness
	[106951] = { type = "buffs_offensive" }, -- Berserk
	[12042]  = { type = "buffs_offensive" }, -- Arcane Power
	[51271]  = { type = "buffs_offensive" }, -- Pillar of Frost
	[152279] = { type = "buffs_offensive" }, -- Breath of Sindragosa
	[41425]  = { type = "buffs_other" }, -- Hypothermia
	[130736] = { type = "buffs_other" }, -- Soul Reaper
	[77606]  = { type = "buffs_other" }, -- Dark Simulacrum
	[114239] = { type = "buffs_other" }, -- Phantasm
	[119032] = { type = "buffs_other" }, -- Spectral Guise
	[1044]   = { type = "buffs_other" }, -- Hand of Freedom
	[10060]  = { type = "buffs_other" }, -- Power Infusion
	[5384]   = { type = "buffs_other" }, -- Feign Death
	[108978] = { type = "buffs_other" }, -- Alter Time
	[170856] = { type = "buffs_other" }, -- Nature's Grasp
	[110959] = { type = "buffs_other" }, -- Greater Invisibility
	[18499]  = { type = "buffs_other" }, -- Berserker Rage	
	[114896] = { type = "buffs_other" }, -- Windwalk Totem
	[122]    = { type = "roots" }, -- Frost Nova
		[33395] = { type = "roots", parent = 122 }, -- Freeze
	[339]    = { type = "roots" }, -- Entangling Roots
		[170855] = { type = "roots", parent = 339 }, -- Entangling Roots (Nature's Grasp)
	[53148]  = { type = "roots" }, -- Charge (Hunter)
	[105771] = { type = "roots" }, -- Charge (Warrior)
	[64695]  = { type = "roots" }, -- Earthgrab Totem
	[96294]  = { type = "roots" }, -- Chains of Ice
	[102359] = { type = "roots" }, -- Mass Entanglement
	[116706] = { type = "roots" }, -- Disable
	[135373] = { type = "roots" }, -- Entrapment
	[136634] = { type = "roots" }, -- Narrow Escape
	[55536]  = { type = "roots" }, -- Frostweave Net
	[157997] = { type = "roots" }, -- Ice Nova
	[45334]  = { type = "roots" }, -- Wild Charge

	-- Special
	--[6788]   = { type = "special", nounitFrames = true, noraidFrames = true }, -- Weakened Soul
}

local specDispel = {
	[65] = { -- Holy Paladin
		Magic = true,
		Poison = true,
		Disease = true,
	},
	[66] = { -- Protection Paladin
		Poison = true,
		Disease = true,
	},
	[70] = { -- Retribution Paladin
		Poison = true,
		Disease = true,
	},
	[102] = { -- Balance Druid
		Curse = true,
		Poison = true,
	},
	[103] = { -- Feral Druid
		Curse = true,
		Poison = true,
	},
	[104] = { -- Guardian Druid
		Curse = true,
		Poison = true,
	},
	[105] = { -- Restoration Druid
		Magic = true,
		Curse = true,
		Poison = true,
	},
	[256] = { -- Discipline Priest
		Magic = true,
		Disease = true,
	},
	[257] = { -- Holy Priest
		Magic = true,
		Disease = true,
	},
	[258] = { -- Shadow Priest
		Magic = true,
		Disease = true,
	},
	[262] = { -- Elemental Shaman
		Curse = true,
	},
	[263] = { -- Enhancement Shaman
		Curse = true,
	},
	[264] = { -- Restoration Shaman
		Magic = true,
		Curse = true,
	},
	[268] = { -- Brewmaster Monk
		Poison = true,
		Disease = true,
	},
	[269] = { -- Windwalker Monk
		Poison = true,
		Disease = true,
	},
	[270] = { -- Mistweaver Monk
		Magic = true,
		Poison = true,
		Disease = true,
	},
	[577] = {
		Magic = function() return GetSpellInfo(205604) end, -- Reverse Magic
	},
	[581] = {
		Magic = function() return GetSpellInfo(205604) end, -- Reverse Magic
	},
}

-- Make sure we always see these debuffs, but don't make them bigger
BigDebuffs.PriorityDebuffs = {
	30108,  -- Unstable Affliction
	34914,  -- Vampiric Touch
	102355, -- Faerie Swarm
	770,    -- Faerie Fire
	130736, -- Soul Reaper (Unholy)
}

local units = {
	"player",
	"pet",
	"target",
	"focus",
	"party1",
	"party2",
	"party3",
	"party4",
	"arena1",
	"arena2",
	"arena3",
	"arena4",
	"arena5",
}

local UnitDebuff, UnitBuff = UnitDebuff, UnitBuff

local GetAnchor = {
	ShadowedUnitFrames = function(anchor)
		local frame = _G[anchor]
		if not frame then return end
		if frame.portrait and frame.portrait:IsShown() then
			return frame.portrait, frame
		else
			return frame, frame, true
		end
	end,
	ZPerl = function(anchor)
		local frame = _G[anchor]
		if not frame then return end
		if frame:IsShown() then
			return frame, frame
		else
			frame = frame:GetParent()
			return frame, frame, true
		end
	end,
}

local anchors = {
	["ElvUI"] = {
		noPortait = true,
		units = {
			player = "ElvUF_Player",
			pet = "ElvUF_Pet",
			target = "ElvUF_Target",
			focus = "ElvUF_Focus",
			party1 = "ElvUF_PartyGroup1UnitButton1",
			party2 = "ElvUF_PartyGroup1UnitButton2",
			party3 = "ElvUF_PartyGroup1UnitButton3",
			party4 = "ElvUF_PartyGroup1UnitButton4",
		},
	},
	["bUnitFrames"] = {
		noPortait = true,
		alignLeft = true,
		units = {
			player = "bplayerUnitFrame",
			pet = "bpetUnitFrame",
			target = "btargetUnitFrame",
			focus = "bfocusUnitFrame",
			arena1 = "barena1UnitFrame",
			arena2 = "barena2UnitFrame",
			arena3 = "barena3UnitFrame",
			arena4 = "barena4UnitFrame",
		},
	},
	["Shadowed Unit Frames"] = {
		func = GetAnchor.ShadowedUnitFrames,
		units = {
			player = "SUFUnitplayer",
			pet = "SUFUnitpet",
			target = "SUFUnittarget",
			focus = "SUFUnitfocus",
			party1 = "SUFHeaderpartyUnitButton1",
			party2 = "SUFHeaderpartyUnitButton2",
			party3 = "SUFHeaderpartyUnitButton3",
			party4 = "SUFHeaderpartyUnitButton4",
		},
	},
	["ZPerl"] = {
		func = GetAnchor.ZPerl,
		units = {
			player = "XPerl_PlayerportraitFrame",
			pet = "XPerl_Player_PetportraitFrame",
			target = "XPerl_TargetportraitFrame",
			focus = "XPerl_FocusportraitFrame",
			party1 = "XPerl_party1portraitFrame",
			party2 = "XPerl_party2portraitFrame",
			party3 = "XPerl_party3portraitFrame",
			party4 = "XPerl_party4portraitFrame",
		},
	},
	["Blizzard"] = {
		units = {
			player = "PlayerPortrait",
			pet = "PetPortrait",
			target = "TargetFramePortrait",
			focus = "FocusFramePortrait",
			party1 = "PartyMemberFrame1Portrait",
			party2 = "PartyMemberFrame2Portrait",
			party3 = "PartyMemberFrame3Portrait",
			party4 = "PartyMemberFrame4Portrait",
			arena1 = "ArenaEnemyFrame1ClassPortrait",
			arena2 = "ArenaEnemyFrame2ClassPortrait",
			arena3 = "ArenaEnemyFrame3ClassPortrait",
			arena4 = "ArenaEnemyFrame4ClassPortrait",
			arena5 = "ArenaEnemyFrame5ClassPortrait",
		},
	},
}

function BigDebuffs:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("BigDebuffsDB", defaults, true)

	-- Upgrade old database
	if type(self.db.profile.raidFrames.dispellable) == "number" then
		self.db.profile.raidFrames.dispellable = {
			cc = self.db.profile.raidFrames.dispellable,
			roots = self.db.profile.raidFrames.roots
		}
	end
	for i = 1, #units do
		local key = units[i]:gsub("%d", "")
		if type(self.db.profile.unitFrames[key]) == "boolean" then
			self.db.profile.unitFrames[key] = {
				enabled = self.db.profile.unitFrames[key],
				anchor = "auto",
			}
		end
	end

	self.db.RegisterCallback(self, "OnProfileChanged", "Refresh")
	self.db.RegisterCallback(self, "OnProfileCopied", "Refresh")
	self.db.RegisterCallback(self, "OnProfileReset", "Refresh")
	self.frames = {}
	self.UnitFrames = {}
	self:SetupOptions()
end

local function HideBigDebuffs(frame)
	if not frame.BigDebuffs then return end
	for i = 1, #frame.BigDebuffs do
		frame.BigDebuffs[i]:Hide()
	end
end

function BigDebuffs:Refresh()
	for frame, _ in pairs(self.frames) do
		if frame:IsVisible() then CompactUnitFrame_UpdateDebuffs(frame) end
		if frame and frame.BigDebuffs then self:AddBigDebuffs(frame) end
	end
	for unit, frame in pairs(self.UnitFrames) do
		frame:Hide()
		frame.current = nil
		frame.cooldown:SetHideCountdownNumbers(not self.db.profile.unitFrames.cooldownCount)
		frame.cooldown.noCooldownCount = not self.db.profile.unitFrames.cooldownCount
		self:UNIT_AURA(unit)
	end
end

function BigDebuffs:AttachUnitFrame(unit)
	if InCombatLockdown() then return end

	local frame = self.UnitFrames[unit]
	local frameName = "BigDebuffs" .. unit .. "UnitFrame"

	if not frame then
		frame = CreateFrame("Button", frameName, UIParent, "BigDebuffsUnitFrameTemplate")
		self.UnitFrames[unit] = frame
		frame:SetScript("OnEvent", function() self:UNIT_AURA(unit) end)
		frame.icon:SetDrawLayer("BORDER")
		frame:RegisterUnitEvent("UNIT_AURA", unit)
		frame:RegisterForDrag("LeftButton")
		frame:SetMovable(true)
		frame.unit = unit
	end

	frame:EnableMouse(self.test)

	_G[frameName.."Name"]:SetText(self.test and not frame.anchor and unit)

	frame.anchor = nil
	frame.blizzard = nil

	local config = self.db.profile.unitFrames[unit:gsub("%d", "")]

	if config.anchor == "auto" then
		-- Find a frame to attach to
		for k,v in pairs(anchors) do
			local anchor, parent, noPortait
			if v.units[unit] then
				if v.func then
					anchor, parent, noPortait = v.func(v.units[unit])
				else
					anchor = _G[v.units[unit]]
				end

				if anchor then
					frame.anchor, frame.parent, frame.noPortait = anchor, parent, noPortait
					if v.noPortait then frame.noPortait = true end
					frame.alignLeft = v.alignLeft
					frame.blizzard = k == "Blizzard"
					if not frame.blizzard then break end
				end
			end		
		end
	end

	if frame.anchor then
		if frame.blizzard then
			-- Blizzard Frame
			frame:SetParent(frame.anchor:GetParent())
			frame:SetFrameLevel(frame.anchor:GetParent():GetFrameLevel())
			frame.cooldown:SetFrameLevel(frame.anchor:GetParent():GetFrameLevel())
			frame.anchor:SetDrawLayer("BACKGROUND")
			frame.cooldown:SetSwipeTexture("Interface\\CHARACTERFRAME\\TempPortraitAlphaMaskSmall")
		else
			frame:SetParent(frame.parent and frame.parent or frame.anchor)
			frame:SetFrameLevel(99)
		end

		frame:ClearAllPoints()

		if frame.noPortait then
			-- No portrait, so attach to the side
			if frame.alignLeft then
				frame:SetPoint("TOPRIGHT", frame.anchor, "TOPLEFT")
			else
				frame:SetPoint("TOPLEFT", frame.anchor, "TOPRIGHT")
			end
			local height = frame.anchor:GetHeight()
			frame:SetSize(height, height)
		else
			frame:SetAllPoints(frame.anchor)
		end
	else
		-- Manual
		frame:SetParent(UIParent)
		frame:ClearAllPoints()

		if not self.db.profile.unitFrames[unit] then self.db.profile.unitFrames[unit] = {} end

		if self.db.profile.unitFrames[unit].position then
			frame:SetPoint(unpack(self.db.profile.unitFrames[unit].position))
		else
			-- No saved position, anchor to the blizzard position
			LoadAddOn("Blizzard_ArenaUI")
			local relativeFrame = _G[anchors.Blizzard.units[unit]] or UIParent
			frame:SetPoint("CENTER", relativeFrame, "CENTER")
		end
		
		frame:SetSize(config.size, config.size)
	end

end

function BigDebuffs:SaveUnitFramePosition(frame)
	self.db.profile.unitFrames[frame.unit].position = { frame:GetPoint() }
end

function BigDebuffs:Test()
	self.test = not self.test
	self:Refresh()
end

local TestDebuffs = {}

local function InsertTestDebuff(spellID, dispelType)
	local texture = GetSpellTexture(spellID)
	table.insert(TestDebuffs, { spellID, texture, 0, dispelType })
end

local function UnitDebuffTest(unit, index)
	local debuff = TestDebuffs[index]
	if not debuff then return end
	return "Test", nil, debuff[2], 0, debuff[4], 9, GetTime() + 9, nil, nil, nil, debuff[1]
end

function BigDebuffs:OnEnable()
	self:RegisterEvent("PLAYER_TALENT_UPDATE")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_FOCUS_CHANGED")
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("UNIT_PET")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:PLAYER_TALENT_UPDATE()

	-- Prevent OmniCC finish animations
	if OmniCC then
		self:RawHook(OmniCC, "TriggerEffect", function(object, cooldown)
			local name = cooldown:GetName()
			if name and name:find("BigDebuffs") then return end
			self.hooks[OmniCC].TriggerEffect(object, cooldown)
		end, true)
	end

	InsertTestDebuff(8122, "Magic") -- Psychic Scream
	InsertTestDebuff(408, nil) -- Kidney Shot
	InsertTestDebuff(30108, "Magic") -- Unstable Affliction
	InsertTestDebuff(339, "Magic") -- Entangling Roots
	InsertTestDebuff(114404, nil) -- Void Tendrils
	InsertTestDebuff(589, "Magic") -- Shadow Word: Pain
	InsertTestDebuff(772, nil) -- Rend

end

function BigDebuffs:PLAYER_ENTERING_WORLD()
	for i = 1, #units do
		self:AttachUnitFrame(units[i])
	end
end

local MAX_BUFFS = 6

function BigDebuffs:AddBigDebuffs(frame)
	if not frame or not frame.displayedUnit or not UnitIsPlayer(frame.displayedUnit) then return end
	local frameName = frame:GetName()
	if self.db.profile.raidFrames.increaseBuffs then
		for i = 4, MAX_BUFFS do
			local buffPrefix = frameName .. "Buff"
			local buffFrame = _G[buffPrefix .. i] or CreateFrame("Button", buffPrefix .. i, frame, "CompactBuffTemplate")
			buffFrame:ClearAllPoints()
			if math.fmod(i - 1, 3) == 0 then
				buffFrame:SetPoint("BOTTOMRIGHT", _G[buffPrefix .. i - 3], "TOPRIGHT")
			else
				buffFrame:SetPoint("BOTTOMRIGHT", _G[buffPrefix .. i - 1], "BOTTOMLEFT")
			end
		end
	end

	frame.BigDebuffs = frame.BigDebuffs or {}
	local max = self.db.profile.raidFrames.maxDebuffs + 1 -- add a frame for warning debuffs
	for i = 1, max do
		local big = frame.BigDebuffs[i] or
			CreateFrame("Button", frameName .. "BigDebuffsRaid" .. i, frame, "CompactDebuffTemplate")
		big:ClearAllPoints()
		if i > 1 then
			if self.db.profile.raidFrames.anchor == "INNER" then
				big:SetPoint("BOTTOMLEFT", frame.BigDebuffs[i-1], "BOTTOMRIGHT", 0, 0)
			elseif self.db.profile.raidFrames.anchor == "LEFT" then
				big:SetPoint("BOTTOMRIGHT", frame.BigDebuffs[i-1], "BOTTOMLEFT", 0, 0)
			elseif self.db.profile.raidFrames.anchor == "RIGHT" then
				big:SetPoint("BOTTOMLEFT", frame.BigDebuffs[i-1], "BOTTOMRIGHT", 0, 0)
			end
		else
			if self.db.profile.raidFrames.anchor == "INNER" then
				big:SetPoint("BOTTOMLEFT", frame.debuffFrames[1], "BOTTOMLEFT", 0, 0)
			elseif self.db.profile.raidFrames.anchor == "LEFT" then
				big:SetPoint("BOTTOMRIGHT", frame, "BOTTOMLEFT", 0, 1)
			elseif self.db.profile.raidFrames.anchor == "RIGHT" then
				big:SetPoint("BOTTOMLEFT", frame, "BOTTOMRIGHT", 0, 1)
			end
		end

		big.cooldown:SetHideCountdownNumbers(not self.db.profile.raidFrames.cooldownCount)
		big.cooldown.noCooldownCount = not self.db.profile.raidFrames.cooldownCount

		big.cooldown:SetDrawEdge(false)
		frame.BigDebuffs[i] = big
		big:Hide()
		self.frames[frame] = true
		self:ShowBigDebuffs(frame)
	end
	return true
end

local pending = {}

hooksecurefunc("CompactUnitFrame_UpdateAll", function(frame)
	local name = frame:GetName()
	if not name or not name:match("^Compact") then return end
	if InCombatLockdown() and not frame.BigDebuffs then
		if not pending[frame] then pending[frame] = true end
	else
		BigDebuffs:AddBigDebuffs(frame)
	end
end)

function BigDebuffs:PLAYER_TALENT_UPDATE()
	local specID = GetSpecializationInfo(GetSpecialization() or 1)
	self.specDispel = specID and specDispel[specID] and specDispel[specID]
end

function BigDebuffs:PLAYER_REGEN_ENABLED()
	for frame,_ in pairs(pending) do
		BigDebuffs:AddBigDebuffs(frame)
		pending[frame] = nil
	end
end

local function IsPriorityDebuff(id)
	for i = 1, #BigDebuffs.PriorityDebuffs do
		if id == BigDebuffs.PriorityDebuffs[i] then
			return true
		end
	end
end

hooksecurefunc("CompactUnitFrame_HideAllDebuffs", HideBigDebuffs)

function BigDebuffs:IsDispellable(dispelType)
	if not dispelType or not self.specDispel then return end
	if type(self.specDispel[dispelType]) == "function" then return self.specDispel[dispelType]() end
	return self.specDispel[dispelType]
end

function BigDebuffs:GetDebuffSize(id, dispellable)
	if self.db.profile.raidFrames.pve > 0 then
		local _, instanceType = IsInInstance()
		if dispellable and instanceType and (instanceType == "raid" or instanceType == "party") then
			return self.db.profile.raidFrames.pve
		end
	end
	
	if not self.Spells[id] then return end
	id = self.Spells[id].parent or id -- Check for parent spellID

	local category = self.Spells[id].type

	if not category or not self.db.profile.raidFrames[category] then return end

	-- Check for user set
	if self.db.profile.spells[id] then
		if self.db.profile.spells[id].raidFrames and self.db.profile.spells[id].raidFrames == 0 then return end
		if self.db.profile.spells[id].size then return self.db.profile.spells[id].size end
	end

	if self.Spells[id].noraidFrames and (not self.db.profile.spells[id] or not self.db.profile.spells[id].raidFrames) then
		return
	end

	local dispellableSize = self.db.profile.raidFrames.dispellable[category]
	if dispellable and dispellableSize and dispellableSize > 0 then return dispellableSize end

	if self.db.profile.raidFrames[category] > 0 then
		return self.db.profile.raidFrames[category]
	end
end

-- For raid frames
function BigDebuffs:GetDebuffPriority(id)
	if not self.Spells[id] then return 0 end
	id = self.Spells[id].parent or id -- Check for parent spellID
	
	return self.db.profile.spells[id] and self.db.profile.spells[id].priority or
		self.db.profile.priority[self.Spells[id].type] or 0
end

-- For unit frames
function BigDebuffs:GetAuraPriority(id)
	if not self.Spells[id] then return end
	id = self.Spells[id].parent or id -- Check for parent spellID
    if not self.Spells[id] then return end
	
	-- Make sure category is enabled
	if not self.db.profile.unitFrames[self.Spells[id].type] then return end

	-- Check for user set
	if self.db.profile.spells[id] then
		if self.db.profile.spells[id].unitFrames and self.db.profile.spells[id].unitFrames == 0 then return end
		if self.db.profile.spells[id].priority then return self.db.profile.spells[id].priority end
	end

	if self.Spells[id].nounitFrames and (not self.db.profile.spells[id] or not self.db.profile.spells[id].unitFrames) then
		return
	end

	return self.db.profile.priority[self.Spells[id].type] or 0
end

-- Copy this function to check for testing mode
local function CompactUnitFrame_UtilSetDebuff(debuffFrame, unit, index, filter, isBossAura, isBossBuff, test)
	local UnitDebuff = test and UnitDebuffTest or UnitDebuff
    -- make sure you are using the correct index here!
    --isBossAura says make this look large.
    --isBossBuff looks in HELPFULL auras otherwise it looks in HARMFULL ones
    local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, canStealOrPurge, shouldConsolidate, spellId;
    if (isBossBuff) then
        name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, canStealOrPurge, shouldConsolidate, spellId = UnitBuff(unit, index, filter);
    else
        name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, canStealOrPurge, shouldConsolidate, spellId = UnitDebuff(unit, index, filter);
    end
    debuffFrame.filter = filter;
    debuffFrame.icon:SetTexture(icon);
    if ( count > 1 ) then
        local countText = count;
        if ( count >= 10 ) then
            countText = BUFF_STACKS_OVERFLOW;
        end
        debuffFrame.count:Show();
        debuffFrame.count:SetText(countText);
    else
        debuffFrame.count:Hide();
    end
    debuffFrame:SetID(index);
    if ( expirationTime and expirationTime ~= 0 ) then
        local startTime = expirationTime - duration;
        debuffFrame.cooldown:SetCooldown(startTime, duration);
        debuffFrame.cooldown:Show();
    else
        debuffFrame.cooldown:Hide();
    end
     
    local color = DebuffTypeColor[debuffType] or DebuffTypeColor["none"];
    debuffFrame.border:SetVertexColor(color.r, color.g, color.b);
 
    debuffFrame.isBossBuff = isBossBuff;
    if ( isBossAura ) then
        debuffFrame:SetSize(debuffFrame.baseSize + BOSS_DEBUFF_SIZE_INCREASE, debuffFrame.baseSize + BOSS_DEBUFF_SIZE_INCREASE);
    else
        debuffFrame:SetSize(debuffFrame.baseSize, debuffFrame.baseSize);
    end
     
    debuffFrame:Show();
end

function BigDebuffs:ShowBigDebuffs(frame)

	if not self.db.profile.raidFrames.enabled or not frame.debuffFrames or not frame.BigDebuffs then return end

	if not UnitIsPlayer(frame.displayedUnit) then
		return
	end	

	local UnitDebuff = self.test and UnitDebuffTest or UnitDebuff

	HideBigDebuffs(frame)

	local debuffs = {}
	local big
	local now = GetTime()
	local warning, warningId

	for i = 1, 40 do
		local _,_,_,_, dispelType, _, time, caster, _,_, id = UnitDebuff(frame.displayedUnit, i)
		if id then
			local reaction = caster and UnitReaction("player", caster) or 0
			local friendlySmokeBomb = id == 212183 and reaction > 4
			local size = self:GetDebuffSize(id, self:IsDispellable(dispelType))
			if size and not friendlySmokeBomb then
				big = true
				local duration = time and time - now or 0
				tinsert(debuffs, { i, size, duration, self:GetDebuffPriority(id) })
			elseif self.db.profile.raidFrames.redirectBliz or
			(self.db.profile.raidFrames.anchor == "INNER" and not self.db.profile.raidFrames.hideBliz) then
				if not frame.optionTable.displayOnlyDispellableDebuffs or self:IsDispellable(dispelType) then
					tinsert(debuffs, { i, self.db.profile.raidFrames.default, 0, 0 }) -- duration 0 to preserve Blizzard order
				end
			end

			-- Set warning debuff
			local k
			for j = 1, #self.WarningDebuffs do
				if id == self.WarningDebuffs[j] and
				self.db.profile.raidFrames.warningList[id] and
				not friendlySmokeBomb and
				(not k or j < k) then
					k = j
					warning = i
					warningId = id
				end
			end
		end
	end

	if #debuffs > 0 then
		-- insert the warning debuff if it exists and we have a big debuff
		if big and warning then
			local size = self.db.profile.raidFrames.warning
			-- remove duplicate
			for k,v in pairs(debuffs) do
				if v[1] == warning then
					if self.Spells[warningId] then size = v[2] end -- preserve the size
					table.remove(debuffs, k)
					break
				end
			end
			tinsert(debuffs, { warning, size, 0, 0, true })
		else
			warning = nil
		end

		-- sort by priority > size > duration > index
		table.sort(debuffs, function(a, b)
			if a[4] == b[4] then
				if a[2] == b[2] then
					if a[3] < b[3] then return true end
					if a[3] == b[3] then return a[1] < b[1] end
				end
				return a[2] > b[2]
			end
			return a[4] > b[4]
		end)

		local index = 1

		if self.db.profile.raidFrames.hideBliz or
		self.db.profile.raidFrames.anchor == "INNER" or
		self.db.profile.raidFrames.redirectBliz then
			CompactUnitFrame_HideAllDebuffs(frame)
		end

		for i = 1, #debuffs do
			if index <= self.db.profile.raidFrames.maxDebuffs or debuffs[i][1] == warning then
				if not frame.BigDebuffs[index] then break end
				frame.BigDebuffs[index].baseSize = frame:GetHeight() * debuffs[i][2] * 0.01
				CompactUnitFrame_UtilSetDebuff(frame.BigDebuffs[index], frame.displayedUnit, debuffs[i][1], nil, false, false, self.test)
				frame.BigDebuffs[index].cooldown:SetSwipeColor(0, 0, 0, 0.7)
				index = index + 1
			end
		end

	end

end

-- We need to copy the entire function to avoid taint
hooksecurefunc("CompactUnitFrame_UpdateDebuffs", function(frame)
	if not UnitIsPlayer(frame.displayedUnit) then
		return
	end	

	if ( not frame.optionTable.displayDebuffs ) then
		CompactUnitFrame_HideAllDebuffs(frame);
		return;
	end
	local test = BigDebuffs.test
	local UnitDebuff = test and UnitDebuffTest or UnitDebuff
	local index = 1;
	local frameNum = 1;
	local filter = nil;
	local maxDebuffs = frame.maxDebuffs;
	--Show both Boss buffs & debuffs in the debuff location
	--First, we go through all the debuffs looking for any boss flagged ones.
	while ( frameNum <= maxDebuffs ) do
		local debuffName = UnitDebuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, false) ) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, true, false, test);
				frameNum = frameNum + 1;
				--Boss debuffs are about twice as big as normal debuffs, so display one less.
				local bossDebuffScale = (debuffFrame.baseSize + BOSS_DEBUFF_SIZE_INCREASE)/debuffFrame.baseSize
				maxDebuffs = maxDebuffs - (bossDebuffScale - 1);
			end
		else
			break;
		end
		index = index + 1;
	end
	--Then we go through all the buffs looking for any boss flagged ones.
	index = 1;
	while ( frameNum <= maxDebuffs ) do
		local debuffName = UnitBuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, true) ) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, true, true, test);
				frameNum = frameNum + 1;
				--Boss debuffs are about twice as big as normal debuffs, so display one less.
				local bossDebuffScale = (debuffFrame.baseSize + BOSS_DEBUFF_SIZE_INCREASE)/debuffFrame.baseSize
				maxDebuffs = maxDebuffs - (bossDebuffScale - 1);
			end
		else
			break;
		end
		index = index + 1;
	end
	
	--Now we go through the debuffs with a priority (e.g. Weakened Soul and Forbearance)
	index = 1;
	while ( frameNum <= maxDebuffs ) do
		local debuffName, _,_,_,_,_,_,_,_,_, id = UnitDebuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if ( CompactUnitFrame_UtilIsPriorityDebuff(frame.displayedUnit, index, filter) or IsPriorityDebuff(id)) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, false, false, test);
				frameNum = frameNum + 1;
			end
		else
			break;
		end
		index = index + 1;
	end
	
	if ( frame.optionTable.displayOnlyDispellableDebuffs ) then
		filter = "RAID";
	end
	
	index = 1;
	--Now, we display all normal debuffs.
	if ( frame.optionTable.displayNonBossDebuffs ) then
	while ( frameNum <= maxDebuffs ) do
		local debuffName, _,_,_,_,_,_,_,_,_, id = UnitDebuff(frame.displayedUnit, index, filter);
		if ( debuffName ) then
			if BigDebuffs.test or (( CompactUnitFrame_UtilShouldDisplayDebuff(frame.displayedUnit, index, filter) and not CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, false) and
				not CompactUnitFrame_UtilIsPriorityDebuff(frame.displayedUnit, index, filter) and not IsPriorityDebuff(id))) then
				local debuffFrame = frame.debuffFrames[frameNum];
				CompactUnitFrame_UtilSetDebuff(debuffFrame, frame.displayedUnit, index, filter, false, false, test);
				frameNum = frameNum + 1;
			end
		else
			break;
		end
		index = index + 1;
	end
	end
	
	for i=frameNum, frame.maxDebuffs do
		local debuffFrame = frame.debuffFrames[i];
		debuffFrame:Hide();
	end

	BigDebuffs:ShowBigDebuffs(frame)
end)

function BigDebuffs:IsPriorityBigDebuff(id)
	if not self.Spells[id] then return end
	id = self.Spells[id].parent or id -- Check for parent spellID
	return self.Spells[id].priority
end

function BigDebuffs:UNIT_AURA(unit)
	if not self.db.profile.unitFrames.enabled or not self.db.profile.unitFrames[unit:gsub("%d", "")].enabled then return end

	self:AttachUnitFrame(unit)

	local frame = self.UnitFrames[unit]
	if not frame then return end

	local UnitDebuff = BigDebuffs.test and UnitDebuffTest or UnitDebuff

	local now = GetTime()
	local left, priority, duration, expires, icon, debuff, buff = 0, 0

	for i = 1, 40 do
		-- Check debuffs
		local _,_, n, _,_, d, e, caster, _,_, id = UnitDebuff(unit, i)
		if id then
			if self.Spells[id] then
				local reaction = caster and UnitReaction("player", caster) or 0
				local friendlySmokeBomb = id == 212183 and reaction > 4
				local p = self:GetAuraPriority(id)
				if p and p >= priority and not friendlySmokeBomb then
					if p > priority or self:IsPriorityBigDebuff(id) or e == 0 or e - now > left then
						left = e - now
						duration = d
						debuff = i
						priority = p
						expires = e
						icon = n
					end
				end
			end
		end

		-- Check buffs
		local _,_, n, _,_, d, e, _,_,_, id = UnitBuff(unit, i)
		if id then
			if self.Spells[id] then
				local p = self:GetAuraPriority(id)
				if p and p >= priority then
					if p > priority or self:IsPriorityBigDebuff(id) or e == 0 or e - now > left then
						left = e - now
						duration = d
						debuff = i
						priority = p
						expires = e
						icon = n
						buff = true
					end
				end
			end
		end
	end

	if debuff then
		if duration < 1 then duration = 1 end -- auras like Solar Beam don't have a duration

		if frame.current ~= icon then
			if frame.blizzard then
				-- Blizzard Frame
				SetPortraitToTexture(frame.icon, icon)

				-- Adapt
				if frame.anchor and Adapt and Adapt.portraits[frame.anchor] then
					Adapt.portraits[frame.anchor].modelLayer:SetFrameStrata("BACKGROUND")
				end
			else
				frame.icon:SetTexture(icon)
			end
		end
		
		frame.cooldown:SetCooldown(expires - duration, duration)
		frame:Show()
		frame.cooldown:SetSwipeColor(0, 0, 0, 0.6)

		-- set for tooltips
		frame:SetID(debuff)
		frame.buff = buff

		frame.current = icon
        if GridStatusBigDebuffs then GridStatusBigDebuffs:SendGained(unit, icon, expires, duration) end
	else
		-- Adapt
		if frame.anchor and frame.blizzard and Adapt and Adapt.portraits[frame.anchor] then
			Adapt.portraits[frame.anchor].modelLayer:SetFrameStrata("LOW")
		end

		frame:Hide()
		frame.current = nil
        if GridStatusBigDebuffs then GridStatusBigDebuffs:SendLost(unit) end
	end
end

function BigDebuffs:PLAYER_FOCUS_CHANGED()
	self:UNIT_AURA("focus")
end

function BigDebuffs:PLAYER_TARGET_CHANGED()
	self:UNIT_AURA("target")
end

function BigDebuffs:UNIT_PET()
	self:UNIT_AURA("pet")
end

-- Show extra buffs
-- Setting frame.maxBuffs causes taint, so we need to copy entire function (FrameXML/CompactUnitFrame.lua)
hooksecurefunc("CompactUnitFrame_UpdateBuffs", function(frame)

	if not UnitIsPlayer(frame.displayedUnit) then
		return
	end	
	
	if not BigDebuffs.db.profile.raidFrames.increaseBuffs then return end

	if ( not frame.optionTable.displayBuffs ) then
		CompactUnitFrame_HideAllBuffs(frame);
		return;
	end
	
	local index = 1;
	local frameNum = 1;
	local filter = nil;
	while ( frameNum <= MAX_BUFFS ) do
		local buffName = UnitBuff(frame.displayedUnit, index, filter);
		if ( buffName ) then
			if ( CompactUnitFrame_UtilShouldDisplayBuff(frame.displayedUnit, index, filter) and not CompactUnitFrame_UtilIsBossAura(frame.displayedUnit, index, filter, true) ) then
				local buffFrame = frame.buffFrames[frameNum];
				if buffFrame then CompactUnitFrame_UtilSetBuff(buffFrame, frame.displayedUnit, index, filter); end
				frameNum = frameNum + 1;
			end
		else
			break;
		end
		index = index + 1;
	end
	for i=frameNum, MAX_BUFFS do
		local buffFrame = frame.buffFrames[i];
		if buffFrame then buffFrame:Hide() end
	end
end)

SLASH_BigDebuffs1 = "/bd"
SLASH_BigDebuffs2 = "/bigdebuffs"
SlashCmdList.BigDebuffs = function(msg)
	InterfaceOptionsFrame_OpenToCategory("BigDebuffs")
	InterfaceOptionsFrame_OpenToCategory("BigDebuffs")
end
