--[[
*********************************************************
-- NPCMark Database (Traditional Chinese)
-- Currently Maintained by 静谧的狼狈 @ 2016/08/18
*********************************************************
-- Format
1.拍賣師 Auctioneer

2.銀行職員 Banker

3.飛行管理員 Flight Master
蝙蝠Bat, 龍鷹Dragonhawk, 獅鷲Gryphon, 角鷹獸Hippogryph, 雙足飛龍Wind Rider, etc.

4.旅館老闆 Innkeeper

5.獸欄管理員 Stable Master

6.專業訓練師
煉金術Alchemy
考古學Archaeology
鍛造Blacksmithing
烹飪Cooking
附魔Enchanting
工程學Engineering
急救First Aid
釣魚Fishing,
飛行Flying
草藥學Herbalism
銘文學Inscription
珠寶設計Jewelcrafting
制皮Leatherworking
採礦Mining
騎術Riding
剝皮Skinning
裁縫Tailoring
惡魔Demon
傳送門Portal

7.職業訓練師
死亡騎士Death Knight
惡魔獵手Demon Hunter
德魯伊Druid
獵人Hunter
法師Mage
武僧Monk
聖騎士Paladin
牧師Priest
盜賊Rogue
薩滿Shaman
術士Warlock
戰士Warrior

8.商人
Vendor, Trader, Quartermaster, Supply Officer, Gladiator, etc.

9.其他NPC
公會管理員Guild Masters, 美容師Barber, 秘法重鑄師Arcane Reforger, etc.

10.訓練假人 Dummy
--]]

if GetLocale() == 'zhTW' then
	MapPlusNodeData = {
	-- 主要城市 Major Cities
		-- Darnassus
		["達納蘇斯"]={
		-- 拍賣師
			{"拍賣師", "拍賣師圖爾倫",{54.9,57.6}}, -- 8669
			{"拍賣師", "拍賣師戈洛薩斯",{54.8,58.2}}, -- 8723
			{"拍賣師", "拍賣師塞爾瓦拉斯",{55,58}}, -- 15678
			{"拍賣師", "拍賣師卡劄雷茲",{54.4,58.1}}, -- 15679
		-- 銀行職員
			{"銀行職員", "伊迪瑞娜",{43.4,51.3}}, -- 4155
			{"銀行職員", "萊恩",{43.6,50.6}}, -- 4208
			{"銀行職員", "加瑞斯",{43.6,51.0}}, -- 4209
		-- 飛行管理員
			{"角鷹獸管理員", "利奧拉",{36.2,47.8}}, -- 40552
		-- 旅館老闆
			{"旅館老闆", "旅館老闆塞琳尼",{62.4,32.8}}, -- 6735
			{"旅館老闆", "格溫•阿姆斯特",{48.2,14.6}}, -- 48735
		-- 獸欄管理員
			{"獸欄管理員", "阿拉辛",{43.2,29.0}}, -- 10056
		-- 專業訓練師
			{"煉金術訓練師", "安尼希爾",{54.0,38.6}}, -- 4160
			{"考古學訓練師", "隱世者漢蒙",{42.6,83.3}}, -- 47569
			{"鍛造訓練師", "羅爾夫•卡爾尼爾",{56.8,52.8}}, --52640
			{"烹飪訓練師", "阿雷貢",{49.4,36.7}}, -- 4210
			{"附魔訓練師", "塔蘭丹",{56.6,31.6}}, -- 4213
			{"工程學訓練師", "塔娜•倫特尼爾",{49.6,32.6}}, --52636
			{"急救訓練師", "丹納羅爾",{51.6,30.6}}, -- 4211
			{"釣魚訓練師", "阿斯坦婭",{49.0,61.0}}, -- 4156
			{"草藥學訓練師", "菲羅迪恩•喚月",{49.0,69.0}}, -- 4204
			{"銘文學訓練師", "芬迪•達金",{56.4,32.3}}, -- 30715
			{"珠寶設計訓練師", "艾莎•銀露",{54.2,30.4}}, --52645
			{"制皮訓練師", "泰龍尼斯",{60.6,36.4}}, -- 4212
			{"採礦訓練師", "工頭佩爾尼奇",{50.6,33.8}}, --52642
			{"騎術訓練師", "賈薩姆",{42.7,33.0}}, -- 4753
			{"剝皮訓練師", "艾拉迪爾",{60.2,37.0}}, -- 6292
			{"裁縫訓練師", "邁裡恩",{59.6,37.2}}, -- 4159
			{"傳送門訓練師", "埃麗莎•杜馬斯",{43.4,78.3}}, -- 4165
		-- 職業訓練師
			{"德魯伊訓練師", "瑪斯雷•馭熊者",{40.5,27.8}}, -- 4217
			{"德魯伊訓練師", "德納薩里安",{40.2,28.0}}, -- 4218
			{"德魯伊訓練師", "菲勒裡亞•夜翼",{39.6,28.4}}, -- 4219
			{"德魯伊訓練師", "萊羅斯•疾風",{49.6,17.0}}, -- 50505
			{"德魯伊訓練師", "野性泰爾蘭",{50.6,17.9}}, -- 50506
			{"德魯伊訓練師", "法珊德拉•暴風爪",{49.6,17.2}}, -- 50507
			{"獵人訓練師", "吉恩拉",{43.5,25.8}}, -- 4138
			{"獵人訓練師", "祖卡斯特",{43.8,28.0}}, -- 4146
			{"獵人訓練師", "多利安",{45.2,27.8}}, -- 4205
			{"獵人訓練師", "獵手佈雷克",{48.7,18.4}}, -- 50497
			{"法師訓練師", "米莉安•喚法者",{49.7,15.4}}, -- 50499
			{"法師訓練師", "塔勒維爾",{37.7,80.0}}, -- 50690
			{"法師訓練師", "戴爾娜拉",{37.5,80.4}}, -- 50714
			{"法師訓練師", "瑪伊里爾",{37.6,80.2}}, -- 50715
			{"武僧訓練師", "茶道大師蘭風",{47.6,60.0}}, --62450
			{"聖騎士訓練師", "魯庫阿",{43.6,78.6}}, -- 35281
			{"牧師訓練師", "阿斯塔利•逐星",{43.2,77.4}}, -- 4090
			{"牧師訓練師", "賈德莉亞",{42.6,78.6}}, -- 4091
			{"牧師訓練師", "拉瑞亞",{43.8,82.6}}, -- 4092
			{"牧師訓練師", "女祭司阿蘭希雅",{43.4,79.4}}, -- 11401
			{"牧師訓練師", "艾爾米拉修女",{48.2,17.6}}, -- 50501
			{"盜賊訓練師", "塞尤娜",{41.6,37.1}}, -- 4163
			{"盜賊訓練師", "艾里安•影語",{40.0,39.7}}, -- 4214
			{"盜賊訓練師", "安妮莎爾",{42.8,36.4}}, -- 4215
			{"盜賊訓練師", "俠盜蘿倫",{47.4,15.4}}, -- 50498
			{"薩滿訓練師", "德羅哈",{43.8,78.8}}, --52292
			{"術士訓練師", "維圖斯•暗行者",{49.8,16.7}}, -- 50502
			{"戰士訓練師", "阿雷亞斯塔•刃歌",{56.6,46.2}}, -- 4087
			{"戰士訓練師", "希達奈爾",{58.4,50.2}}, -- 4089
			{"戰士訓練師", "達納斯•刃歌",{56.6,46.6}}, -- 7315
			{"戰士訓練師", "克利希中士",{48.4,18.1}}, -- 50500
		-- 商人
			--{"達納蘇斯軍需官", "月之女祭司娜薩拉",{36.6,49.0}}, -- 50305
			--{"吉爾尼斯軍需官", "坎德雷勳爵",{37.0,47.8}}, -- 50307
			{"軍需官", "達納蘇斯;吉爾尼斯",{36.6,49.0}}, -- 50305/50307
		-- 其他NPC
			{"公會註冊員", "琳沙娜",{64.6,37.6}}, -- 4161
		-- 訓練假人
			{"訓練假人", "訓練假人",{60.6,47.2}}, -- 31144
			{"訓練假人", "團隊副本訓練假人",{60.8,53.2}}, -- 31146
			{"訓練假人", "訓練假人",{61.2,45.0}}, -- 32666
			{"訓練假人", "訓練假人",{61.4,54.6}}, -- 32667
		-- 交通工具
			{"傳送門", "魯瑟蘭村-泰達希爾",{37.4,50.4}},
			{"傳送門", "地獄火半島;埃索達",{44.0,78.5}},
		},

		-- Ironforge
		["鐵爐堡"]={
		-- 拍賣師
			{"拍賣師", "拍賣師巴克爾",{23.8,72.0}}, -- 8671
			{"拍賣師", "拍賣師雷姆斯",{24.2,74.4}}, -- 8720
			{"拍賣師", "拍賣師林姆克",{25.8,75.2}}, -- 9859
		-- 銀行職員
			{"銀行職員", "巴納姆•石衣",{34.6,59.0}}, -- 2460
			{"銀行職員", "拜雷•石衣",{35.4,60.6}}, -- 2461
			{"銀行職員", "索雷爾•石衣",{36.4,62.2}}, -- 5099
		-- 飛行管理員
			{"獅鷲管理員", "格萊斯•瑟登",{55.0,48.4}}, -- 1573
		-- 旅館老闆
			{"旅館老闆", "旅館老闆洛雷•火酒",{18.6,51.4}}, -- 5111
		-- 獸欄管理員
			{"獸欄管理員", "烏佈雷克•火拳",{69.4,84.0}}, -- 9984
		-- 專業訓練師
			{"煉金術訓練師", "塔雷•漿泡",{66.6,55.0}}, -- 5177
			{"考古學訓練師", "學者教授鐵褲",{75.4,11.2}}, -- 39718
			{"鍛造訓練師", "本古斯•深爐",{52.2,41.4}}, -- 4258
			{"鍛造訓練師", "格魯努斯•削鋼",{50.2,42.8}}, -- 5164
			{"鍛造訓練師", "埃隆努斯•冷鋼",{50.4,43.0}}, -- 11146
			{"烹飪訓練師", "達瑞爾•瑞克努索",{60.1,36.4}}, -- 5159
			{"附魔訓練師", "吉布•草須",{60.4,45.4}}, -- 5157
			{"工程學訓練師", "賓斯匹德",{68.4,44.2}}, -- 5174
			{"工程學訓練師", "工匠大師歐沃斯巴克",{69.8,50.2}}, -- 7944
			{"急救訓練師", "尼莎•火石",{54.8,58.6}}, -- 5150
			{"釣魚訓練師", "格瑞諾爾•石印",{48.4,8.2}}, -- 5161
			{"草藥學訓練師", "雷納•石枝",{55.6,58.8}}, -- 5137
			{"銘文學訓練師", "艾莉絲•布萊裡特",{60.6,44.8}}, -- 30717
			{"珠寶設計訓練師", "哈尼爾•堅石",{50.4,26.2}}, --52586
			{"制皮訓練師", "費布•鋼軸",{40.4,32.4}}, -- 5127
			{"採礦訓練師", "吉爾弗拉姆•石趾",{50.6,27.6}}, -- 4254
			{"剝皮訓練師", "巴爾薩斯•裂石",{39.2,31.8}}, -- 6291
			{"裁縫訓練師", "約莫德•石眉",{43.2,28.8}}, -- 5153
			{"惡魔訓練師", "尋屍者祖貝爾",{53.2,7.4}}, --6382
			{"傳送門訓練師", "貝爾斯塔弗•風暴之眼",{25.4,7.4}}, -- 2489
		-- 職業訓練師
			{"獵人訓練師", "戴拉•銳矛",{71.0,90.6}}, -- 5115
			{"獵人訓練師", "奧爾明•燃須",{70.9,83.6}}, -- 5116
			{"獵人訓練師", "雷格努斯•雷石",{69.9,82.9}}, -- 5117
			{"法師訓練師", "彬克",{26.2,7.3}}, -- 5144
			{"法師訓練師", "朱莉•雷線",{26.6,7.8}}, -- 5145
			{"法師訓練師", "尼特布林•火花",{27.0,6.8}}, -- 5146
			{"法師訓練師", "丁克",{27.0,8.4}}, -- 7312
			{"法師訓練師", "炎術師灼酒",{24.3,10.3}}, -- 50716
			{"法師訓練師", "菲拉娜•火舌",{24.3,11.6}}, -- 50717
			{"法師訓練師", "萊恩達•金石",{24.4,11.4}}, -- 50720
			{"武僧訓練師", "千杯不醉劉伶",{19.6,52.8}}, --62425
			{"聖騎士訓練師", "瓦爾加•高爐",{22.6,5.7}}, -- 5147
			{"聖騎士訓練師", "貝爾杜克•凝眉",{24.6,5.6}}, -- 5148
			{"聖騎士訓練師", "布蘭度爾•鐵錘",{23.4,6.2}}, -- 5149
			{"牧師訓練師", "塞歐杜斯•霜須",{23.2,8.3}}, -- 5141
			{"牧師訓練師", "布萊納•火崖",{24.8,8.0}}, -- 5142
			{"牧師訓練師", "陶德雷•鐵礦",{25.8,9.4}}, -- 5143
			{"牧師訓練師", "高階牧師洛漢",{26.8,7.8}}, -- 11406
			{"盜賊訓練師", "霍夫丹•黑須",{51.8,14.0}}, -- 5165
			{"盜賊訓練師", "奧米爾•火眼",{52.0,14.0}}, -- 5166
			{"盜賊訓練師", "芬斯維克",{51.0,14.8}}, -- 5167
			{"薩滿訓練師", "先知亞瓦德",{55.2,29.0}}, -- 23127
			{"術士訓練師", "瑟斯哈特",{50.2,7.7}}, -- 5171
			{"術士訓練師", "布瑞爾索恩",{50.2,7.0}}, -- 5172
			{"術士訓練師", "亞歷山大•考德爾",{50.2,6.9}}, -- 5173
			{"術士訓練師", "克裡奇•岩刃",{50.6,6.8}}, -- 50723
			{"術士訓練師", "巫婆達爾芭",{50.2,6.0}}, -- 50729
			{"術士訓練師", "拉恩•深洞",{50.1,6.6}}, -- 50732
			{"戰士訓練師", "克斯塔姆•碎石",{67.0,88.9}}, -- 1901
			{"戰士訓練師", "凱夫•重錘",{69.2,91.4}}, -- 5113
			{"戰士訓練師", "比爾班•飛鉗",{66.8,87.4}}, -- 5114
		-- 商人
			{"傳家寶商人", "克羅姆•粗臂",{74.6,9.8}}, -- 6294
			--{"諾莫瑞根軍需官", "工匠大師崔尼",{55.4,48.0}}, -- 50308
			--{"鐵爐堡軍需官", "石盔上尉",{55.8,47.8}}, -- 50309
			{"軍需官", "鐵爐堡;諾莫瑞根",{55.8,47.8}}, -- 50308/50309
		-- 其他NPC
			{"公會註冊員", "喬多•鋼眉",{36.6,84.6}}, -- 5130
			{"美容師", "貝拉•布拉魯斯",{26.1,49.5}}, -- 29141
		-- 訓練假人
			{"訓練假人", "訓練假人",{55.4,66.6}}, -- ?
			{"訓練假人", "團隊副本訓練假人",{55.4,66.6}}, -- ?
		-- 交通工具
			{"傳送門", "地獄火半島",{27.2,7.0}},
			{"地鐵", "暴風城;比茲莫搏擊俱樂部",{72.6,50.2}},
		},

		-- Stormwind City
		["暴風城"]={
		-- 拍賣師
			{"拍賣師", "拍賣師希爾頓",{60.8,71.0}}, -- 8670
			{"拍賣師", "拍賣師費奇",{61.2,70.8}}, -- 8719
			{"拍賣師", "拍賣師亞克森",{61.4,70.6}}, -- 15659
			{"拍賣師", "拍賣師何塞",{60.2,32.4}}, -- 43690
			{"拍賣師", "拍賣師勞菲爾",{60.2,32.0}}, -- 43841
			{"拍賣師", "拍賣師菲格拉德",{60.2,31.8}}, -- 43842
		-- 銀行職員
			{"銀行職員", "奧利維亞•伯恩賽德",{62.7,78.4}}, -- 2455
			{"銀行職員", "牛頓•伯恩賽德",{62.6,78.0}}, -- 2456
			{"銀行職員", "約翰•伯恩賽德",{62.4,78.2}}, -- 2457
			{"銀行職員", "克莉斯丁•卡紮雷茲",{63.3,79.4}}, -- 43692
			{"銀行職員", "賈敏•克雷斯特",{64.8,29.2}}, -- 43723
			{"銀行職員", "李•克雷斯特",{65.1,28.3}}, -- 43724
			{"銀行職員", "科提斯•克雷斯特",{65.3,28.0}}, -- 43725
			{"銀行職員", "柯爾斯蒂•韋斯特米爾",{63.0,77.7}}, -- 43819
			{"銀行職員", "斯科特•韋斯特米爾",{63.1,78.7}}, -- 43820
			{"銀行職員", "湯瑪斯•韋斯特米爾",{63.3,78.4}}, -- 43822
			{"銀行職員", "萊斯莉•韋恩懷特",{64.3,29.0}}, -- 43823
			{"銀行職員", "安•韋恩懷特",{64.4,28.6}}, -- 43824
			{"銀行職員", "沃倫•韋恩懷特",{64.9,27.7}}, -- 43825
			{"銀行職員", "費裡亞斯•G•班克沃斯",{65.6,27.6}}, -- 43840
		-- 飛行管理員
			{"獅鷲管理員", "杜加爾•朗德瑞克",{71.0,72.6}}, -- 43768
		-- 旅館老闆
			{"旅館老闆", "史蒂文•洛漢",{51.6,93.6}}, -- 3628
			{"旅館老闆", "旅館老闆奧裡森",{60.4,75.2}}, -- 6740
			{"旅館老闆", "塔格娜•耕石",{64.8,32.0}}, -- 44235
			{"旅館老闆", "梅根•提爾曼",{75.6,54.2}}, -- 44237
		-- 獸欄管理員
			{"獸欄管理員", "塞麗斯塔",{42.5,60.6}}, -- 9977
			{"獸欄管理員", "耶諾瓦•石盾",{67.0,37.6}}, -- 11069
			{"獸欄管理員", "卡琳",{77.8,67.2}}, -- 44252
		-- 專業訓練師
			{"煉金術訓練師", "莉琳希亞•夜風",{55.6,85.8}}, -- 5499
			{"考古學訓練師", "哈里森•鐘斯",{85.6,25.8}}, -- 44238
			{"鍛造訓練師", "瑟魯姆•深爐",{63.4,37.2}}, -- 5511
			--{"鍛造訓練師", "博古斯•鋼拳",{59.4,34.1}}, -- 7232
			{"鍛造訓練師", "喬丹•史密斯",{64.8,48.2}}, -- 55684
			{"烹飪訓練師", "斯蒂芬•雷百克",{77.2,53.2}}, -- 5482
			{"烹飪訓練師", "羅比•弗雷",{50.6,71.6}}, -- 42288
			{"附魔訓練師", "魯坎•考迪爾",{53.0,74.2}}, -- 1317
			{"工程學訓練師", "利廉姆•火軸",{62.8,32.0}}, -- 5518
			{"急救訓練師", "安吉拉•雷菲德",{52.0,45.6}}, -- 56796
			{"釣魚訓練師", "阿諾德•利蘭",{54.8,69.4}}, -- 5493
			{"飛行訓練師", "布娜拉•雲翼",{70.2,73.4}}, -- 43769
			{"草藥學訓練師", "莎拉米爾",{40.9,65.9}}, -- 5502
			{"草藥學訓練師", "塔尼莎",{54.4,84.0}}, -- 5566
			{"銘文學訓練師", "卡塔莉娜•斯坦弗",{49.6,74.6}}, -- 30713
			{"珠寶設計訓練師", "特蕾莎•登曼",{63.4,61.6}}, -- 44582
			{"制皮訓練師", "西蒙•坦納爾",{71.8,62.8}}, -- 5564
			{"採礦訓練師", "吉爾曼•石手",{59.6,37.6}}, -- 5513
			{"騎術訓練師", "達爾雷恩•斯托克斯",{77.4,67.4}}, -- 43693
			{"騎術訓練師", "林梅",{67.6,18.6}}, -- 70296
			{"剝皮訓練師", "馬瑞斯•格蘭治",{72.0,62.4}}, -- 1292
			{"裁縫訓練師", "喬吉奧•波利羅",{53.2,81.4}}, -- 1346
			{"裁縫訓練師", "嘉萊恩•艾羅",{40.2,84.4}}, -- 9584
			{"惡魔訓練師", "斯巴克爾",{39.6,84.6}}, -- 5520
			{"傳送門訓練師", "拉瑞麥尼•普爾度",{50.2,86.0}}, -- 2485
		-- 職業訓練師
			{"德魯伊訓練師", "沙德拉斯•月樹",{27.6,50.1}}, -- 5504
			{"德魯伊訓練師", "沙德拉斯•月樹",{46.7,64.0}}, -- 5504
			{"德魯伊訓練師", "塞瑞德蘭",{42.6,60.3}}, -- 5505
			{"德魯伊訓練師", "瑪爾德利恩",{45.0,71.0}}, -- 5506
			{"德魯伊訓練師", "豐收女巫塞萊斯廷",{57.6,24.9}}, -- 44395
			{"獵人訓練師", "恩瑞斯•銳矛",{67.4,36.4}}, -- 5515
			{"獵人訓練師", "奧菲爾•鐵須",{67.5,36.8}}, -- 5516
			{"獵人訓練師", "索爾芬•石盾",{67.4,37.0}}, -- 5517
			{"獵人訓練師", "多恩•奧瑪爾",{79.1,70.4}}, -- 43277
			{"獵人訓練師", "烏爾夫•哈斯雷姆",{79.1,70.4}}, -- 44247
			{"獵人訓練師", "莎裡希•朱莫",{79.1,70.4}}, -- 44249
			{"法師訓練師", "詹妮亞•坎農",{49.4,86.1}}, -- 5497
			{"法師訓練師", "艾爾莎林",{48.1,88.0}}, -- 5498
			{"法師訓練師", "亮火",{49.0,87.2}}, -- 85307
			{"法師訓練師", "拉魯",{50.0,86.6}}, -- 89174
			{"武僧訓練師", "艾莎•雲歌",{68.2,16.6}}, -- 62419
			{"聖騎士訓練師", "格雷森•沙東布瑞克公爵",{52.4,45.4}}, -- 928
			{"聖騎士訓練師", "虔誠的亞瑟",{52.3,45.6}}, -- 5491
			{"聖騎士訓練師", "純潔的凱薩琳",{52.3,45.6}}, -- 5492
			{"牧師訓練師", "高階牧師勞瑞娜",{49.7,44.9}}, -- 376
			{"牧師訓練師", "本傑明修士",{51.0,45.3}}, -- 5484
			{"牧師訓練師", "喬舒修士",{49.7,45.2}}, -- 5489
			{"牧師訓練師", "娜拉•梅德隆",{27.9,50.4}}, -- 11397
			{"牧師訓練師", "首席外科醫生焊創",{62.4,34.0}}, -- 45306
			{"盜賊訓練師", "夜行者奧斯伯",{77.4,65.3}}, -- 918
			{"盜賊訓練師", "托尼•羅曼諾",{79.6,61.2}}, -- 13283
			{"盜賊訓練師", "亞瑟•休維",{79.6,60.8}}, -- 51998
			{"薩滿訓練師", "先知安布洛爾",{65.9,31.4}}, -- 20407
			{"薩滿訓練師", "伯爾納•錘喙",{65.4,30.9}}, -- 44393
			{"薩滿訓練師", "達爾加•錘喙",{66.0,31.2}}, -- 44394
			{"術士訓練師", "德米賽特•克勞斯",{39.4,84.8}}, -- 461
			{"術士訓練師", "厄蘇拉•德林",{40.0,84.3}}, -- 5495
			{"術士訓練師", "山達爾",{39.4,85.0}}, -- 5496
			{"戰士訓練師", "安得爾•傑曼",{79.5,69.0}}, -- 914
			{"戰士訓練師", "武神",{79.8,69.4}}, -- 5479
			{"戰士訓練師", "伊爾薩•考賓",{79.8,69.3}}, -- 5480
		-- 商人
			-- 勇士大廳
			--{"PvP裝備商", "軍士長貝金斯",{75.6,66.6}}, -- 12781 "雜貨軍需官"
			--{"PvP裝備商", "加克斯賓中尉",{75.6,66.6}}, -- 12784 "舊世界武器軍需官"
			--{"PvP裝備商", "克萊特軍士長",{75.8,66.4}}, -- 12785 "舊世界護甲軍需官"
			--{"PvP裝備商", "崔絲提亞中尉",{74.8,67.6}}, -- 51255 "殘忍角鬥士Vicious"
			--{"PvP裝備商", "埃德蘭•哈爾辛",{74.6,68.2}}, -- 52029 "嗜血角鬥士Bloodthirsty"
			{"榮譽傳家寶", "莉莉安娜•恩貝弗斯特",{74.4,67.6}}, -- 52030
			--{"PvP裝備商", "騎士隊長蒂麥爾•塞緹絲",{75.0,67.0}}, -- 69974 "冷酷角鬥士Ruthless"
			--{"PvP裝備商", "迪格漢默上尉",{74.8,67.6}}, -- 69975 "災變角鬥士Cataclysmic"
			{"PvP裝備商", "舊世界武器護甲;戰爭坐騎;S9L;S9H;S10;S11",{74.6,68.2}}, -- 12781/12784/1285|12783/73190|51255/52029/69974/69975
			-- 勇士大廳門外
			--{"戰爭坐騎軍需官", "卡特爾中尉",{76.2,65.6}}, -- 12783
			--{"戰爭坐騎軍需官", "通靈領主賽普",{76.8,65.6}}, -- 73190
			-- 指揮大廳
			--{"PvE裝備商", "費爾德倫•提爾斯戴爾",{79.0,69.6}}, -- 44245 "勇氣軍需官"
			--{"PvE裝備商", "瑪嘉莎•斯利文托",{79.0,69.6}}, -- 44246 "正義軍需官"
			--{"PvE裝備商", "托倫•蘭道",{79.0,70.0}}, -- 58154 "傳承正義軍需官"
			{"PvE裝備商", "費爾德倫•提爾斯戴爾;瑪嘉莎•斯利文托;托倫•蘭道",{79.0,69.6}}, --44245/44246/58154
			-- 派系
			{"暴風城軍需官", "騎士隊長蘭希•萊薇森",{67.6,72.8}}, -- 49877
			{"土水派軍需官", "門徒韓俊",{68.0,17.0}}, -- 69334
			-- 其他
			{"大地的裂變時空漫遊商人", "琪雅科",{76.0,17.6}}, -- 101759
			-- 惡魔入侵
			{"惡魔入侵軍需官", "被俘的蟲語者",{41.0,78.8}}, -- 109912
		-- 其他NPC
			{"公會註冊員", "奧德文•拉弗林",{64.6,76.8}}, -- 4974
			{"美容師", "耶利尼克•沙希爾",{61.2,64.8}}, -- 29142
			{"秘法重鑄師", "魔術師瓦西裡恩",{50.6,60.6}}, -- 54441
		-- 訓練假人
			{"訓練假人", "團隊副本訓練假人",{80.2,64.5}}, -- 31146
			{"訓練假人", "訓練假人",{81.4,64.8}}, -- 32666
			{"訓練假人", "訓練假人",{81.0,65.0}}, -- 32667
			{"訓練假人", "訓練假人",{79.6,62.0}}, -- 46647
		-- 交通工具
			{"傳送門", "坡東村",{68.9,17.2}},
			{"傳送門", "托爾巴拉德半島;深岩之洲;瓦斯琪爾;暮光高地;海加爾山;奧丹姆",{74.5,18.4}},
			{"傳送門", "地獄火半島;詛咒之地",{49.2,87.0}},
			{"傳送門", "阿什蘭",{82.5,29.7}},
			{"地鐵", "鐵爐堡;比茲莫搏擊俱樂部",{68.7,32.2}},
			{"船舶", "魯瑟蘭村-泰達希爾",{22.7,56.0}},
			{"船舶", "無畏要塞-北風苔原",{18.3,25.3}},
		},

		-- The Exodar
		["埃索達"]={
		-- 拍賣師
			{"拍賣師", "伊歐奇",{63.7,58.7}}, -- 16707
			{"拍賣師", "範尼",{63.0,59.2}}, -- 18348
			{"拍賣師", "艾瑞紗",{63.4,59.0}}, -- 18349
		-- 銀行職員
			{"銀行職員", "凱拉格",{45.4,43.3}}, -- 16710
			{"銀行職員", "歐斯科",{45.4,44.4}}, -- 17773
			{"銀行職員", "潔拉",{45.4,43.9}}, -- 18350
		-- 飛行管理員
			{"角鷹獸管理員", "史丹樊那斯",{54.8,35.8}}, -- 17555
		-- 旅館老闆
			{"旅館老闆", "照顧者布利尤",{59.4,19.2}}, -- 16739
		-- 獸欄管理員
			{"獸欄管理員", "阿斯艾德",{60.0,25.4}}, -- 16764
		-- 專業訓練師
			{"煉金術訓練師", "魯克",{27.8,61.6}}, -- 16723
			{"考古學訓練師", "蒂亞",{34.0,66.7}}, -- 47570
			{"鍛造訓練師", "米阿爾",{60.6,89.6}}, -- 16724
			{"烹飪訓練師", "穆曼",{55.9,27.0}}, -- 16719
			{"附魔訓練師", "納霍加",{40.2,39.5}}, -- 16725
			{"工程學訓練師", "奧克基爾",{54.8,92.2}}, -- 16726
			{"急救訓練師", "努絲",{39.6,22.6}}, -- 16731
			{"釣魚訓練師", "伊雷特",{31.2,15.2}}, -- 16774
			{"草藥學訓練師", "塞摩爾漢",{27.6,63.8}}, -- 16736
			{"銘文學訓練師", "索斯",{39.8,39.6}}, -- 30716
			{"珠寶設計訓練師", "法裡",{44.8,24.6}}, -- 19778
			{"制皮訓練師", "阿克漢姆",{67.2,74.8}}, -- 16728
			{"採礦訓練師", "穆亞特",{60.6,88.1}}, -- 16752
			{"騎術訓練師", "埃亞倫",{81.4,52.6}}, -- 20914
			{"剝皮訓練師", "雷米勒",{65.5,74.9}}, -- 16763
			{"裁縫訓練師", "雷菲克",{64.2,68.3}}, -- 16729
			{"傳送門訓練師", "魯納爾蘭",{46.1,63.6}}, -- 16755
		-- 職業訓練師
			{"獵人訓練師", "德雷米斯",{47.7,86.4}}, -- 16738
			{"獵人訓練師", "沃爾德",{47.4,88.1}}, -- 17122
			{"獵人訓練師", "基爾拉克",{46.6,89.6}}, -- 17505
			{"法師訓練師", "伊迪拉恩",{46.9,62.5}}, -- 16749
			{"法師訓練師", "哈爾南",{46.6,62.7}}, -- 17513
			{"法師訓練師", "巴蒂",{46.4,63.1}}, -- 17514
			{"武僧訓練師", "武魂潘勁",{54.8,82.0}}, --62464
			{"聖騎士訓練師", "巴圖恩",{39.0,84.2}}, -- 16761
			{"聖騎士訓練師", "卡威恩",{39.4,81.8}}, -- 17121
			{"聖騎士訓練師", "約爾",{38.4,82.2}}, -- 17509
			{"牧師訓練師", "凱德莫斯",{38.8,51.0}}, -- 16756
			{"牧師訓練師", "伊茲米爾",{40.0,52.0}}, -- 17510
			{"牧師訓練師", "法爾拉特",{39.5,51.5}}, -- 17511
			{"薩滿訓練師", "預言者努波頓",{30.2,32.4}}, -- 17204
			{"薩滿訓練師", "蘇蘭",{32.9,24.2}}, -- 17219
			{"薩滿訓練師", "霍巴肯",{35.0,8.2}}, -- 17519
			{"薩滿訓練師", "古爾拉格",{24.2,39.7}}, -- 17520
			{"戰士訓練師", "安霍納",{55.0,83.4}}, -- 16771
			{"戰士訓練師", "貝霍瑪特",{55.3,82.0}}, -- 17120
			{"戰士訓練師", "卡茲",{56.8,84.2}}, -- 17504
		-- 商人
			{"埃索達軍需官", "卡杜",{54.6,36.8}}, -- 50306
		-- 其他NPC
			{"公會註冊員", "弗納姆",{53.6,70.6}}, -- 16734
		-- 訓練假人
			{"訓練假人", "團隊副本訓練假人",{24.0,32.6}}, -- ?
			{"訓練假人", "訓練假人",{24.0,32.6}}, -- ?
		-- 交通工具
			{"傳送門", "地獄火半島;達納蘇斯",{48.1,62.3}},
		},

		-- [MISTS] Shrine of Seven Stars
		["七星殿"]={
		-- 拍賣師
			{"工程拍賣", "H.A.R.V.E.Y.",{57.4,51.8},3}, -- 65599
		-- 銀行職員
			{"銀行職員", "寶庫管理者夏恩",{44.2,67.2},4}, -- 63967 -- 二層
			{"銀行職員", "寶庫管理者惜凡",{38.8,75.0},4}, -- 63968 -- 二層
			{"銀行職員", "寶庫管理者菲茲諾金",{40.6,80.6},4}, -- 63969 -- 二層
			{"銀行職員", "寶庫管理者梅爾卡",{46.2,69.8},4}, -- 63970 -- 二層
			{"銀行職員", "寶庫管理者賈庫",{36.0,71.0},4}, -- 63971 -- 二層
			{"銀行職員", "寶庫管理者佩耶塔",{44.0,65.6},4}, -- 64023 -- 二層
			{"銀行職員", "寶庫管理者銀掌",{45.2,68.8},4}, -- 64024	-- 二層
			{"工程倉庫", "小罐頭",{57.4,51.8},3}, -- 65596
		-- 旅館老闆
			{"旅館老闆", "瓦妮阿姨",{35.4,66.8},3}, -- 64149
		-- 專業訓練師
			{"鍛造訓練師", "科倫•錘眉",{72.4,50.6},3}, -- 64085
			{"急救訓練師", "治療者楠",{45.0,62.4},3}, -- 64482
			{"工程學訓練師", "工程學訓練師",{57.4,51.8},3}, -- need update
		-- 商人
			--{"PvE裝備商", "薇爾貝茨•歡哨",{41.6,42.6},4}, -- 74020 "隨機副本商人" -- 二層
			--{"PvE裝備商", "克拉麗絲•查普曼",{43.6,45.6},4}, -- 74021 "英雄副本商人" -- 二層
			--{"PvE裝備商", "德里特•岩心",{42.6,43.6},4}, -- 74022 "團隊副本商人" -- 二層
			--{"PvE裝備商", "勞瑞•暖心",{43.6,47.6},4}, -- 74027 "史詩副本商人" -- 二層
			{"PvE裝備商", "薇爾貝茨•歡哨;克拉麗絲•查普曼;德里特•岩心;勞瑞•暖心",{42.6,43.6},4}, -- 74020/74021/74022/74027
		-- 其他NPC
			{"秘法重鑄師", "魔術師法拉凱特",{53.2,87.6},4}, -- 64045 -- 二層
		-- 交通工具
			{"傳送門", "暴風城;鐵爐堡;達納蘇斯;埃索達;達拉然;沙塔斯城",{70.1,40.2},4}, -- 二層
		},

		-- [WARLORDS] Stormshield
		["暴風之盾"]={
		-- 拍賣師
			{"拍賣師", "喬吉特•泰隆",{54.0,65.0}}, -- 85964
			{"拍賣師", "大衛•泰隆",{53.8,65.0}}, -- 86733
			{"拍賣師", "艾德瑞",{53.6,67.2}}, -- 88520
			{"拍賣師", "孔酒步",{54.4,67.2}}, -- 88522
		-- 銀行職員
			{"銀行職員", "諾蘭•伯布裡克",{55.2,48.2}}, -- 85957
			{"銀行職員", "巴薩姆•燧眉",{54.4,49.2}}, -- 88468
			{"銀行職員", "蓋米爾•熔鋼",{54.8,49.0}}, -- 88469
			{"銀行職員", "德芬•汽距",{55.0,48.6}}, -- 88471
		-- 飛行管理員
			{"飛行管理員", "恩斯特•坦恩•博世",{30.8,48.8}}, -- 85959
		-- 旅館老闆
			{"旅館老闆", "加西亞•悅花",{35.4,77.6}}, -- 85956
		-- 獸欄管理員
			{"獸欄管理員", "奧維爾•曼弗雷德",{33.4,65.4}}, -- 85963
		-- 專業訓練師
			{"煉金術訓練師", "賈登•塔斯克",{36.6,69.2}}, -- 85905
			{"考古學訓練師", "曼達•達洛維",{49.0,33.8}}, -- 85927
			{"鍛造訓練師", "艾米•金爐",{48.8,46.6}}, -- 85917
			{"烹飪訓練師", "愛爾頓•布萊克",{35,76.6}}, -- 85925
			{"附魔訓練師", "比爾•星酒",{56.4,64.6}}, -- 85914
			{"工程學訓練師", "希爾達•銅絲",{47.6,40.4}}, -- 85918
			{"急救訓練師", "特麗絲•護藤",{47.0,30.6}}, -- 85930
			{"釣魚訓練師", "奧斯丁•溫德米爾",{55.6,77.8}}, -- 85926
			{"草藥學訓練師", "潔•野花",{37.2,69.4}}, -- 85921
			{"銘文學訓練師", "銘文學師芝源",{62.8,34.0}}, -- 85911
			{"寶石加工訓練師", "技師妮希亞",{43.8,34.2}}, -- 85916
			{"制皮訓練師", "吉斯頓•銳羽",{52.0,42.4}}, -- 85920
			{"採礦訓練師", "約拿斯•鏈拳",{47.0,43.4}}, -- 85919
			{"剝皮訓練師", "遊俠蘭頓",{51.8,42.6}}, -- 85923
			{"裁縫訓練師", "約書亞•福斯汀",{51.0,37.0}}, -- 85910
			{"傳送門訓練師", "茱莉亞•瓦吉斯",{63.6,35.4}}, -- 88254
		-- 商人
			-- 軍需官
			--{"PvP裝備商", "布萊格•銅鑄",{56.2,20.0}}, -- 86175 "榮譽軍需官"
			--{"PvP裝備商", "英格麗德•黑錠",{55.4,19.8}}, -- 86176 "征服軍需官"
			--{"PvP裝備商", "Alixandr Fallor",{54.8,18.8}}, -- 93905 "Elite Conquest Quartermaster" -- need translation
			--{"PvP裝備商", "Slugg Spinbolt",{54.6,19.6}}, -- 93906 "Wild Honor Quartermaster" -- need translation
			--{"PvP裝備商", "Amelia Clarke",{54.6,18.6}}, -- 93907 "Wild Conquest Quartermaster" -- need translation
			--{"PvP裝備商", "Holly McTilla",{55.6,19.2}}, -- 93914 "Warmongering Conquest Quartermaster" -- need translation
			--{"PvP裝備商", "Li Crunchpaw Tsang",{55.6,19.4}}, -- 93915 "Warmongering Honor Quartermaster" -- need translation
			{"PvP裝備商", "布萊格•銅鑄;英格麗德•黑錠,etc.",{56.2,20.0}}, -- 86175/86176/93905/93906/93907/93914/93915
			-- 派系
			--{"主教議會軍需官", "守備官努瑞姆",{46.6,76.2}}, -- 85932
			--{"鴉人流亡者軍需官", "暗影賢者巴考斯",{44.8,75.0}}, -- 85946
			--{"熱砂軍需官", "加茲瑞克斯•輪鎖",{43.2,77.6}}, -- 88482
			{"軍需官", "主教議會;鴉人流亡者;熱砂",{46.6,76.2}}, -- 85932/85946/88482
			-- 其他
			{"圖紙商人", "金凱德•加科布",{29.8,53.0}}, -- 85849
			--{"埃匹希斯商人", "覓晨者里拉克",{50.0,61.6}}, -- 86387 "埃匹希斯頭盔商人"
			--{"埃匹希斯商人", "覓晨者維羅克",{49.6,61.6}}, -- 86389 "埃匹希斯斗篷商人"
			--{"埃匹希斯商人", "覓晨者瓦拉爾",{49.8,61.4}}, -- 86390 "埃匹希斯手套商人"
			--{"埃匹希斯商人", "覓晨者科雷克",{50.6,61.8}}, -- 86391 "埃匹希斯護腿商人"
			--{"埃匹希斯商人", "Dawn-Seeker Skelak",{49.6,61.8}}, -- 91321 "埃匹希斯護腕商人" -- need translation
			--{"埃匹希斯商人", "Dawn-Seeker Kasrek",{51.6,61.8}}, -- 92501 "埃匹希斯腰帶商人" -- need translation
			{"埃匹希斯商人", "頭盔;斗篷;手套;護腿;護腕;腰帶",{50.0,61.6}}, -- 86387/86389/86390/86391/91321/92501
		-- 訓練假人
			{"訓練假人", "團隊副本訓練假人",{60.2,15.6}}, -- 87320
			{"訓練假人", "訓練假人",{58.6,17.6}}, -- 87321
			{"訓練假人", "地下城訓練假人",{59.0,18.8}}, -- 87322
			{"訓練假人", "團隊副本訓練假人",{64.0,14.0}}, -- 87329
		-- 交通工具
			{"傳送門", "暴風城-艾爾文森林",{61.2,38.7}},
			{"傳送門", "鐵爐堡-丹莫羅",{50.8,50.6}},
			{"傳送門", "達納蘇斯-泰達希爾",{60.5,59.0}},
		},

		-- Orgrimmar
		["奧格瑞瑪"]={
		-- 拍賣師
			{"拍賣師", "拍賣師索瓦特",{41.4,48.2}}, --  44787
			{"拍賣師", "拍賣師法茲德蘭",{53.7,73.5}}, --  44865
			{"拍賣師", "拍賣師德雷澤米特",{54,73.5}}, --  44866
			{"拍賣師", "拍賣師拉林紮",{53.7,73.7}}, --  44867
			{"拍賣師", "拍賣師艾克斯法",{54.1,73.4}}, --  44868
			{"拍賣師", "拍賣師澤基",{33.1,65}}, --  45082
			{"拍賣師", "拍賣師芬卡",{37.3,78.7}}, --  45659
			{"拍賣師", "拍賣師德雷澤比特",{66.4,36.4}}, --  46637
			{"拍賣師", "拍賣師維茲普特",{66.9,36.1}}, --  46638
			{"拍賣師", "拍賣師茲爾比娜",{66.4,36.4}}, --  46639
			{"拍賣師", "拍賣師庫薇",{66.8,36.2}}, --  46640
		-- 銀行職員
			{"銀行職員", "塔特比",{40,46.4}}, -- 44770
			{"銀行職員", "裡格吉茲",{48.7,84}}, -- 44852
			{"銀行職員", "布蘭茲利特",{48.4,83.3}}, -- 44853
			{"銀行職員", "琪克薩",{48.4,83.7}}, -- 44854
			{"銀行職員", "佩妮克薩",{49,83.6}}, -- 44856
			{"銀行職員", "瑪卡烏",{33.2,64.7}}, -- 45081
			{"銀行職員", "澤瑞特",{38.2,78.4}}, -- 45661
			{"銀行職員", "努佐",{38.2,78.4}}, -- 45662
			{"銀行職員", "菲比",{67.8,52}}, -- 46618
			{"銀行職員", "比妮澤拉",{67.7,53.1}}, -- 46619
			{"銀行職員", "溫克",{67.4,53.1}}, -- 46620
			{"銀行職員", "龐克",{67.3,52.6}}, -- 46621
			--{"銀行職員", "梅茲利克",{48.6,83.6}}, -- 72554
		-- 飛行管理員
			{"雙足飛龍管理員", "朵拉斯",{49.4,59.2}}, -- 3310
		-- 旅館老闆
			{"旅館老闆", "旅館老闆格雷什卡",{53.4,78.8}}, -- 6929
			{"旅館老闆", "米瓦娜",{39.0,48.6}}, -- 44785
			{"旅館老闆", "希加姆比",{32.6,64.8}}, -- 45086
			{"旅館老闆", "緹茲娜•銀盃",{39.8,81.2}}, -- 45563
			{"旅館老闆", "旅館老闆努法",{70.4,49.0}}, -- 46642
		-- 獸欄管理員
			{"獸欄管理員", "克蘇卡",{32.6,64.8}}, -- 9988
			{"獸欄管理員", "倫托",{39.4,48.4}}, -- 44788
			{"獸欄管理員", "巴茲爾",{40.4,80.4}}, -- 45789
			{"獸欄管理員", "姆羅格",{62.0,35.2}}, -- 47764
		-- 專業訓練師
			{"煉金術訓練師", "耶爾瑪克",{55.6,45.8}}, -- 3347
			{"考古學訓練師", "貝洛克•輝刃",{49.0,70.6}}, -- 47571
			{"鍛造訓練師", "薩魯•鋼怒",{76.2,34.6}}, -- 3355
			{"鍛造訓練師", "莎伊斯•鋼怒",{75.3,37.1}}, -- 7230
			{"鍛造訓練師", "克爾格魯克•血斧",{76.0,37.2}}, -- 7231
			{"鍛造訓練師", "奧克索斯•鐵怒",{75.4,34.2}}, -- 11177
			{"鍛造訓練師", "伯古什",{75.8,33.8}}, -- 11178
			{"鍛造訓練師", "羅格",{44.4,77.2}}, -- 37072
			{"鍛造訓練師", "奧普諾•鐵角",{40.6,49.8}}, -- 44781
			{"鍛造訓練師", "卡爾克•碎盔者",{35.8,83.6}}, -- 45548
			{"烹飪訓練師", "紮姆沙",{32.3,69.4}}, -- 3399
			{"烹飪訓練師", "瑪洛格",{56.6,62.6}}, -- 42506
			{"烹飪訓練師", "紮爾博•碎肉餅",{39.0,85.8}}, -- 45550
			{"烹飪訓練師", "阿露基",{56.2,61.6}}, -- 46709
			{"附魔訓練師", "古丹",{53.4,49.4}}, -- 3345
			{"工程學訓練師", "羅克希克",{56.8,56.4}}, -- 11017
			{"工程學訓練師", "“傑克”•帕薩雷克•砸修",{36.4,86.6}}, -- 45545
			{"急救訓練師", "科倫克•剁肢",{37.0,87.2}}, -- 45540
			{"釣魚訓練師", "魯瑪克",{66.6,41.6}}, -- 3332
			{"釣魚訓練師", "老恩姆貝托",{35.0,67.6}}, -- 44975
			{"飛行訓練師", "瑪奇薩",{49.0,59.2}}, -- 44919
			{"草藥學訓練師", "加迪",{34.5,63.5}}, -- 3404
			{"草藥學訓練師", "穆拉加",{54.4,50.4}}, -- 46741
			{"銘文學訓練師", "猶爾曼",{35.7,69.5}}, -- 30706
			{"銘文學訓練師", "內羅格",{55.2,55.8}}, -- 46716
			{"珠寶設計訓練師", "魯格娜",{72.4,34.4}}, -- 46675
			{"制皮訓練師", "卡洛雷克",{60.8,54.8}}, -- 3365
			{"採礦訓練師", "馬卡魯",{72.4,35}}, -- 3357
			{"採礦訓練師", "古恩托",{44.6,78.4}}, -- 46357
			{"採礦訓練師", "吉茲克•礦握",{36.0,82.8}},-- 52170
			{"騎術訓練師", "基爾達",{61.4,34.4}}, -- 4752
			{"騎術訓練師", "蕾薇•推杆",{36.6,87.0}}, -- 48513
			{"騎術訓練師", "柔爪",{69.8,40.8}}, -- 70301
			{"剝皮訓練師", "蘇爾德",{61.0,54.6}}, -- 7088
			{"剝皮訓練師", "雷恩托",{39.4,49.4}}, -- 44782
			{"裁縫訓練師", "瑪加爾",{60.6,59.0}}, -- 3363
			{"裁縫訓練師", "希瓦希•三羽",{38.8,50.3}}, -- 44783
			{"裁縫訓練師", "妮維•精編",{41.0,79.6}}, -- 45559
			{"惡魔訓練師", "摩古爾",{51.8,40.6},2}, -- 88706 -- 暗影裂口
			{"傳送門訓練師", "觀星者吉拉吉",{35.8,68.2}}, -- 45139
			{"傳送門訓練師", "朗多克",{46.2,66.6},2}, -- 47253 -- 暗影裂口
		-- 職業訓練師
			{"德魯伊訓練師", "莎烏拉•白葉",{44.9,51.6}}, -- 44726
			{"德魯伊訓練師", "塞瑟比",{34.4,67.8}}, -- 44978
			{"獵人訓練師", "奧瑪克",{64,32.8}}, -- 3352
			{"獵人訓練師", "諾希•平原行者",{44.8,52.9}}, -- 44743
			{"獵人訓練師", "女獵人庫紮莉",{34.4,74}}, -- 45023
			{"獵人訓練師", "達克因•遠狙",{39.4,82.4}}, -- 45713
			{"獵人訓練師", "克爾拉",{63.4,32.9}}, -- 47767
			{"獵人訓練師", "古爾多爾",{63.4,32.9}}, -- 47788
			{"法師訓練師", "尤塞爾奈",{35.2,68.6}}, -- 7311
			{"法師訓練師", "尤蕾達",{50,69.9},2}, -- 47246 -- 暗影裂口
			{"法師訓練師", "瑪魯德",{49.2,66.8},2}, -- 47247 -- 暗影裂口
			{"法師訓練師", "吉加",{48.2,69.5},2}, -- 47248 -- 暗影裂口
			{"法師訓練師", "咒術師米克西莉",{40.1,80.7}}, -- 45714
			{"武僧訓練師", "季•火掌",{68.8,39.6}}, -- 62445
			{"聖騎士訓練師", "派雷亞諾",{49,71.8}}, -- 23128
			{"聖騎士訓練師", "烈日行者阿托莫",{45.2,53.4}}, -- 44725
			{"牧師訓練師", "先知利瓦薩",{45.4,53.4}}, -- 44735
			{"牧師訓練師", "暗影行者祖魯",{35.4,69.2}}, -- 45137
			{"牧師訓練師", "提耶利斯",{49,71.7}}, -- 45337
			{"牧師訓練師", "黑暗牧師塞希莉",{48.2,72.8}}, -- 45339
			{"牧師訓練師", "聖銀幣修士",{37.4,87.2}}, -- 45347
			{"盜賊訓練師", "蓋斯特",{32.3,65.3},2}, -- 3327 -- 暗影裂口
			{"盜賊訓練師", "奧莫克",{32.3,66},2}, -- 3328 -- 暗影裂口
			{"盜賊訓練師", "戈達爾",{32.4,66},2}, -- 47233 -- 暗影裂口
			{"盜賊訓練師", "夜行者庫納基",{32.2,63.6}}, -- 45095
			{"盜賊訓練師", "盜賊維西",{39.8,80.9}}, -- 45717
			{"薩滿訓練師", "薩祖",{39.0,47.7}}, -- 3403
			{"薩滿訓練師", "薩格尼",{39.7,47.5}}, -- 13417
			{"薩滿訓練師", "莎伊•雲歌",{44.8,52}}, -- 44740
			{"薩滿訓練師", "巫醫尤姆布",{31.1,64.3}}, -- 45029
			{"薩滿訓練師", "環境工程師林茲娜",{36.2,84.2}}, -- 45718
			{"薩滿訓練師", "碎地者特加",{39.0,47.6}}, -- 72939
			{"術士訓練師", "烏恩加里•邪語",{35.8,69.6}}, -- 45138
			{"術士訓練師", "女巫卡茲拉莉",{40.6,80.2}}, -- 45720
			{"術士訓練師", "格蘭杜爾",{53.6,37.4},2}, -- 88704 -- 暗影裂口
			{"術士訓練師", "卡諾什",{54.8,35.6},2}, -- 88705 -- 暗影裂口
			{"戰士訓練師", "格雷茲•怒拳",{73.3,45.4}}, -- 3353
			{"戰士訓練師", "索瑞克",{73.3,45.1}}, -- 3354
			{"戰士訓練師", "納胡•怒蹄",{44.8,53.1}}, -- 44723
			{"戰士訓練師", "狂暴者曾迦",{34.3,74.5}}, -- 45019
			{"戰士訓練師", "衛兵賈尼克斯",{37.3,79.1}}, -- 45709
			{"戰士訓練師", "劍聖羅納卡達",{73.2,45.3}}, -- 46667
		-- 商人
			-- 傳說大廳
			--{"PvP裝備商", "衛兵布萊恩•石皮",{38.2,72.6}}, -- 12793 榮耀印記 "雜貨軍需官"
			--{"PvP裝備商", "石頭守衛紮爾格",{38.6,72.8}}, -- 12794 "舊世界武器軍需官"
			--{"PvP裝備商", "一等軍士長霍拉麥",{38.2,72.6}}, -- 12795 榮耀印記 "舊世界護甲軍需官"
			--{"PvP裝備商", "洛戈克",{37.8,71.6}}, -- 52033 榮耀印記 "嗜血角鬥士Bloodthirsty"
			{"榮譽傳家寶", "加爾拉",{38,70.8}}, -- 52036 榮耀印記 "榮譽傳家寶"
			--{"PvP裝備商", "桃麗絲•沃蘭休斯",{38.8,69.8}}, -- 54657 榮耀印記 "殘忍角鬥士Vicious"
			--{"PvP裝備商", "血衛士紮爾什",{38.2,70.4}}, --69977 榮耀印記 "冷酷角鬥士Ruthless"
			--{"PvP裝備商", "雷角中士",{38.6,70.0}}, --69978 榮耀印記 "災變角鬥士Cataclysmic"
			{"PvP裝備商", "舊世界武器護甲;戰爭坐騎;S9L;S9H;S10;S11",{37.8,71.6}}, -- 12793/12794/12795|12796/73151|52033/54657/69977/69978
			-- 傳說大廳門外
			--{"戰爭坐騎軍需官", "狼騎兵波爾克",{41.8,73.6}}, -- 12796 榮耀印記 "戰爭坐騎軍需官"
			--{"戰爭坐騎軍需官", "亡靈衛兵奈薩里安",{41.8,73.0}}, -- 73151 邪氣鞍座 "戰爭坐騎軍需官"
			-- 格羅瑪什要塞頂部
			--{"PvE裝備商", "貢娜",{48.4,71.6}}, -- 46555 "正義軍需官"
			--{"PvE裝備商", "傑姆斯瓦茲",{48.6,71.4}}, -- 46556 "勇氣軍需官"
			--{"PvE裝備商", "魯戈克",{48.2,71.6}}, -- 58155 "傳承正義軍需官"
			{"PvE裝備商", "貢娜;傑姆斯瓦茲;魯戈克",{48.4,71.6}}, -- 46555/46556/58155
			-- 派系
			--{"鏽水財閥軍需官", "弗裡茲•維拉馬爾",{49.8,58.6}}, -- 50323
			--{"暗矛軍需官", "勇士烏拉金",{50.0,58.6}}, -- 50477
			--{"奧格瑞瑪軍需官", "石頭守衛納爾戈爾",{50.0,58.6}}, -- 50488
			{"軍需官", "奧格瑞瑪;鏽水財閥;暗矛",{50.0,58.6}}, -- 50323/50477/50488
			{"火金派軍需官", "門徒君思",{68.6,40.6}}, -- 69333
			-- 其他
			{"大地的裂變時空漫遊商人", "琪雅科",{52.0,41.6}}, -- 101759
			-- 惡魔入侵
			{"惡魔入侵軍需官", "被俘的蟲語者",{52.6,57.6}}, -- 109912
		-- 其他NPC
			{"公會註冊員", "烏特倫",{48.6,76.2}}, -- 3370
			{"美容師", "貝布莉•科弗庫爾",{40.2,60.8}}, -- 29143
			{"秘法重鑄師", "魔術師紮吉爾",{57.8,65.6}}, -- 54471
		-- 訓練假人
			{"訓練假人", "訓練假人",{73.6,47.4}}, -- 31144
			{"訓練假人", "團隊副本訓練假人",{64.6,33.0}}, -- 31146
			{"訓練假人", "團隊副本訓練假人",{61.4,45.4}}, -- 31146
			{"訓練假人", "團隊副本訓練假人",{73.6,46.0}}, -- 31146
			{"訓練假人", "訓練假人",{73.6,43.8}}, -- 32666
			{"訓練假人", "訓練假人",{76.0,43.4}}, -- 32667
			{"訓練假人", "訓練假人",{63.6,34.2}}, -- 46647
			{"訓練假人", "訓練假人",{63.6,49.2}}, -- 46647
			{"訓練假人", "訓練假人",{73.8,43.8}}, -- 46647
		-- 交通工具
			{"傳送門", "蜜露村",{68.8,39.6}},
			{"傳送門", "托爾巴拉德半島;深岩之洲;瓦斯琪爾;暮光高地;海加爾山;奧丹姆",{50.0,37.8}},
			{"傳送門", "地獄火半島;詛咒之地",{35.8,69.0}},
			{"傳送門", "阿什蘭",{47.6,72.2}},
			{"入口", "搏擊競技場",{70.5,31.0}},
			{"飛艇", "雷霆崖;戰歌要塞",{43.8,63.5}},
			{"飛艇", "提瑞斯法林地;格羅姆高營地",{51.5,54.4}},
		},

		-- Silvermoon City
		["銀月城"]={
		-- 拍賣師
			{"拍賣師", "拍賣師伊西利安",{92.6,58.2}}, -- 16627
			{"拍賣師", "拍賣師塞多裡",{92.4,59.2}}, -- 16628
			{"拍賣師", "拍賣師坦德隆",{93.0,57.0}}, -- 16629
			{"拍賣師", "拍賣師耶納斯",{59.8,62.6}}, -- 17627
			{"拍賣師", "拍賣師維納",{60.6,63.6}}, -- 17628
			{"拍賣師", "拍賣師菲恩娜",{61.4,62.4}}, -- 17629
			{"拍賣師", "拍賣師達莉絲",{60.4,61.7}}, -- 18761
		-- 銀行職員
			{"銀行職員", "諾維婭",{89.0,43.2}}, -- 16615
			{"銀行職員", "彼雷爾",{89.7,43.2}}, -- 16616
			{"銀行職員", "黛妮絲",{90.4,43.2}}, -- 16617
			{"銀行職員", "希爾拉",{67.4,77.9}}, -- 17631
			{"銀行職員", "伊爾拉娜",{67.4,79.1}}, -- 17632
			{"銀行職員", "哈瑟恩",{67.4,76.7}}, -- 17633
		-- 旅館老闆
			{"旅館老闆", "旅館老闆維蘭德拉",{79.6,58.2}}, -- 16618
			{"旅館老闆", "旅館老闆約維婭",{67.6,73.0}}, -- 17630
		-- 獸欄管理員
			{"獸欄管理員", "沙爾蕾恩",{83.4,30.4}}, -- 16656
		-- 專業訓練師
			{"煉金術訓練師", "卡博隆",{66.8,18.0}}, -- 16642
			{"考古學訓練師", "埃萊娜拉",{81.3,63.3}}, -- 47346
			{"鍛造訓練師", "波瑪爾",{79.4,39.0}}, -- 16669
			{"附魔訓練師", "瑟丹娜",{69.4,24.3}}, -- 16633
			{"工程學訓練師", "丹文",{76.3,40.6}}, -- 16667
			{"急救訓練師", "埃雷圖斯",{77.2,70.4}}, -- 16662
			{"釣魚訓練師", "德拉森",{76.4,68.0}}, -- 16780
			{"草藥學訓練師", "植物學家娜薩蘭",{67.4,17.9}}, -- 16644
			{"銘文學訓練師", "贊塔希婭",{69.0,24.8}}, -- 30710
			{"珠寶設計訓練師", "卡琳達",{90.6,73.8}}, -- 19775
			{"制皮訓練師", "萊納裡斯",{84.9,80.6}}, -- 16688
			{"採礦訓練師", "比利爾",{79.0,42.8}}, -- 16663
			{"剝皮訓練師", "提恩",{84.1,79.6}}, -- 16692
			{"裁縫訓練師", "基倫•希斯",{56.8,50.9}}, -- 16640
			{"惡魔訓練師", "托利安",{74.6,44.4}}, -- 16649
			{"傳送門訓練師", "納林斯",{57.4,21.0}}, -- 16654
		-- 職業訓練師
			{"德魯伊訓練師", "哈雷尼•平原行者",{71.6,56.8}}, -- 16655
			{"獵人訓練師", "塔納",{82.5,26.4}}, -- 16672
			{"獵人訓練師", "歐尼納斯",{84.2,26.5}}, -- 16673
			{"獵人訓練師", "桑迪恩",{84.4,28.0}}, -- 16674
			{"法師訓練師", "塞伊丹納",{57.3,19.2}}, -- 16651
			{"法師訓練師", "奎恩薩斯",{58.3,18.6}}, -- 16652
			{"法師訓練師", "伊尼文",{58.4,19.3}}, -- 16653
			{"武僧訓練師", "睿智的肖恩",{83.6,39.8}}, -- 62463
			{"聖騎士訓練師", "歐塞蘭",{91.3,38.3}}, -- 16679
			{"聖騎士訓練師", "伊瑟裡斯",{91.3,36.1}}, -- 16680
			{"聖騎士訓練師", "勇士巴卡希",{91.5,36.2}}, -- 16681
			{"牧師訓練師", "奧德蘭",{53.3,26.6}}, -- 16658
			{"牧師訓練師", "洛塞蘭",{55.2,26.4}}, -- 16659
			{"牧師訓練師", "貝蕾絲特拉",{54.0,28.2}}, -- 16660
			{"盜賊訓練師", "瑟蘭尼斯",{78.9,52.1}}, -- 16684
			{"盜賊訓練師", "艾爾蘭拉",{79.4,49.0}}, -- 16685
			{"盜賊訓練師", "奈裡森",{78.7,50.4}}, -- 16686
			{"薩滿訓練師", "吉茲利",{71.8,56.8}}, -- 16661
			{"術士訓練師", "奧拉瑪",{73.2,46.8}}, -- 16646
			{"術士訓練師", "塔萊尼婭",{73.7,47.5}}, -- 16647
			{"術士訓練師", "薩尼恩",{73.2,45.3}}, -- 16648
			{"戰士訓練師", "捍衛者阿爾蘇達",{80.4,37.2}}, -- 43009
			{"戰士訓練師", "薩瑞瑟娜",{80.3,36.8}}, -- 44128
			{"戰士訓練師", "貝爾迪斯",{80.4,38.0}}, -- 44129
		-- 其他NPC
			{"公會註冊員", "坦德莉恩",{78.4,84.6}}, -- 16568
		-- 訓練假人
			{"訓練假人", "訓練假人",{82.2,35.4}}, -- 31144
			{"訓練假人", "團隊副本訓練假人",{82.6,37.8}}, -- 31146
			{"訓練假人", "訓練假人",{83.0,37.0}}, -- 32667
		-- 交通工具
			{"傳送門", "地獄火半島",{58.4,21.0}},
			{"傳送寶珠", "洛丹倫廢墟-提瑞斯法林地",{49.3,15.0}},
		},

		-- Thunder Bluff
		["雷霆崖"]={
		-- 拍賣師
			{"拍賣師", "拍賣師斯塔比",{40.4,52.2}}, -- 8674
			{"拍賣師", "拍賣師古雷姆",{39.0,50.6}}, -- 8722
		-- 銀行職員
			{"銀行職員", "托恩",{46.8,58.4}}, -- 2996
			{"銀行職員", "徹斯姆",{46.4,58.4}}, -- 8356
			{"銀行職員", "阿特帕",{46.4,58.8}}, -- 8357
		-- 飛行管理員
			{"雙足飛龍管理員", "塔爾",{46.8,49.8}}, -- 2995
		-- 旅館老闆
			{"旅館老闆", "旅館老闆帕拉",{45.4,64.2}}, -- 6746
		-- 獸欄管理員
			{"獸欄管理員", "布林魯格",{45.0,59.6}}, -- 10054
		-- 專業訓練師
			{"煉金術訓練師", "本娜•冰蹄",{46.8,33.4}}, -- 3009
			{"考古學訓練師", "歐托•灰皮",{75.3,28.2}}, -- 47572
			{"鍛造訓練師", "卡恩•石蹄",{40.0,55.6}}, -- 2998
			{"烹飪訓練師", "阿絲卡•迷霧行者",{51.0,52.8}}, -- 3026
			{"附魔訓練師", "泰戈•晨行者",{45.2,39.1}}, -- 3011
			{"工程學訓練師", "工程師蒼蹄",{36.4,59.6}}, -- 52651
			{"急救訓練師", "潘德•縛石",{29.3,21.0}}, -- 2798
			{"釣魚訓練師", "卡爾•迷霧行者",{55.8,47.6}}, -- 3028
			{"草藥學訓練師", "克米恩•冰蹄",{49.3,39.5}}, -- 3013
			{"銘文學訓練師", "波什金•哈比德爾",{28.8,20.6}}, -- 30709
			{"珠寶設計訓練師", "娜哈莉•追雲者",{35.6,53.8}}, -- 52657
			{"制皮訓練師", "猶納",{41.8,42.8}}, -- 3007
			{"採礦訓練師", "布瑞克•石蹄",{34.7,57.6}}, -- 3001
			{"剝皮訓練師", "莫蘭塔",{44.6,42.8}}, -- 7089
			{"裁縫訓練師", "坦帕",{44.2,45.0}}, -- 3004
			{"傳送門訓練師", "比爾吉特•克蘭斯頓",{22.0,17.5}}, -- 5957
		-- 職業訓練師
			{"德魯伊訓練師", "圖拉克•符文圖騰",{76.3,27.4}}, -- 3033
			{"德魯伊訓練師", "希爾•符文圖騰",{77.0,28.0}}, -- 3034
			{"德魯伊訓練師", "凱姆•蠻鬃",{76.3,31.0}}, -- 3036
			{"獵人訓練師", "卡瑞•雷角",{58.4,88.0}}, -- 3038
			{"獵人訓練師", "浩特•雷角",{57.4,89.2}}, -- 3039
			{"獵人訓練師", "烏瑞克•雷角",{58.7,85.6}}, -- 3040
			{"法師訓練師", "大法師山姆",{22.8,14.2}}, -- 3047
			{"法師訓練師", "奧松•格魯爾",{25.8,21.6}}, -- 3048
			{"法師訓練師", "瑟斯頓•科薩恩",{27.2,16.6}}, -- 3049
			{"武僧訓練師", "甯神花茶大師冉瑟",{22.6,19.2}}, -- 62462
			{"聖騎士訓練師", "烈日行者賽恩",{63.0,79.8}}, -- 8664
			{"聖騎士訓練師", "烈日行者萊哈",{62.4,79.5}}, -- 43001
			{"聖騎士訓練師", "奧伯妮•亮鬃",{63.2,79.8}}, -- 43795
			{"牧師訓練師", "麥爾斯•威爾什",{22.0,17.6}}, -- 3044
			{"牧師訓練師", "馬拉凱•克羅斯",{24.4,22.1}}, -- 3045
			{"牧師訓練師", "柯布神父",{24.9,20.5}}, -- 3046
			{"牧師訓練師", "先知卡雅",{77.8,27.9}}, -- 43004
			{"牧師訓練師", "塔胡•慧風",{77.3,31.1}}, -- 43796
			{"牧師訓練師", "綠石先知",{75.4,28.5}}, -- 43870
			{"薩滿訓練師", "希恩•逐星",{22.8,20.7}}, -- 3030
			{"薩滿訓練師", "提戈爾•逐星",{23.3,18.4}}, -- 3031
			{"薩滿訓練師", "博拉姆•逐星",{22.2,19.3}}, -- 3032
			{"術士訓練師", "迪拉諾•莫里賽特",{25.3,14.1}}, -- 43881
			{"術士訓練師", "揚森•托馬森",{25.3,14.2}}, -- 43883
			{"術士訓練師", "莫萊拉妮亞•荷爾登",{24.2,15.5}}, -- 43892
			{"戰士訓練師", "托姆•暴怒圖騰",{57.2,88.1}}, -- 3041
			{"戰士訓練師", "薩爾克•暴怒圖騰",{57.3,88.9}}, -- 3042
			{"戰士訓練師", "科爾•暴怒圖騰",{57.9,85.8}}, -- 3043
		-- 商人
			{"雷霆崖軍需官", "衛兵圖霍",{46.8,50.0}}, -- 50483
		-- 其他NPC
			{"公會註冊員", "克拉姆",{37.6,63.0}}, -- 5054
		-- 訓練假人
			{"訓練假人", "訓練假人",{57.0,79.8}}, -- 32666
		-- 交通工具
			{"傳送門", "地獄火半島",{30.8,31.7}},
			{"飛艇", "奧格瑞瑪-杜隆塔爾",{15.7,25.7}},
		},

		-- Undercity
		["幽暗城"]={
		-- 拍賣師
			{"拍賣師", "拍賣師裡卡",{67.8,52.2}}, -- 8672
			{"拍賣師", "拍賣師埃比圖",{64.0,52.2}}, -- 8721
			{"拍賣師", "拍賣師斯托克頓",{71.2,47.0}}, -- 15675
			{"拍賣師", "拍賣師亞爾利",{71.4,41.4}}, -- 15676
			{"拍賣師", "拍賣師凱恩",{67.8,36.0}}, -- 15682
			{"拍賣師", "拍賣師納克雷米斯",{64.0,36.0}}, -- 15683
			{"拍賣師", "拍賣師特裡特",{60.6,41.2}}, -- 15684
			{"拍賣師", "拍賣師雷克爾",{60.6,46.8}}, -- 15686
		-- 銀行職員
			{"銀行職員", "藍道夫•蒙泰古",{66.0,43.0}}, -- 2458
			{"銀行職員", "摩塔莫爾•蒙泰古",{66.8,44.0}}, -- 2459
			{"銀行職員", "威廉•蒙泰古",{65.8,45.2}}, -- 4549
			{"銀行職員", "奧芬利亞•蒙泰古",{65.2,44.0}}, -- 4550
		-- 飛行管理員
			{"蝙蝠管理員", "邁克爾•加勒特",{63.0,48.2}}, -- 4551
		-- 旅館老闆
			{"旅館老闆", "旅館老闆諾曼",{67.6,38.2}}, -- 6741
		-- 獸欄管理員
			{"獸欄管理員", "安雅•瑪爾雷",{67.8,38.6}}, -- 10053
		-- 專業訓練師
			{"煉金術訓練師", "赫伯特•哈爾希醫生",{47.4,72.2}}, -- 4611
			{"考古學訓練師", "亞當•霍薩克",{75.8,37.2}}, -- 47382
			{"鍛造訓練師", "詹姆斯•範•布朗特",{61.2,29.1}}, -- 4596
			{"烹飪訓練師", "尤奈斯•伯奇",{63.6,9.0}}, -- 4552
			{"附魔訓練師", "拉文尼亞•克洛文",{61.8,61.0}}, -- 4616
			{"工程學訓練師", "弗蘭克林•洛伊德",{76.0,73.6}}, -- 11031
			{"急救訓練師", "瑪麗•艾塔斯",{73.4,55.6}}, -- 4591
			{"釣魚訓練師", "阿曼德•克倫威爾",{81.0,31.2}}, -- 4573
			{"草藥學訓練師", "瑪律薩•奧列斯塔",{54.0,49.4}}, -- 4614
			{"銘文學訓練師", "瑪爾迦絲•派克雷",{61.6,58.6}}, -- 30711
			{"珠寶設計訓練師", "內勒爾•費恩",{56.2,36.6}}, -- 52587
			{"制皮訓練師", "亞瑟•摩爾",{70.2,58.6}}, -- 4588
			{"採礦訓練師", "布羅姆•基裡安",{56.0,37.0}}, -- 4598
			{"剝皮訓練師", "基裡安•哈根",{70.4,59.2}}, -- 7087
			{"裁縫訓練師", "喬瑟夫•格裡高利",{70.8,30.0}}, -- 4576
			{"裁縫訓練師", "約瑟芬•李斯特",{86.4,22.4}}, -- 4578
			{"惡魔訓練師", "瑪律薩•斯坦恩",{85.8,15.4}}, -- 5753
			{"傳送門訓練師", "萊克斯頓•莫泰姆",{83.3,15.6}}, -- 2492
		-- 職業訓練師
			{"德魯伊訓練師", "瑪拉•天衛",{55.0,50.6}}, -- 52319
			{"獵人訓練師", "阿波羅斯",{49.2,29.8}}, -- 39116
			{"獵人訓練師", "納薩諾斯•凋零者",{50.0,28.4}}, -- 50609
			{"法師訓練師", "凱利斯蒂亞",{85.8,14.2}}, -- 4566
			{"法師訓練師", "皮爾斯•沙克爾頓",{85.6,14.8}}, -- 4567
			{"法師訓練師", "安娜斯塔西婭•哈特威爾",{85.6,11.0}}, -- 4568
			{"法師訓練師", "不死者德爾勒克",{56.6,17.6}}, -- 23103
			{"武僧訓練師", "簡傲",{56.8,33.2}}, -- 62393
			{"聖騎士訓練師", "塞希婭•黎明玫瑰",{57.8,91.6}}, -- 20406
			{"牧師訓練師", "艾薩萊斯特",{49.6,17.0}}, -- 4606
			{"牧師訓練師", "蘭克斯特神父",{50.0,14.7}}, -- 4607
			{"牧師訓練師", "拉劄魯斯神父",{47.6,19.2}}, -- 4608
			{"盜賊訓練師", "卡洛琳•瓦德",{83.8,73.6}}, -- 4582
			{"盜賊訓練師", "邁爾斯•迪克斯特",{85.0,71.6}}, -- 4583
			{"盜賊訓練師", "格雷戈•查理斯",{85.2,72.4}}, -- 4584
			{"薩滿訓練師", "瑪哈拉•雲歌",{55.0,50.6}}, -- 52317
			{"術士訓練師", "卡爾•噬靈",{85.3,15.3}}, -- 4563
			{"術士訓練師", "盧瑟•匹克曼",{86.1,15.5}}, -- 4564
			{"術士訓練師", "理查•科爾文",{88.1,16.8}}, -- 4565
			{"戰士訓練師", "克里斯多夫•沃克",{46.8,16.5}}, -- 4593
			{"戰士訓練師", "安吉拉•科薩斯",{47.9,15.5}}, -- 4594
			{"戰士訓練師", "巴爾圖斯•弗勒",{46.4,17.6}}, -- 4595
		-- 商人
			{"傳家寶商人", "艾斯特蕾•根德瑞",{78.2,76.6}}, -- 6566
			{"幽暗城軍需官", "多納爾德•亞當斯上尉",{63.6,48.8}}, -- 50304
		-- 其他NPC
			{"公會註冊員", "克里斯多夫•德庫爾",{69.4,44.2}}, -- 4613
			{"美容師", "納茲尼克•蘇薩弗",{71.0,47.2}}, -- 29139
		-- 訓練假人
			{"訓練假人", "團隊副本訓練假人",{54.4,17.7}}, -- ?
			{"訓練假人", "訓練假人",{55.4,17.2}}, -- 31144
			{"訓練假人", "訓練假人",{55.4,16.0}}, -- 32666
		-- 交通工具
			{"傳送門", "地獄火半島",{85.3,17.1}},
		},

		-- Shrine of Two Moons
		["雙月殿"]={
		-- 拍賣師
			{"工程拍賣", "D.E.N.T.",{59.4,43.2},1}, -- 67130
		-- 銀行職員
			{"銀行職員", "寶庫管理者韓恩",{21.4,47.4},2}, -- 63964 -- 二層
			{"銀行職員", "寶庫管理者金硬幣",{23.0,54.8},2}, -- 63965 -- 二層
			{"銀行職員", "寶庫管理者詩風",{22.8,62.2},2}, -- 63966 -- 二層
			{"工程倉庫", "提維裡克斯•本高特",{61.0,44.4},1}, -- 64925
		-- 旅館老闆
			{"旅館老闆", "薇洛夫人",{69.2,49.0},1}, -- 62996
			{"旅館老闆", "酒仙司柯葉",{59.8,75.2},2}, -- 63008
		-- 專業訓練師
			{"鍛造訓練師", "賈魯高•石蹄",{26.2,45.6},1}, -- 64058
			{"工程學訓練師", "古約•晶輪",{60.8,44.0},1}, -- 64924
			{"急救訓練師", "艾拉西尼爾",{29.6,74.2},1}, -- 65862
		-- 商人
			--{"PvE裝備商", "布裡茲克•火刀",{43.2,74.4},2}, -- 73674 "隨機副本商人" -- 二層
			--{"PvE裝備商", "納迪娜•星晶",{43.4,76.0},2}, -- 74010 "團隊副本商人" -- 二層
			--{"PvE裝備商", "奇阿戈努",{43.8,77.8},2}, -- 74012 "英雄副本商人" -- 二層
			--{"PvE裝備商", "圖阿霍•開山",{43.8,80.2},2}, -- 74019 "史詩副本商人" -- 二層
			{"PvE裝備商", "布裡茲克•火刀;圖阿霍•開山;奇阿戈努;納迪娜•星晶",{43.8,77.8},2}, -- 73674/74010/74012/74019
		-- 其他NPC
			{"秘法重鑄師", "魔術師安裘爾",{63.6,19.6},2}, -- 64044 -- 二層
		-- 交通工具
			{"傳送門", "奧格瑞瑪;雷霆崖;幽暗城;銀月城;達拉然;沙塔斯城",{69.8,45.0},2}, -- 二層
		},

		-- Warspear
		["戰爭之矛"]={
		-- 拍賣師
			{"拍賣師", "瑞拉•明棘",{54.2,25.6}}, -- 86635
			{"拍賣師", "夏安•幼蹄",{54.8,25}}, -- 88128
			{"拍賣師", "肖恩•幼蹄",{54.8,26.2}}, -- 88130
			{"拍賣師", "Torm Ironfur",{54.4,25.6}}, -- 88133 -- need translation
		-- 銀行職員
			{"銀行職員", "塔恩•赤拳",{51.6,61.6}}, -- 86631
			{"銀行職員", "烏瑞拉•血石",{52.0,62.4}}, -- 88143
			{"銀行職員", "法蘭•銅庫",{51.6,61.2}}, -- 88451
			{"銀行職員", "羅伊•碎螺",{52.2,62.6}}, -- 88453
		-- 飛行管理員
			{"飛行管理員", "伊拉魯",{44.2,34.2}}, -- 86049
		-- 旅館老闆
			{"旅館老闆", "娜甯•晨光",{44.8,43.6}}, -- 86307
		-- 獸欄管理員
			{"獸欄管理員", "烏佳",{77.2,59}}, -- 86052
		-- 專業訓練師
			{"煉金術訓練師", "克里斯多夫•柯西",{60.8,27.0}}, -- 86009
			{"考古學訓練師", "麗娜•碎輪",{73.4,30.8}}, -- 86033
			{"鍛造訓練師", "馬茲頓•商齒",{74.4,37.0}}, -- 86048
			{"烹飪訓練師", "蓋伊•火眼",{45.2,44.2}}, -- 86029
			{"附魔訓練師", "哈尼克",{78.4,52.6}}, -- 86027
			{"工程學訓練師", "漢•跳箭",{71.4,40.2}}, -- 86012
			{"急救訓練師", "威恩•妙手",{65.2,51.4}}, -- 86034
			{"釣魚訓練師", "布裡克斯•箭投",{69.4,16.4}}, -- 86628
			{"草藥學訓練師", "安東尼•阿裡安",{62.2,30.4}}, -- 86006
			{"銘文學訓練師", "喬魯曼",{76.8,48.0}}, -- 86015
			{"寶石加工訓練師", "亞歷山大•迅鋼",{60.0,40.2}}, -- 86010
			{"制皮訓練師", "布林加•硬皮",{50.0,28.2}}, -- 86032
			{"採礦訓練師", "姆格•石裂",{76.6,38.0}}, -- 86014
			{"剝皮訓練師", "孔達爾•獵誓",{49.0,31.6}}, -- 86028
			{"裁縫訓練師", "塞莎•銀血",{59.0,42.6}}, -- 86004
			{"傳送門訓練師", "薩麥爾•玫刃",{59.2,50.6}}, -- 88255
		-- 商人
			-- 軍需官
			--{"PvP裝備商", "碎拳中尉",{48.8,57.3}}, -- 87774 榮耀印記 "Primal Honor"
			--{"PvP裝備商", "斬斧中尉",{48.8,56.6}}, -- 88569 榮耀印記 "Primal Conquest"
			--{"PvP裝備商", "Fobbly Kickfix",{49.2,56.8}}, -- 93908 榮耀印記 "Wild Honor Quartermaster" -- need translation
			--{"PvP裝備商", "Cladd Dawnstrider",{49.2,56.4}}, -- 93909 榮耀印記 "Wild Conquest Quartermaster" -- need translation
			--{"PvP裝備商", "Legionnaire Gutcrush",{49.0,57.2}}, -- 93911/93912 榮耀印記 "Elite Conquest Quartermaster" -- need translation
			--{"PvP裝備商", "Tae'loxe Soulshrivel",{49.0,57.0}}, -- 93916 榮耀印記 "Warmongering Honor Quartermaster" -- need translation
			--{"PvP裝備商", "Malukah Lightsong",{49.0,57.2}}, -- 93917 榮耀印記 "Warmongering Conquest Quartermaster" -- need translation
			{"PvP裝備商", "碎拳中尉;斬斧中尉,etc.",{48.8,57.3}}, -- 87774/88569/93908/93909/93911/93912/93916/93917
			-- 派系
			--{"鴉人流亡者軍需官", "暗影賢者巴考斯",{53.6,60.2}}, -- 85946
			--{"霜狼氏族軍需官", "貝斯卡•赤牙",{53.6,62.0}}, -- 86036
			--{"熱砂軍需官", "米米•響泡",{53.8,60.8}}, -- 88493
			{"軍需官", "霜狼氏族;鴉人流亡者;熱砂",{53.8,60.8}}, -- 85946/86036/88493
			-- 其他
			{"圖紙商人", "托格•菲力克辛頓",{42.8,36.6}}, -- 85840
			--{"埃匹希斯商人", "覓晨者寇里克",{66.6,63.8}}, -- 86376 "埃匹希斯頭盔商人"
			--{"埃匹希斯商人", "覓晨者吉克拉",{66.6,63.6}}, -- 86378 "埃匹希斯斗篷商人"
			--{"埃匹希斯商人", "覓晨者利克斯",{65.8,64.6}}, -- 86379 "埃匹希斯手套商人"
			--{"埃匹希斯商人", "覓晨者阿克賽特",{65.6,64.6}}, -- 86382 "埃匹希斯護腿商人"
			--{"埃匹希斯商人", "Dawn-Seeker Kayrek",{65.6,64.2}}, -- 91322 "埃匹希斯護腕商人" -- need translation
			--{"埃匹希斯商人", "Dawn-Seeker Skariss",{66.2,62.8}}, -- 92503 "埃匹希斯腰帶商人" -- need translation
			{"埃匹希斯商人", "頭盔;斗篷;手套;護腿;護腕;腰帶",{66.6,63.8}}, -- 86376/86378/86379/86382/91322/92503
		-- 訓練假人
			{"訓練假人", "團隊副本訓練假人",{70.0,57.2}}, -- 87762
			{"訓練假人", "訓練假人",{69.0,58.6}}, -- 88835
			{"訓練假人", "地下城訓練假人",{69.4,56.0}}, -- 88836
			{"訓練假人", "團隊副本訓練假人",{68.8,57.0}}, -- 88837
		-- 交通工具
			{"傳送門", "奧格瑞瑪-杜隆塔爾",{59.9,52.1}},
			{"傳送門", "雷霆崖-莫高雷",{50.6,23.6}},
			{"傳送門", "幽暗城-提瑞斯法林地",{62.5,22.8}},
		},

		-- [BC] Shattrath City
		["沙塔斯城"]={
		-- 拍賣師
			{"拍賣師", "拍賣師卡拉倫",{56.9,62.4}}, -- 50139
			{"拍賣師", "拍賣師賴爾莎拉",{56.9,62.4}}, -- 50140
			{"拍賣師", "拍賣師伊托蘭",{50.8,26.6}}, -- 50143
			{"拍賣師", "拍賣師布拉庫",{51.2,27.2}}, -- 50145
		-- 銀行職員
			{"奧爾多銀行職員", "門度恩",{47.8,29.0}}, -- 19034
			{"占星者銀行職員", "比魯達•秘誓",{60.2,60.6}}, -- 19246
			{"奧爾多銀行職員", "格魯登",{48.2,29.0}}, -- 19318
			{"占星者銀行職員", "魯拉•金刺",{59.8,60.6}}, -- 19338
		-- 飛行管理員
			{"飛行管理員", "努特拉爾",{63.8,41.0}}, -- 18940
		-- 旅館老闆
			{"奧爾多旅館老闆", "米娜蕾",{28.0,49.2}}, -- 19046
			{"占星者旅館老闆", "旅館老闆海索恩",{55.8,80.8}}, -- 19232
		-- 獸欄管理員
			{"占星者獸欄管理員", "伊蘇瑞爾",{56.6,79.6}}, -- 21517
			{"奧爾多獸欄管理員", "奧爾魯赫",{28.4,47.4}}, -- 21518
		-- 專業訓練師
			{"煉金術訓練師", "羅羅基姆",{45.8,20.4}}, -- 19052
			{"占星者煉金術訓練師", "埃爾辛",{38.6,71.8}}, -- 33630
			{"奧爾多煉金術訓練師", "煉金師卡恩胡",{39.2,29.4}}, -- 33674
			{"考古學訓練師", "搜尋者波杜魯",{62.6,70.0}}, -- 47575
			{"鍛造訓練師", "克拉度•利刃",{69.8,42.4}}, -- 20124
			{"鍛造訓練師", "祖拉•熔怒",{69.8,42.2}}, -- 20125
			{"占星者鍛造訓練師", "巴厘爾",{43.6,65.2}}, -- 33631
			{"奧爾多鍛造訓練師", "奧努度",{37.6,31.2}}, -- 33675
			{"烹飪訓練師", "傑克•塔博爾",{62.8,68.4}}, -- 19185
			{"烹飪訓練師", "凱蕾妮",{74.8,31.2}}, -- 19186
			{"占星者附魔訓練師", "附魔師沃拉莉",{43.6,92.4}}, -- 19251
			{"占星者附魔訓練師", "高階附魔師巴爾杜蘭",{43.1,92.4}}, -- 19252
			{"占星者附魔訓練師", "附魔師安蒂亞拉",{56.2,74.4}}, -- 33633
			{"奧爾多附魔訓練師", "蘇蕾",{36.4,44.6}}, -- 33676
			{"占星者工程學訓練師", "工程師辛蓓",{43.6,65.2}}, -- 33634
			{"奧爾多工程學訓練師", "技師米希拉",{37.6,31.6}}, -- 33677
			{"急救訓練師", "米爾蕾•弗萊徹爾",{66.6,13.6}}, -- 19184
			{"占星者草藥學訓練師", "草藥學家奧萊拉",{38.3,72.0}}, -- 33639
			{"奧爾多草藥學訓練師", "吉嘉",{38.2,30.0}}, -- 33678
			{"占星者銘文學訓練師", "抄寫員蘭羅爾",{56.6,74.5}}, -- 33638
			{"奧爾多銘文學訓練師", "記錄員利迪歐",{36.2,44.6}}, -- 33679
			{"奧爾多珠寶設計訓練師", "哈曼納爾",{35.8,20.6}}, -- 19063
			{"占星者珠寶設計訓練師", "吉蕾布莉•銀絲",{58.6,75.2}}, -- 33637
			{"奧爾多珠寶設計訓練師", "奈米哈",{36.2,47.0}}, -- 33680
			{"制皮訓練師", "達爾瑪裡",{67.2,67.0}}, -- 19187
			{"占星者制皮訓練師", "戴恩瑞爾",{41.9,63.8}}, -- 33635
			{"奧爾多制皮訓練師", "庫裡姆",{37.5,28.6}}, -- 33681
			{"占星者採礦訓練師", "韓里爾",{58.1,75.0}}, -- 33640
			{"奧爾多採礦訓練師", "弗諾",{36.0,48.4}}, -- 33682
			{"剝皮訓練師", "塞莫爾",{64.6,66.2}}, -- 19180
			{"占星者剝皮訓練師", "伊爾杜",{40.9,63.4}}, -- 33641
			{"奧爾多剝皮訓練師", "德雷姆",{37.6,27.9}}, -- 33683
			{"占星者裁縫訓練師", "米拉麗絲",{41.8,63.6}}, -- 33636
			{"奧爾多裁縫訓練師", "編織者歐爾",{37.6,27.8}}, -- 33684
			{"占星者傳送門訓練師", "米爾卡•遠步",{43.2,93.2}}, -- 19340
			{"傳送門訓練師", "艾歐莉婭",{56.8,48.0}}, -- 20791
			-- 書櫃
			{"煉金術訓練師", "書櫃",{44.2,90.4}}, -- 33608
			{"鍛造訓練師", "書櫃",{44.0,89.4}}, -- 33609
			{"烹飪訓練師", "書櫃",{43.6,91.0}}, -- 33619
			{"附魔訓練師", "書櫃",{43.8,90.2}}, -- 33610
			{"工程學訓練師", "書櫃",{43.8,89.4}}, -- 33611
			{"急救訓練師", "書櫃",{43.8,90.4}}, -- 33621
			{"釣魚訓練師", "書櫃",{43.6,91.0}}, -- 33623
			{"草藥學訓練師", "書櫃",{43.8,90.2}}, -- 33616
			{"銘文學訓練師", "書櫃",{43.4,90.6}}, -- 33615
			{"珠寶設計訓練師", "書櫃",{43.6,90.8}}, -- 33614
			{"制皮訓練師", "書櫃",{43.8,90.4}}, -- 33612
			{"採礦訓練師", "書櫃",{43.6,90.8}}, -- 33617
			{"剝皮訓練師", "書櫃",{43.6,90.8}}, -- 33618
			{"裁縫訓練師", "書櫃",{44.4,90.2}}, -- 33613
		-- 職業訓練師
			{"德魯伊訓練師", "貝里爾",{59.2,47.6}}, -- 50136
			{"德魯伊訓練師", "穆哈",{59.2,47.6}}, -- 50137
			{"占星者獵人訓練師", "德麗瑟拉",{52.2,52.2}}, -- 50007
			{"奧爾多獵人訓練師", "伊爾瓦",{52.8,37.6}}, -- 50020
			{"占星者法師訓練師", "阿拉萊莎",{52.2,51.0}}, -- 50010
			{"奧爾多法師訓練師", "拉魯希",{55.6,37.6}}, -- 50021
			{"占星者聖騎士訓練師", "血騎士阿爾格隆",{52.8,52.6}}, -- 50012
			{"奧爾多聖騎士訓練師", "歐爾多",{55.8,37.2}}, -- 50023
			{"占星者牧師訓練師", "護理者伊莎瑪拉",{52.0,51.4}}, -- 50013
			{"奧爾多牧師訓練師", "薩爾哈",{55.6,36.6}}, -- 50024
			{"占星者盜賊訓練師", "尋路者阿爾帕里爾",{52.2,52.4}}, -- 50016
			{"盜賊訓練師", "風之獵手埃弗拉姆",{59.2,46.6}}, -- 50127
			{"奧爾多薩滿訓練師", "達拉胡",{55.6,37.0}}, -- 50019
			{"薩滿訓練師", "盧克納爾",{58.2,47.1}}, -- 50130
			{"占星者術士訓練師", "召喚著杜雷爾",{51.8,52.0}}, -- 50017
			{"術士訓練師", "惡魔召喚者古洛圖",{58.6,47.6}}, -- 50128
			{"占星者戰士訓練師", "塔爾希爾",{52.3,52.9}}, -- 50018
			{"奧爾多戰士訓練師", "布拉圖",{56.0,37.6}}, -- 50025
		-- 商人
			-- 軍需官
			{"占星者PvE裝備商", "阿羅迪斯•炎刃",{42.6,90.6}}, -- 20613
			{"奧爾多PvE裝備商", "阿蘇爾",{23.6,32.6}}, -- 20616
			{"占星者PvE裝備商", "威恩娜•晨星",{44.8,91.6}}, -- 21905
			{"奧爾多PvE裝備商", "克爾拉蘭",{24.8,27.0}}, -- 21906
			-- 派系
			{"奧爾多軍需官", "軍需官恩達爾林",{48.0,26.6}}, -- 19321
			{"占星者軍需官", "軍需官恩努利爾",{60.6,64.2}}, -- 19331
			{"沙塔爾軍需官", "奧瑪多爾",{51.6,41.6}}, -- 21432
			{"貧民窟軍需官", "納克杜",{62.6,69.0}}, -- 21655
			-- 其他商人
			{"燃燒的遠征時空漫遊商人", "凱普麗",{54.6,39.6}}, -- 98685
			{"寶石商人", "利薩爾絲•血目",{54.6,82.6}}, -- 19330
			{"<巨無霸背包>商人", "哈莉絲•西爾頓",{75.6,31.6}}, -- 18756
		-- 其他NPC
			{"公會註冊員", "德羅哈",{58.8,46.4}}, -- 52277
		-- 訓練假人
			--{"訓練假人", "傷害訓練假人",{59.0,52.6}}, -- 83552
			--{"訓練假人", "治療訓練假人",{29.6,46.8}}, -- 83565
			--{"訓練假人", "坦克訓練假人",{62.8,39.4}}, -- 83574
		-- 交通工具
			{"傳送門", "暴風城;奧格瑞瑪",{59.0,46.7}},
			{"傳送門", "奎爾丹納斯島",{47.9,41.8}},
		},

		-- [CATA] Darkmoon Island
		["暗月島"]={
		-- 專業訓練師
			{"釣魚訓練師", "斯蒂芬•斯塔格納羅",{52.6,88.4}}, -- 56068
		-- 商人
			--{"紀念品與玩具商人", "吉瓦斯•格里加特",{48.0,64.8}}, -- 14828
			--{"寵物坐騎商人", "蘭拉",{48.2,69.4}}, -- 14846
			{"暗月卡片商人", "薩杜斯•帕雷教授",{51.8,60.6}}, -- 14847
			--{"仿製護甲商人", "巴倫姆",{47.6,66.2}}, -- 55072
			{"釣魚獎勵商人", "加里莎•日露",{52.4,88.4}}, -- 55103
			{"傳家寶商人", "迪蘭德•晨峰",{47.8,66.6}}, -- 56335
			--{"仿製護甲商人", "巴倫瑪",{47.6,66.2}}, -- 57983
			{"禮服奇物商人", "賈斯特",{51.2,75.0}}, -- 85484
			{"商人", "寵物坐騎;仿製護甲;玩具紀念品",{48.2,69.4}}, -- 14828/14846/55072/57983
			{"血色軍需官","出售:裁壞的血色十字軍戰袍;血色十字軍鱗甲鎖甲套裝",{58.0,80.6}}, -- 108785
		-- 交通工具
			{"傳送門", "艾爾文森林;莫高雷",{51.2,23.2}},
			{"回程傳送門", "艾爾文森林;莫高雷",{50.5,90.2}},
		},

		-- Dalaran -- need update
		["達拉然"]={
		-- 1層 暗影大廳;2層 達拉然; 3層 達拉然下水道; 4層 艾格文的畫廊
		-- 拍賣師
			--{"聯盟蒸汽動力拍賣師","布拉斯博特•機鉗",{39.0,26.6},1}, -- 35594
			--{"部落蒸汽動力拍賣師","雷迦納德•弧炎",{38.8,25.2},1}, -- 35607
			{"聯盟蒸汽動力拍賣師","布拉斯博特•機鉗",{37.1,54.8},1}, -- 35594
			{"部落蒸汽動力拍賣師","雷迦納德•弧炎",{65.5,23.5},1}, -- 35607
			{"蒸汽動力拍賣師","[A]布拉斯博特•機鉗;[H]雷迦納德•弧炎",{39.0,26.6},1}, -- 35594/35607
		-- 銀行職員
			{"銀行職員","出納員拉莫斯",{52.6,14.8},1}, -- 28675
			{"銀行職員","出納員奧西裡斯",{54.4,15.8},1}, -- 28676
			{"銀行職員","出納員哈娜",{53.4,15.4},1}, -- 28677
			{"銀行職員","出納員奧斯丁",{53.2,14.6},1}, -- 29282
			{"銀行職員","出納員奧爾米達",{44.0,80.0},1}, -- 30604
			{"銀行職員","出納員吉恩",{43.2,79.4},1}, -- 30605
			{"銀行職員","出納員查恩",{43.4,80.2},1}, -- 30606
			{"銀行職員","出納員普萊施尼爾",{42.4,78.8},1}, -- 30607
			{"銀行職員","出納員阿瑪迪",{42.6,79.6},1}, -- 30608
			{"銀行職員","賓茲克•戈布克",{32.6,55.4},2}, -- 29530 -- 達拉然下水道
		-- 飛行管理員
			{"飛行管理員","奧魯丹•白雲",{72.8,45.6},1}, -- 28674
		-- 旅館老闆
			{"旅館老闆","艾米絲•埃索蓋斯",{50.0,39.2},1}, -- 28687
			{"聯盟旅館老闆","伊絲拉米•輕風",{44.6,63.0},1}, -- 32413
			{"部落旅館老闆","獸女烏達",{64.6,32.4},1}, -- 31557
			{"旅館老闆","埃因•格林",{35.6,56.8},2}, -- 29532 -- 達拉然下水道
		-- 獸欄管理員
			{"獸欄管理員","塔西婭•幽谷",{59.4,37.6},1}, -- 28690
		-- 專業訓練師
			{"煉金術訓練師", "林奇•黑箭",{42.4,32.0},1}, -- 28703
			{"考古學訓練師", "博學者達瑞妮斯",{48.6,38.4},1}, -- 47579
			{"鍛造訓練師", "奧拉爾德•施米爾",{45.4,28.0},1}, -- 28694
			{"鍛造訓練師", "伊曼蒂爾•鋒歌",{45.4,28.6},1}, -- 29505
			{"鍛造訓練師", "奧蘭德•夏菲爾",{44.8,28.6},1}, -- 29506
			{"聯盟烹飪訓練師", "凱薩琳•李",{40.4,65.8},1}, -- 28705
			{"部落烹飪訓練師", "埃維羅•隆古巴",{70.0,39.0},1}, -- 29631
			{"附魔訓練師", "附魔師納薩尼斯",{39.0,40.2},1}, -- 28693
			{"工程學訓練師", "迪墨菲•歐申克",{38.8,25.8},1}, -- 28697
			{"工程學訓練師", "鉗工蒂迪",{39.4,25.2},1}, -- 29513
			{"工程學訓練師", "芬德爾•汽哨",{39.2,25.0},1}, -- 29514
			{"急救訓練師", "善良的歐麗莎拉",{36.8,37.0},1}, -- 28706
			{"釣魚訓練師", "瑪西婭•切斯",{52.6,64.8},1}, -- 28742
			{"飛行訓練師", "希拉•雪晨",{70.0,45.4},1}, -- 31238
			{"草藥學訓練師", "多蘿希•埃根",{43.2,34.2},1}, -- 28704
			{"銘文學訓練師", "帕林教授",{41.8,36.8},1}, -- 28702
			{"珠寶設計訓練師", "提莫斯•鐘斯",{40.4,35.0},1}, -- 28701
			{"制皮訓練師", "蒂亞妮•坎寧斯",{35.0,26.6},1}, -- 28700
			{"制皮訓練師", "曼弗萊德•斯塔勒",{34.2,29.2},1}, -- 29507
			{"制皮訓練師", "安德里奧",{34.2,27.4},1}, -- 29508
			{"制皮訓練師", "娜穆•月水",{36.2,29.8},1}, -- 29509
			{"採礦訓練師", "傑迪安•漢德爾斯",{41.2,27.0},1}, -- 28698
			{"剝皮訓練師", "迪爾克•馬克斯",{35.2,28.4},1}, -- 28696
			{"裁縫訓練師", "查理•沃爾斯",{36.2,33.6},1}, -- 28699
			{"傳送門訓練師", "大法師塞琳德拉",{56.6,46.6},1}, -- 29156
		-- 職業訓練師
			{"法師訓練師", "戰爭法師法諾萊斯",{55.8,48.8},1}, -- 28956
			{"法師訓練師", "葉薩•維爾",{56.0,46.6},1}, -- 28958
			{"聯盟德魯伊訓練師", "穆蘭•法爾登",{38.0,63.4},1}, -- 50171
			{"聯盟獵人訓練師", "遊俠塞羅妮",{39.6,62.8},1}, -- 50157
			{"聯盟聖騎士訓練師", "魯倫•光賜",{39.6,62.6},1}, -- 50160
			{"聯盟牧師訓練師", "監護者阿蕾蘇",{38.6,63.8},1}, -- 50163
			{"聯盟盜賊訓練師", "尋路者賴爾瑟",{38.6,64.6},1}, -- 50158
			{"聯盟薩滿訓練師", "先知羅帕雅",{38.0,64.8},1}, -- 50174
			{"聯盟術士訓練師", "召喚者諾爾裡克",{38.6,64.6},1}, -- 50156
			{"聯盟戰士訓練師", "納西弗",{39.6,62.6},1}, -- 50155
			{"部落德魯伊訓練師", "哈娜•月巔",{57.6,24.2},1}, -- 50152
			{"部落獵人訓練師", "遊俠伊歐斯",{59.2,26.6},1}, -- 50144
			{"部落聖騎士訓練師", "尼魯爾•光誓",{59.6,24.8},1}, -- 50150
			{"部落牧師訓練師", "監護者奧瑟拉",{58.0,27.6},1}, -- 50148
			{"部落盜賊訓練師", "尋路者裡瑟拉",{58.2,28.6},1}, -- 50147
			{"部落薩滿訓練師", "調諧者莫爾格哈",{57.6,24.6},1}, -- 50153
			{"部落術士訓練師", "召喚者喀爾文",{57.0,27.8},1}, -- 50142
			{"部落戰士訓練師", "文恩蘇恩",{59.6,24.8},1}, -- 50149
		-- 商人
			-- 軍需官
			{"肯瑞托軍需官", "大法師奧瓦利斯",{25.8,46.2},1}, -- 32287
			--{"聯盟PvE裝備商", "奧術師埃杜林",{37.6,54.8},1}, -- 31579 "傳承正義軍需官"
			--{"聯盟PvE裝備商", "奧術師艾弗蕾妮",{37.0,55.0},1}, -- 31580 "傳承正義軍需官"
			--{"聯盟PvE裝備商", "奧術師菲賴爾",{38.6,55.0},1}, -- 33964 "傳承正義軍需官"
			--{"聯盟PvE裝備商", "奧術師米露蕊婭",{37.8,54.6},1}, -- 35494 "傳承正義軍需官"
			--{"聯盟PvE裝備商", "奧術師尤維爾",{38.6,53.6},1}, -- 37942 "傳承正義軍需官"
			{"聯盟PvE裝備商", "奧術師埃杜林;奧術師艾弗蕾妮,etc.",{37.6,54.8},1}, -- 31579/31580/33964/35494/37942
			--{"部落PvE裝備商", "魔導師布拉塞爾",{65.8,23.6},1}, -- 31581
			--{"部落PvE裝備商", "魔導師拉姆布莉絲",{65.6,23.6},1}, -- 31582
			--{"部落PvE裝備商", "魔導師薩雷恩",{65.6,24.0},1}, -- 33963
			--{"部落PvE裝備商", "魔導師維莎拉",{65.6,23.2},1}, -- 35495
			--{"部落PvE裝備商", "魔導師奧爾蘭",{65.6,23.6},1}, -- 37941
			{"部落PvE裝備商", "魔導師布拉塞爾;魔導師拉姆布莉絲,etc.",{65.8,23.6},1}, -- 31581/31582/33963/35495/37941
			-- 裝備商
			{"PvE裝備商", "板甲;盾牌",{46.8,28.0},1}, -- 28997/34252/35498|28990
			{"PvE裝備商", "布甲;披風;腳部裝備",{43.8,49.2},1}, -- 28995/35496|29495|29703
			{"PvE裝備商", "副手;飾品",{49.0,54.6},1}, -- 29527|29528
			{"PvE裝備商", "單手劍;匕首;拳套",{54.0,61.4},1}, -- 28991|29499
			{"PvE裝備商", "鎖甲;皮甲",{51.6,72.6},1}, -- 28992/35497|29523/35500
			-- 其他商人
			{"坐騎寵物商人", "布琳妮;梅爾•弗蘭希斯",{58.6,39.6},1}, -- 28951/32216
			{"玩具商人", "耶比托•喬巴斯;發條助手",{44.6,46.0},1}, -- 29478/29716
			{"肯瑞托飾品商人", "哈樂德•溫斯頓",{38.4,33.8},1}, -- 32172
			{"物品兌換商人", "夢境碎片;厚北地皮;戰爭約束者墨水;冰凍寶珠",{42.8,35.6},1}, -- 32514/32515/33027/40160
			{"法師<奧術語言/幻覺技能書>與玩具商人","恩多拉•莫爾海德",{38.6,53.8},1}, -- 28715 -- 逆風小徑同名NPC 99337
			{"獵人<煙花技能書>商人","比爾亞•蘭德斯",{39.0,26.0},1}, -- 28722
			{"巫妖王之怒時空漫遊商人", "奧金",{50.6,46.6},1}, -- 98690
			--達拉然下水道
			{"PvE裝備商","赫塞爾•加洛特",{60.6,11.8},2}, -- 29538
			{"PvP裝備商","S5L;S5M;S5H;S6;S7;S8;S9H;S10;S11",{59.4,58.0},2}, -- 30885/40212/69318/69321/69971/69973 "暴怒角鬥士Wrathful" "憎恨角鬥士Hateful" "兇殘角鬥士Savage" "災變角鬥士Cataclysmic" "冷酷角鬥士Ruthless" "殘忍角鬥士Vicious" "狂怒角鬥士Furious" "致命角鬥士Deadly" "無情角鬥士Relentless"
			{"技能書商人","卡維茲•洛典(刷新機制未知.售賣薩滿<妖術:蟑螂>技能書;盜賊<偵測>技能書,;牧師玩具;燃盡雕文配方)",{47.0,28.0},2}, -- 106887
		-- 其他NPC
			{"公會註冊員","安德魯•馬休",{51.4,54.4},1}, -- 28774
			{"美容師","吉茲•考波克利",{52.8,31.2},1}, -- 28708
		-- 交通工具
			{"入口","達拉然下水道",{60.4,47.4},1},
			{"傳送寶珠","紫羅蘭哨站-晶歌森林",{56.0,46.8},1},
			{"傳送門","時光之穴-塔納利斯;紫色天臺",{25.2,47.7},1},
			{"傳送門","暴風城-艾爾文森林",{39.9,62.8},1},
			{"傳送門","冬擁湖",{33.6,68.8},1},
			{"傳送門","戰歌峽谷;阿拉希盆地;奧特蘭克山谷;風暴之眼;征服之島;遠古海灘",{29.7,75.8},1},
			{"傳送門","奧格瑞瑪-杜隆塔爾",{55.6,25.6},1},
			{"傳送門","冬擁湖;阿拉希盆地;風暴之眼;征服之島",{58.1,25.8},1},
			{"傳送門","戰歌峽谷;奧特蘭克山谷;遠古海灘",{61.2,16.4},1},
		},

		-- Deeprun Tram
		["礦道地鐵"]={
			{"入口", "比茲莫搏擊俱樂部",{52.5,69.8}},
		-- 比茲莫搏擊俱樂部
			{"比茲莫搏擊俱樂部軍需官", "奎肯布希",{54.4,25.0},2}, -- 68363
			{"稀有與奢侈飲料商人", "莫茲爾•輪須",{27.0,62.8},2}, -- 70719
			{"奢侈食品商人", "賈斯法夫人",{25.6,70.8},2}, -- 70723
			{"卡牌商人", "卡牌商人蕾拉",{52.2,25.2},2}, -- 70752
		},

		-- [MISTS] Brawl'gar Arena
		["搏擊競技場"]={
			{"搏擊競技場軍需官", "保爾•諾斯",{50.9,29.2}}, -- 68364
			--{"稀有與奢侈飲料商人", "哈克西爾•酒神",{,}}, -- 70713 -- need update
			--{"奢侈食品商人", "哈爾•灰鬃",{,}}, -- 70714 -- need update
			{"卡牌商人", "卡牌商人阿彌",{60.3,77.2}}, -- 70751
		},

	-- 卡利姆多 Kalimdor
		-- Azuremyst Isle
		["秘藍島"]={
		-- 飛行管理員
			{"飛行管理員", "薩爾達恩",{49.6,49.2},0}, -- 43991
		-- 旅館老闆
			{"旅館老闆", "看護員謝爾蘭",{48.4,49.2},0}, -- 16553
		-- 獸欄管理員
			{"獸欄管理員", "伊斯比納",{49,49.8},0}, -- 17485
		-- 專業訓練師
			{"煉金術訓練師", "丹達爾",{48.4,51.4},0}, -- 17215
			{"鍛造訓練師", "鐵匠卡裡普索",{46.4,71.0},0}, -- 17245
			{"烹飪訓練師", "“曲奇”米維克索斯",{46.6,70.4},0}, -- 17246
			{"附魔訓練師", "瓦倫",{48.6,52.2},0}, -- 47431
			{"工程學訓練師", "技師戴羅",{48.4,50.2},0}, -- 17222
			{"工程學訓練師", "瓦倫",{48.6,52.2},0}, -- 47431
			{"急救訓練師", "學者法蒂瑪",{48.4,51.8},0}, -- 17214
			{"釣魚訓練師", "迪泰娜",{61.0,54.2},0}, -- 17101
			{"草藥學訓練師", "赫羅",{48.2,51.2},0}, -- 17983
			{"草藥學訓練師", "瓦倫",{48.6,52.2},0}, -- 47431
			{"珠寶設計訓練師", "瓦倫",{48.6,52.2},0}, -- 47431
			{"制皮訓練師", "莫多",{44.8,23.8},0}, -- 17442
			{"採礦訓練師", "杜爾維",{48.8,51.0},0}, -- 17488
			{"採礦訓練師", "瓦倫",{48.6,52.2},0}, -- 47431
			{"剝皮訓練師", "古爾弗",{44.6,23.4},0}, -- 17441
			{"裁縫訓練師", "艾林•凱利",{46.4,70.6},0}, -- 17487
			{"裁縫訓練師", "瓦倫",{48.6,52.2},0}, -- 47431
		-- 交通工具
			{"船舶", "魯瑟蘭村-泰達希爾",{29.3,28.2},0},
		},

		-- Teldrassil
		["泰達希爾"]={
		-- 飛行管理員
			{"角鷹獸管理員", "維斯派塔斯",{55.4,88.4},0}, -- 3838
			{"角鷹獸管理員", "菲德利奧",{55.4,50.4},0}, -- 40553
		-- 旅館老闆
			{"旅館老闆", "旅館老闆凱達米爾",{55.4,52.2},0}, -- 6736
		-- 獸欄管理員
			{"獸欄管理員", "瑟裡亞迪",{56.2,52.0},0}, -- 10051
		-- 專業訓練師
			{"煉金術訓練師", "塞恩德拉•細語者",{57.0,53.0},0}, -- 3603
			{"烹飪訓練師", "紮瑞恩",{56.6,53.4},0}, -- 6286
			{"附魔訓練師", "奧蘭納•鴉眼",{39.0,30.0},0}, -- 3606
			{"急救訓練師", "拜恩希",{55.0,49.6},0}, -- 6094
			{"釣魚訓練師", "安多爾•橡木之手",{54.0,89.8},0}, -- 3607
			{"銘文學訓練師", "瑪洛尼•刃葉",{57.0,53.0},0}, -- 3604
			{"制皮訓練師", "納迪婭•織發",{43.4,43.2},0}, -- 3605
			{"制皮訓練師", "伊蘭尼斯•影花",{56.0,52.2},0}, -- 47420
			{"剝皮訓練師", "拉德納爾•織發",{43.6,43.8},0}, -- 6287
			{"剝皮訓練師", "伊蘭尼斯•影花",{56.0,52.2},0}, -- 47420
		-- 交通工具
			{"船舶", "瓦拉爾港口-秘藍島",{52.3,59.5},0},
			{"船舶", "暴風城港口-暴風城",{55.0,93.7},0},
			{"界門", "達納蘇斯-泰達希爾",{55.1,88.5},0},
		},

		-- Durotar
		["杜隆塔爾"]={
		-- 飛行管理員
			{"飛行管理員", "波洛克",{53.0,43.6},0}, -- 41140
			{"蝙蝠管理員", "管理員曼雷克",{55.4,73.4},0}, -- 41142
		-- 旅館老闆
			{"旅館老闆", "旅館老闆格羅斯克",{51.6,41.6},0}, -- 6928
		-- 獸欄管理員
			{"獸欄管理員", "蘇亞米",{52.0,41.8},0}, -- 9987
		-- 專業訓練師
			{"煉金術訓練師", "米奧贊",{55.4,74.0},0}, -- 3184
			{"煉金術訓練師", "倫達",{52.8,42.0},0}, -- 47418
			{"鍛造訓練師", "杜克",{52.0,40.6},0}, -- 3174
			{"工程學訓練師", "穆德拉克",{52.2,40.8},0}, -- 11025
			{"急救訓練師", "拉烏克",{54.0,42.0},0}, -- 5943
			{"釣魚訓練師", "勞迪克",{57.2,77.0},0}, -- 5941
			{"草藥學訓練師", "米什基",{55.6,75.2},0}, -- 3185
			{"草藥學訓練師", "倫達",{52.8,42.0},0}, -- 47418
			{"制皮訓練師", "倫達",{52.8,42.0},0}, -- 47418
			{"騎術訓練師", "克薩爾迪",{55.2,75.4},0}, -- 7953
			{"剝皮訓練師", "倫達",{52.8,42.0},0}, -- 47418
			{"惡魔訓練師", "基薩",{54.6,41.4},0}, -- 6027
		},

		-- Mulgore
		["莫高雷"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "塔克",{47.4,58.6},0}, -- 40809
		-- 旅館老闆
			{"旅館老闆", "旅館老闆考烏斯",{46.8,60.4},0}, -- 6747
		-- 獸欄管理員
			{"獸欄管理員", "希克瓦",{47.0,59.6},0}, -- 10050
		-- 專業訓練師
			{"烹飪訓練師", "派爾•沉默行者",{45.6,57.6},0}, -- 3067
			{"工程學訓練師", "圖茲維克•斯普格林",{61.2,32.6},0}, -- 10993
			{"急救訓練師", "維爾拉•幼蹄",{46.8,60.2},0}, -- 5939
			{"釣魚訓練師", "尤薩恩•靜水",{44.8,60.0},0}, -- 5938
			{"草藥學訓練師", "拉魯姆•黑鬃",{46.4,57.6},0}, -- 47419
			{"制皮訓練師", "查爾•硬皮",{45.8,57.4},0}, -- 3069
			{"採礦訓練師", "拉魯姆•黑鬃",{46.4,57.6},0}, -- 47419
			{"騎術訓練師", "卡爾•雷歌",{47.6,58.0},0}, -- 3690
			{"剝皮訓練師", "姚恩•深刺",{45.8,57.4},0}, -- 6290
		},

		-- Bloodmyst Isle
		["秘血島"]={
		-- 飛行管理員
			{"角鷹獸管理員", "蘭度",{57.6,54.0}}, -- 17554
		-- 旅館老闆
			{"旅館老闆", "托菲爾•羅阿",{55.6,59.6}}, -- 17553
		-- 獸欄管理員
			{"獸欄管理員", "阿斯圖",{55.0,59.8}}, -- 17666
		-- 專業訓練師
			{"急救訓練師", "學者菲索斯",{54.6,54.0}}, -- 17424
			{"草藥學訓練師", "莫萊",{56.2,54.2}}, -- 17434
			{"採礦訓練師", "勘探者納克蘭",{53.2,57.6}}, -- 18804
		},

		-- Darkshore
		["黑海岸"]={
		-- 飛行管理員
			{"角鷹獸管理員", "特爾迪娜•月羽",{51.6,17.6}}, -- 3841
			{"飛行管理員", "德拉莉亞",{44.4,75.4}}, -- 33253
		-- 旅館老闆
			{"旅館老闆", "旅館老闆凱特蘭",{51.0,18.6}}, -- 43420
		-- 獸欄管理員
			{"獸欄管理員", "賈琳希亞",{50.4,19.2}}, -- 10085
		-- 專業訓練師
			{"考古學訓練師", "史蒂芬妮•克魯希克",{50.6,20.6}}, -- 51997
			{"鍛造訓練師", "泰耶爾•焰擊",{50.8,19.2}}, -- 43429
			{"工程學訓練師", "潔娜•雷姆尼利",{50.6,20.6}}, -- 11037
			{"採礦訓練師", "帕莉亞蕾",{51.4,19.0}}, -- 43431
			{"裁縫訓練師", "菲葉琳•柳月",{50.6,20.8}}, -- 43428
		-- 商人
			{"部落<枯萎的樹人>商人", "藥劑師弗洛斯",{57.2,33.8}}, -- 33980
		},

		-- Azshara
		["艾薩拉"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "克隆姆",{53.0,49.8}}, -- 8610
			{"雙足飛龍管理員", "克隆姆",{14.2,65.0}}, -- 36728
			{"飛行管理員", "“天旋地轉”費里茲",{51.4,74.2}}, -- 37005
			{"飛行管理員", "布里茲•爆裂彈",{66.4,20.8}}, -- 43328
		-- 旅館老闆
			{"旅館老闆", "米克希",{57.0,50.4}}, -- 43771
		-- 獸欄管理員
			{"獸欄管理員", "史蒂拉•布恩布恩",{56.8,50.0}}, -- 43773
		-- 專業訓練師
			{"急救訓練師", "卡亞羅全能訓練機豪華版",{57.0,50.6}}, -- 49885
			{"急救訓練師", "紮普諾茲醫生",{57.0,50.6}}, -- 49879
			{"釣魚訓練師", "卡亞羅全能訓練機豪華版",{57.0,50.6}}, -- 49885
		-- 商人
			{"中立<卡萊莎的魂縈墜飾>商人", "特克斯•垂旋",{57.0,50.6}}, -- 36375
			-- 惡魔入侵
			{"惡魔入侵軍需官", "被俘的蟲語者",{29.8,68.8}}, -- 109912
		},

		-- Northern Barrens
		["北貧瘠之地"]={
		-- 銀行職員
			{"銀行職員", "法茲拉克",{68.4,71.2},0}, -- 3496
			{"銀行職員", "茲科爾",{68.4,71.2},0}, -- 8119
		-- 飛行管理員
			{"雙足飛龍管理員", "迪弗拉克",{48.6,58.6},0}, -- 3615/110574 -- 惡魔入侵
			{"飛行管理員", "布拉高克",{69.0,70.6},0}, -- 16227
			{"飛行管理員", "格特•血翔",{42.0,15.8},0}, -- 34927
			{"飛行管理員", "加瑞克斯",{62.4,17.2},0}, -- 40558
		-- 旅館老闆
			{"旅館老闆", "旅館老闆伯蘭德•草風",{49.6,58.0},0}, -- 3934/104802 -- 惡魔入侵
			{"旅館老闆", "旅館老闆維爾雷",{67.2,74.6},0}, -- 6791
			{"旅館老闆", "酒館老闆克莉澤爾",{62.4,16.6},0}, -- 43945
			{"旅館老闆", "旅館老闆科爾蒂斯",{56.2,40.0},0}, -- 43946
		-- 獸欄管理員
			{"獸欄管理員", "希克瓦",{49.0,57.6},0}, -- 9981/95609 -- 惡魔入侵
			{"獸欄管理員", "雷格菲茲",{67.4,74.2},0}, -- 10063
			{"獸欄管理員", "維爾隆•噴酸",{62.4,16.8},0}, -- 43982
			{"獸欄管理員", "卡索科",{56.6,39.8},0}, -- 43988
		-- 專業訓練師
			{"鍛造訓練師", "特勞弗",{48.2,56.2},0}, -- 3478
			{"烹飪訓練師", "杜恩格",{55.4,61.2},0}, -- 8306/95981 -- 惡魔入侵
			{"工程學訓練師", "廷克維斯",{68.4,69.2},0}, -- 3494
			{"工程學訓練師", "瓦薩里奧•林克格雷斯",{68.4,69.2},0}, -- 8738
			{"裁縫訓練師", "基爾哈拉",{49.8,61.0},0}, -- 3484/95794 -- 惡魔入侵
			{"惡魔訓練師", "邁特羅•塞舒瓦",{68.0,67.8},0}, -- 23535
		-- 商人
			{"戰歌軍需官", "凱爾姆•哈古斯",{40.2,20.0},0}, -- 14754
			-- 惡魔入侵
			{"惡魔入侵軍需官", "被俘的蟲語者",{51.2,57.6},0}, -- 109912
		-- 交通工具
			{"船舶", "藏寶海灣-荊棘穀海角",{70.2,73.8},0},
		},

		-- Moonglade
		["月光林地"]={
		-- 飛行管理員
			{"角鷹獸管理員", "辛德拉爾",{48.0,67.2}}, -- 10897
			{"德魯伊雷霆崖飛行管理員", "布瑟恩•草風",{44.2,45.6}}, -- 11798
			{"德魯伊達納蘇斯飛行管理員", "希爾瓦•菲納雯斯",{44.2,45.8}}, -- 11800
			{"雙足飛龍管理員", "法斯托恩",{32.2,66.4}}, -- 12740
		-- 職業訓練師
			{"德魯伊訓練師", "洛甘納爾",{52.4,40.6}}, -- 12042
			{"德魯伊訓練師", "贊巴萊",{47.8,32.6}}, -- 13476
		-- 專業訓練師
			{"草藥學訓練師", "瑪沃爾",{45.4,47.0}}, -- 12025
		-- 商人
			{"德魯伊<技能書>商人", "羅賴爾•冬歌",{48.6,40.2}}, -- 12022 -- need translation 7.0.3新增職業物品
		},

		-- Ashenvale
		["灰穀"]={
		-- 飛行管理員
			{"角鷹獸管理員", "黛琳希亞",{34.4,48.0}}, -- 4267
			{"雙足飛龍管理員", "安德魯克",{11.2,34.4}}, -- 11901
			{"雙足飛龍管理員", "烏爾格拉",{73.2,61.6}}, -- 12616
			{"角鷹獸管理員", "索拉萊斯•遠風",{85.0,43.4}}, -- 22935
			{"聯盟飛行管理員", "索萊斯",{18.2,20.6}}, -- 34374
			{"聯盟飛行管理員", "麥瑞•月翔",{35.0,72.0}}, -- 34378
			{"雙足飛龍管理員", "薩拉卡",{38.0,42.2}}, -- 34429
			{"部落飛行管理員", "馴風者舒舍克",{49.2,65.2}}, -- 34943
		-- 旅館老闆
			{"聯盟旅館老闆", "旅館老闆基姆利雅",{37.0,49.2}}, -- 6738
			{"部落旅館老闆", "旅館老闆凱利斯克",{74.0,60.6}}, -- 12196
			{"部落旅館老闆", "旅館老闆杜拉斯",{13.0,34.0}}, -- 43606
			{"部落旅館老闆", "旅館老闆林卡莎",{38.6,42.2}}, -- 43624
			{"部落旅館老闆", "旅館老闆奇恩托卡",{50.4,67.0}}, -- 43633
		-- 獸欄管理員
			{"聯盟獸欄管理員", "瑪魯希亞",{36.4,50.4}}, -- 10052
			{"部落獸欄管理員", "基蘇",{73.2,60.6}}, -- 15131
			{"部落獸欄管理員", "魯爾莎",{12.6,33.8}}, -- 43617
			{"部落獸欄管理員", "德雷克",{38.6,42.4}}, -- 43630
			{"部落獸欄管理員", "沃爾查",{50.2,65.8}}, -- 43634
		-- 專業訓練師
			{"部落釣魚訓練師", "基爾希瓦納",{10.8,33.8}}, -- 12961
			{"聯盟制皮訓練師", "艾蒂安•花叢之風",{35.8,52.0}}, -- 3967
		-- 商人
			{"銀翼軍需官", "艾蒂爾•月火",{61.6,83.8}}, -- 14753
		},

		-- Stonetalon Mountains
		["石爪山脈"]={
		-- 飛行管理員
			{"角鷹獸管理員", "泰羅倫",{40.0,32.0}}, -- 4407
			{"聯盟飛行管理員", "卡璐納•歌翔",{70.8,80.4}}, -- 35136
			{"聯盟飛行管理員", "艾蘭娜•迅翔",{58.8,54.2}}, -- 35137
			{"聯盟飛行管理員", "瑟攸拉",{32.0,61.8}}, -- 35138 -- need translation
			{"部落飛行管理員", "齊拉內",{70.6,89.4}}, -- 35139
			{"部落飛行管理員", "迅捷科瑪爾",{66.4,62.8}}, -- 35140
			{"部落飛行管理員", "歐爾娜•觀天者",{45.0,30.8}}, -- 35141 -- need translation
			{"聯盟飛行管理員", "菲歐拉•月翔",{48.6,51.6}}, -- 41240
			{"部落飛行管理員", "弗勞克",{53.8,40.0}}, -- 41246
		-- 旅館老闆
			{"聯盟旅館老闆", "奧莉西雅•眠湖",{59.0,56.4}}, -- 40898
			{"聯盟旅館老闆", "萊納斯",{71.0,79.0}}, -- 41286
			{"聯盟旅館老闆", "瓦羅斯•影息",{39.4,32.8}}, -- 41491
			{"部落旅館老闆", "菲洛留斯•斯塔克",{66.4,64.2}}, -- 41892
			{"聯盟旅館老闆", "旅館老闆波妮絲",{31.4,60.6}}, -- 44177 -- need translation
		-- 獸欄管理員
			{"部落獸欄管理員", "格雷克",{50.8,63.0}}, -- 10048
			{"部落獸欄管理員", "格爾賓",{66.2,64.0}}, -- 41893
			{"聯盟獸欄管理員", "法赫斯塔德",{39.8,32.2}}, -- 43017
			{"聯盟獸欄管理員", "泰爾朵拉",{31.8,61.6}}, -- 43019 -- need translation
			{"聯盟獸欄管理員", "阿多琉斯",{58.6,56.6}}, -- 43021
		-- 專業訓練師
			{"部落附魔訓練師", "赫加斯",{51.8,59.8}}, -- 11074
		-- 商人
			{"部落PvE裝備商", "克羅姆加軍需官",{65.8,64.0}}, -- 42028
		},

		-- Southern Barrens
		["南貧瘠之地"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "約翰•約翰森",{38.8,10.8}}, -- 39210
			{"聯盟飛行管理員", "史蒂夫•史蒂文生",{49.2,67.8}}, -- 39211
			{"聯盟飛行管理員", "比爾•威廉姆斯",{66.4,47.0}}, -- 39212
			{"部落飛行管理員", "克雷多",{41.2,70.8}}, -- 39330
			{"部落飛行管理員", "烏內加",{39.6,20.2}}, -- 39340
			{"雙足飛龍管理員", "羅格納",{41.6,47.6}}, -- 52060
		-- 旅館老闆
			{"聯盟旅館老闆", "後勤軍士雷納爾多",{39.0,11.0}}, -- 44219
			{"聯盟旅館老闆", "後勤軍士薩莉絲塔",{49.0,68.6}}, -- 44267
			{"聯盟旅館老闆", "城堡衛士克裡",{65.6,46.6}}, -- 44268
			{"部落旅館老闆", "旅館老闆胡納哈特",{39.2,20.0}}, -- 44270
			{"部落旅館老闆", "旅館老闆魯哈卡德",{40.8,69.2}}, -- 44276
		-- 獸欄管理員
			{"聯盟獸欄管理員", "布蘭登•梅裡威瑟",{39.0,11.2}}, -- 44346
			{"聯盟獸欄管理員", "沃納•伊斯特布魯克",{49.0,68.2}}, -- 44347
			{"聯盟獸欄管理員", "卡雷•威利斯",{66.0,46.8}}, -- 44348
			{"部落獸欄管理員", "穆納達",{39.2,19.8}}, -- 44349
			{"部落獸欄管理員", "格蘭托爾",{40.8,69.6}}, -- 44354
		-- 專業訓練師
			{"部落制皮訓練師", "克魯姆•滿月",{44.4,51.0}}, -- 3703
			{"部落剝皮訓練師", "德拉恩",{44.6,52.0}}, -- 6387
			{"部落裁縫訓練師", "馬哈尼",{41.6,47.0}}, -- 3704
		},

		-- Desolace
		["淒涼之地"]={
		-- 飛行管理員
			{"角鷹獸管理員", "巴瑞特•克羅斯",{64.6,10.4},0}, -- 6706
			{"雙足飛龍管理員", "薩隆",{21.6,74.0},0}, -- 6726
			{"部落飛行管理員", "納裡瑪",{44.2,29.6},0}, -- 35315
			{"飛行管理員", "拉斯特瑞•綠風",{57.6,49.6},0}, -- 35478
			{"獅鷲管理員", "茉艾拉•鋼翼",{36.8,71.6},0}, -- 35481
			{"飛行管理員", "桑克的雙足飛龍",{70.6,32.8},0}, -- 35556
			{"飛行管理員", "庫拉的角鷹獸",{39.0,27.0},0}, -- 35562
		-- 旅館老闆
			{"聯盟旅館老闆", "旅館老闆利莎瑞亞",{66.2,6.6},0}, -- 11103
			{"部落旅館老闆", "旅館老闆希科瓦",{24.0,68.2},0}, -- 11106
			{"旅館老闆", "旅館老闆德希娜",{56.8,50.0},0}, -- 43872
		-- 獸欄管理員
			{"聯盟獸欄管理員", "舍爾戈萊恩",{65.6,7.8},0}, -- 11104
			{"部落獸欄管理員", "安伯達",{24.8,6.8},0}, -- 11105
			{"獸欄管理員", "菲娜•止林",{57.0,49.6},0}, -- 43877
		-- 專業訓練師
			{"部落釣魚訓練師", "魯伊馬拉",{22.6,72.6},0}, -- 12032
			{"部落制皮訓練師", "納夫",{55.2,56.2},0}, -- 8153
			{"部落剝皮訓練師", "馬魯克斯",{23.2,69.8},0}, -- 12030
		},

		-- Dustwallow Marsh
		["塵泥沼澤"]={
		-- 銀行職員
			{"聯盟銀行職員", "出納員蘭德裡",{67.8,48.2}}, -- 5083
		-- 飛行管理員
			{"獅鷲管理員", "巴德拉克",{67.4,51.2}}, -- 4321
			{"雙足飛龍管理員", "沙爾迪",{35.6,31.8}}, -- 11899
			{"飛行管理員", "德斯利克•希維格拉",{42.8,72.4}}, -- 40358
		-- 旅館老闆
			{"聯盟旅館老闆", "旅館老闆詹妮",{66.4,45.4}}, -- 6272
			{"旅館老闆", "埃克斯勒",{41.8,74.0}}, -- 23995
			{"部落旅館老闆", "“小個子”洛戈克",{36.8,32.2}}, -- 24208
		-- 獸欄管理員
			{"聯盟獸欄管理員", "麥克爾",{65.8,45.4}}, -- 10047
		-- 專業訓練師
			{"煉金術訓練師", "煉金師納瑞特",{64.0,47.6}}, -- 4900
			{"考古學訓練師", "菲娜•絨套",{66.2,45.2}}, -- 53421
			{"鍛造訓練師", "瑪蕾•霍斯頓",{64.6,50.0}}, -- 4888
			{"烹飪訓練師", "克萊格•諾瓦德",{66.8,45.2}}, -- 4894
			{"附魔訓練師", "麗薩•斯貝維克",{66.0,49.6}}, -- 53410
			{"工程學訓練師", "卡茲•雙鏈",{64.6,50.4}}, -- 4941
			{"急救訓練師", "古斯塔夫•范沃森醫生",{67.6,48.8}}, -- 12939
			{"釣魚訓練師", "“髒鬼”邁克爾•克羅維",{69.2,51.8}}, -- 23896
			{"草藥學訓練師", "布蘭特•加斯布魯姆",{64.0,47.6}}, -- 4898
			{"銘文學訓練師", "瑟爾頓•曼勒斯",{66.0,49.6}}, -- 53415
			{"珠寶設計訓練師", "因格•絨套",{66.2,45.2}}, -- 5388
			{"制皮訓練師", "尤塔西•坦維爾",{66.4,45.2}}, -- 53436
			{"採礦訓練師", "“狗頭人”科爾裡克",{64.6,49.8}}, -- 53409
			{"騎術訓練師", "珊莎•瑪克溫斯",{65.4,51.6}}, -- 53407
			{"剝皮訓練師", "休伯特•坦維爾",{66.4,45.2}}, -- 53437
			{"裁縫訓練師", "提莫斯•沃森特",{66.2,51.6}}, -- 11052
			{"傳送門訓練師", "伊蘇莉婭",{66.0,49.0}}, -- 27703
		-- 商人
			{"H<迷你魔法炸彈>/A<塞拉摩戰袍>商人", "希多爾米",{55.8,49.6}}, -- 63546
		-- 交通工具
			{"船舶", "米奈希爾港-濕地",{71.2,54.0}},
		},

		-- Feralas
		["菲拉斯"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "希恩",{75.4,44.2}}, -- 39898
			{"角鷹獸管理員", "塞亞娜•夜靈",{77.2,56.8}}, -- 40367
			{"雙足飛龍管理員", "托諾",{41.4,15.4}}, -- 40473
			{"聯盟飛行管理員", "瑟洛",{50.2,16.6}}, -- 40966
			{"角鷹獸管理員", "伊瑞拉•月羽",{46.8,45.2}}, -- 41383
			{"聯盟飛行管理員", "愛倫達",{57.0,54.0}}, -- 41580
			{"雙足飛龍管理員", "瑪爾格",{51.0,48.4}}, -- 41605
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆格魯爾",{74.8,45.0}}, -- 7737
			{"部落旅館老闆", "雅蒂恩•輝樹",{41.4,15.6}}, -- 40467
			{"聯盟旅館老闆", "安多利爾",{51.0,17.8}}, -- 40968
			{"部落旅館老闆", "沖克",{51.8,47.4}}, -- 44376
			{"聯盟旅館老闆", "旅館老闆希瑞亞",{46.0,45.2}}, -- 44391
		-- 獸欄管理員
			{"部落獸欄管理員", "謝爾卡•狼行者",{74.6,43.2}}, -- 9986
			{"聯盟獸欄管理員", "安塔留斯",{46.8,45.6}}, -- 10059
			{"部落獸欄管理員", "阿加耶",{51.6,48.0}}, -- 44378
			{"聯盟獸欄管理員", "瓦爾",{51.0,18.0}}, -- 44382
			{"部落獸欄管理員", "索拉",{41.4,15.6}}, -- 44384
		-- 專業訓練師
			{"聯盟煉金術訓練師", "凱蘭娜•風語",{46.6,42.8}}, -- 7948
			{"聯盟附魔訓練師", "辛琳妮亞•星光",{46.6,42.8}}, -- 7949
			{"聯盟釣魚訓練師", "布拉諾克",{45.2,41.4}}, -- 7946
			{"部落草藥學訓練師", "拉烏",{76.0,43.4}}, -- 8146
			{"部落制皮訓練師", "哈拉納•鐵皮",{74.4,43.0}}, -- 11098
			{"部落剝皮訓練師", "庫雷格•石角",{74.4,43.0}}, -- 8144
		-- 商人
			{"中立<雙塔山降落傘>商人", "卡林•風程",{49.0,21.4}}, -- 7772
		},

		-- Thousand Needles
		["千針石林"]={
		-- 飛行管理員
			{"飛行管理員", "紮茲克斯•爆旅",{79.0,71.8}}, -- 40769
			{"雙足飛龍管理員", "納赫特",{11.0,11.6}}, -- 44399
		-- 旅館老闆
			{"旅館老闆", "黛西",{76.4,74.6}}, -- 40832
		-- 商人
			{"中立<灰色小雞>商人", "勇敢的強森",{85.6,91.6}}, -- 41135
		},

		-- Felwood
		["費伍德森林"]={
		-- 飛行管理員
			{"角鷹獸管理員", "米薩琳娜",{60.6,25.2}}, -- 12578
			{"翡翠議會飛行管理員", "高瑞姆",{51.4,80.8}}, -- 22931
			{"中立角鷹獸管理員", "哈娜•南歌",{43.6,28.6}}, -- 43073
			{"中立角鷹獸管理員", "凱拉•靜林",{44.2,61.8}}, -- 43079
		-- 旅館老闆
			{"聯盟旅館老闆", "狼巢之母尤爾莉卡",{61.8,26.6}}, -- 47931
			{"旅館老闆", "旅館老闆瓦拉莉亞",{44.8,29.0}}, -- 48215
			{"旅館老闆", "旅館老闆提尼考",{44.0,61.8}}, -- 48599
		-- 獸欄管理員
			{"獸欄管理員", "納雷塞特",{61.6,25.4}}, -- 543
			{"聯盟獸欄管理員", "胡拉",{44.4,28.6}}, -- 48216
		-- 專業訓練師
			{"裁縫訓練師", "梅羅什",{64.8,5.2}}, -- 11557
		-- 商人
			{"中立<熊怪變形棒>商人", "梅羅什",{64.8,5.2}}, -- 11557
		},

		-- Tanaris
		["塔納利斯"]={
		-- 拍賣師
			{"拍賣師", "拍賣師比爾杜",{51.8,30.4},0}, -- 8661/106939 -- 惡魔入侵
		-- 銀行職員
			{"銀行職員", "吉布索恩",{52.2,29.6},0}, -- 7799/98841 -- 惡魔入侵
			{"銀行職員", "奇茲克",{52.2,29.6},0}, -- 8124/98842 -- 惡魔入侵
		-- 飛行管理員
			{"獅鷲管理員", "博拉•石錘",{51.4,29.4},0}, -- 7823
			{"雙足飛龍管理員", "布科雷克•怒拳",{52.0,27.6},0}, -- 7824
			{"聯盟飛行管理員", "蘇爾達",{40.0,77.4},0}, -- 40827
			{"飛行管理員", "斯裡克•墜沉",{55.8,60.6},0}, -- 41214
			{"部落飛行管理員", "萊娜•日翔",{33.2,77.2},0}, -- 41215
		-- 旅館老闆
			{"旅館老闆", "旅館老闆菲茲格瑞博",{52.6,27.0},0}, -- 7733/106940 -- 惡魔入侵
			{"旅館老闆", "卡門•艾般諾茲",{55.6,60.8},0}, -- 38714
		-- 獸欄管理員
			{"獸欄管理員", "拉茲弗斯",{52.6,27.4},0}, -- 9985/98861 -- 惡魔入侵
		-- 專業訓練師
			{"工程學訓練師", "尼克斯•斯普克斯賓",{52.2,28.2},0}, -- 8126/98838 -- 惡魔入侵
			{"工程學訓練師", "巴茲克•布拉斯溫",{51.6,30.2},0}, -- 8736/98872 -- 惡魔入侵
			{"採礦訓練師", "皮庫爾",{51.0,29.0},0}, -- 8128/106979 -- 惡魔入侵
		-- 商人
			-- 軍需官
			--{"PvP裝備商", "維克斯頓",{51.6,28.0},0}, -- 20278/106944 榮耀印記 "嗜血角鬥士Bloodthirsty" "暴怒角鬥士Wrathful" "野蠻角鬥士Brutal" "守衛者Guardian"
			--{"PvP裝備商", "騙子布拉茲克",{51.4,28.0},0}, -- 40216/106945 "殘忍角鬥士Vicious" "暴怒角鬥士Wrathful" "野蠻角鬥士Brutal"
			--{"PvP裝備商", "“巫婆”凱普斯",{51.4,28.0},0}, -- 69322/106947 "災變角鬥士Cataclysmic" "無情角鬥士Relentless" "殘忍角鬥士Vicious"
			--{"PvP裝備商", "小個子泰格",{51.4,28.0},0}, -- 69323/106946 "冷酷角鬥士Ruthless" "災變角鬥士Cataclysmic" "殘忍角鬥士Vicious"
			--{"PvP裝備商", "埃克頓•布拉斯塔",{51.4,28.0},0}, -- 69979/106949 "榮譽軍需官" -- 惡魔入侵 "冷酷角鬥士Ruthless"
			--{"PvP裝備商", "伊維•考伯斯賓",{51.4,28.0},0}, -- 69980/106948 "征服軍需官" -- 惡魔入侵 "災變角鬥士Cataclysmic" "冷酷角鬥士Ruthless" "殘忍角鬥士Vicious"
			{"PvP裝備商", "守衛者;S4;S7;S8;S9L;S9H;S10;S11",{51.4,28.0},0}, -- 20278/40216/69322/69323/69979/69980
			-- 派系
			{"時光守護者軍需官", "艾魯爾米",{48.4,71.6},0}, -- 21643
			-- 其他商人
			{"中立<諾格弗格藥劑>商人", "斯賓科爾•諾格弗格",{51.2,29.8},0}, -- 43418/98844 -- 惡魔入侵
			-- 惡魔入侵
			{"惡魔入侵軍需官", "被俘的蟲語者",{53.0,25.8},0}, -- 109912
		},

		-- Un'Goro Crater
		["安戈洛環形山"]={
		-- 飛行管理員
			{"飛行管理員", "格萊菲",{56.0,64.0},0}, -- 10583
			{"飛行管理員", "弗裡茲•考斯班納",{44.0,40.2},0}, -- 39175
		-- 商人
			{"中立<玩具風車>任務商人", "北郡騎士麥斯米蘭",{30.6,51.2},0}, -- 38237
			{"部落<毒皮暴掠龍哨>任務商人", "莫維克",{71.6,73.8},0}, -- 11701
		},

		-- Winterspring
		["冬泉穀"]={
		-- 拍賣師
			{"拍賣師", "拍賣師格裡茲林",{59.8,49.2}}, -- 9857
		-- 銀行職員
			{"銀行職員", "伊茲•考伯加布",{59.8,49.0}}, -- 13917
		-- 飛行管理員
			{"角鷹獸管理員", "麥瑟蕾亞",{61.0,48.6}}, -- 11138
			{"雙足飛龍管理員", "尤格雷克",{58.8,48.2}}, -- 11139
		-- 旅館老闆
			{"旅館老闆", "旅館老闆維茲奇",{59.8,51.2}}, -- 11118
		-- 獸欄管理員
			{"獸欄管理員", "阿茲雷比",{58.6,50.2}}, -- 11119
		-- 商人
			{"聯盟<冬泉霜刃豹韁繩>商人", "雷沃•霜翼",{46.6,17.6}}, -- 10618
			{"中立<冬泉豹幼崽>商人", "蜜雪兒•德朗姆",{59.8,51.6}}, -- 52830
		},

		-- Silithus
		["希利蘇斯"]={
		-- 飛行管理員
			{"角鷹獸管理員", "克勞德•天舞者",{54.4,32.8},0}, -- 15177
			{"雙足飛龍管理員", "魯克•馴風者",{52.8,34.6},0}, -- 15178
		-- 旅館老闆
			{"旅館老闆", "卡蘭德拉斯",{55.4,36.6},0}, -- 15174
		-- 獸欄管理員
			{"獸欄管理員", "萊歐倫•瑪爾迪拉斯",{53.2,34.6},0}, -- 15722
		},

		-- Mount Hyjal
		["海加爾山"]={
		-- 飛行管理員
			{"飛行管理員", "費蘭•艾爾薩斯",{62.2,21.6}}, -- 41861
			{"飛行管理員", "艾裡希爾•冬蛾",{19.6,36.4}}, -- 41860/53783
			{"飛行管理員", "蒂諾萊•迅羽",{41.2,42.6}}, -- 43481/50084
			{"飛行管理員", "艾爾特拉",{71.6,75.2}}, -- 43549
			{"飛行管理員", "蕾尼拉•羽峽",{27.8,63.4}}, -- 54392/54393
		-- 旅館老闆
			{"旅館老闆", "塞貝莉亞",{63.0,24.0}}, -- 40843
			{"旅館老闆", "薩利恩•月熊",{18.6,37.2}}, -- 43378/53779
			{"旅館老闆", "艾莎娜•溪行",{42.6,45.6}}, -- 43487/50068
		-- 獸欄管理員
			{"獸欄管理員", "艾麗•綠柳",{63.2,23.0}}, -- 43408
			{"獸欄管理員", "利米婭•白枝",{19.4,36.2}}, -- 43379/53780
			{"獸欄管理員", "奧爾塔林•灰雲",{41.8,45.0}}, -- 43494/50069
		-- 商人
			{"海加爾守護者軍需官", "供給官白雲",{62.8,23.8}}, -- 50314
			{"海加爾復仇者軍需官", "納瑟爾•雷怒",{47.8,78.2}}, -- 54401
			{"PvE裝備商", "魯娜•怒藤",{47.6,77.6}}, -- 54402 "火石結晶收集者"
		},

		-- Uldum
		["奧丹姆"]={
		-- 飛行管理員
			{"飛行管理員", "伊瓦克斯•油光",{22.2,64.8}}, -- 48273
			{"飛行管理員", "約克•琳賽",{26.6,8.2}}, -- 48274
			{"飛行管理員", "庫塞爾",{56.2,33.6}}, -- 48275
		-- 旅館老闆
			{"旅館老闆", "卡澤穆迪",{54.6,32.8}}, -- 48886
			{"旅館老闆", "雅斯敏",{26.6,7.2}}, -- 49406
		-- 獸欄管理員
			{"獸欄管理員", "達爾維什",{54.6,33.8}}, -- 48887
			{"獸欄管理員", "法拉•泰咪娜",{27.0,7.6}}, -- 49408
		-- 商人
			{"拉穆卡恒軍需官", "鐵匠阿巴西",{54.0,33.2}}, -- 48617
		},

		-- Molten Front
		["熔火前線"]={
		-- 商人
			--{"世界之樹的印記商人", "贊沃卡",{47.6,77.6}}, -- 52822 "世界之樹的饋贈"
			{"PvE裝備商", "達默克•沖爐",{47.6,77.6}}, -- 53214 "優質裝備"
			--{"寵物玩具裝備商人", "艾拉•影暴",{47.6,77.6}}, -- 53881 "艾露恩的珍寶"
			--{"寵物玩具裝備商人", "瓦爾蘭•高枝",{47.6,77.6}}, -- 53882 "林地補給官"
			{"商人", "世界之樹的印記;寵物;玩具",{47.6,77.6}}, -- 52822/53881/53882
		},

	-- 東部王國 Eastern Kingdoms
		-- Dun Morogh
		["丹莫羅"]={
		-- 飛行管理員
			{"獅鷲管理員", "布洛倫•風須",{53.8,52.6},0}, -- 43701
			{"獅鷲管理員", "多明尼克•風須",{75.8,54.4},0}, -- 43702
		-- 旅館老闆
			{"旅館老闆", "旅館老闆貝爾姆",{54.4,50.8},0}, -- 1247
		-- 獸欄管理員
			{"獸欄管理員", "謝爾比•石火",{54.0,51.0},0}, -- 9980
		-- 專業訓練師
			{"鍛造訓練師", "托格努斯•燧火",{52.4,50.2},0}, -- 1241
			{"烹飪訓練師", "廚師格瑞姆",{75.6,52.8},0}, -- 1355
			{"烹飪訓練師", "格雷姆羅克•匹斯諾爾",{54.6,50.6},0}, -- 1699/99991 惡魔入侵
			{"工程學訓練師", "布隆克",{57.2,48.6},0}, -- 1702
			{"急救訓練師", "薩姆諾•普爾",{54.2,50.8},0}, -- 2326/100013 惡魔入侵
			{"草藥學訓練師", "溫比爾•工作列",{53.8,52.0},0}, -- 47396/99938 惡魔入侵
			{"採礦訓練師", "丹克•利刃",{76.6,53.6},0}, -- 1701/99845 惡魔入侵
			{"採礦訓練師", "亞爾•錘石",{57.2,48.6},0}, -- 5392
			{"採礦訓練師", "溫比爾•工作列",{53.8,52.0},0}, -- 47396/99938 惡魔入侵
			{"騎術訓練師", "奧薩姆•鐵角",{71.2,48.4},0}, -- 4772
			{"騎術訓練師", "賓吉•羽哨",{56.2,46.4},0}, -- 7954/100164 惡魔入侵
			{"剝皮訓練師", "溫比爾•工作列",{53.8,52.0},0}, -- 47396/99938 惡魔入侵
			{"惡魔訓練師", "丹尼•血泡",{54.4,52.0},0}, -- 6328/99979 惡魔入侵
		-- 商人
			-- 惡魔入侵
			{"惡魔入侵軍需官", "被俘的蟲語者",{59.8,35.2},0}, -- 109912
		},

		-- Elwynn Forest
		["艾爾文森林"]={
		-- 飛行管理員
			{"獅鷲管理員", "勇敢的巴特利",{41.8,64.6},0}, -- 42983
			{"獅鷲管理員", "迅翼高斯",{81.8,66.4},0}, -- 43000
		-- 旅館老闆
			{"旅館老闆", "旅館老闆法雷",{43.8,65.8},0}, -- 295
		-- 獸欄管理員
			{"獸欄管理員", "艾瑪",{42.8,65.8},0}, -- 6749
		-- 專業訓練師
			{"煉金術訓練師", "煉金師瑪洛瑞",{39.8,48.6},0}, -- 1215
			{"煉金術訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"鍛造訓練師", "鐵匠阿古斯",{41.6,65.6},0}, -- 514
			{"鍛造訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"烹飪訓練師", "異種搜尋者",{44.2,66.0},0}, -- 4130
			{"附魔訓練師", "基塔•費溫德",{64.8,70.6},0}, -- 11072
			{"附魔訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"工程學訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"急救訓練師", "蜜雪兒•貝利",{43.4,65.6},0}, -- 2329
			{"釣魚訓練師", "李•布朗",{47.4,62.2},0}, -- 1651
			{"草藥學訓練師", "草藥師博米洛伊",{39.8,48.4},0}, -- 1218
			{"草藥學訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"制皮訓練師", "艾德勒•費歐德",{46.4,62.0},0}, -- 1632
			{"採礦訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"騎術訓練師", "工頭考茲爾",{64.2,65.0},0}, -- 4723
			{"剝皮訓練師", "海倫尼•派特斯金納",{46.2,62.2},0}, -- 6306
			{"裁縫訓練師", "艾爾丁",{79.2,69.0},0}, -- 1103
			{"裁縫訓練師", "萊恩•法爾娜",{42.0,67.0},0}, -- 47384
			{"惡魔訓練師", "塞琳娜•達克哈特",{44.4,66.0},0}, -- 6374
		},

		-- Eversong Woods
		["永歌森林"]={
		-- 飛行管理員
			{"龍鷹管理員", "葛拉米",{54.4,50.8}}, -- 16192
			{"龍鷹管理員", "飛行管理員晨光",{44.0,77.0}}, -- 44036
			{"龍鷹管理員", "飛行管理員斯凱勒斯",{46.2,46.8}}, -- 44244
		-- 旅館老闆
			{"旅館老闆", "瑪尼爾•琥珀之光",{43.6,71.2}}, -- 15397
			{"旅館老闆", "旅館老闆德蘭妮爾",{48.0,47.6}}, -- 15433
		-- 獸欄管理員
			{"獸欄管理員", "阿娜索絲",{47.6,47.2}}, -- 16185
		-- 專業訓練師
			{"煉金術訓練師", "奧術師森納瑟林",{38.2,72.6}}, -- 16161
			{"煉金術訓練師", "塞倫",{48.8,46.8}}, -- 47421
			{"鍛造訓練師", "阿拉瑟爾",{59.6,62.6}}, -- 15400
			{"烹飪訓練師", "卡雷斯特拉",{48.6,47.0}}, -- 16277
			{"附魔訓練師", "魔導師艾雷達妮婭",{38.2,72.6}}, -- 16160
			{"急救訓練師", "卡娜莉亞",{48.4,47.6}}, -- 16272
			{"草藥學訓練師", "植物學家塔尼安雷爾",{37.4,71.8}}, -- 16367
			{"草藥學訓練師", "塞倫",{48.8,46.8}}, -- 47421
			{"珠寶設計訓練師", "奧雷妮亞",{48.4,47.4}}, -- 15501
			{"珠寶設計訓練師", "塞倫",{48.8,46.8}}, -- 47421
			{"制皮訓練師", "薩瑟林",{53.6,51.2}}, -- 16278
			{"採礦訓練師", "塞倫",{48.8,46.8}}, -- 47421
			{"騎術訓練師", "佩拉斯卡米",{61.2,54.0}}, -- 16280
			{"剝皮訓練師", "瑪斯雷恩",{53.8,51.2}}, -- 16273
			{"裁縫訓練師", "女裁縫蔻妮•琥珀之光",{37.4,71.8}}, -- 16366
			{"惡魔訓練師", "戴絲特拉",{48.2,47.8}}, -- 16267
		-- 商人
			{"銀月城軍需官", "女魔導師妮薩拉",{54.2,50.8}}, -- 50484
		},

		-- [LEGION] Tirisfal Glades -- need update
		["提瑞斯法林地"]={
		-- 飛行管理員
			{"蝙蝠管理員", "提摩西•卡寧漢",{83.4,70.0},0}, -- 37915
			{"蝙蝠管理員", "安內特•威廉姆斯",{58.8,51.8},0}, -- 43124
		-- 旅館老闆
			{"旅館老闆", "旅館老闆瑞尼",{60.8,51.6},0}, -- 5688
		-- 獸欄管理員
			{"獸欄管理員", "莫加努斯",{61.8,52.0},0}, -- 10055
		-- 專業訓練師
			{"煉金術訓練師", "卡羅萊•安尼斯",{59.4,52.0},0}, -- 2132
			{"烹飪訓練師", "大廚",{61.2,52.4},0}, -- 47405
			{"附魔訓練師", "范斯•安德格魯姆",{59.8,53.2},0}, -- 5695
			{"急救訓練師", "妮拉",{59.8,52.0},0}, -- 5759
			{"釣魚訓練師", "克萊德•凱林",{67.2,51.0},0}, -- 5690
			{"草藥學訓練師", "法魯薩",{59.4,52.0},0}, -- 2114
			{"草藥學訓練師", "尼德里奇•沙洛",{61.0,51.0},0}, -- 47400
			{"制皮訓練師", "舍倫尼•洛巴爾特",{65.4,60.0},0}, -- 3549
			{"採礦訓練師", "尼德里奇•沙洛",{61.0,51.0},0}, -- 47400
			{"騎術訓練師", "維爾瑪•瓦納姆",{61.8,51.8},0}, -- 4773
			{"剝皮訓練師", "蘭德•洛巴爾特",{65.4,60.0},0}, -- 6289
			{"剝皮訓練師", "尼德里奇•沙洛",{61.0,51.0},0}, -- 47400
			{"裁縫訓練師", "博文•布裡斯博埃斯",{52.6,55.6},0}, -- 3523
			{"裁縫訓練師", "尼德里奇•沙洛",{61.0,51.0},0}, -- 47400
			{"惡魔訓練師", "吉娜•朗恩",{61.0,50.4},0}, -- 5750
		-- 商人
			{"銀色黎明軍需官", "<中立>銀色黎明軍需官哈薩娜",{83.2,68.0},0}, -- 10856
		-- 交通工具
			{"傳送寶珠", "內部聖殿-銀月城",{59.4,67.5},0},
			{"飛艇", "復仇港-嚎風峽灣",{58.5,59.0},0},
			{"飛艇", "奧格瑞瑪-杜隆塔爾;格羅姆高營地-北荊棘穀",{62.5,59.0},0},
		},

		-- Westfall
		["西部荒野"]={
		-- 飛行管理員
			{"獅鷲管理員", "索爾",{56.6,49.4},0}, -- 523/110587 惡魔入侵
			{"獅鷲管理員", "霍博艾爾",{49.8,18.8},0}, -- 42406
			{"獅鷲管理員", "緹娜•斯基登",{42.0,63.4},0}, -- 42426
		-- 旅館老闆
			{"旅館老闆", "旅館老闆希瑟爾",{52.8,53.6},0}, -- 8931/110583 惡魔入侵
		-- 獸欄管理員
			{"獸欄管理員", "科爾克•麥克斯韋爾",{53.0,53.0},0}, -- 10045
		},

		-- Loch Modan
		["洛克莫丹"]={
		-- 飛行管理員
			{"獅鷲管理員", "索格拉姆•伯雷森",{33.8,50.8}}, -- 1572
			{"獅鷲管理員", "艾瑞文•格蕾爾",{81.8,64.2}}, -- 41332
		-- 旅館老闆
			{"旅館老闆", "維林•疾風",{81.8,64.4}}, -- 1156
			{"旅館老闆", "旅館老闆納克羅•壁爐",{35.4,48.4}}, -- 6734
		-- 獸欄管理員
			{"獸欄管理員", "麗娜•壁爐",{34.6,48.0}}, -- 9989
			{"獸欄管理員", "格拉芬因•鋼須",{84.0,62.8}}, -- 43979
		-- 專業訓練師
			{"煉金術訓練師", "加克",{37.0,49.2}}, -- 1470
			{"工程學訓練師", "迪克",{42.8,10.0}}, -- 3290
			{"釣魚訓練師", "瓦格•深水",{40.6,39.6}}, -- 1683
			{"草藥學訓練師", "卡利",{36.4,48.4}}, -- 1473
			{"採礦訓練師", "布洛克•尋石者",{37.0,47.8}}, -- 1681
		},

		-- Ghostlands
		["幽魂之地"]={
		-- 飛行管理員
			{"龍鷹管理員", "飛行管理員加尼斯•日翼",{45.4,30.6},0}, -- 16189
			{"中立飛行管理員", "吉茲•考斯班納",{74.6,67.0},0}, -- 24851
		-- 旅館老闆
			{"旅館老闆", "維林•疾風",{48.4,32.4},0}, -- 1156
		-- 獸欄管理員
			{"獸欄管理員", "帕尼亞",{48.4,31.2},0}, -- 16665
		-- 專業訓練師
			{"烹飪訓練師", "大廚師莫迪爾",{48.4,31.0},0}, -- 16253
		-- 商人
			{"部落<塔奎林勇士披風>商人", "補給官弗雷迪加",{47.6,32.2},0}, -- 16528
		},

		-- Silverpine Forest
		["銀松森林"]={
		-- 飛行管理員
			{"蝙蝠管理員", "卡洛斯•拉佐克",{45.4,42.4}}, -- 2226
			{"飛行管理員", "蝙蝠管理員瑪格特布裡斯",{57.8,8.8}}, -- 44825
			{"蝙蝠管理員", "史蒂芬•斯圖紮卡",{50.8,63.6}}, -- 46552
			{"蝙蝠管理員", "弗蘭妮•梅爾茲",{45.8,21.8}}, -- 50463
		-- 旅館老闆
			{"旅館老闆", "旅館老闆貝茨",{46.4,42.6}}, -- 6739
			{"旅館老闆", "指揮官辛克雷",{44.4,20.4}}, -- 45496
		-- 獸欄管理員
			{"獸欄管理員", "薩拉•古迪",{46.0,42.6}}, -- 9979
			{"獸欄管理員", "“老水兵”洛克卡",{44.6,20.8}}, -- 45498
		-- 專業訓練師
			{"鍛造訓練師", "古拉摩•索洛伊",{42.8,40.8}}, -- 3557
			{"採礦訓練師", "喬漢•弗徹",{43.4,40.6}}, -- 3555
		},

		-- Redridge Mountains
		["赤脊山"]={
		-- 飛行管理員
			{"獅鷲管理員", "艾蕾娜•斯托姆法瑟",{29.4,53.6}}, -- 931
			{"獅鷲管理員", "諾拉•巴爾德溫",{77.8,65.8}}, -- 43072
			{"獅鷲管理員", "阿爾倫•瑪爾斯特",{52.8,54.6}}, -- 43371
		-- 旅館老闆
			{"旅館老闆", "旅館老闆布里安娜",{26.2,41.4}}, -- 6727
		-- 獸欄管理員
			{"獸欄管理員", "本尼",{26.2,43.0}}, -- 9982
		-- 專業訓練師
			{"烹飪訓練師", "克裡斯托•鮑曼",{22.8,40.4}}, -- 3087
			{"釣魚訓練師", "馬修•胡柏",{26.0,46.6}}, -- 1680
			{"草藥學訓練師", "奧瑪•詹洛斯",{22.0,42.2}}, -- 812
			{"剝皮訓練師", "威爾瑪•蘭薩爾",{78.6,63.6}}, -- 6295
		},

		-- Duskwood
		["暮色森林"]={
		-- 飛行管理員
			{"獅鷲管理員", "菲利希亞•瑪林",{77.4,44.2}}, -- 2409
			{"獅鷲管理員", "約翰•謝爾比",{21.0,56.6}}, -- 43697
		-- 旅館老闆
			{"旅館老闆", "旅館老闆崔萊尼",{73.8,44.4}}, -- 6790
		-- 獸欄管理員
			{"獸欄管理員", "斯蒂文•布萊克",{74.0,46.2}}, -- 10062
		-- 專業訓練師
			{"鍛造訓練師", "克拉莉斯•納爾特裡",{74.0,48.4}}, -- 3136
			{"工程學訓練師", "芬布斯",{77.4,48.6}}, -- 1676
			{"採礦訓練師", "瑪特•約翰森",{73.8,49.8}}, -- 3137
		-- 商人
			{"中立<稀有貨物>商人", "卡茲克斯",{81.8,19.8}}, -- 3134
		},

		-- Wetlands
		["濕地"]={
		-- 飛行管理員
			{"獅鷲管理員", "謝爾雷•布隆迪爾",{9.4,59.6}}, -- 1571
			{"獅鷲管理員", "艾爾金•巴勒",{38.6,39.0}}, -- 41321
			{"角鷹獸管理員", "哈蘭娜",{56.4,41.8}}, -- 41322
			{"獅鷲管理員", "達蒙•巴爾羅",{38.6,39.0}}, -- 41323
			{"獅鷲管理員", "卡雷布•巴耶羅",{50.0,18.4}}, -- 41325
		-- 旅館老闆
			{"旅館老闆", "旅館老闆赫布瑞克",{10.6,60.8}}, -- 1464
			{"旅館老闆", "旅館老闆道格尼",{25.6,25.8}}, -- 44006
			{"旅館老闆", "旅館老闆拉麗莎",{58.0,39.2}}, -- 43993
		-- 獸欄管理員
			{"獸欄管理員", "貝塞尼•火錘",{10.6,59.6}}, -- 10046
			{"獸欄管理員", "薩魯斯特雷德",{57.6,40.2}}, -- 43994
			{"獸欄管理員", "謝普•金牌養護",{26.2,25.8}}, -- 44007
		-- 專業訓練師
			{"急救訓練師", "弗雷瑪爾",{10.6,60.2}}, -- 3181
			{"釣魚訓練師", "哈洛德•李格斯",{8.0,58.6}}, -- 3179
			{"草藥學訓練師", "泰倫瑞諾•月影",{11.2,52.0}}, -- 1458
		-- 交通工具
			{"船舶", "瓦加德-嚎風峽灣",{5.1,55.7}},
			{"船舶", "塞拉摩-塵泥沼澤",{6.4,62.3}},
		},

		-- Hillsbrad Foothills
		["希爾斯布萊德丘陵"]={
		-- 飛行管理員
			{"蝙蝠管理員", "紮瑞斯",{56.0,46.0}}, -- 2389/110404 惡魔入侵
			{"蝙蝠管理員", "達爾拉•哈瑞斯",{49.0,66.2}}, -- 47644/110940 惡魔入侵
			{"蝙蝠管理員", "潘蜜拉•斯圖紮卡",{29.0,64.4}}, -- 47655
			{"蝙蝠管理員", "達倫•朗費羅",{59.6,63.2}}, -- 47661/110769 惡魔入侵
			{"蝙蝠管理員", "菲力浦•哈爾丁",{58.2,26.4}}, -- 47665
		-- 旅館老闆
			{"旅館老闆", "旅館老闆沙恩",{57.8,47.2}}, -- 2388/112837 惡魔入侵
			{"旅館老闆", "旅館老闆哈爾希貝格",{35.8,61.2}}, -- 49394
			{"旅館老闆", "旅館老闆杜更斯",{60.2,64.0}}, -- 49430
		-- 獸欄管理員
			{"獸欄管理員", "塞多蒙•克雷爾",{56.8,46.8}}, -- 10057/110357 惡魔入侵
			{"獸欄管理員", "莎儂•朗博",{36.2,61.6}}, -- 49395/110889 惡魔入侵
			{"獸欄管理員", "安歇爾•湯瑟沃斯",{59.6,64.8}}, -- 49431
		-- 專業訓練師
			{"煉金術訓練師", "瑟爾格•希諾特",{49.0,66.2}}, -- 2391
			{"草藥學訓練師", "阿蘭奈•維諾布拉德",{57.2,47.4}}, -- 2390/110345 惡魔入侵
			{"裁縫訓練師", "達瑞爾•斯塔克",{58.0,47.8}}, -- 2399
		-- 商人
			{"雷矛軍需官", "塔薩迪斯•雪光",{44.6,46.6}}, -- 13217
			{"霜狼軍需官", "喬雷克•鐵盾",{58.0,33.6}}, -- 13219
			{"中立<煉金配方：冰霜之油>商人", "布洛金",{44.0,21.8}}, -- 2480
		},

		-- Arathi Highlands
		["阿拉希高地"]={
		-- 飛行管理員
			{"獅鷲管理員", "瑟迪克•普羅斯",{39.8,47.4}}, -- 2835
			{"雙足飛龍管理員", "尤爾達",{68.2,33.4}}, -- 2851
			{"蝙蝠管理員", "洛達•鮑威",{13.4,34.8}}, -- 43104
		-- 旅館老闆
			{"聯盟旅館老闆", "維琪•隆薩夫",{40.0,49.0}}, -- 2808
			{"部落旅館老闆", "旅館老闆埃德瓦",{69.0,33.4}}, -- 9501
		-- 獸欄管理員
			{"部落獸欄管理員", "薩里頓",{69.0,34.0}}, -- 9976
			{"聯盟獸欄管理員", "艾米莉•傑克遜",{40.0,49.0}}, -- 44123
		-- 專業訓練師
			{"部落制皮訓練師", "布魯姆•白蹄",{21.8,46.6}}, -- 7869
		-- 商人
			{"污染者軍需官", "盧瑟弗•圖恩",{68.4,30.6}}, -- 15126
			{"阿拉索軍需官", "薩繆爾•霍克",{40.2,46.4}}, -- 15127
		},

		-- Northern Stranglethorn
		["北荊棘穀"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "塞斯塔",{39.0,51.2}}, -- 1387
			{"獅鷲管理員", "羅伯特•洛德斯",{52.6,66.2}}, -- 43042
			{"獅鷲管理員", "詹姆斯•斯蒂賴爾",{47.8,11.8}}, -- 43045
			{"部落飛行管理員", "拉斯克哈",{62.4,39.2}}, -- 43052
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆蘇貝克",{37.2,51.8}}, -- 5814
			{"聯盟旅館老闆", "利文斯頓•馬紹爾",{53.2,66.8}}, -- 44019
		-- 獸欄管理員
			{"部落獸欄管理員", "杜雷克",{38.0,51.2}}, -- 16094
		-- 專業訓練師
			{"部落烹飪訓練師", "瑪杜克",{37.2,49.2}}, -- 1382
			{"部落草藥學訓練師", "安葛籣",{38.6,48.4}}, -- 2856
			{"部落制皮訓練師", "布勞恩",{37.8,50.4}}, -- 1385
			{"部落制皮訓練師", "瑟伊布",{45.2,58.6}}, -- 7871
		-- 交通工具
			{"飛艇", "奧格瑞瑪-杜隆塔爾;提瑞斯法林地",{37.5,51.5}},
		},

		-- The Cape of Stranglethorn
		["荊棘穀海角"]={
		-- 拍賣師
			{"拍賣師", "拍賣師克雷斯克",{42.0,73.4}}, -- 9858
			{"拍賣師", "拍賣師格拉維斯",{43.0,71.4}}, -- 15677
			{"拍賣師", "拍賣師奧利雷",{40.2,72.2}}, -- 15681
		-- 銀行職員
			{"銀行職員", "掘金者維茲尼克",{40.0,72.4}}, -- 2625
			{"銀行職員", "掘金者裡克",{40.0,72.4}}, -- 8123
		-- 飛行管理員
			{"雙足飛龍管理員", "格林戈",{40.6,73.2}}, -- 2858
			{"獅鷲管理員", "蓋爾",{41.6,74.4}}, -- 2859
			{"獅鷲管理員", "科林•迅錘",{55.6,41.2}}, -- 43043/52646
			{"部落飛行管理員", "希茲爾",{35.0,39.2}}, -- 43053
		-- 旅館老闆
			{"旅館老闆", "旅館老闆斯金德",{40.8,73.8}}, -- 6807
			{"部落旅館老闆", "旅館老闆德拉克希爾",{35.0,27.2}}, -- 44190
		-- 獸欄管理員
			{"獸欄管理員", "格雷米斯塔克",{41.4,73.6}}, -- 10060
			{"部落獸欄管理員", "費奇•沃奇沃茲",{34.8,27.6}}, -- 44191
		-- 專業訓練師
			{"煉金術訓練師", "加克森",{42.6,74.8}}, -- 2837
			{"鍛造訓練師", "布裡克•基克拉夫",{44.0,70.8}}, -- 2836
			{"烹飪訓練師", "甘特夫人",{42.6,72.8}}, -- 54232
			{"工程學訓練師", "奧格索普•奧布諾提斯",{43.0,72.0}}, -- 7406
			{"釣魚訓練師", "麥依茲•拉齊卡",{41.6,73.4}}, -- 2834
			{"草藥學訓練師", "芙羅拉•希沃溫德",{42.0,74.6}}, -- 908
			{"裁縫訓練師", "格拉尼克•古斯提",{43.6,73.0}}, -- 2627
		-- 商人
			{"中立<鸚鵡籠>商人", "納爾克",{42.6,69.2}}, -- 2663
		-- 交通工具
			{"船舶", "棘齒城-北貧瘠之地",{38.6,67.4}},
		},

		-- The Hinterlands
		["辛特蘭"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "格卡斯",{81.6,81.8}}, -- 4314
			{"獅鷲管理員", "戈斯魯姆",{11.0,46.0}}, -- 8018
			{"獅鷲管理員", "布羅克•鐵須",{65.6,44.8}}, -- 43570
			{"部落飛行管理員", "凱倫•庫恩",{32.4,58.0}}, -- 43573
		-- 旅館老闆
			{"聯盟旅館老闆", "旅館老闆蘇弗拉姆",{14.0,44.8}}, -- 7744
			{"部落旅館老闆", "拉爾德",{78.2,81.2}}, -- 14731
			{"聯盟旅館老闆", "旅館老闆柯爾南",{66.2,44.4}}, -- 43699
			{"部落旅館老闆", "小小胖",{31.8,58.0}}, -- 43739
		-- 獸欄管理員
			{"聯盟獸欄管理員", "基利姆•石趾",{14.4,45.2}}, -- 10061
			{"部落獸欄管理員", "獵戶馬克霍爾",{79.0,79.6}}, -- 14741
			{"聯盟獸欄管理員", "塔薩恩•雷石",{66.4,45.0}}, -- 43770
			{"部落獸欄管理員", "羅斯林•帕克斯頓",{32.0,57.6}}, -- 43766
		-- 專業訓練師
			{"聯盟制皮訓練師", "德拉克•石拳",{13.4,43.4}}, -- 11097
			{"部落釣魚訓練師", "釣魚者卡圖姆",{80.4,81.4}}, -- 14740
		},

		-- Western Plaguelands
		["西瘟疫之地"]={
		-- 飛行管理員
			{"獅鷲管理員", "比比爾法茲",{42.8,85.0}}, -- 12596
			{"蝙蝠管理員", "朗達•莫維爾",{46.6,64.6}}, -- 46004
			{"聯盟飛行管理員", "金妮•古德溫",{39.4,69.4}}, -- 46006
			{"中立獅鷲管理員", "瑪姬•赫夫曼",{50.4,52.2}}, -- 46011
			{"中立飛行管理員", "威廉•亨特爾森",{44.6,18.4}}, -- 47875
		-- 旅館老闆
			{"聯盟旅館老闆", "馬特莉大媽",{43.4,84.4}}, -- 46269
			{"部落旅館老闆", "羅曼•加內爾",{48.2,63.8}}, -- 47857
		-- 獸欄管理員
			{"獸欄管理員", "漢克•福特",{47.2,31.8}}, -- 47761
			{"部落獸欄管理員", "洛伊斯•亨德爾森",{47.8,64.0}}, -- 47866
		-- 商人
			{"銀色北伐軍需官", "銀色黎明軍需官萊斯巴克",{42.8,83.8}}, -- 10857
			{"中立<元素精華煉金配方>商人", "瑪格努斯•霜鳴",{68.0,77.6}}, -- 11278
		},

		-- Eastern Plaguelands
		["東瘟疫之地"]={
		-- 飛行管理員
			{"獅鷲管理員", "凱琳•斯蒂文",{75.8,53.4}}, -- 12617
			{"飛行管理員", "格萊森•鐵翼",{51.2,21.2}}, -- 28621
			{"飛行管理員", "鬼翼",{83.8,50.2}}, -- 29480
			{"飛行管理員", "弗萊克斯•巴克特德普",{10.0,65.8}}, -- 37888
			{"飛行管理員", "理查•杜魯弗賴特",{61.6,43.8}}, -- 44230
			{"飛行管理員", "德沃•曼寧",{52.8,53.6}}, -- 44231
			{"飛行管理員", "詹尼絲•邁爾斯",{34.8,68.0}}, -- 44232
			{"飛行管理員", "小威廉•凱拉",{18.4,27.4}}, -- 44233
		-- 旅館老闆
			{"旅館老闆", "傑希卡•查伯斯",{75.6,52.4}}, -- 16256
		-- 商人
			{"銀色北伐軍軍需官", "軍需官米蘭達•布利洛克",{75.8,54.0}}, -- 11536
			{"牧師聖騎士<技能書>商人", "軍需官米蘭達•布利洛克",{75.8,54.0}}, -- 11536 -- need translation 7.0.3新增職業物品
			{"死亡騎士軍需官", "軍需官奧佐格",{82.0,48.2}}, -- 28512
			{"死亡騎士商人", "黑鋒骸骨獅鷲;技能書",{68.0,77.6}}, -- 29587 -- need translation 7.0.3新增職業物品
			--{"中立<白銀之手套裝>PvE裝備商", "Eadric the Pure",{75.6,49.2}}, -- 100196 -- need translation
		},

		-- Badlands
		["荒蕪之地"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "格裡克",{17.2,40.2},0}, -- 2861
			{"飛行管理員", "米可茲•蜜旅",{64.2,35.2},0}, -- 44407
			{"部落飛行管理員", "塞拉娜",{52.4,50.8},0}, -- 44408
			{"聯盟飛行管理員", "南茜•空酒",{48.4,36.2},0}, -- 44409
			{"聯盟飛行管理員", "傑克•荒地",{21.6,57.6},0}, -- 44410
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆舒爾卡",{18.2,42.8},0}, -- 9356
			{"旅館老闆", "莎莉•固輪",{65.8,35.6},0}, -- 48054
			{"聯盟旅館老闆", "埃文•齊菲爾",{20.6,56.2},0}, -- 48093
			{"旅館老闆", "偉大的皮薩尼",{90.0,37.6},0}, -- 49934
		-- 獸欄管理員
			{"部落獸欄管理員", "格雷斯",{18.2,42.2},0}, -- 10058
			{"獸欄管理員", "迪迪•投矢",{65.6,36.4},0}, -- 48055
			{"聯盟獸欄管理員", "卡催娜•萊昂斯",{21.0,56.6},0}, -- 48095
		},

		-- Searing Gorge
		["灼熱峽谷"]={
		-- 飛行管理員
			{"獅鷲管理員", "蘭尼•瑞德",{37.8,30.6},0}, -- 2941
			{"雙足飛龍管理員", "格瑞沙",{34.8,30.8},0}, -- 3305
			{"飛行管理員", "道格•俯衝",{41.0,68.6},0}, -- 47927
		-- 旅館老闆
			{"旅館老闆", "威爾瑪•崩岩",{39.4,66.2},0}, -- 47942
		-- 獸欄管理員
			{"獸欄管理員", "卡恩•峭牧",{40.6,68.6},0}, -- 47934
		},

		-- Burning Steppes
		["燃燒平原"]={
		-- 飛行管理員
			{"獅鷲管理員", "博古斯•粗臂",{72.2,65.6},0}, -- 2299
			{"雙足飛龍管理員", "瓦格魯克",{54.2,24.2},0}, -- 13177
			{"飛行管理員", "漢斯•石翱",{17.6,52.6},0}, -- 48318
			{"飛行管理員", "格裡姆•焦羽",{46.0,41.8},0}, -- 48321
		-- 商人
			{"術士絕版<克索諾斯恐懼戰馬任務物品>商人", "戈瑟奇•邪眼",{8.2,35.8},0}, -- 14437
		},

		-- Deadwind Pass -- need update
		["逆風小徑"]={
		-- 拍賣師
			{"蒸汽動力拍賣師", "Brassbolt Mechawrench",{43.8,67.2}}, -- 99094
		-- 銀行職員
			{"銀行職員", "Teller Gee",{45.6,84.2}}, -- 113414
			{"銀行職員", "Teller Plushner",{45.6,85.2}}, -- 113415
		-- 獸欄管理員
			{"獸欄管理員", "Tassia Whisperglen",{50.8,71.4}}, -- 113337
		-- 專業訓練師
			{"煉金術訓練師", "Linzy Blackbolt",{45.0,69.4}}, -- 99157
			{"鍛造訓練師", "Alard Schmied",{45.8,68.4}}, -- 99121
			{"附魔訓練師", "Enchanter Nalthanis",{44.0,72.4}}, -- 98839
			{"工程學訓練師", "Didi the Wrench",{44.0,67.2}}, -- 99076
			{"工程學訓練師", "Findle Whistlesteam",{44.0,67.2}}, -- 99078
			{"工程學訓練師", "Timofey Oshenko",{43.8,67.2}}, -- 99098
			{"急救訓練師", "Olisarra the Kind",{43.2,71.0}}, -- 98843
			{"草藥學訓練師", "Dorothy Egan",{45.2,70.2}}, -- 99167
			{"銘文學訓練師", "Professor Pallin",{44.8,71.0}}, -- 99169
			{"珠寶設計訓練師", "Timothy Jones",{44.4,70.4}}, -- 98901
			{"制皮訓練師", "Namha Moonwater",{43.0,68.4}}, -- 98950
			{"採礦訓練師", "Jedidiah Handers",{44.8,67.4}}, -- 99099
			{"裁縫訓練師", "Ainderu Summerleaf",{43.2,70.0}}, -- 98908
		-- 商人
			{"法師<魔寵石>玩具商人", "恩多拉•莫爾海德",{43.6,77.2}}, -- 99337 -- 達拉然同名NPC 28715
		},

		-- Swamp of Sorrows
		["悲傷沼澤"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "佈雷依克",{47.6,55.0}}, -- 6026
			{"中立獅鷲管理員", "斯基茲",{72.0,12.0}}, -- 43086
			{"獅鷲管理員", "寶拉•巴爾德溫",{70.0,38.4}}, -- 43087
			{"飛行管理員", "耶德林",{30.6,34.6}}, -- 43088
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆卡拉庫爾",{46.8,56.8}}, -- 6930
			{"旅館老闆", "格裡奇船長",{71.6,13.8}}, -- 47334
			{"聯盟旅館老闆", "瓦拉德",{29.0,32.4}}, -- 47367
		-- 獸欄管理員
			{"部落獸欄管理員", "哈克魯",{47.2,55.2}}, -- 10049
			{"獸欄管理員", "謝奇•蝦獵",{72.0,14.8}}, -- 47337
			{"聯盟獸欄管理員", "喬蘭",{28.6,33.2}}, -- 47368
		-- 專業訓練師
			{"部落煉金術訓練師", "羅格瓦爾",{49.8,56.0}}, -- 1386
			{"部落傳送門訓練師", "洛林•躍火",{49.6,55.6}}, -- 27705
		},

		-- Plaguelands: The Scarlet Enclave
		["東瘟疫之地：血色領地"]={
		-- 商人
			{"死亡騎士軍需官", "軍需官奧佐格",{48.8,32.2}}, -- 28512
		},

		-- Blasted Lands
		["詛咒之地"]={
		-- 飛行管理員
			{"獅鷲管理員", "亞歷山大•康斯坦丁",{61.2,21.6}}, -- 8609
			{"角鷹獸管理員", "格拉漢姆•麥凱利斯特",{47.0,89.2}}, -- 43107
			{"龍鷹管理員", "莎琳娜",{50.8,72.8}}, -- 43114
			{"雙足飛龍管理員", "普蕾達",{43.6,14.2}}, -- 43121
			{"聯盟飛行管理員", "阿拉茲",{67.6,28.0}}, -- 85731
			{"部落飛行管理員", "艾茉莉•風刃",{72.8,48.6}}, -- 85734
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆格拉克",{40.4,11.4}}, -- 44309
			{"聯盟旅館老闆", "莫爾頓老媽",{60.6,14.0}}, -- 44325
			{"聯盟旅館老闆", "多娜•貝利莫",{44.4,87.6}}, -- 44334
		-- 獸欄管理員
			{"部落獸欄管理員", "克魯夫",{41.6,12.8}}, -- 44310
			{"聯盟獸欄管理員", "吉娜•格拉爾",{60.2,16.0}}, -- 44330
			{"聯盟獸欄管理員", "威拉德•C•貝南頓",{46.0,85.4}}, -- 44335
		-- 專業訓練師
			{"聯盟急救訓練師", "“縫衣針”焊釘",{67.6,28.6}}, -- 76108
			{"部落急救訓練師", "羅特•骨指",{72.2,47.8}}, -- 76519
		-- 商人
			{"聯盟任務獎勵兌換商人", "軍需官琳黛勒",{66.4,27.6}}, -- 76117
			{"部落任務獎勵兌換商人", "澤平•震鉗",{71.6,49.0}}, -- 76522
		},

		-- Isle of Quel'Danas
		["奎爾丹納斯島"]={
		-- 飛行管理員
			{"中立龍鷹管理員", "歐胡拉",{48.4,25.2}}, -- 26560
		-- 旅館老闆
			{"旅館老闆", "護理員因納拉",{51.0,33.8}}, -- 25036
		-- 獸欄管理員
			{"獸欄管理員", "塞拉菲娜•血心",{50.2,35.4}}, -- 25037
		-- 商人
			{"破碎殘陽軍需官", "艾爾達拉•晨行者",{47.2,30.6}}, -- 25032
			--{"PvE裝備商", "瑟雷米斯",{50.2,28.6}}, -- 25976 "失落神器管理者"
			--{"PvE裝備商", "伊爾瑪",{50.2,28.2}}, -- 25977 "辛多雷聖物轉化師"
			{"PvE裝備商", "瑟雷米斯;伊爾瑪",{50.2,28.6}}, -- 25976/25977
			--{"PvP裝備商", "卡艾莉",{50.0,39.8}}, -- 26089 "特種裝備銷售商"
			--{"PvP裝備商", "卡蕾娜",{49.6,40.4}}, -- 26090 "特種裝備銷售商"
			--{"PvP裝備商", "歐魯斯",{50.0,40.0}}, -- 26091 "特種裝備銷售商"
			--{"PvP裝備商", "索因",{49.4,39.8}}, -- 26092 "特種裝備銷售商"
			{"PvP裝備商", "卡艾莉;卡蕾娜;歐魯斯;索因",{50.0,40.0}}, -- 26089/26090/26091/26092
		},

		-- Abyssal Depths
		["無底海淵"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "迅捷的海馬",{56.8,75.4}}, -- 40866
			{"部落飛行管理員", "迅捷的海馬",{53.8,59.6}}, -- 40873
		-- 旅館老闆
			{"聯盟旅館老闆", "營房主管密爾遜",{54.6,72.2}}, -- 42963
			{"部落旅館老闆", "旅館老闆內留斯",{51.2,60.6}}, -- 43141
		-- 獸欄管理員
			{"聯盟獸欄管理員", "凱斯•威瑟爾",{56.0,73.0}}, -- 42966
			{"部落獸欄管理員", "舒拉克",{53.0,59.2}}, -- 43151
		},

		-- Kelp'thar Forest
		["柯爾普薩之森"]={
		-- 飛行管理員
			{"飛行管理員", "迅捷的海馬",{56.2,31.0}}, -- 40852
			{"部落飛行管理員", "迅捷的海馬",{49.2,87.8}}, -- 43216
			{"聯盟飛行管理員", "迅捷的海馬",{42.4,66.2}}, -- 43287
		-- 旅館老闆
			{"聯盟旅館老闆", "石語者埃魯納克",{45.0,23.2}}, -- 36915
			{"旅館老闆", "石語者埃魯納克",{63.8,59.8}}, -- 41341
			{"部落旅館老闆", "石語者埃魯納克",{38.8,31.6}}, -- 41618
		-- 商人
			{"聯盟大地之環裝備商人", "石語者埃魯納克",{45.0,23.2}}, -- 36915
			{"部落大地之環裝備商人", "石語者埃魯納克",{38.8,31.6}}, -- 41618
		},

		-- Shimmering Expanse
		["爍光海床"]={
		-- 飛行管理員
			{"飛行管理員", "迅捷的海馬",{49.4,41.2}}, -- 40851
			{"聯盟飛行管理員", "迅捷的海馬",{48.6,57.4}}, -- 40867
			--{"部落飛行管理員", "迅捷的海馬",{50.8,63.4}}, -- 40871
			{"部落飛行管理員", "布裡格拉爾",{61.0,28.2}}, -- 43220
			{"獅鷲管理員", "法蘭西斯•格林尼",{57.0,17.0}}, -- 43290
			{"部落飛行管理員", "迅捷的海馬",{49.4,65.6}}, -- 43293
		-- 旅館老闆
			{"旅館老闆", "看護者穆拉",{49.2,42.0}}, -- 39878
			{"聯盟旅館老闆", "阿麗莎•瑪西利",{49.6,57.4}}, -- 42873
			{"部落旅館老闆", "尊加",{51.6,62.6}}, -- 42908
		-- 獸欄管理員
			{"獸欄管理員", "看護者阿魯",{49.4,42.0}}, -- 41903
			{"聯盟獸欄管理員", "米莉安•黃銅炸彈",{49.0,57.6}}, -- 42875
			{"部落獸欄管理員", "拉洛克",{51.4,62.6}}, -- 42911
		-- 商人
			{"大地之環軍需官", "補給官阿羅克",{49.0,42.0}}, -- 50324
		},

		-- Vashj'ir
		["瓦絲琪爾"]={
		-- 飛行管理員
			{"部落飛行管理員", "布洛格多爾",{64.8,68.0}}, -- 43225
			{"聯盟飛行管理員", "濕咸的麥克特拉維斯",{69.4,75.2}}, -- 43295
		},

		-- Twilight Highlands
		["暮光高地"]={
		-- 飛行管理員
			--{"獅鷲管理員", "安古斯•巍山",{43.8,57.2}}, -- 45904
			--{"雙足飛龍管理員", "喬喬•黏脖",{45.6,76.0}}, -- 45947
			{"部落飛行管理員", "哈爾波•電肘",{75.4,17.8}}, -- 47061
			--{"雙足飛龍管理員", "托克羅格",{45.6,76.2}}, -- 47116
			{"雙足飛龍管理員", "托克羅格;喬喬•黏脖",{45.6,76.2}}, -- 45947/47116
			--{"獅鷲管理員", "戴斯蒙德•查德沃斯",{43.8,57.2}}, -- 47118
			{"獅鷲管理員", "戴斯蒙德•查德沃斯;安古斯•巍山",{43.8,57.2}}, -- 45904/47118
			{"獅鷲管理員", "葛籣•阿爾巴克",{81.6,77.0}}, -- 47119
			{"飛行管理員", "阿奎納斯塔茲",{28.4,24.8}}, -- 47121
			{"雙足飛龍管理員", "桑希格",{36.8,38.0}}, -- 47133
			{"獅鷲管理員", "法斯塔德•石握",{60.4,57.6}}, -- 47147
			{"獅鷲管理員", "多朗•爪心",{48.6,28.2}}, -- 47154
			{"獅鷲管理員", "沙伊娜•爪心",{56.6,15.2}}, -- 47155
			{"雙足飛龍管理員", "布拉莫克•血翼",{54.0,42.2}}, -- 47156
			{"部落飛行管理員", "格索烏",{73.8,52.8}}, -- 47174
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆魯茨",{75.8,52.6}}, -- 49498
			{"聯盟旅館老闆", "沃恩•密須",{54.6,18.0}}, -- 49574
			{"聯盟旅館老闆", "納威恩•軟鼻",{49.6,30.4}}, -- 49591
			{"聯盟旅館老闆", "本•莫拉",{43.6,57.2}}, -- 49599
			--{"聯盟旅館老闆", "旅館老闆特蕾莎",{79.0,77.6}}, -- 49686
			--{"聯盟旅館老闆", "旅館老闆法蘭西斯",{79.4,78.6}}, -- 49688
			{"聯盟旅館老闆", "旅館老闆特蕾莎;旅館老闆法蘭西斯",{79.0,77.6}}, -- 49686/49688
			{"部落旅館老闆", "旅館老闆克魯姆",{45.0,76.6}}, -- 49747
			{"部落旅館老闆", "旅館老闆圖爾克",{73.2,42.8}}, -- 49762
			{"部落旅館老闆", "旅館老闆吉諾",{75.4,16.6}}, -- 49783
			{"聯盟旅館老闆", "旅館老闆科林",{60.4,58.0}}, -- 49795
		-- 獸欄管理員
			{"部落獸欄管理員", "卡納斯",{75.6,52.6}}, -- 49554
			{"聯盟獸欄管理員", "巴爾德•黑羽",{55.6,14.8}}, -- 49577
			{"聯盟獸欄管理員", "塔爾姆•深谷",{48.6,29.6}}, -- 49593
			{"聯盟獸欄管理員", "馬修•徹奇希爾",{43.6,57.4}}, -- 49600
			{"聯盟獸欄管理員", "邦妮•海寧根",{80.6,77.4}}, -- 49689
			{"部落獸欄管理員", "紮伊哈娜",{45.2,76.4}}, -- 49755
			{"部落獸欄管理員", "魯克•髒塔",{53.8,43.0}}, -- 49767
			{"部落獸欄管理員", "卡茲•費查姆",{75.6,16.8}}, -- 49790
			{"聯盟獸欄管理員", "科恩南",{60.2,58.0}}, -- 49803
		-- 商人
			{"蠻錘部族軍需官", "克勞•麥克格羅",{48.6,30.6}}, -- 49386
			{"龍喉氏族軍需官", "格羅特•致命打擊",{53.8,42.0}}, -- 49387
			--{"聯盟碎片商人", "塞希伊",{78.6,77.0}}, -- 50134
			--{"聯盟重蠻皮商人", "米斯蒂•梅裡維斯",{78.6,76.2}}, -- 50381
			--{"聯盟燃鋼錠商人", "布藍達爾•鑿膽",{79.0,76.6}}, -- 50382
			--{"聯盟燼絲布卷商人", "塞爾•費拉加",{78.6,76.8}}, -- 50386
			{"聯盟兌換商人", "碎片;重蠻皮;燃鋼錠;燼絲布卷",{78.6,77.0}}, -- 50134/50381/50382/50386
			--{"部落碎片商人", "阿加提亞•法拉諾斯",{76.6,49.4}}, -- 50146
			--{"部落重蠻皮商人", "斯雷姆•黑首",{75.2,50.0}}, -- 50172
			--{"部落燃鋼錠商人", "庫爾丹•鋼齒",{77.2,53.0}}, -- 50375
			--{"部落燼絲布卷商人", "阿裡斯塔萊昂•日織",{75.2,50.0}}, -- 50433
			{"部落兌換商人", "碎片;重蠻皮;燃鋼錠;燼絲布卷",{76.6,49.4}}, -- 50146/50172/50375/50433
			{"中立<大災變食品>商人", "古羅克•漢姆奇克",{50.6,58.4}}, -- 57262
		},

	-- 外域 Outland
		-- Hellfire Peninsula
		["地獄火半島"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "巴爾雷",{56.2,36.2}}, -- 16587
			{"獅鷲管理員", "克莉爾•比特修",{54.6,62.4}}, -- 16822
			{"角鷹獸管理員", "古瑪",{25.2,37.2}}, -- 18785
			{"雙足飛龍管理員", "維拉加•亂羽",{87.4,48.2}}, -- 18930
			{"獅鷲管理員", "阿米什•蠻錘",{87.4,52.4}}, -- 18931
			{"雙足飛龍管理員", "因娜麗雅",{27.8,60.0}}, -- 18942
			{"雙足飛龍管理員", "阿米爾雅•風心",{61.6,81.2}}, -- 19558
			{"獅鷲管理員", "魯恩托格•蠻錘",{78.4,35.0}}, -- 20234
		-- 旅館老闆
			{"部落旅館老闆", "佛洛德•平克",{56.6,37.4}}, -- 16602
			{"聯盟旅館老闆", "希德•利巴迪",{54.2,63.4}}, -- 16826
			{"部落旅館老闆", "旅館老闆巴希爾•歐洛塔斯",{26.8,59.6}}, -- 18905
			{"聯盟旅館老闆", "奧菲拉•風怒",{23.4,36.4}}, -- 18906
		-- 獸欄管理員
			{"部落獸欄管理員", "獵手托爾弗•怒蹄",{54.4,41.0}}, -- 16586
			{"聯盟獸欄管理員", "軍士長洛琳•薩梅洛克",{54.4,62.6}}, -- 16824
		-- 專業訓練師
			{"聯盟煉金術訓練師", "煉金師格裡比",{53.8,65.8}}, -- 18802
			{"聯盟考古學訓練師", "歌達•法德爾芙",{53.6,65.8}}, -- 47574
			{"聯盟鍛造訓練師", "哈姆菲",{56.8,63.8}}, -- 16823
			{"聯盟鍛造訓練師", "達姆菲",{51.2,60.2}}, -- 21209
			{"聯盟烹飪訓練師", "加斯頓",{54.0,63.4}}, -- 18987
			{"聯盟附魔訓練師", "喬漢•巴內斯",{53.6,66.0}}, -- 18773
			{"聯盟工程學訓練師", "萊布斯基",{55.6,65.4}}, -- 18775
			{"聯盟急救訓練師", "布林庫",{22.4,39.2}}, -- 18990
			{"聯盟飛行訓練師", "哈根•銅翼",{54.2,62.6}}, -- 35100
			{"聯盟草藥學訓練師", "羅雷利恩",{53.6,65.8}}, -- 18776
			{"聯盟銘文學訓練師", "邁克爾•斯克瓦",{54.0,65.6}}, -- 30721
			{"聯盟珠寶設計訓練師", "塔蒂亞娜",{54.6,63.6}}, -- 18774
			{"聯盟制皮訓練師", "布魯曼",{54.0,64.0}}, -- 18771
			{"聯盟採礦訓練師", "霍納克•格裡莫德",{56.6,63.8}}, -- 18779
			{"聯盟剝皮訓練師", "耶蕾娜•夜空",{54.4,63.2}}, -- 18777
			{"聯盟裁縫訓練師", "哈瑪",{54.6,63.6}}, -- 18772
			{"部落煉金術訓練師", "藥劑師安東尼維奇",{52.2,36.4}}, -- 16588
			{"部落考古學訓練師", "茜拉貝爾",{52.4,36.0}}, -- 47573
			{"部落鍛造訓練師", "羅霍克",{53.2,38.2}}, -- 16583
			{"部落烹飪訓練師", "阿莉森",{56.8,37.4}}, -- 49789
			{"部落附魔訓練師", "菲蘭妮婭",{52.2,36.0}}, -- 18753
			{"部落工程學訓練師", "塞比格",{54.8,38.6}}, -- 18752
			{"部落急救訓練師", "阿蕾瑟拉",{26.2,62.0}}, -- 18991
			{"部落飛行訓練師", "馭風者雅胡布",{54.2,41.6}}, -- 35093
			{"部落草藥學訓練師", "魯埃克•硬角",{52.2,36.2}}, -- 18748
			{"部落銘文學訓練師", "奈菲拉蒂",{52.2,36.0}}, -- 30722
			{"部落珠寶設計訓練師", "卡萊恩",{56.8,37.6}}, -- 18751
			{"部落制皮訓練師", "巴里姆•裂蹄",{56.2,38.6}}, -- 18754
			{"部落採礦訓練師", "克魯格什",{55.4,37.6}}, -- 18747
			{"部落剝皮訓練師", "穆魯圖",{56.2,38.4}}, -- 18755
			{"部落裁縫訓練師", "達琳娜",{56.6,37.2}}, -- 18749
		-- 商人
			{"榮耀堡軍需官", "後勤軍需官烏瑞卡",{56.6,62.6}}, -- 17657
			{"薩爾瑪軍需官", "軍需官烏爾格隆",{54.8,37.8}}, -- 17585
			--{"聯盟寶石商人", "委任官翠希•普羅維爾",{56.4,62.8}}, -- 18266
			--{"聯盟寶石商人", "馬庫斯•斯卡蘭",{53.9,63.5}}, -- 22227
			{"聯盟寶石商人", "委任官翠希•普羅維爾;馬庫斯•斯卡蘭",{56.4,62.8}}, -- 18266/22227
			--{"部落寶石商人", "傳令官布萊肯•黑眼",{55.8,39.0}}, -- 18267
			--{"部落寶石商人", "雷甘•曼庫索",{56.8,37.6}}, -- 22225
			{"部落寶石商人", "傳令官布萊肯•黑眼;雷甘•曼庫索",{55.8,39.0}}, -- 18267/22225

		},

		-- Zangarmarsh
		["贊加沼澤"]={
		-- 飛行管理員
			{"角鷹獸管理員", "蒙希",{67.8,51.4}}, -- 18788
			{"雙足飛龍管理員", "杜迦",{33.0,51.0}}, -- 18791
			{"雙足飛龍管理員", "古爾基爾",{84.8,55.0}}, -- 20762
			{"角鷹獸管理員", "哈盧",{41.2,28.8}}, -- 22485
		-- 旅館老闆
			{"部落旅館老闆", "梅拉吉特",{30.6,50.8}}, -- 18245
			{"聯盟旅館老闆", "看護者阿比達爾",{67.2,49.0}}, -- 18251
			{"旅館老闆", "旅館老闆考伊斯•斯托克頓",{78.4,63.0}}, -- 18907
			{"聯盟旅館老闆", "旅館老闆克爾普",{41.8,26.2}}, -- 18908
		-- 獸欄管理員
			{"獸欄管理員", "卡米爾•長路",{78.8,64.2}}, -- 17896
			{"部落獸欄管理員", "坎蘭",{31.8,49.8}}, -- 18244
			{"聯盟獸欄管理員", "約拉爾",{67.6,49.6}}, -- 18250
		-- 專業訓練師
			{"烹飪訓練師", "納卡",{78.6,63.0}}, -- 18993
			{"聯盟工程學訓練師", "凱莉•弗萊",{68.6,50.2}}, -- 17634
			{"部落工程學訓練師", "馬克•迪沃",{34.0,51.0}}, -- 17637
			{"部落釣魚訓練師", "蘇爾加亞",{32.2,49.6}}, -- 18018
			{"釣魚訓練師", "基諾•杜弗萊",{78.0,66.0}}, -- 18911
		-- 商人
			{"塞納裡奧遠征隊軍需官", "芬德雷•迅矛",{79.2,63.8}}, -- 17904
			{"孢子村軍需官", "麥卡",{17.8,51.2}}, -- 18382
			{"榮耀堡印記商人", "部落戰地斥候",{33.0,49.0}}, -- 18564
			{"薩爾瑪印記商人", "聯盟戰地斥候",{64.6,46.4}}, -- 18581
		},

		-- Terokkar Forest
		["泰羅卡森林"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "柯納",{49.2,43.4}}, -- 18807
			{"獅鷲管理員", "伏爾南•天嘯",{59.4,55.4}}, -- 18809
		-- 旅館老闆
			{"部落旅館老闆", "旅館老闆格里爾卡",{48.8,45.0}}, -- 18957
			{"聯盟旅館老闆", "旅館老闆貝莉比",{56.6,53.2}}, -- 19296
		-- 獸欄管理員
			{"部落獸欄管理員", "塔拉戈",{49.4,44.6}}, -- 18984
			{"聯盟獸欄管理員", "雷薩安",{56.8,53.8}}, -- 24905
		-- 專業訓練師
			{"急救訓練師", "學者恩沙姆",{30.8,76.0}}, -- 22477
			{"釣魚訓練師", "老漁夫巴爾洛",{38.6,12.8}}, -- 25580
		-- 商人
			{"天空衛隊軍需官", "格蕾拉",{64.2,66.2}}, -- 23367
			{"部落幽魂碎片商人", "靈魂先知加爾托克",{49.8,46.6}}, -- 19772
			{"聯盟幽魂碎片商人", "靈魂先知斯蘭",{56.0,53.6}}, -- 19773
		},

		-- Nagrand 477
		["納格蘭外域"]={
		-- 飛行管理員
			{"角鷹獸管理員", "菲爾古",{54.2,75.0}}, -- 18789
			{"雙足飛龍管理員", "古爾沙",{57.2,35.2}}, -- 18808
		-- 旅館老闆
			{"部落旅館老闆", "蒂基特",{56.6,34.6}}, -- 18913
			{"聯盟旅館老闆", "看護者伊塞爾",{54.2,76.0}}, -- 18914
		-- 獸欄管理員
			{"部落獸欄管理員", "維爾達•熊鬃",{56.8,40.8}}, -- 19018
			{"聯盟獸欄管理員", "盧弗塔希婭",{55.8,74.6}}, -- 19019
		-- 商人
			{"庫雷尼軍需官", "商人納拉蘇",{54.6,75.0}}, -- 20240
			{"瑪格漢軍需官", "補給官納瑟拉",{53.4,36.8}}, -- 20241
			{"星界財團軍需官", "帕斯塔茲",{30.6,57.0}}, -- 23007
			--{"部落哈蘭勳章商人", "軍需官亞弗雷•諾雷裡克",{41.2,44.2}}, -- 18821
			--{"聯盟哈蘭勳章商人", "軍需官達維安•瓦克拉弗",{41.2,44.2}}, -- 18822
			{"哈蘭勳章商人", "[A]軍需官達維安•瓦克拉弗;[H]軍需官亞弗雷•諾雷裡克",{41.2,44.2}}, -- 18821/18822
			{"薩滿<技能書>商人", "元素師沙爾瓦克",{60.6,22.2}}, -- 18072 -- need translation 7.0.3新增職業物品
		},

		-- Blade's Edge Mountains
		["刀鋒山"]={
		-- 飛行管理員
			{"角鷹獸管理員", "埃莫倫•葉影",{37.8,61.4}}, -- 18937
			{"雙足飛龍管理員", "安努克•綠蹄",{52.0,54.2}}, -- 18953
			{"獅鷲管理員", "裡普•派茲拉姆",{61.0,70.4}}, -- 21107
			{"飛行管理員", "菲恩•葉影",{61.6,39.6}}, -- 22216
			{"部落飛行管理員", "飛行管理員瑪克索",{76.4,65.8}}, -- 22455
		-- 旅館老闆
			{"聯盟旅館老闆", "旅館老闆肖恩妮絲",{35.8,63.8}}, -- 19495
			{"部落旅館老闆", "苟拉爾",{53.2,55.4}}, -- 19470
			{"部落旅館老闆", "瓦拉伊",{76.0,60.2}}, -- 21088
			{"聯盟旅館老闆", "菲茲特•錶針",{60.8,68.2}}, -- 21110
			{"旅館老闆", "旅館老闆埃蕾爾婭",{62.8,38.2}}, -- 22922
		-- 獸欄管理員
			{"部落獸欄管理員", "勞爾",{53.6,53.2}}, -- 19476
			{"部落獸欄管理員", "奧格林",{75.6,60.4}}, -- 22468
			{"聯盟獸欄管理員", "菲斯卡•影歌",{36.0,64.6}}, -- 22469
			{"獸欄管理員", "天空衛隊獸欄管理員",{27.6,52.6}}, -- 23392
		-- 專業訓練師
			{"部落急救訓練師", "菲拉•蒼白行者",{53.8,55.0}}, -- 19478
			{"部落制皮訓練師", "格裡卡",{76.8,65.4}}, -- 21087
		-- 商人
			{"奧格瑞拉軍需官", "霍納斯",{28.0,58.6}}, -- 23428
			{"埃匹希斯商人", "資深乙太技師",{54.4,10.8}}, -- 23244 "Aether-tech Adept"
			{"埃匹希斯商人", "資深乙太技師",{54.4,10.8}}, -- 23245 "Aether-tech Master" -- need translation
		},

		-- Netherstorm
		["虛空風暴"]={
		-- 銀行職員
			{"銀行職員", "納迪克斯",{33.0,67.8}}, -- 21732
			{"銀行職員", "坎索",{32.8,68.0}}, -- 21733
			{"銀行職員", "塞克希",{32.6,67.8}}, -- 21734
			{"銀行職員", "米達",{32.2,37.2}}, -- 28343
		-- 飛行管理員
			{"飛行管理員", "克雷茲希爾",{33.8,64.0}}, -- 18938
			{"飛行管理員", "葛籣尼克",{45.2,34.8}}, -- 19583
			{"飛行管理員", "哈帕克斯",{65.2,66.6}}, -- 20515
		-- 旅館老闆
			{"旅館老闆", "尤尼克斯",{43.4,36.0}}, -- 19531
			{"旅館老闆", "旅館老闆雷米•度蘇",{32.0,64.4}}, -- 19571
		-- 獸欄管理員
			{"獸欄管理員", "裡薩•卡勒菲克斯",{32.0,64.8}}, -- 24974
		-- 專業訓練師
			{"附魔訓練師", "阿薩納",{44.2,33.6}}, -- 19540
			{"工程學訓練師", "塞希羅",{32.4,66.6}}, -- 19576
			{"珠寶設計訓練師", "賈達萊德",{44.4,34.0}}, -- 19539
		-- 商人
			{"星界財團軍需官", "卡拉茲",{43.6,34.4}}, -- 20242
			--{"PvP裝備商", "打擊者科吉克",{33.0,64.2}}, -- 54650 "角鬥士Gladiator" "復仇角鬥士Vengeful" "殘酷角鬥士Merciless" "將軍General" "統帥Marshal"
			--{"PvP裝備商", "Izzee the 'Clutch'",{33.0,64.2}}, -- 107599 "殘酷角鬥士Merciless" "老兵Veteran" -- need translation
			--{"PvP裝備商", "Kitzie Crankshot",{33.0,64.2}}, -- 107610 "復仇角鬥士Vengeful" "守備官Vindicator" -- need translation
			--{"PvP裝備商", "Blaze Magmaburn",{33.2,64.0}}, -- 107619 "野蠻角鬥士Brutal" "守衛者Guardian" -- need translation
			{"PvP裝備商", "老兵;統帥;將軍;守備官;守衛者;S1;S2;S3;S4",{33.0,64.2}}, -- 54650/107599/107610/107619
			--{"PvE裝備商", "克裡希•賓奇維斯",{33.0,64.0}}, -- 23396 "經典舊世聯盟鎖甲及板甲"
			--{"PvE裝備商", "格雷克斯•布萊伯勒",{33.0,64.0}}, -- 40209 "經典舊世聯盟布甲及皮甲"
			--{"PvE裝備商", "雷尼•“招牌微笑”•斯莫",{33.0,64.0}}, -- 54648 "經典舊世部落鎖甲及板甲"
			--{"絕版PvE裝備商", "佐克•托齊維克",{33.0,64.2}}, -- 54649 "經典舊世武器"
			--{"PvE裝備商", "提尼•斯莫",{33.0,64.0}}, -- 58152 "經典舊世部落布甲及皮甲"
			{"PvE裝備商", "克裡希•賓奇維斯;格雷克斯•布萊伯勒,etc.",{33.0,64.0}}, -- 23396/40209/54648/54649/58152
			{"寵物商人", "商人拉沙德",{43.4,35.2}}, -- 20980 "特種小動物"
			{"<達拉然泰坦神鐵徽記>商人", "Blaze Magmaburn",{33.2,64.0}}, -- 107619 -- need translation
		-- 其他NPC
			{"美容師", "普裡克•斯韋尼",{31.0,66.8}}, -- 29145
		},

		-- Shadowmoon Valley 473
		["影月穀外域"]={
		-- 飛行管理員
			{"獅鷲管理員", "布魯貝克•雷足",{37.6,55.4}}, -- 18939
			{"雙足飛龍管理員", "德雷克格爾",{30.2,29.2}}, -- 19317
			{"飛行管理員", "瑪蒂克斯",{63.2,30.4}}, -- 19581
			{"飛行管理員", "奧雷索爾",{56.2,57.8}}, -- 21766
		-- 旅館老闆
			{"旅館老闆", "看護者奧魯羅",{61.0,28.2}}, -- 21746
			{"聯盟旅館老闆", "德雷格•掠雲",{37.0,58.2}}, -- 19352
			{"旅館老闆", "霍盧斯",{66.2,87.0}}, -- 23143
			{"部落旅館老闆", "旅館老闆達爾格•血爪",{30.2,27.8}}, -- 19319
			{"旅館老闆", "倫德瑪爾",{56.2,59.8}}, -- 21744
		-- 獸欄管理員
			{"聯盟獸欄管理員", "克裡恩•尋路者",{37.6,56.0}}, -- 19368
			{"部落獸欄管理員", "蓋德拉",{29.2,29.4}}, -- 21336
		-- 專業訓練師
			{"部落鍛造訓練師", "格魯塔恩",{29.6,31.6}}, -- 19341
			{"聯盟烹飪訓練師", "希琳•鋼翼",{37.2,58.4}}, -- 19369
			{"聯盟工程學訓練師", "奈奧比•維茲巴克",{36.6,55.0}}, -- 24868
			{"部落工程學訓練師", "喬納森•加雷特",{29.2,28.6}}, -- 25099
			{"部落飛行訓練師", "歐爾洛克",{29.2,29.2}}, -- 20500
			{"聯盟飛行訓練師", "伊爾薩•槍酒",{37.2,56.2}}, -- 20511
		-- 商人
			{"中立<靈翼幼龍的韁繩>商人", "霍爾倫克",{65.6,86.0}}, -- 23489
		},

	-- 諾森德 Northrend
		-- Borean Tundra
		["北風苔原"]={
		-- 飛行管理員
			{"飛行管理員", "蘇雷斯塔茲",{45.2,34.4}}, -- 24795
			{"雙足飛龍管理員", "圖莉達•冷風",{40.4,51.4}}, -- 25288
			{"聯盟飛行管理員", "卡拉•芒星",{56.6,20.}}, -- 26602
			{"雙足飛龍管理員", "烏姆•魂風",{77.6,37.8}}, -- 26847
			{"雙足飛龍管理員", "基姆比紮",{49.6,11.0}}, -- 26848
			{"獅鷲管理員", "湯瑪斯•雷維爾",{58.8,68.2}}, -- 26879
			{"飛行管理員", "戰鬥法師阿達米",{33.0,34.4}}, -- 27046
			{"飛行管理員", "比爾克•迪弗斯巴克",{78.4,51.4}}, -- 28195
		-- 旅館老闆
			{"聯盟旅館老闆", "詹姆斯•迪肯",{58.2,68.0}}, -- 25245
			{"部落旅館老闆", "威廉姆森",{41.8,54.4}}, -- 25278
			{"聯盟旅館老闆", "查莉•諾斯托",{57.0,18.6}}, -- 26596
			{"部落旅館老闆", "帕烏•霜蹄",{76.2,37.2}}, -- 26709
			{"部落旅館老闆", "護理者瑪迦爾",{49.6,10.0}}, -- 27069
			{"旅館老闆", "護理者普奧盧",{78.4,49.2}}, -- 27187
		-- 獸欄管理員
			{"部落獸欄管理員", "布蕾卡•狼女",{49.8,10.6}}, -- 27065
			{"聯盟獸欄管理員", "塞莉德•酒痕",{58.4,68.6}}, -- 27010
			{"部落獸欄管理員", "杜爾克特•狼脈",{40.2,55.0}}, -- 26044
			{"部落獸欄管理員", "哈洛娜•雷語者",{77.0,37.2}}, -- 26721
			{"聯盟獸欄管理員", "羅奈爾得•安德森",{56.6,73.0}}, -- 27385
			{"聯盟獸欄管理員", "“母鵝”托比•鐵栓",{57.0,19.0}}, -- 26597
			{"獸欄管理員", "獵手薩格哈尼",{78.0,49.0}}, -- 27194
		-- 專業訓練師
			{"聯盟煉金術訓練師", "法隆•夜語",{57.8,71.8}}, -- 26987
			{"聯盟考古學訓練師", "法達•法德爾芙",{57.6,71.6}}, -- 47576
			{"聯盟鍛造訓練師", "亞格•斯托德",{57.2,66.6}}, -- 26988
			{"聯盟烹飪訓練師", "羅裡克•瑪克雷爾",{57.8,71.6}}, -- 26989
			{"聯盟附魔訓練師", "亞莉希絲•瑪洛",{57.6,71.6}}, -- 26990
			{"聯盟工程學訓練師", "索克•亮釘",{57.6,72.2}}, -- 26991
			{"聯盟急救訓練師", "布萊娜•維爾森",{57.8,66.2}}, -- 26992
			{"聯盟釣魚訓練師", "老人羅伯特",{57.8,66.2}}, -- 26993
			{"聯盟飛行訓練師", "麥格拉•鋒羽",{58.8,68.2}}, -- 35133
			{"聯盟草藥學訓練師", "基琳•月舞",{57.8,71.8}}, -- 26994
			{"聯盟銘文學訓練師", "汀克•亮釘",{57.6,71.6}}, -- 26995
			{"聯盟珠寶設計訓練師", "奧雷斯托斯",{57.4,72.2}}, -- 26997
			{"聯盟制皮訓練師", "洛絲瑪麗•伯瓦爾德",{57.6,71.8}}, -- 26998
			{"聯盟採礦訓練師", "芬德里格•紅須",{57.4,66.2}}, -- 26999
			{"聯盟剝皮訓練師", "獵戶傑克",{57.6,71.8}}, -- 27000
			{"聯盟裁縫訓練師", "達爾林•古斯丁",{57.4,72.2}}, -- 27001
			{"部落煉金術訓練師", "亞瑟•亨斯洛",{41.8,54.2}}, -- 26975
			{"部落考古學訓練師", "林德雷爾",{41.2,53.8}}, -- 47577
			{"部落鍛造訓練師", "克洛格•鋼骨",{40.8,55.2}}, -- 26981
			{"部落烹飪訓練師", "奧恩•嫩蹄",{42.0,54.2}}, -- 26972
			{"部落附魔訓練師", "艾歐萊•晨擊",{41.2,53.8}}, -- 26980
			{"部落工程學訓練師", "首席技師利維尼",{42.6,53.6}}, -- 25277
			{"部落急救訓練師", "護士艾波伍德",{41.6,54.4}}, -- 29233
			{"部落釣魚訓練師", "漁夫瑟爾金",{41.8,54.6}}, -- 32474
			{"部落飛行訓練師", "馭風者薩曼巴",{42.0,55.2}}, -- 35135
			{"部落草藥學訓練師", "塔希•蠻鬃",{42.0,53.6}}, -- 26974
			{"部落銘文學訓練師", "奧德蕾•炎槍",{41.2,53.8}}, -- 26977
			{"部落珠寶設計訓練師", "格巴里",{41.6,53.4}}, -- 26982
			{"部落制皮訓練師", "埃萬•冰原",{76.2,37.0}}, -- 26996
			{"部落採礦訓練師", "布隆娜•鐵斧",{42.6,53.2}}, -- 26976
			{"部落剝皮訓練師", "迪波妮•雷語者",{76.2,37.4}}, -- 26986
			{"部落裁縫訓練師", "萊娜",{41.6,53.4}}, -- 26969
		-- 商人
			{"聯盟先遣軍軍需官", "後勤官希瓦絲頓",{57.6,66.2}}, -- 32564
			{"部落遠征軍軍需官", "迦拉•裂顱者",{41.4,53.6}}, -- 32565
			{"冬鱗蚌殼商人", "呀嚕咕嚕",{43.0,13.8}}, -- 25206
		-- 交通工具
			{"船舶","暴風城港口-暴風城",{59.7,69.4}},
			{"飛艇","奧格瑞瑪-杜隆塔爾",{41.4,53.6}},
			{"船舶","莫亞基港口-龍骨荒野",{77.3,51.4}},
		},

		-- Howling Fjord
		["嚎風峽灣"]={
		-- 飛行管理員
			{"獅鷲管理員", "普莉希拉•冬風",{59.8,63.2}}, -- 23736
			{"獅鷲管理員", "格雷爾•岩錘",{31.2,44.0}}, -- 23859
			{"雙足飛龍管理員", "塞莉亞•冰鬃",{49.4,11.6}}, -- 24032
			{"獅鷲管理員", "詹姆斯•奧斯比",{60.0,16.0}}, -- 24061
			{"蝙蝠管理員", "托比亞斯•薩克霍夫",{52.0,67.4}}, -- 24155
			{"蝙蝠管理員", "莉莉絲•拉德斯庫",{26.0,25.0}}, -- 26844
			{"蝙蝠管理員", "艾德琳•查博斯",{79.0,29.6}}, -- 27344
			{"飛行管理員", "基普•特斯基普",{24.6,57.8}}, -- 28197
		-- 旅館老闆
			{"聯盟旅館老闆", "旅館老闆哈吉爾•拉格拉斯",{58.4,62.6}}, -- 23731
			{"聯盟旅館老闆", "旅館老闆塞蕾絲•古德哈徹",{30.8,41.4}}, -- 23937
			{"部落旅館老闆", "波雷•寒冬圖騰",{49.4,10.8}}, -- 24033
			{"聯盟旅館老闆", "克利絲蒂娜•丹尼爾",{60.4,15.8}}, -- 24057
			{"部落旅館老闆", "巴希爾•奧斯古德",{52.2,66.4}}, -- 24149
			{"部落旅館老闆", "蒂姆斯•霍蘭德",{79.6,30.8}}, -- 24342
			{"旅館老闆", "護理員伊克尼克",{25.4,59.8}}, -- 27148
		-- 獸欄管理員
			{"聯盟獸欄管理員", "馬童霍拉提奧",{58.6,63.0}}, -- 23733
			{"聯盟獸欄管理員", "阿爾提•灰手",{60.6,16.0}}, -- 24066
			{"部落獸欄管理員", "瑪哈納•霜蹄",{49.4,11.0}}, -- 24067
			{"部落獸欄管理員", "瑪麗•達隆",{52.0,66.6}}, -- 24154
			{"部落獸欄管理員", "羅伯特•克拉克",{79.0,30.8}}, -- 24350
			{"獸欄管理員", "獵戶塞什",{25.4,59.0}}, -- 27150
			{"聯盟獸欄管理員", "切爾希•雷斯",{31.6,41.4}}, -- 29658
		-- 專業訓練師
			{"聯盟煉金術訓練師", "拉諾利斯•晨露",{58.4,62.2}}, -- 26903
			{"聯盟考古學訓練師", "胡根•金智",{58.2,62.4}}, -- 47578
			{"聯盟鍛造訓練師", "羅希娜•雷維特",{59.6,63.6}}, -- 26904
			{"聯盟烹飪訓練師", "布羅姆",{58.2,62.0}}, -- 26905
			{"聯盟附魔訓練師", "伊莉莎白•傑克森",{58.6,62.8}}, -- 26906
			{"聯盟工程學訓練師", "提沙•長橋",{59.6,64.0}}, -- 26907
			{"聯盟急救訓練師", "學者亞米娜",{59.8,62.2}}, -- 23734
			{"聯盟釣魚訓練師", "拜隆•維爾維克",{60.2,64.0}}, -- 26909
			{"聯盟草藥學訓練師", "菲因•語葉",{58.8,63.0}}, -- 26910
			{"聯盟銘文學訓練師", "明蒂•丁克斯",{58.2,62.4}}, -- 26916
			{"聯盟珠寶設計訓練師", "恩霍羅",{59.8,63.8}}, -- 26915
			{"聯盟制皮訓練師", "波娜蒂特•迪克斯特",{59.8,63.6}}, -- 26911
			{"聯盟採礦訓練師", "格魯伯爾•鐵鋤",{59.8,63.8}}, -- 26912
			{"聯盟剝皮訓練師", "菲德里克•布林霍斯",{59.8,63.6}}, -- 26913
			{"聯盟裁縫訓練師", "本傑明•克萊格",{58.6,62.6}}, -- 26914
			{"部落煉金術訓練師", "維爾赫米娜•雷尼爾",{78.6,28.6}}, -- 26951
			{"部落考古學訓練師", "伊安•湯瑪斯•沃爾",{79.4,29.2}}, -- 47568
			{"部落鍛造訓練師", "克裡斯汀•斯米瑟",{79.2,29.0}}, -- 26952
			{"部落烹飪訓練師", "湯瑪斯•克裡奇",{78.6,29.4}}, -- 26953
			{"部落附魔訓練師", "埃米爾•奧頓",{78.6,28.2}}, -- 26954
			{"部落工程學訓練師", "亞米希娜•瓦特雷",{78.4,30.0}}, -- 26955
			{"部落急救訓練師", "薩莉•托普金斯",{79.4,29.4}}, -- 26956
			{"部落釣魚訓練師", "安吉麗娜•索倫",{79.4,27.2}}, -- 26957
			{"部落草藥學訓練師", "瑪律約裡•凱恩斯",{78.4,28.4}}, -- 26958
			{"部落銘文學訓練師", "書記員凱爾斯",{79.4,29.2}}, -- 26959
			{"部落珠寶設計訓練師", "卡特爾•迪芬斯",{79.2,28.8}}, -- 26960
			{"部落制皮訓練師", "岡特爾•漢森",{78.2,28.2}}, -- 26961
			{"部落採礦訓練師", "喬納森•路易斯",{79.2,29.0}}, -- 26962
			{"部落剝皮訓練師", "洛貝塔•賈克斯",{78.2,28.2}}, -- 26963
			{"部落裁縫訓練師", "亞歷山卓•米庫恩",{79.4,30.6}}, -- 26964
		-- 商人
			{"卡魯亞克軍需官", "塔奈卡",{25.4,58.6}}, -- 31916
			{"聯盟先遣軍軍需官", "後勤官員布萊頓",{59.6,63.8}}, -- 32773
			{"部落遠征軍軍需官", "塞巴斯迪安•克蘭",{79.6,30.6}}, -- 32774
		-- 交通工具
			{"飛艇","提瑞斯法林地",{77.7,28.3}},
			{"船舶","米奈希爾港-濕地",{61.3,62.6}},
			{"船舶","莫亞基港口-龍骨荒野",{23.9,58.0}},
		},

		-- Dragonblight
		["龍骨荒野"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "納蘇•破天者",{37.4,45.6}}, -- 26566
			{"蝙蝠管理員", "朱特爾•維斯",{76.4,62.2}}, -- 26845
			{"雙足飛龍管理員", "努莫•魂風",{43.8,16.8}}, -- 26850
			{"飛行管理員", "奈瑟斯塔茲",{60.2,51.4}}, -- 26851
			{"獅鷲管理員", "德里克•拉米爾",{39.4,25.8}}, -- 26877
			{"獅鷲管理員", "羅尼•威爾斯",{77.0,49.8}}, -- 26878
			{"角鷹獸管理員", "帕蕾娜•銀雲",{29.2,55.4}}, -- 26881
			{"飛行管理員", "希德•弗勞菲克斯",{48.4,74.4}}, -- 28196
		-- 旅館老闆
			{"部落旅館老闆", "軍營管理員哈爾加",{38.0,46.6}}, -- 26985
			{"部落旅館老闆", "溫特白夫人",{76.8,63.0}}, -- 27027
			{"聯盟旅館老闆", "伊露希亞•盧恩",{77.4,51.4}}, -- 27042
			{"聯盟旅館老闆", "諾哈因",{28.8,56.0}}, -- 27052
			{"旅館老闆", "護理者穆米克",{48.2,74.6}}, -- 27174
			{"旅館老闆", "德米斯塔茲",{59.8,54.2}}, -- 27950
		-- 獸欄管理員
			{"部落獸欄管理員", "加爾米•赫佐格",{76.8,62.6}}, -- 28057
			{"獸欄管理員", "莉塞拉",{61.6,53.4}}, -- 27948
			{"聯盟獸欄管理員", "哨兵琪珊•清泉",{28.8,56.0}}, -- 27056
			{"部落獸欄管理員", "索艾•鷹怒",{37.0,48.6}}, -- 26504
			{"獸欄管理員", "獵戶提卡尼",{48.4,74.6}}, -- 27183
			{"聯盟獸欄管理員", "達納蘇斯的塞巴魯斯",{77.4,50.8}}, -- 27040
		-- 專業訓練師
			{"部落煉金術訓練師", "煉金師布蕾薩",{36.2,48.6}}, -- 27023
			{"部落煉金術訓練師", "藥劑師沃維克",{76.8,62.2}}, -- 27029
			{"部落鍛造訓練師", "伯魯斯•折鐵",{36.6,47.0}}, -- 26564
			{"部落鍛造訓練師", "約裡克•費姆",{75.8,63.2}}, -- 27034
		-- 商人
			{"龍眠聯軍軍需官", "希爾絲塔薩",{59.8,53.0}}, -- 32533
			{"卡魯亞克軍需官", "塞魯克",{48.6,75.6}}, -- 32763
		-- 交通工具
			{"船舶","卡瑪古-嚎風峽灣;烏努比-北風苔原",{48.5,75.3}},
		},

		-- Grizzly Hills
		["灰熊丘陵"]={
		-- 飛行管理員
			{"雙足飛龍管理員", "克拉烏",{22.0,64.4}}, -- 26852
			{"雙足飛龍管理員", "瑪姬•冬風",{64.8,46.8}}, -- 26853
			{"獅鷲管理員", "瓦娜•格雷",{31.2,59.2}}, -- 26880
			{"獅鷲管理員", "薩繆爾•克萊布克",{59.8,26.6}}, -- 26876
		-- 旅館老闆
			{"聯盟旅館老闆", "軍需官米卡迪",{59.4,26.2}}, -- 26375
			{"部落旅館老闆", "埃亞•冷風",{65.4,47.0}}, -- 26680
			{"聯盟旅館老闆", "珍妮佛•貝爾",{32.0,60.2}}, -- 27066
			{"部落旅館老闆", "軍營管理員雷爾庫",{20.8,64.4}}, -- 27125
		-- 獸欄管理員
			{"聯盟獸欄管理員", "侍從皮爾斯",{59.0,26.6}}, -- 26377
			{"部落獸欄管理員", "索魯克•雷怒",{65.0,47.8}}, -- 26944
			{"聯盟獸欄管理員", "瑪修•埃克曼",{32.6,59.6}}, -- 27068
			{"聯盟獸欄管理員", "蒂姆•斯崔特",{13.8,84.6}}, -- 29250
			{"部落獸欄管理員", "考烏爾",{13.8,84.8}}, -- 29251
			{"部落獸欄管理員", "克拉迦•鐵刺",{21.6,64.0}}, -- 29740
		-- 商人
			--{"部落風險硬幣商人", "普科姆",{13.8,86.2}}, -- 27730
			--{"聯盟風險硬幣商人", "“灰發”亞當斯",{13.8,86.4}}, -- 27760
			{"風險硬幣商人", "[A]“灰發”亞當斯;[H]普科姆",{13.8,86.4}}, -- 27730/27760
		},

		-- Zul'Drak
		["祖達克"]={
		-- 飛行管理員
			{"飛行管理員", "毒翼",{14.0,73.6}}, -- 28615
			--{"飛行管理員", "丹妮卡•森特",{32.2,74.4}}, -- 28618
			{"飛行管理員", "古瑞克",{41.4,64.4}}, -- 28623
			{"飛行管理員", "瑪爾卡",{60.0,56.8}}, -- 28624
			--{"飛行管理員", "莉安娜中士",{32.0,74.4}}, -- 29137
			{"飛行管理員", "丹妮卡•森特;莉安娜中士",{32.2,74.4}}, -- 28618/29137
			{"飛行管理員", "拉法伊",{70.4,23.2}}, -- 30569
		-- 旅館老闆
			{"旅館老闆", "瑪麗薩•艾沃基",{40.8,66.2}}, -- 28791
			{"旅館老闆", "潘婭",{59.2,57.2}}, -- 29583
		-- 獸欄管理員
			{"獸欄管理員", "法拉•柔蹄",{40.2,65.2}}, -- 28790
			{"獸欄管理員", "阿斯佳莉",{59.0,57.6}}, -- 30039
		},

		-- Sholazar Basin
		["索拉查盆地"]={
		-- 飛行管理員
			{"飛行管理員", "諾莫瑞根之魂",{25.2,58.4}}, -- 28037
			{"飛行管理員", "瑪爾文•搖鏈",{50.0,61.4}}, -- 28574
		-- 旅館老闆
			{"旅館老闆", "普瑟爾•波利安",{26.8,59.2}}, -- 28038
		-- 獸欄管理員
			{"獸欄管理員", "哈迪烏斯•哈洛維",{27.2,59.4}}, -- 28047
		-- 專業訓練師
			{"飛行訓練師", "飛行員維克",{50.0,61.4}}, -- 28746
			{"大師級草藥學訓練師", "Dani Earthtouch",{63.8,49.0}}, -- 98223
		-- 商人
			{"神諭者軍需官", "吉恩",{54.6,56.2}}, -- 31910
			{"狂心氏族軍需官", "塔納克",{55.0,69.0}}, -- 31911
			{"獵人<技能書>商人","瑪爾丹•雷蹄",{27.2,59.6}}, -- 28040 -- need translation 7.0.3新增職業物品
		},

		-- Icecrown
		["冰冠冰川"]={
		-- 飛行管理員
			{"飛行管理員", "茉莉亞•恐翼",{43.6,24.4}}, -- 30314
			{"飛行管理員", "埃丹•莫蘭",{87.8,78.0}}, -- 30433
			{"飛行管理員", "本諾比奧斯",{79.4,72.2}}, -- 31069
			{"飛行管理員", "恐翼",{19.4,47.8}}, -- 31078
			{"飛行管理員", "赫爾利丹•輕翼",{72.6,22.6}}, -- 33849
		-- 旅館老闆
			{"旅館老闆", "新兵佈雷納斯",{44.0,22.2}}, -- 30308
			{"聯盟旅館老闆", "卡雷斯•炎槍",{76.2,19.6}}, -- 33970
			{"部落旅館老闆", "亞爾林•晨光",{76.0,24.0}}, -- 33971
		-- 獸欄管理員
			{"獸欄管理員", "伯納爾•鐵足",{69.6,22.0}}, -- 35344
			{"獸欄管理員", "伊哈蒂亞",{44.2,22.4}}, -- 30304
			{"聯盟獸欄管理員", "月玲",{75.8,20.2}}, -- 35291
			{"部落獸欄管理員", "斯汀•綠角",{75.6,23.6}}, -- 35290
			{"獸欄管理員", "湯瑪斯•帕塔基",{71.8,22.4}}, -- 33854
		-- 專業訓練師
			{"煉金術訓練師", "克莉絲塔•火花",{71.6,21.0}}, -- 33588
			{"鍛造訓練師", "重錘蕾卡",{71.8,20.8}}, -- 33591
			{"烹飪訓練師", "貝薩妮•克倫威爾",{72.4,20.8}}, -- 33587
			{"附魔訓練師", "費爾•晨歌",{73.0,20.6}}, -- 33583
			{"工程學訓練師", "賓吉•明鏈",{72.2,20.8}}, -- 33586
			{"急救訓練師", "約瑟弗•威爾森",{71.4,22.6}}, -- 33589
			{"銘文學訓練師", "亞瑟•丹尼",{71.6,20.8}}, -- 33603
			{"珠寶設計訓練師", "歐魯洛斯",{71.4,20.8}}, -- 33590
			{"制皮訓練師", "庫爾德",{71.8,20.8}}, -- 33581
			{"裁縫訓練師", "達斯汀•維爾",{73.0,20.8}}, -- 33580
		-- 商人
			{"銀色北伐軍軍需官", "精銳北伐軍戰士奧利卡•塞加德",{87.6,75.6}}, -- 30431
			{"黑鋒騎士團軍需官", "女公爵麥恩克絲",{43.4,20.6}}, -- 32538
			{"冠軍徽記傳家寶", "卡普薩里斯夫人",{69.4,23.2}}, -- 34885
			--{"聯盟PvE裝備商", "奧術師阿薩琳娜",{75.2,21.6}}, -- 35573 "傳承正義軍需官"
			--{"部落PvE裝備商", "魔導師伊露維婭",{75.2,22.0}}, -- 35574 "傳承正義軍需官"
			{"PvE裝備商", "[A]奧術師阿薩琳娜;[H]魔導師伊露維婭",{75.2,21.6}}, -- 35573/35574
			{"軍需官", "奪日者;銀色盟約;八大主城;諾莫瑞根;暗矛",{76.2,19.6}}, -- 34772/34881|[A]33307/33310/33650/33653/33657|[H]33553/33554/33555/33556/33557
		},

		-- The Storm Peaks
		["風暴峭壁"]={
		-- 飛行管理員
			{"飛行管理員", "佈雷克•岩眉",{30.6,36.4}}, -- 29950
			{"飛行管理員", "古怪的沙瓦留斯",{44.4,28.2}}, -- 29951
			{"飛行管理員", "斯克茲爾•斯萊德",{40.6,84.6}}, -- 29721
			{"聯盟飛行管理員", "法爾多弗•冷寒",{29.6,74.2}}, -- 29750
			{"部落飛行管理員", "卡巴格•馴風者",{36.2,49.2}}, -- 29757
			{"雙足飛龍管理員", "海婭•帕爾卡",{65.4,50.6}}, -- 29762
			{"飛行管理員", "哈爾弗丹",{62.6,60.8}}, -- 32571
		-- 旅館老闆
			{"旅館老闆", "微笑的斯利爾克•布拉諾布",{41.0,85.8}}, -- 29904
			{"聯盟旅館老闆", "古達•硬錘",{28.6,74.4}}, -- 29926
			{"部落旅館老闆", "苦工加克拉",{37.0,49.6}}, -- 29944
			{"旅館老闆", "瑪古恩",{30.8,37.2}}, -- 29963
			{"部落旅館老闆", "瓦達巴•冰花",{67.6,50.6}}, -- 29971
			{"旅館老闆", "女主人伊布拉",{48.8,65.0}}, -- 30005
		-- 獸欄管理員
			{"獸欄管理員", "赫克希",{40.8,86.0}}, -- 29906
			{"聯盟獸欄管理員", "野豬馴養員布萊格",{28.6,74.4}}, -- 29948
			{"獸欄管理員", "安度爾格•岩甲",{30.6,36.8}}, -- 29959
			{"部落獸欄管理員", "安多霍•踏冰者",{67.4,50.2}}, -- 29967
			{"獸欄管理員", "獸王卡莉",{49.8,66.0}}, -- 30008
		-- 專業訓練師
			{"聯盟鍛造訓練師", "布蘭迪格",{28.8,74.8}}, -- 29924
			{"飛行訓練師", "洛克希•拉姆羅基",{40.6,84.8}}, -- 31247
		-- 商人
			{"霍迪爾之子軍需官", "李奧霍夫",{66.0,61.4}}, -- 32540
			{"聯盟奧杜爾聖物商人", "洛爾克•銳須",{28.8,74.0}}, -- 29744
			{"部落奧杜爾聖物商人", "奧魯特•埃雷古",{37.0,49.6}}, -- 30472
		},

		-- Crystalsong Forest
		["晶歌森林"]={
		-- 飛行管理員
			{"龍鷹管理員", "飛行管理員拜裡克",{78.4,50.2}}, -- 30269
			{"角鷹獸管理員", "加林德洛•白翼",{72.0,80.8}}, -- 30271
		-- 商人
			{"中立<工程圖紙:奧金幼龍>商人", "安德魯•錢伯斯",{34.0,35.6}}, -- 35826
		-- 交通工具
			{"傳送寶珠","達拉然-晶歌森林",{15.7,42.5}},
		},

		-- Wintergrasp
		["冬擁湖"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "埃佐•希弗萊特",{72.0,31.0}}, -- 30869
			{"部落飛行管理員", "赫佐•希弗萊特",{21.6,34.8}}, -- 30870
		-- 商人
			{"冬擁湖軍需官", "騎士達米隆",{51.6,17.6}}, -- [A]32294/39172|[H]32296/39173
		},

	-- 大漩渦 The Maelstrom
		-- The Lost Isles
		["失落群島"]={
		-- 銀行職員
			{"銀行職員", "大胖",{28.4,76.4}}, -- 36186
			{"銀行職員", "大胖",{56.8,32.2}}, -- 38746
		-- 旅館老闆
			{"旅館老闆", "格裡米•油指",{45.0,65.4}}, -- 42473
		-- 獸欄管理員
			{"獸欄管理員", "比斯布拉特•巴布斯納夫",{42.4,16.4}}, -- 68989 -- need translation
			{"獸欄管理員", "比斯布拉特•巴布斯納夫",{39.6,27.8}}, -- 68989
			{"獸欄管理員", "比斯布拉特•巴布斯納夫",{53.0,35.6}}, -- 68989
			{"獸欄管理員", "比斯布拉特•巴布斯納夫",{45.2,65.0}}, -- 68989
			{"獸欄管理員", "比斯布拉特•巴布斯納夫",{28.0,76.2}}, -- 68989
		-- 專業訓練師
			{"烹飪訓練師", "卡亞羅全能訓練機豪華版",{42.8,16.4}}, -- 45286
			{"烹飪訓練師", "卡亞羅全能訓練機豪華版",{39.6,27.8}}, -- 45286
			{"烹飪訓練師", "卡亞羅全能訓練機豪華版",{53.0,35.6}}, -- 45286
			{"烹飪訓練師", "卡亞羅全能訓練機豪華版",{45.6,65.6}}, -- 45286
			{"工程學訓練師", "卡亞羅全能訓練機豪華版",{42.8,16.4}}, -- 45286
			{"工程學訓練師", "卡亞羅全能訓練機豪華版",{39.6,27.8}}, -- 45286
			{"工程學訓練師", "卡亞羅全能訓練機豪華版",{53.0,35.6}}, -- 45286
			{"工程學訓練師", "卡亞羅全能訓練機豪華版",{45.6,65.6}}, -- 45286
			{"急救訓練師", "紮普諾茲醫生",{42.6,16.2}}, -- 36615
			{"急救訓練師", "紮普諾茲醫生",{28.4,76.4}}, -- 36615
			{"急救訓練師", "紮普諾茲醫生",{35.6,67.4}}, -- 36615
			{"急救訓練師", "紮普諾茲醫生",{45.6,65.6}}, -- 36615
			{"釣魚訓練師", "卡亞羅全能訓練機豪華版",{42.8,16.4}}, -- 45286
			{"釣魚訓練師", "卡亞羅全能訓練機豪華版",{39.6,27.8}}, -- 45286
			{"釣魚訓練師", "卡亞羅全能訓練機豪華版",{53.0,35.6}}, -- 45286
			{"釣魚訓練師", "卡亞羅全能訓練機豪華版",{45.6,65.6}}, -- 45286
			{"草藥學訓練師", "卡亞羅全能訓練機豪華版",{42.8,16.4}}, -- 45286
			{"草藥學訓練師", "卡亞羅全能訓練機豪華版",{39.6,27.8}}, -- 45286
			{"草藥學訓練師", "卡亞羅全能訓練機豪華版",{53.0,35.6}}, -- 45286
			{"草藥學訓練師", "卡亞羅全能訓練機豪華版",{45.6,65.6}}, -- 45286
			{"珠寶設計訓練師", "卡亞羅全能訓練機豪華版",{42.8,16.4}}, -- 45286
			{"珠寶設計訓練師", "卡亞羅全能訓練機豪華版",{39.6,27.8}}, -- 45286
			{"珠寶設計訓練師", "卡亞羅全能訓練機豪華版",{53.0,35.6}}, -- 45286
			{"珠寶設計訓練師", "卡亞羅全能訓練機豪華版",{45.6,65.6}}, -- 45286
			{"採礦訓練師", "卡亞羅全能訓練機豪華版",{42.8,16.4}}, -- 45286
			{"採礦訓練師", "卡亞羅全能訓練機豪華版",{39.6,27.8}}, -- 45286
			{"採礦訓練師", "卡亞羅全能訓練機豪華版",{53.0,35.6}}, -- 45286
			{"採礦訓練師", "卡亞羅全能訓練機豪華版",{45.6,65.6}}, -- 45286
		},

		-- The Wandering Isle
		["迷蹤島"]={
		-- 旅館老闆
			{"旅館老闆", "程•晨勉",{51.6,46.0}}, -- 57619
			{"旅館老闆", "老馬良",{49.0,58.4}}, -- 65046
		-- 獸欄管理員
			{"獸欄管理員", "馴獸師小麗",{53.6,47.8}}, -- 68986
		-- 專業訓練師
			{"煉金術訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"鍛造訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"鍛造訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"附魔訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"附魔訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"工程學訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"草藥學訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"草藥學訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"銘文學訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"珠寶設計訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"珠寶設計訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"制皮訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"採礦訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"採礦訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"剝皮訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"剝皮訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
			{"裁縫訓練師", "木藝師大偉",{63.0,41.6}}, -- 57620
			{"裁縫訓練師", "橡掌長老",{50.6,58.6}}, -- 65043
		},

		-- Deepholm
		["深岩之洲"]={
		-- 旅館老闆
			{"旅館老闆", "看護者努恩瓦",{49.2,51.8}}, -- 45300
		-- 獸欄管理員
			{"獸欄管理員", "馭獸者鏽夾",{51.2,50.2}}, -- 45297
			{"獸欄管理員", "馴騾者鐵棒",{47.4,51.6}}, -- 45298
		-- 商人
			{"塞拉贊恩軍需官", "收集者德羅姆",{56.8,13.2}}, -- 45408
		},

		-- Tol Barad Peninsula
		["托爾巴拉德半島"]={
		-- 商人
			{"巴拉丁典獄官軍需官", "軍需官佈雷澤",{72.6,62.6}}, -- 47328
			{"地獄咆哮近衛軍軍需官", "普格",{54.6,81.0}}, -- 48531
		},

	-- 潘達利亞 Pandaria
		-- The Jade Forest
		["翡翠林"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "歐提南",{58.0,82.4},0}, -- 56737
			{"飛行管理員", "酒桶飛人老李",{47.0,46.2},0}, -- 59186
			{"飛行管理員", "金莎•箭眼",{54.6,61.6},0}, -- 59727
			{"飛行管理員", "尹夏曆•湖花",{57.0,44.0},0}, -- 59732
			{"飛行管理員", "金戈•酒腹",{55.4,23.6},0}, -- 59733
			{"飛行管理員", "供應商陶莎",{50.8,26.8},0}, -- 59735
			{"飛行管理員", "好學的朱謹",{43.6,24.6},0}, -- 59736
			{"部落飛行管理員", "古魯金飛行管理猿",{27.8,47.8},0}, -- 60952
			{"飛行管理員", "天舞者阿吉",{43.0,68.4},0}, -- 64310
			{"聯盟飛行管理員", "焦翼",{46.0,85.0},0}, -- 66023
			{"部落飛行管理員", "韓翼",{28.0,15.6},0}, -- 66227
		-- 旅館老闆
			{"旅館老闆", "林•風裘",{45.6,43.8},0}, -- 55233
			{"旅館老闆", "菲拉•木穗",{54.6,63.2},0}, -- 57313
			{"聯盟旅館老闆", "和藹的傑蘇",{59.6,83.2},0}, -- 61599
			{"旅館老闆", "優雅的斯萬",{48.2,34.8},0}, -- 62322
			{"旅館老闆", "長者伯羅",{41.6,23.2},0}, -- 62867
			{"旅館老闆", "“海風”拉納",{55.8,24.4},0}, -- 62868
			{"聯盟旅館老闆", "佳意•蘋花",{44.8,84.4},0}, -- 65907
			{"部落旅館老闆", "酒坊老闆娘奇奇",{28.6,13.2},0}, -- 66236
		-- 獸欄管理員
			{"部落獸欄管理員", "獸語者吱吱",{27.8,46.8},0}, -- 66717
			{"聯盟獸欄管理員", "張垣",{44.6,84.8},0}, -- 66266
			{"獸欄管理員", "親切的阿宏",{46.4,43.8},0}, -- 66241
			{"獸欄管理員", "善良的潘",{54.8,63.0},0}, -- 66243
			{"部落獸欄管理員", "蘇米",{28.6,13.0},0}, -- 66230
		-- 專業訓練師
			{"鍛造訓練師", "“大錘”鐵倫",{48.4,36.8},0}, -- 65114
			{"烹飪訓練師", "秦",{46.2,45.4},0}, -- 56707
			{"附魔訓練師", "萊•咒爪",{46.8,42.8},0}, -- 65127
			{"聯盟急救訓練師", "索拉卡",{45.4,85.8},0}, -- 65983
			{"部落急救訓練師", "莫爾長老",{28.2,15.2},0}, -- 66222
			{"部落草藥學訓練師", "培育者苗萍",{27.8,15.4},0}, -- 66980
			{"聯盟草藥學訓練師", "果園守衛李梅",{45.4,86.0},0}, -- 67025
			{"銘文學訓練師", "墨水大師魏",{54.6,44.2},0}, -- 56065
			{"銘文學訓練師", "篆書人甯吉",{47.6,35.0},0}, -- 62327
			{"珠寶設計訓練師", "塑玉者麥逸",{48.4,36.8},0}, -- 65098
			{"採礦訓練師", "冶煉大師灰掌",{46.0,29.4},0}, -- 65092
			{"部落採礦訓練師", "碎石者里安",{27.8,14.8},0}, -- 66979
			{"聯盟採礦訓練師", "覓石者郭岩",{45.0,85.8},0}, -- 67024
			{"部落剝皮訓練師", "陷阱獵手里安",{27.8,15.4},0}, -- 66981
			{"聯盟剝皮訓練師", "“鹿角”郝立",{44.8,85.6},0}, -- 67026
		-- 商人
			{"部落<黯淡林木套裝>商人", "利維特•急刹",{27.2,50.6},0}, -- 56406
			{"中立<黯淡林木套裝>商人", "拙焰師匠",{46.6,45.6},0}, -- 56705 "探險裝備供應商"
			{"聯盟<黯淡林木套裝>商人", "織絲者如意",{58.2,84.0},0}, -- 61598 "探險裝備供應商"
			{"雲端翔龍騎士團軍需官","颯安•紅鱗",{56.6,44.4},0}, -- 58414
		},

		-- Krasarang Wilds
		["卡桑琅叢林"]={
		-- 飛行管理員
			{"部落飛行管理員", "黎娜•裂天者",{59.2,24.6},0}, -- 59046
			{"部落飛行管理員", "蒙奇•風蹄",{29.0,50.4},0}, -- 59047
			{"聯盟飛行管理員", "梅倫•月羽",{25.2,33.4},0}, -- 59048
			{"聯盟飛行管理員", "泰倫•月羽",{67.6,32.4},0}, -- 59049
			{"飛行管理員", "黃吉",{76.6,8.4},0}, -- 60232
			{"飛行管理員", "南博",{52.4,76.6},0}, -- 60441
			{"飛行管理員", "飛羽管理員李息",{31.2,63.2},0}, -- 65189
			{"部落飛行管理員", "庫姆薩爾",{9.6,52.6},0}, -- 67785
			{"聯盟飛行管理員", "達金•風須",{88.4,34.6},0}, -- 68226
		-- 旅館老闆
			{"部落旅館老闆", "艾希拉•逐晨者",{28.2,50.6},0}, -- 62967
			{"旅館老闆", "搏魚者柯蘭法",{51.6,77.2},0}, -- 62872
			{"聯盟旅館老闆", "酒保傑瑞爾",{88.8,35.2},0}, -- 69088
			{"部落旅館老闆", "馬拉雅•逐晨者",{60.8,24.8},0}, -- 58184
			{"旅館老闆", "仁慈的倪",{40.8,34.4},0}, -- 62869
			{"旅館老闆", "粗魯的肖老闆",{75.8,7.2},0}, -- 62879
			{"部落旅館老闆", "托納科",{10.8,52.4},0}, -- 67775
		-- 獸欄管理員
			{"部落獸欄管理員", "提夫•逐晨者",{59.2,24.4},0}, -- 59310
			{"聯盟獸欄管理員", "女獵手維爾耶麗",{67.2,32.2},0}, -- 66251
		-- 專業訓練師
			{"釣魚訓練師", "納特•帕格",{68.4,43.4},0}, -- 63721
		-- 商人
			{"垂釣翁軍需官", "納特•帕格",{68.4,43.4},0}, -- 63721
			{"神盾守備軍軍需官", "特工瑪律利",{89.6,33.4},0}, -- 69059
			{"統禦先鋒軍軍需官", "撕咬者古卡納",{10.8,53.4},0}, -- 69060
			{"統禦崗哨委任狀商人", "獵手佈雷克",{84.2,18.8},0}, -- 67558
			{"統禦崗哨委任狀商人", "普凡迪特•格蘭特利",{89.6,33.4},0}, -- 67881
			{"統禦崗哨委任狀商人", "游商斯科文",{17.6,79.4},0}, -- 68198
			{"雄獅港委任狀商人", "喬恩•星眼",{12.6,62.6},0}, -- 67447
			{"雄獅港委任狀商人", "奧格羅姆•黑牙",{10.6,53.6},0}, -- 67751
			{"雄獅港委任狀商人", "韋弗•沃博蒂特",{76.2,34.4},0}, -- 68107
		},

		-- [LEGION] Kun-Lai Summit -- need update
		["昆萊山"]={
		-- 飛行管理員
			{"飛行管理員", "表叔東風急",{42.8,69.6},0}, -- 60416
			{"飛行管理員", "大哥綠羽毛",{66.2,50.6},0}, -- 61118
			{"飛行管理員", "信•語雲",{63.2,40.2},0}, -- 61380
			{"飛行管理員", "風箏大師倪風",{43.8,89.6},0}, -- 61473
			{"飛行管理員", "觀風者喬雲",{72.4,94.0},0}, -- 61474
			{"飛行管理員", "小鬼白風箏",{57.6,59.8},0}, -- 61504
			{"飛行管理員", "追風人阿波",{62.4,30.0},0}, -- 61511
			{"飛行管理員", "風箏大師林息",{34.6,59.0},0}, -- 61512
			{"聯盟飛行管理員", "飛行家泰波",{54.0,84.2},0}, -- 61744
			{"部落飛行管理員", "翔天爪",{62.4,80.6},0}, -- 61745
			{"部落飛行管理員", "莫拉•天刃",{36.0,83.6},0}, -- 65863
		-- 旅館老闆
			{"旅館老闆", "李•金釀",{64.4,61.2},0}, -- 59405
			{"旅館老闆", "奇遊•霧爪",{57.4,60.0},0}, -- 59688
			{"旅館老闆", "苜蓿保管人",{42.6,69.6},0}, -- 60420
			{"旅館老闆", "劉哲",{62.4,28.8},0}, -- 60605/65535
			{"旅館老闆", "童叟無欺普利",{72.6,92.2},0}, -- 62871
			{"旅館老闆", "污泥盞",{44.4,90.2},0}, -- 62877
			{"聯盟旅館老闆", "焦慮的凱",{54.0,82.8},0}, -- 62882
			{"部落旅館老闆", "打瞌睡的麥金",{62.6,80.4},0}, -- 62883
			{"旅館老闆", "調酒師拓莫若",{56.0,91.6},0}, -- 65976
		-- 獸欄管理員
			{"獸欄管理員", "表哥山麝香",{42.2,69.2},0}, -- 59413
			{"獸欄管理員", "牧民自由麝",{65.4,61.6},0}, -- 59509
		-- 專業訓練師
			--{"部落考古學訓練師", "埃萊娜拉",{57.2,78.6},0}, -- 47346 --need update
			{"急救訓練師", "陳藥師",{71.6,92.8},0}, -- 59077
			{"急救訓練師", "畢邇大師",{51.0,40.2},0}, -- 66357
			{"制皮訓練師", "亮皮帶",{64.6,60.8},0}, -- 65121
			{"採礦訓練師", "布蘭登師傅",{48.6,44.6},0}, -- 66360
		-- 商人
			--{"部落PvP裝備商", "魯•戴斯文",{35.4,83.2},0}, -- 75688 "暴虐角鬥士Tyrannical"
			--{"部落PvP裝備商", "洛克諾•血拳",{35.4,83.4},0}, -- 75690 "恐怖角鬥士Dreadful"
			--{"部落PvP裝備商", "桃麗絲•奇爾頓妮斯",{35.4,83.4},0}, -- 75693 "惡毒角鬥士Malevolent"
			--{"部落PvP裝備商", "阿肯•死亡統禦",{35.4,83.2},0}, -- 75695 "惡孽角鬥士Grievous"
			--{"部落PvP裝備商", "蘇雄",{35.4,83.2},0}, -- 78461 "驕矜角鬥士Prideful"
			{"部落PvP裝備商", "S12L;S12H;S13;S14;S15S",{35.4,83.2},0}, -- 75688/75690/75693/75695/78461
			{"中立<攀山者套裝>商人", "鍛鐵爪",{71.4,92.2},0}, -- 61749 "探險裝備供應商"
			{"中立<犛牛>商人", "表叔大口袋",{65.4,61.6},0}, -- 64518
			{"武僧<技能書>商人","黃師傅",{50.4,42.6},0}, -- 66356 -- need translation 7.0.3新增職業物品
		},

		-- Valley of the Four Winds
		["四風穀"]={
		-- 飛行管理員
			{"飛行管理員", "丹•“龍之翼”",{20.2,58.6},0}, -- 58843
			{"飛行管理員", "普林斯頓",{84.4,21.0},0}, -- 60230
			{"飛行管理員", "“飛翼”小雅",{56.4,50.2},0}, -- 60231
			{"飛行管理員", "“山風”基姆",{70.8,24.2},0}, -- 62658
			{"聯盟飛行管理員", "泰波•疾風",{12.0,32.8},0}, -- 65865
		-- 旅館老闆
			{"旅館老闆", "旅館老闆雷嵐",{55.0,50.4},0}, -- 59582
			--{"旅館老闆", "農夫的日誌",{52.6,48.0},0}, -- 70585
			{"旅館老闆", "“砌石酒盞”阿楠",{19.6,56.2},0}, -- 62878
			{"旅館老闆", "楠•雷腳",{83.6,20.2},0}, -- 65528
		-- 獸欄管理員
			{"獸欄管理員", "小提布",{83.8,21.8},0}, -- 66242
			{"獸欄管理員", "馴獸師蘇明",{55.2,49.6},0}, -- 66244
		-- 專業訓練師
			{"烹飪訓練師", "孫行•鐵掌",{53.6,51.2},0}, -- 64231/53712-53717
			{"工程學訓練師", "莎莉•輪怒",{16.0,83.0},0}, -- 55143
			{"釣魚訓練師", "“大嗓門”班宏",{58.8,47.0},0}, -- 70398
			{"草藥學訓練師", "韓•繁花",{53.6,51.2},0}, -- 65877
			{"剝皮訓練師", "普利波先生",{16.0,83.0},0}, -- 63825
			{"裁縫訓練師", "蔡絲匠",{62.6,59.6},0}, -- 57405
		-- 商人
			--{"聯盟PvP裝備商", "桃麗絲•奇爾頓妮斯",{12.2,34.2},0}, -- 75689 "惡毒角鬥士Malevolent"
			--{"聯盟PvP裝備商", "洛克諾•血拳",{12.2,34.0},0}, -- 75691 "恐怖角鬥士Dreadful"
			--{"聯盟PvP裝備商", "阿肯•死亡統禦",{12.0,34.2},0}, -- 75692 "惡孽角鬥士Grievous"
			--{"聯盟PvP裝備商", "魯•戴斯文",{12.0,34.0},0}, -- 75694 "暴虐角鬥士Tyrannical"
			--{"聯盟PvP裝備商", "蘇雄",{12.0,34.0},0}, -- 78456 "驕矜角鬥士Prideful"
			{"聯盟PvP裝備商", "S12L;S12H;S13;S14;S15",{12.2,34.2},0}, -- 75689/75691/75692/75694/78456
			{"阡陌客軍需官", "吉娜•泥爪",{53.1,52.1},0}, -- 58706
			--{"中立<種子>商人", "商人綠野",{52.8,52.0},0}, -- 58718
			{"中立<黯淡林木套裝>商人", "商人迦姆比茲",{56.2,47.0},0}, -- 59583 "探險裝備供應商"
			{"中立<黯淡林木套裝>商人", "柯拉爾塔",{84.8,21.6},0}, -- 61215 "探險裝備供應商"
			--{"中立<不穩定的傳送門>商人", "巴納比•弗萊徹",{53.2,51.6},0}, -- 67565
			{"中立商人", "種子;不穩定的傳送門",{52.8,52.0},0}, -- 58718/67565
		},

		-- The Veiled Stair
		["霧紗棧道"]={
		-- 飛行管理員
			{"飛行管理員", "鴻毛阿信",{56.6,75.8},0}, -- 61759
		-- 旅館老闆
			{"旅館老闆", "調酒師童福",{54.8,72.4},0}, -- 62917
		-- 獸欄管理員
			{"獸欄管理員", "馴獸師卡瑪",{55.8,75.8},0}, -- 62935
		-- 商人
			{"黑王子軍需官", "黑爪軍需官",{54.4,72.8},0}, -- 70436
		},

		-- Townlong Steppes
		["螳螂高原"]={
		-- 飛行管理員
			{"飛行管理員", "風箏大師李森",{54.2,79.0},0}, -- 62898
			{"飛行管理員", "風箏大師吳工",{71.0,57.2},0}, -- 62901
			{"飛行管理員", "風箏大師甯師師",{74.4,81.4},0}, -- 62903
			{"飛行管理員", "風箏大師姚莉",{50.0,71.8},0}, -- 62909
		-- 旅館老闆
			{"旅館老闆", "睡影賽圖",{71.0,57.8},0}, -- 62873
			{"旅館老闆", "守夜人卡裡",{48.8,70.8},0}, -- 62874
			{"旅館老闆", "安靜的吉姆",{75.8,82.8},0}, -- 62875
		-- 獸欄管理員
			{"獸欄管理員", "馴虎師蓋林",{71.4,57.6},0}, -- 66246
			{"獸欄管理員", "馴虎師劉多",{74.8,81.2},0}, -- 66247
			{"獸欄管理員", "女馴虎師明朵",{50.0,71.4},0}, -- 66248
		-- 商人
			{"影蹤派軍需官", "狡狐魯西",{48.8,70.6},0}, -- 64595
			--{"PvE裝備商", "指揮官牛心",{37.8,64.6},0}, -- 64606 "勇氣軍需官"
			--{"PvE裝備商", "指揮官羅平",{37.8,64.6},0}, -- 64607 "正義軍需官"
			--{"PvE裝備商", "白傲",{38.0,64.6},0}, -- 70346 "影蹤突襲營軍需官"
			{"PvE裝備商", "指揮官牛心;指揮官羅平;白傲",{37.8,64.6},0}, -- 64606/64607/70346
			{"中立<攀山者/廢土套裝>商人", "供應商老辛",{70.8,55.8},0}, -- 62737/65171 "裝備商人"/"探險裝備供應商"
		},

		-- Dread Wastes
		["恐懼廢土"]={
		-- 飛行管理員
			{"飛行管理員", "乘風者溟",{56.0,70.2}}, -- 63498
			{"飛行管理員", "飛桶阿晉",{50.2,12.2}}, -- 63500
			{"飛行管理員", "基克提克",{55.8,34.8}}, -- 63501
			{"飛行管理員", "滲透者伊克薩爾",{42.6,55.6}}, -- 65511
		-- 旅館老闆
			{"旅館老闆", "澄海者塞安",{55.2,71.0}}, -- 63016
			{"旅館老闆", "茲特提克斯",{55.8,32.2}}, -- 65220
		-- 獸欄管理員
			{"獸欄管理員", "馴馬人金姆",{55.8,69.6}}, -- 66249
			{"獸欄管理員", "訓練師卡拉維克",{53.6,32.4}}, -- 66250
		-- 專業訓練師
			{"煉金術訓練師", "下毒者克爾茲特",{55.6,35.2}}, -- 65186
		-- 商人
			{"卡拉克西軍需官", "琥珀匠師齊克",{55.0,35.6}}, -- 64599
		},

		-- Isle of Giants
		["巨獸島"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "比波爾•短扳",{41.8,79.2}}, -- 69359
			{"部落飛行管理員", "波茲爾•爆索",{51.8,75.4}}, -- 69360
		-- 商人
			{"聯盟<恐角龍皮偽裝>商人", "阿加特•銳眼",{35.8,53.6}}, -- 70030
			{"部落<恐角龍皮偽裝>商人", "阿諾德•雷甘",{60.6,44.0}}, -- 70034
		},

		-- Isle of Thunder
		["雷神島"]={
		-- 旅館老闆
			{"部落旅館老闆", "獸女烏達",{33.4,32.6},0}, -- 67668
			{"聯盟旅館老闆", "伊絲拉米•輕風",{64.8,73.0},0}, -- 70182
		-- 獸欄管理員
			{"部落獸欄管理員", "遊俠沙蘭",{32.8,32.6},0}, -- 69252
			{"聯盟獸欄管理員", "塔西婭•幽谷",{63.2,73.8},0}, -- 70184
		-- 專業訓練師
			{"部落考古學訓練師", "埃萊娜拉",{33.8,33.6},0}, -- 67586
		-- 商人
			{"奪日者先鋒軍軍需官", "瓦薩林•赤晨",{33.4,32.4},0}, -- 67672
			{"肯瑞托遠征軍軍需官", "海倫•慧歌",{64.6,74.6},0}, -- 68000
			{"影蹤突襲營軍需官", "飛刀客騰青",{51.6,46.6},0}, -- 70535
			{"好運符與羊皮紙商人", "供應商老包",{51.4,45.8},0}, -- 70318
		},

		-- Timeless Isle
		["永恆島"]={
		-- 飛行管理員
			{"部落飛行管理員", "馴天者甄洛",{21.8,39.8},0}, -- 71939
			{"聯盟飛行管理員", "蜜琪•風花",{23.2,71.0},0}, -- 71940
		-- 旅館老闆
			{"旅館老闆", "優雅的斯萬",{36.6,47.0},0}, -- 73622
		-- 獸欄管理員
			{"獸欄管理員", "怯懦的祖音",{37.2,46.8},0}, -- 73632
		-- 商人
			{"中立<庫庫魯寶箱鑰匙>商人", "庫庫魯大師",{59.2,40.4},0}, -- 72007
			{"天神鑄幣商人", "李大師",{34.8,59.6},0}, -- 73082
			{"永恆鑄幣商人", "維茨格;",{41.6,47.2},0}, -- 73293
			{"永恆鑄幣商人", "織霧者顧嚴",{42.8,55.6},0}, -- 73305/73306
			{"永恆鑄幣商人", "莫苦",{41.2,63.6},0}, -- 73819
			{"永恆/染血鑄幣商人", "發言人古蘭",{75.0,44.8},0}, -- 73307
		},

		-- Vale of Eternal Blossoms
		["錦繡穀"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "薩琳娜•踏春",{84.6,62.4},0}, -- 61121
			{"部落飛行管理員", "塔尼亞•夏風",{62.8,21.6},0}, -- 61122
			{"飛行管理員", "鐵壁老麥",{14.2,79.2},0}, -- 63497
		-- 旅館老闆
			{"旅館老闆", "調酒師拓莫若",{35.4,77.4},0}, -- 58691
		-- 獸欄管理員
			{"部落獸欄管理員", "追蹤者老朗",{60.4,22.6},0}, -- 63986
			{"聯盟獸欄管理員", "賈許",{84.6,63.2},0}, -- 63988
			{"獸欄管理員", "騎羊人尼克尼克",{36.0,75.2},0}, -- 66245
		-- 專業訓練師
			{"考古學訓練師", "布萊恩•銅須",{83.6,31.0},0}, -- 64922
			{"部落考古學訓練師", "伊莉娜拉",{21.0,15.2},0}, -- 67837
			{"鍛造訓練師", "禪宗鐵匠勞敖",{21.6,72.2},0}, -- 65129
			{"飛行訓練師", "穿雲行者淩大師",{84.2,61.6},0}, -- 60166
			{"飛行訓練師", "舞空者書恩",{62.8,23.2},0}, -- 60167
			{"銘文學訓練師", "遊學者胡恩",{82.0,29.4},0}, -- 64691
		-- 商人
			-- 七星殿
			{"聯盟軍需官", "金蓮教;至尊天神",{84.2,62.6},0}, -- 59908/64032
			{"祥和之靈商人", "克裡斯托",{84.6,60.6},0}, -- 66678
			{"聯盟PvE裝備商", "挑戰者老宋",{86.2,61.6},0}, -- 64028
			-- 雙月殿
			{"部落軍需官", "金蓮教;至尊天神",{63.0,22.2},0}, -- 59908/64001
			{"祥和之靈商人", "達奇",{61.6,21.6},0}, -- 66685
			{"部落PvE裝備商", "挑戰者吳立",{61.2,20.8},0}, -- 63994
			-- 魔古山宮殿
			{"遊學者軍需官", "譚欣眺",{82.2,29.4},0}, -- 64605
			{"中立<先祖鳳凰>商人", "凱•羽落",{82.2,34.0},0}, -- 66973
			-- 其他
			{"稀有古董商人", "大塊頭齊奇",{60.4,43.2},0}, -- 61650
			{"中立<廢土套裝>商人", "全副武裝的倫",{14.2,78.8},0}, -- 65172 "探險裝備供應商"
		},

	-- 德拉諾 Draenor
		-- Frostfire Ridge
		["霜火嶺"]={
		-- 飛行管理員
			{"部落飛行管理員", "飛狼羅爾克",{24.4,37.2},0}, -- 76781
			{"部落飛行管理員", "普爾•塑風",{21.6,5.6},0}, -- 76782
			{"部落飛行管理員", "加諾克•破曉",{31.8,9.6},0}, -- 76783
			{"部落飛行管理員", "貝爾•戰頸",{83.6,60.8},0}, -- 76784
			{"飛行管理員", "貝蕾娜•天沼",{51.4,21.4},0}, -- 76787
			{"部落飛行管理員", "天空獵手多莫甘",{40.0,51.8},0}, -- 76879
			{"部落飛行管理員", "賈卡納",{51.8,41.0},0}, -- 78699
			{"聯盟飛行管理員", "遊俠薇拉",{87.4,62.6},0}, -- 84993
			{"部落飛行管理員", "獵風",{73.6,60.0},0}, -- 87707
		-- 旅館老闆
			{"部落旅館老闆", "卓戈",{40.6,51.6},0}, -- 72382
			--{"部落旅館老闆", "德什威",{27.0,36.4},0}, -- 76746
			{"部落旅館老闆", "謙卑的薩科",{20.8,56.6},0}, -- 77460
			--{"部落旅館老闆", "髒兮兮的哈威",{30.0,38.6},0}, -- 77468
			{"部落旅館老闆", "德什威;髒兮兮的哈威",{27.0,36.4},0}, -- 76746/77468
			{"部落旅館老闆", "補給商拉姆巴拉",{52.2,39.8},0}, -- 78672
			{"部落旅館老闆", "旅館老闆查爾",{32.0,10.0},0}, -- 78769
		-- 獸欄管理員
			{"部落獸欄管理員", "幼崽看護員格裡姆貝爾",{38.8,52.0},0}, -- 77455
			--{"部落獸欄管理員", "牧狼者安查",{22.0,56.2},0}, -- 77461
			--{"部落獸欄管理員", "斯圖•白牙",{21.4,54.6},0}, -- 77475
			{"部落獸欄管理員", "斯圖•白牙;牧狼者安查",{21.4,54.6},0}, -- 77461/77475
			{"部落獸欄管理員", "考裡",{52.4,40.2},0}, -- 78698
			--{"聯盟獸欄管理員", "科甘•焰須",{52.6,20.4},0}, -- 86808
			--{"獸欄管理員", "托爾瑪克;科甘•焰須",{52.6,20.6},0}, -- 87006
			{"獸欄管理員", "托爾瑪克;[A]科甘•焰須",{52.6,20.6},0}, -- 86808/87006
		-- 專業訓練師
			{"部落釣魚訓練師", "Sverre",{41.0,73.8},0}, -- 96097 -- need translation
		-- 商人
			{"部落<要塞艦船裝備>商人", "Kronk Rustspark",{40.0,72.2},0}, -- 94801 -- need translation
		},

		-- Shadowmoon Valley 947
		["影月穀德拉諾"]={
		-- 飛行管理員
			{"聯盟飛行管理員", "高頓",{40.6,55.2},0}, -- 76839
			{"聯盟飛行管理員", "伊奧諾",{45.6,38.8},0}, -- 76840
			{"飛行管理員", "瓦格拉",{45.6,25.4},0}, -- 76850
			{"聯盟飛行管理員", "帕婭",{59.4,46.0},0}, -- 76851
			{"聯盟飛行管理員", "莫法科斯",{57.0,56.6},0}, -- 81284
			{"飛行管理員", "阿紮拉•金翼",{43.8,77.4},0}, -- 81285
			{"聯盟飛行管理員", "瓦姆",{58.6,31.8},0}, -- 81289
			--{"飛行管理員", "馴獸師拉達克",{59.8,81.4},0}, -- 83427
			{"聯盟飛行管理員", "伊塔拉",{70.4,50.4},0}, -- 86685
			--{"聯盟飛行管理員", "Beasttamer Zov'jin",{57.6,83.6},0}, -- 88113 -- need translation
			{"飛行管理員", "馴獸師拉達克;[A]馴獸師祖沃金",{59.8,81.4},0}, -- 83427/88113 -- need translation
		-- 旅館老闆
			{"聯盟旅館老闆", "克麗安德",{46.6,40.8},0}, -- 78952
			{"聯盟旅館老闆", "麥法爾",{56.8,57.4},0}, -- 82770
			{"聯盟旅館老闆", "奈瑟妮",{60.0,27.2},0}, -- 82775
		-- 獸欄管理員
			{"聯盟獸欄管理員", "達卡瑞",{25.2,7.0},0}, -- 81830
			{"聯盟獸欄管理員", "艾坦",{59.2,26.6},0}, -- 84730
			--{"聯盟獸欄管理員", "科甘•焰須",{47.6,28.0},0}, -- 86808
			--{"獸欄管理員", "托爾瑪克",{47.6,28.0},0}, -- 87006
			{"獸欄管理員", "托爾瑪克;[A]科甘•焰須",{47.6,28.0},0}, -- 86808/87006
		-- 專業訓練師
			{"聯盟釣魚訓練師", "努拉",{66.8,35.2},0}, -- 85825
			{"聯盟釣魚訓練師", "Lester Scaleworth",{27.4,10.0},0}, -- 94311 -- need translation
		-- 商人
			{"聯盟<略微乾癟的蛤蟆>商人", "老露拉",{41.2,55.0},0}, -- 71641
			{"聯盟<要塞艦船裝備>商人", "Salty Jorren",{28.6,10.8},0}, -- 93812 -- need translation
		},

		-- Gorgrond
		["戈爾隆德"]={
		-- 飛行管理員
			{"部落飛行管理員", "割齒",{46.0,69.2},0}, -- 81055
			{"聯盟飛行管理員", "遊俠拉潔絲",{52.8,59.4},0}, -- 81074
			{"聯盟飛行管理員", "遊俠特維",{64.0,57.4},0}, -- 81884
			{"聯盟飛行管理員", "遊俠納格",{46.4,76.6},0}, -- 81888
			{"部落飛行管理員", "查格斯班",{41.2,87.2},0}, -- 84495
			--{"聯盟飛行管理員", "遊俠亞威爾",{46.4,92.4},0}, -- 84507
			--{"部落飛行管理員", "嘯風",{47.4,90.8},0}, -- 84508
			{"飛行管理員", "[A]遊俠亞威爾;[H]嘯風",{46.9,91.6},0}, -- 84507/84508
			{"飛行管理員", "尼莎",{43.0,20.2},0}, -- 84700
			{"飛行管理員", "奧術師溫德波普",{57.0,45.8},0}, -- 84714
			{"飛行管理員", "法隆•塵世行者",{39.6,36.6},0}, -- 85829
			{"飛行管理員", "尼莎",{45.8,55.0},0}, -- 86492/81674
			{"飛行管理員", "研究員薩莉克絲",{68.6,28.8},0}, -- 88757
			{"部落飛行管理員", "Dron Skyborn",{55.8,6.6},0}, -- 89831 -- need translation
			{"聯盟飛行管理員", "Taal Blevaans",{52.8,9.6},0}, -- 90188 -- need translation
		-- 旅館老闆
			{"部落旅館老闆", "死肉",{60.6,22.4},0}, -- 86994
			{"部落旅館老闆", "咬虱",{46.0,69.8},0}, -- 85967
			{"聯盟旅館老闆", "商人尤拉",{53.2,59.8},0}, -- 85968
			{"旅館老闆", "艾登•夏天",{40.0,36.4},0}, -- 85830
			{"旅館老闆", "奇帕斯",{46.0,54.8},0}, -- 84237
		-- 獸欄管理員
			{"聯盟獸欄管理員", "遊俠科蘭",{52.6,59.6},0}, -- 81075
			{"部落獸欄管理員", "嚼骨",{45.8,69.8},0}, -- 82731
			{"聯盟獸欄管理員", "科甘•焰須",{45.8,43.8},0}, -- 86808
		},

		-- Talador
		["塔拉多"]={
		-- 飛行管理員
			{"飛行管理員", "多明尼克•阿靈頓",{80.4,25.4},0}, -- 80932
			{"部落飛行管理員", "莫克拉",{61.4,10.6},0}, -- 81053
			{"部落飛行管理員", "莫吉巴",{70.8,29.4},0}, -- 81057
			{"部落飛行管理員", "特加•天刃",{55.4,40.8},0}, -- 81058
			{"部落飛行管理員", "Skyreaver Lyriarra",{61.0,73.4},0}, -- 81059 -- Need translation
			{"聯盟飛行管理員", "護天者阿米拉",{69.8,21.4},0}, -- 81060
			{"聯盟飛行管理員", "諾麥爾",{63.2,25.8},0}, -- 81061
			{"聯盟飛行管理員", "Shalaa",{57.4,76.2},0}, -- 81062 -- Need translation
			{"飛行管理員", "紮瑪拉",{51.2,42.6},0}, -- 81064
			{"聯盟飛行管理員", "紮裡",{80.0,56.6},0}, -- 81067
			{"飛行管理員", "貝爾多斯",{42.0,76.8},0}, -- 81068
			--{"聯盟飛行管理員", "妮雅",{54.8,68.8},0}, -- 81077
			--{"部落飛行管理員", "洛卡",{54.6,67.8},0}, -- 81078
			{"飛行管理員", "[A]妮雅;[H]洛卡",{54.8,68.8},0}, -- 81077/81078
			{"飛行管理員", "天爪衛士伊努茲",{70.4,57.0},0}, -- 81354
		-- 旅館老闆
			{"旅館老闆", "看護者烏露拉",{77.2,57.4},0}, -- 75430
			{"部落旅館老闆", "瓦格坦",{61.8,10.8},0}, -- 77028
			{"聯盟旅館老闆", "梅•特塔",{85.2,31.8},0}, -- 80931
			{"聯盟旅館老闆", "奧利維亞•阿比頓",{69.6,21.8},0}, -- 81358
			{"部落旅館老闆", "葆妮•柔蹄",{72.0,30.0},0}, -- 81359
			{"旅館老闆", "巴達",{50.8,44.4},0}, -- 86316
		-- 獸欄管理員
			{"部落獸欄管理員", "獸王塔格",{70.8,29.6},0}, -- 80833
			{"聯盟獸欄管理員", "派翠克•麥瑟",{69.4,21.2},0}, -- 80854
			{"聯盟獸欄管理員", "科甘•焰須",{67.2,49.2},0}, -- 86808
		-- 商人
			{"中立<新奇玩具>商人", "卡茲巴拉",{45.2,38.8},0}, -- 84212
			{"絕版PvE裝備商", "裂鐵者塔加爾",{45.6,38.6},0}, -- 84216
			{"中立<傳說戒指>商人", "佐提•輪怒",{85.0,31.0},0}, -- 86949
		},

		-- Spires of Arak
		["阿蘭卡峰林"]={
		-- 飛行管理員
			{"飛行管理員", "奎文•飛輪",{60.8,73.2}}, -- 82511
			{"部落飛行管理員", "胡托•羽風",{39.4,43.2}}, -- 82612
			{"聯盟飛行管理員", "菲恩•迅風",{39.0,61.8}}, -- 83567
			{"飛行管理員", "天爪衛士米沙爾",{46.2,44.0}}, -- 84498
			{"飛行管理員", "天爪衛士卡拉茲",{61.8,42.6}}, -- 84504
			{"飛行管理員", "天爪衛士庫裡斯",{37.0,24.6}}, -- 84509
			{"飛行管理員", "黯嘯",{51.8,31.0}}, -- 84515
			{"飛行管理員", "暮爪",{65.6,17.6}}, -- 88584
		-- 旅館老闆
			{"旅館老闆", "考比克斯•查奇",{61.6,73.4}}, -- 82516
			{"聯盟旅館老闆", "艾麗婭•墜柳",{40.0,61.4}}, -- 84134
			{"部落旅館老闆", "塔茲加爾",{40.4,43.0}}, -- 84213
			{"旅館老闆", "庫羅阿克",{46.6,44.0}}, -- 86386
		-- 獸欄管理員
			{"獸欄管理員", "威利•礦板",{60.8,71.8}}, -- 82553
		-- 商人
			{"中立<守巢幼鳥/卡利雛鳥>商人", "維沙爾",{46.2,45.4}}, -- 87123
		},

		-- Nagrand 950
		["納格蘭德拉諾"]={
		-- 飛行管理員
			{"獅鷲管理員", "菲利希亞•瑪林",{62.6,40.6},0}, -- 81250
			{"獅鷲管理員", "約翰•謝爾比",{63.6,61.6},0}, -- 82309
			{"雙足飛龍管理員", "烏姆•魂風",{49.4,48.0},0}, -- 82340
			{"雙足飛龍管理員", "塔爾",{83.2,44.6},0}, -- 82346
			{"萊拉克管理員", "吉克斯莫•現鈔",{73.6,26.6},0}, -- 82844
			{"萊拉克管理員", "比吉•戰利",{79.8,49.6},0}, -- 83924
			{"萊拉克管理員", "里爾茲特•噴泥",{50.6,30.6},0}, -- 87395
			{"萊拉克管理員", "內維克•李",{49.4,75.8},0}, -- 88653
			{"萊拉克管理員", "喬茲•納瓦克斯",{62.2,32.8},0}, -- 88668
		-- 旅館老闆
			{"聯盟旅館老闆", "看護菲拉妮",{63.6,62.4},0}, -- 80006
			{"聯盟旅館老闆", "艾瑪•南土",{62.2,40.0},0}, -- 81249
			{"部落旅館老闆", "溫特白夫人",{48.4,47.0},0}, -- 82341
			{"部落旅館老闆", "艾拉絲麗兒•射日者",{82.6,45.4},0}, -- 82345
		-- 獸欄管理員
			--{"聯盟獸欄管理員", "科甘•焰須",{86.6,42.6},0}, -- 86808
			--{"獸欄管理員", "托爾瑪克",{86.6,42.8},0}, -- 87006
			{"獸欄管理員", "托爾瑪克;[A]科甘•焰須",{86.6,42.8},0}, -- 86808/87006
			{"獸欄管理員", "托爾瑪克",{55.6,59.6},0}, -- 87006
		-- 商人
			{"熱砂保護協會軍需官", "奎拉克斯•刀索",{50.4,41.4},0}, -- 87394
			{"中立<窖藏達拉然紅葡萄酒>商人", "Lytah",{76.6,50.6},0}, -- 89702 -- need translation
		},

		-- Tanaan Jungle -- need translation
		["塔納安叢林"]={
		-- 飛行管理員
			{"部落飛行管理員", "Gargash the Diver",{60.4,46.4}}, -- 90550
			--{"部落飛行管理員", "Nasher",{9.2,55.8}}, -- 90552
			{"飛行管理員", "Skytalon Kariz",{26.0,38.8}}, -- 90560
			{"飛行管理員", "Urtol Skyshear",{47.0,70.2}}, -- 90562
			{"聯盟飛行管理員", "Skyguard Thann",{57.4,58.8}}, -- 90960
			--{"聯盟飛行管理員", "Skyguard Blann",{10.0,53.0}}, -- 91940
			{"飛行管理員", "Rocketmaster Malo",{43.4,42.2}}, -- 92808
			{"飛行管理員", "Rangari Sha'ana",{29.6,63.0}}, -- 92809
			{"飛行管理員", "[A]Skyguard Blann;[H]Nasher",{9.6,54.4}}, -- 90552/91940
		-- 旅館老闆
			{"聯盟旅館老闆", "Shima Islebreeze",{58.4,60.2}}, -- 90971
			{"部落旅館老闆", "Retho Quillmane",{61.4,46.0}}, -- 90989
		-- 獸欄管理員
			{"部落獸欄管理員", "Dal Palesmoke",{59.8,45.6}}, -- 90992
		-- 商人
			{"刃牙追獵者軍需官", "行者茲坦加",{55.2,74.8}}, -- 92805
			--{"先知之手軍需官", "Vindicator Krethos",{58.4,60.4}}, -- 90974
			--{"覺醒教派軍需官", "Dawn-Seeker Krisek",{57.8,59.4}}, -- 95424
			{"聯盟軍需官", "先知之手;覺醒教派",{58.0,59.9}}, -- 90974/95424
			{"聯盟埃匹希斯水晶商人", "Ravenspeaker Thelnaas",{57.8,59.4}}, -- 96130
			--{"沃金之鋒軍需官", "Shadow Hunter Denjai",{61.6,45.6}}, -- 96014
			--{"覺醒教派軍需官", "Dawn-Seeker Krisek",{60.4,46.6}}, -- 95424
			{"部落軍需官", "沃金之鋒;覺醒教派",{61.0,46.1}}, -- 96014/95424
			{"部落埃匹希斯水晶商人", "Ravenspeaker Thelnaas",{60.4,46.6}}, -- 96130
		},

		-- Lunarfall
		["墜落之月"]={
		-- 拍賣師
			{"拍賣師", "古代交易機",{35.0,48.4},0}, -- 87205
		-- 銀行職員
			{"銀行職員", "琪拉•金手",{47.0,59.2},0}, -- 84857
		-- 飛行管理員
			{"獅鷲管理員", "杜加爾•朗德瑞克",{47.6,49.6},0}, -- 81103
		-- 獸欄管理員
			{"獸欄管理員", "拉文",{38.2,60.0},0}, -- 77381
		-- 專業訓練師
			{"釣魚訓練師", "羅恩•艾什頓",{54.4,14.4},0}, -- 77733
		-- 商人
			{"沙塔爾防禦者軍需官", "瑪瑞亞",{52.0,43.4},0}, -- 85427
			{"鋼鐵部落碎片商人", "克裡斯汀•石鑄",{36.2,62.8},0}, -- 77377
			{"要塞軍需官", "克勞勒中士",{37.6,36.4},0}, -- 88223
			{"納特的幸運硬幣商人", "納特•帕格",{53.4,14.0},0}, -- 85984
			{"寵物符咒商人", "緹菲•機簧",{29.6,39.0},0}, -- 94512
			{"商人", "圖紙;合約;坐騎;追隨者裝備",{29.6,33.0},0}, -- 85839/88633/95470
		},

		-- Frostwall
		["霜寒晶壁"]={
		-- 拍賣師
			{"拍賣師", "古代交易機",{51.2,61.4},0}, -- 87109
		-- 銀行職員
			{"銀行職員", "尤恩•長蹄",{48.2,33.2},0}, -- 79862
		-- 飛行管理員
			{"飛行管理員", "布羅恩•天角",{45.8,50.2},0}, -- 79407
		-- 獸欄管理員
			{"獸欄管理員", "多吉爾",{52.8,57.4},0}, -- 79816
			{"獸欄管理員", "紮加拉",{65.4,34.2},0}, -- 79860
		-- 專業訓練師
			{"釣魚訓練師", "馬克金",{38.4,72.2},0}, -- 79892
		-- 商人
			{"嘲顱軍需官", "基爾裡普",{51.6,60.4},0}, -- 86698
			{"鋼鐵部落碎片商人", "戈倫萊克",{64.0,35.2},0}, -- 79815
			{"要塞軍需官", "格裡姆加中士",{44.0,47.6},0}, -- 88228
			{"納特的幸運硬幣商人", "納特•帕格",{38.2,72.0},0}, -- 85984
			{"寵物符咒商人", "吉雅達•金索",{33.0,40.0},0}, -- 94516
			{"商人", "圖紙;合約;坐騎;追隨者裝備",{40.8,55.8},0}, -- 79619/88635/95471
		},

		-- [LEGION] Ashran -- need update
		["阿什蘭"]={
		-- 商人
			{"暴風之盾軍需官", "克拉提庫斯•曼比德爾",{44.2,74.0}}, -- 80882
			{"戰爭之矛軍需官", "達茲裡安",{48.4,23.8}}, -- 85115
			{"聯盟PvP裝備商", "大元帥泰佈雷德;加布裡埃爾元帥;卡什•暴爐將軍",{45.2,79.4}}, -- 82876/82878/82880
			{"部落PvP裝備商", "高階督軍沃拉斯;艾弗德將軍;督軍諾克泰",{48.0,26.0}}, -- 82877/82882/82883
		},

	-- 破碎群島 The Broken Isles -- need update
		-- Broken Shore
		["破碎海灘"]={
		-- 飛行管理員
			{"飛行管理員","Grimwing",{97.4,56.0}}, -- 93465
			{"飛行管理員","Izal Whitemoon",{49.6,21.0}}, -- 111323
		},

		-- Stormheim
		["風暴峽灣"]={
		-- 飛行管理員
			{"部落飛行管理員","Duchess",{45.0,59.2}}, -- 92560
			{"部落飛行管理員","Dread-Rider Barnes",{54.6,73.0}}, -- 98105
			{"聯盟飛行管理員","Gryphon-Master Clifford",{72.0,59.8}}, -- 98108
			{"聯盟飛行管理員","Donovan",{37.4,63.8}}, -- 98113
			{"聯盟飛行管理員","Donovan",{33.6,50.6}}, -- 98114
			{"部落飛行管理員","Dread-Rider Roth",{36.4,30.6}}, -- 98124
			{"飛行管理員","Garhal the Scalekeeper",{60.6,50.8}}, -- 98161
			{"飛行管理員","Visser the Scalekeeper",{89.8,10.6}}, -- 111314
			{"飛行管理員","Hillevi the Scalekeeper",{52.0,34.6}}, -- 111327
		-- 旅館老闆
			{"旅館老闆","Riala the Hearthwatcher",{60.4,50.2}}, -- 103796
		-- 專業訓練師
			{"部落剝皮訓練師","Seymour",{45.6,25.6}}, --98721
		-- 商人
			{"瓦拉加爾軍需官","Valdemar Stormseeker",{60.2,51.2}}, -- 106904
		},

		-- Highmountain
		["至高嶺"]={
		-- 飛行管理員
			{"飛行管理員","Tamara Sigmund",{40.2,52.6}}, -- 94973
			{"飛行管理員","Chofa Nighthoof",{47.2,84.6}}, -- 96565
			{"飛行管理員","Farah Skybeak",{52.6,45.2}}, -- 97860
			{"飛行管理員","Rafat Smokehoof",{38.2,39.2}}, -- 97868
			{"飛行管理員","Kimben Wingheart",{30.0,39.4}}, -- 97870
			{"飛行管理員","Steven Nelson",{41.8,10.4}}, -- 98066
			{"飛行管理員","Brun Prepfoot",{58.0,28.6}}, -- 98972
			{"飛行管理員","Poca Firemantle",{56.8,53.8}}, -- 98966
			{"飛行管理員","Roren Longshadow",{35.8,66.0}}, -- 100550
			{"飛行管理員","Lassa Skymane",{59.2,65.0}}, -- 100559
		-- 旅館老闆
			{"旅館老闆","Marius Felbane",{29.8,40.0}}, -- 108504
		-- 專業訓練師
			{"鍛造訓練師","Barm Stonebreaker",{55.2,84.2}}, -- 92242
			{"採礦訓練師","Ronos Ironhorn",{55.0,84.0}}, -- 93691
		},

		-- Thunder Totem
		["雷霆圖騰"]={
		-- 飛行管理員
			{"飛行管理員","Windtamer Nalt",{44.8,38.8}}, -- 95688
		-- 旅館老闆
			{"旅館老闆","Ernu Mesawind",{44.8,53.4}}, -- 97852
		-- 獸欄管理員
			{"獸欄管理員","Liza Galestride",{44.8,53.4}}, -- 97852
		-- 專業訓練師
			{"附魔訓練師","Guron Twaintail ",{44.2,45.2}}, -- 98017
		-- 商人
			{"高嶺部族軍需官","Ransa Greyfeather",{38.4,46.0}}, -- 106902
			{"玩具背包商人","Slyhoof the Shameless Shaman ",{60.8,59.2}}, -- 99574
		},

		-- Val'sharah
		["瓦爾莎拉"]={
		-- 飛行管理員
			{"飛行管理員","Elyssia Winterdusk",{55.0,72.4}}, -- 93447
			{"飛行管理員","Douglas Carrington",{42.2,58.6}}, -- 93940
			{"飛行管理員","Brinlanya Moonstone",{56.6,57.8}}, -- 100459
			{"飛行管理員","Landrius Ravenfall",{69.0,50.8}}, -- 100468
			{"飛行管理員","Gyrdaen Windreef",{25.8,66.4}}, -- 114837
		-- 旅館老闆
			{"旅館老闆","Faeolas Nightwhisper",{69.4,49.4}}, -- 95118
		-- 商人
			{"織夢者軍需官","Sylvia Hartshorn",{54.6,73.2}}, -- 106901
		},

		-- Azsuna
		["阿蘇納"]={
		-- 飛行管理員
			{"飛行管理員","Izal Whitemoon",{44.6,43.8}}, -- 88110
			{"飛行管理員","Dagrona",{48.4,28.0}}, -- 90556
			{"飛行管理員","Stagtamer Maliana",{40.8,9.0}}, -- 90639
			{"飛行管理員","Trainee Sylwindial",{48.2,73.0}}, -- 108888
			{"飛行管理員","Adept Jena Moonrath",{31.8,46.2}}, -- 110971
			{"聯盟飛行管理員","Trainee Starwhisper",{51.8,82.0}}, -- 111418
			{"飛行管理員","Adept Sunwing",{63.8,28.4}}, -- 111624
			{"飛行管理員","Avaya Farwind",{56.2,59.0}}, -- 112866
		-- 旅館老闆
			{"旅館老闆","Berazus",{47.8,23.4}}, -- 89939
			{"旅館老闆","Gentle Rosh",{56.6,59.4}}, -- 91457
			{"旅館老闆","Nalysse Dawnsorrow",{47.2,41.4}}, -- 109372
			{"聯盟旅館老闆","Filrich",{53.0,36.8}}, -- 109377
		-- 專業訓練師
			{"珠寶設計訓練師","Timothy Jones",{46.6,41.4}}, -- 100538
			{"制皮訓練師","Celea",{47.4,44.0}}, -- 98964
			{"剝皮訓練師","Glielle",{47.0,45.0}}, -- 98791
		-- 商人
			{"法羅迪斯宮廷軍需官","Veridis Fallon",{46.8,41.4}}, -- 107376
			{"守望者軍需官","Marin Bladewing",{48.2,73.8}}, -- 107379
		},

		-- Suramar
		["蘇拉瑪"]={
		-- 飛行管理員
			{"飛行管理員","Ancient Cloudwing",{34.2,49.4}}, -- 111675
			{"飛行管理員","Alyndra Stormgazer",{25.4,31.8}}, -- 114666
			{"飛行管理員","Ancient Cloudwing",{64.2,42.0}}, -- 114718
		-- 旅館老闆
			{"旅館老闆","First Arcanist Thalyssra",{36.8,46.6}}, -- 97140
		-- 專業訓練師
			{"鍛造訓練師","Felsmith Nal'ryssa",{29.8,53.4}}, -- 92264
			{"制皮訓練師","Stalriss Dawnrunner",{26.6,71.6}}, -- 98969
			{"剝皮訓練師","Ske'rit",{30.6,33.4}}, -- 98720
		-- 商人
			{"墮夜精靈軍需官","First Arcanist Thalyssra",{36.8,46.6}}, -- 97140
		},

		-- Eye of Azshara
		["艾薩拉之眼"]={
		},
	}
end