/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import java.io.IOException;
import netscape.javascript.JSException;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.main.server.JVMManager;
import sun.plugin2.main.server.LiveConnectSupport;
import sun.plugin2.main.server.Plugin;
import sun.plugin2.main.server.ResultHandler;
import sun.plugin2.main.server.ResultID;
import sun.plugin2.util.PluginTrace;
import sun.plugin2.util.SystemUtil;

public abstract class AbstractPlugin
implements Plugin {
    protected static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    protected static final boolean VERBOSE = SystemUtil.getenv("JPI_PLUGIN2_VERBOSE") != null;
    private AppletID appletID;
    private ResultHandler resultHandler;
    private int activeJScripts = 0;
    protected static final ThreadLocal appletStopMark = new ThreadLocal();
    protected PluginTrace ptrace = new PluginTrace();
    protected static final long STOP_ACK_DELAY = 1100L;
    protected static final long STOP_ACK_DELAY_REDUCTION = 900L;

    public PluginTrace getTrace() {
        return this.ptrace;
    }

    protected void appletStarted(AppletID appletID, ResultHandler resultHandler) {
        this.appletID = appletID;
        this.resultHandler = resultHandler;
    }

    protected void appletStopped() {
        this.startupStatus(4);
        this.appletID = null;
        this.resultHandler = null;
    }

    public int getActiveJSCounter() {
        return this.activeJScripts;
    }

    public void incrementActiveJSCounter() {
        ++this.activeJScripts;
    }

    public void decrementActiveJSCounter() {
        --this.activeJScripts;
    }

    protected abstract boolean scriptingObjectArgumentListsAreReversed();

    protected abstract long allocateVariantArray(int var1);

    protected abstract void freeVariantArray(long var1, int var3);

    protected abstract void setVariantArrayElement(long var1, int var3, boolean var4);

    protected abstract void setVariantArrayElement(long var1, int var3, byte var4);

    protected abstract void setVariantArrayElement(long var1, int var3, char var4);

    protected abstract void setVariantArrayElement(long var1, int var3, short var4);

    protected abstract void setVariantArrayElement(long var1, int var3, int var4);

    protected abstract void setVariantArrayElement(long var1, int var3, long var4);

    protected abstract void setVariantArrayElement(long var1, int var3, float var4);

    protected abstract void setVariantArrayElement(long var1, int var3, double var4);

    protected abstract void setVariantArrayElement(long var1, int var3, String var4);

    protected abstract void setVariantArrayElementToScriptingObject(long var1, int var3, long var4);

    protected abstract void setVariantArrayElementToVoid(long var1, int var3);

    protected abstract Object variantArrayElementToObject(long var1, int var3);

    protected abstract long lookupScriptingObject(RemoteJavaObject var1, boolean var2);

    protected abstract Object wrapOrUnwrapScriptingObject(long var1);

    protected abstract String identifierToString(long var1);

    protected abstract void fillInExceptionInfo(long var1, String var3);

    protected abstract void fillInExceptionInfo(long var1, Exception var3);

    private void setVariantArrayElement(long l, int n, BrowserSideObject browserSideObject) {
        this.setVariantArrayElementToScriptingObject(l, n, browserSideObject.getNativeObjectReference());
    }

    private void setVariantArrayElement(long l, int n, RemoteJavaObject remoteJavaObject) {
        long l2 = this.lookupScriptingObject(remoteJavaObject, false);
        this.setVariantArrayElementToScriptingObject(l, n, l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void objectToVariantArrayElement(Object object, long l, int n) {
        if (l == 0L) return;
        if (object != null) {
            if (object instanceof Boolean) {
                this.setVariantArrayElement(l, n, (Boolean)object);
                return;
            } else if (object instanceof Byte) {
                this.setVariantArrayElement(l, n, (Byte)object);
                return;
            } else if (object instanceof Character) {
                this.setVariantArrayElement(l, n, ((Character)object).charValue());
                return;
            } else if (object instanceof Short) {
                this.setVariantArrayElement(l, n, (Short)object);
                return;
            } else if (object instanceof Integer) {
                this.setVariantArrayElement(l, n, (Integer)object);
                return;
            } else if (object instanceof Long) {
                this.setVariantArrayElement(l, n, (Long)object);
                return;
            } else if (object instanceof Float) {
                this.setVariantArrayElement(l, n, ((Float)object).floatValue());
                return;
            } else if (object instanceof Double) {
                this.setVariantArrayElement(l, n, (Double)object);
                return;
            } else if (object instanceof String) {
                this.setVariantArrayElement(l, n, (String)object);
                return;
            } else if (object instanceof BrowserSideObject) {
                this.setVariantArrayElement(l, n, (BrowserSideObject)object);
                return;
            } else if (object instanceof RemoteJavaObject) {
                this.setVariantArrayElement(l, n, (RemoteJavaObject)object);
                return;
            } else {
                if (object != Void.TYPE) throw new JSException("Inconvertible argument type to LiveConnect: " + object.getClass().getName());
                this.setVariantArrayElementToVoid(l, n);
            }
            return;
        } else {
            this.setVariantArrayElementToScriptingObject(l, n, 0L);
        }
    }

    protected BrowserSideObject newBrowserSideObject(long l) {
        return this.newBrowserSideObject(l, true);
    }

    protected BrowserSideObject newBrowserSideObject(long l, boolean bl) {
        if (bl && this.appletID == null) {
            return null;
        }
        BrowserSideObject browserSideObject = new BrowserSideObject(l);
        if (bl) {
            LiveConnectSupport.registerObject(this.appletID.getID(), browserSideObject);
        }
        return browserSideObject;
    }

    protected long getScriptingObjectForApplet(long l) {
        long l2 = 0L;
        String string = null;
        if (this.appletID == null) {
            this.fillInExceptionInfo(l, "Applet is not running");
            if (DEBUG) {
                string = " because applet is not running";
            }
        } else {
            try {
                ResultID resultID = LiveConnectSupport.sendGetApplet(this, this.appletID);
                if (DEBUG) {
                    System.out.println("AbstractPlugin.getScriptingObjectForApplet starting to wait for result ID " + resultID.getID());
                }
                this.resultHandler.waitForResult(resultID, this.appletID);
                if (DEBUG) {
                    System.out.println("AbstractPlugin.getScriptingObjectForApplet ending wait for result ID " + resultID.getID());
                }
                this.notifyMainThread();
                if (LiveConnectSupport.resultAvailable(resultID)) {
                    try {
                        l2 = this.lookupScriptingObject((RemoteJavaObject)LiveConnectSupport.getResult(resultID), true);
                    }
                    catch (RuntimeException runtimeException) {
                        this.fillInExceptionInfo(l, runtimeException);
                    }
                } else {
                    this.fillInExceptionInfo(l, "Target applet or JVM process exited abruptly");
                }
            }
            catch (IOException iOException) {
                this.fillInExceptionInfo(l, "Target JVM seems to have already exited");
            }
        }
        if (DEBUG) {
            System.out.println("AbstractPlugin.getScriptingObjectForApplet(" + this.appletID + ") returning 0x" + Long.toHexString(l2) + (string != null ? string : ""));
        }
        return l2;
    }

    protected Object getJavaNameSpace(String string) {
        block11: {
            if (this.appletID == null) {
                return null;
            }
            try {
                ResultID resultID = LiveConnectSupport.sendGetNameSpace(this, this.appletID, string);
                if (DEBUG) {
                    System.out.println("AbstractPlugin.getJavaNameSpace starting to wait for result ID " + resultID.getID());
                }
                this.resultHandler.waitForResult(resultID, this.appletID);
                if (DEBUG) {
                    System.out.println("AbstractPlugin.getJavaNameSpace ending wait for result ID " + resultID.getID());
                }
                this.notifyMainThread();
                if (LiveConnectSupport.resultAvailable(resultID)) {
                    try {
                        return LiveConnectSupport.getResult(resultID);
                    }
                    catch (RuntimeException runtimeException) {
                        if (DEBUG) {
                            System.out.println("AbstractPlugin.getJavaNameSpace: exception occurred during fetch of namespace \"" + string + "\"");
                            runtimeException.printStackTrace();
                        }
                    }
                } else if (DEBUG) {
                    System.out.println("AbstractPlugin.getJavaNameSpace: target applet or JVM process exited abruptly");
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block11;
                System.out.println("AbstractPlugin.getJavaNameSpace: target JVM process seems to have already exited");
            }
        }
        return null;
    }

    protected boolean javaObjectInvoke(RemoteJavaObject remoteJavaObject, boolean bl, long l, long l2, int n, long l3, long l4) {
        return this.doJavaObjectOp(remoteJavaObject, bl, 1, this.identifierToString(l), l, l2, n, l3, l4);
    }

    protected boolean javaObjectInvokeConstructor(RemoteJavaObject remoteJavaObject, boolean bl, long l, int n, long l2, long l3) {
        return this.doJavaObjectOp(remoteJavaObject, bl, 1, "<init>", -1L, l, n, l2, l3);
    }

    protected boolean javaObjectGetField(RemoteJavaObject remoteJavaObject, boolean bl, long l, long l2, long l3) {
        return this.doJavaObjectOp(remoteJavaObject, bl, 2, this.identifierToString(l), l, 0L, 0, l2, l3);
    }

    protected boolean javaObjectSetField(RemoteJavaObject remoteJavaObject, boolean bl, long l, long l2, long l3) {
        return this.doJavaObjectOp(remoteJavaObject, bl, 3, this.identifierToString(l), l, l2, 1, 0L, l3);
    }

    protected boolean javaObjectHasField(RemoteJavaObject remoteJavaObject, long l) {
        return this.doJavaObjectOp(remoteJavaObject, false, 4, this.identifierToString(l), l, 0L, 0, 0L, 0L);
    }

    protected boolean javaObjectHasMethod(RemoteJavaObject remoteJavaObject, long l) {
        return this.doJavaObjectOp(remoteJavaObject, false, 5, this.identifierToString(l), l, 0L, 0, 0L, 0L);
    }

    protected boolean javaObjectHasFieldOrMethod(RemoteJavaObject remoteJavaObject, long l) {
        return this.doJavaObjectOp(remoteJavaObject, false, 6, this.identifierToString(l), l, 0L, 0, 0L, 0L);
    }

    protected boolean doJavaObjectOp(RemoteJavaObject remoteJavaObject, boolean bl, int n, String string, long l, long l2, int n2, long l3, long l4) {
        if (string == null) {
            String string2 = "Invalid (null) name -- bad field or method identifier " + l;
            if (DEBUG) {
                System.out.println("AbstractPlugin.doJavaObjectOp: " + string2);
            }
            this.fillInExceptionInfo(l4, string2);
            return false;
        }
        if (remoteJavaObject == null) {
            String string3 = "Invalid (null) object";
            if (DEBUG) {
                System.out.println("AbstractPlugin.doJavaObjectOp: " + string3);
            }
            this.fillInExceptionInfo(l4, string3);
            return false;
        }
        Object[] objectArray = null;
        if (l2 != 0L && n2 > 0) {
            objectArray = new Object[n2];
            if (this.scriptingObjectArgumentListsAreReversed()) {
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.variantArrayElementToObject(l2, n2 - i - 1);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.variantArrayElementToObject(l2, i);
                }
            }
        }
        Object var15_15 = null;
        try {
            ResultID resultID = LiveConnectSupport.sendRemoteJavaObjectOp(this, remoteJavaObject, string, n, objectArray);
            if (DEBUG) {
                System.out.println("AbstractPlugin.doJavaObjectOp starting to wait for result ID " + resultID.getID());
            }
            this.resultHandler.waitForResult(resultID, remoteJavaObject.getJVMID(), new AppletID(remoteJavaObject.getAppletID()));
            if (DEBUG) {
                System.out.println("AbstractPlugin.doJavaObjectOp ending wait for result ID " + resultID.getID());
            }
            this.notifyMainThread();
            if (LiveConnectSupport.resultAvailable(resultID)) {
                try {
                    Object object = LiveConnectSupport.getResult(resultID);
                    if (n == 4 || n == 5 || n == 6) {
                        if (object != null) {
                            return (Boolean)object;
                        }
                        return false;
                    }
                    this.objectToVariantArrayElement(object, l3, 0);
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    if (DEBUG) {
                        runtimeException.printStackTrace();
                    }
                    this.fillInExceptionInfo(l4, runtimeException.getMessage());
                }
            } else {
                this.fillInExceptionInfo(l4, "Target applet or JVM process exited abruptly");
            }
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
            this.fillInExceptionInfo(l4, "Target JVM seems to have already exited");
        }
        catch (JSException jSException) {
            if (DEBUG) {
                jSException.printStackTrace();
            }
            this.fillInExceptionInfo(l4, jSException.toString());
        }
        return false;
    }

    private void javaObjectRemoveField(RemoteJavaObject remoteJavaObject, long l, long l2) {
        this.fillInExceptionInfo(l2, "Removal of Java fields (\"" + this.identifierToString(l) + "\") not supported");
    }

    protected abstract BrowserSideObject javaScriptGetWindowInternal(boolean var1);

    private String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\"' || c == '\\') {
                stringBuffer.append("\\");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected String prepareURL(String string) {
        return this.escape(string);
    }

    protected String prepareTarget(String string) {
        if (string == null || string.length() == 0) {
            string = "_blank";
        }
        return this.escape(string);
    }

    public void showDocument(String string, String string2) {
        BrowserSideObject browserSideObject = this.javaScriptGetWindowInternal(false);
        if (browserSideObject != null) {
            this.javaScriptEval(browserSideObject, "window.open('" + this.prepareURL(string) + "','" + this.prepareTarget(string2) + "').focus();");
        }
    }

    public void showStatus(String string) {
        BrowserSideObject browserSideObject = this.javaScriptGetWindowInternal(false);
        if (string != null && browserSideObject != null) {
            this.javaScriptEval(browserSideObject, "window.top.status='" + this.escape(string) + "';");
        }
    }

    protected void releaseRemoteJavaObject(RemoteJavaObject remoteJavaObject) {
        JVMManager.getManager().releaseRemoteJavaObject(remoteJavaObject);
    }

    private Boolean newBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private Byte newByte(byte by) {
        return new Byte(by);
    }

    private Character newCharacter(char c) {
        return new Character(c);
    }

    private Short newShort(short s) {
        return new Short(s);
    }

    private Integer newInteger(int n) {
        return new Integer(n);
    }

    private Long newLong(long l) {
        return new Long(l);
    }

    private Float newFloat(float f) {
        return new Float(f);
    }

    private Double newDouble(double d) {
        return new Double(d);
    }
}

