
EQUIPSLOTS={HANDS = "hands",HEAD = "head",BODY = "body",BACK = "back",NECK = "neck",}

PrefabFiles = {
	"tf2scout",
	"tf2scout_none",
	"tf2scoutcap",
	"tf2scoutbat",
	"tf2scoutbag",
	"bonkpunch",
	"tf2sandman",
	"crit_cola",
    "holy_mackerel",
	"tf2hot_dogger",
	"baseball",
	"baseballprojectile",
  	"tf2madmilk",
	"tf2bostonbasher",
}

Assets = {

	Asset( "IMAGE", "bigportraits/tf2scout.tex" ),
	 Asset( "ATLAS", "bigportraits/tf2scout.xml" ),
	
	Asset( "IMAGE", "images/map_icons/tf2scout.tex" ),
	Asset( "ATLAS", "images/map_icons/tf2scout.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_tf2scout.tex" ),
	 Asset( "ATLAS", "images/avatars/avatar_tf2scout.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_tf2scout.tex" ),
	Asset( "ATLAS", "images/avatars/avatar_ghost_tf2scout.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_tf2scout.tex" ),
	Asset( "ATLAS", "images/avatars/self_inspect_tf2scout.xml" ),
	
	Asset( "IMAGE", "images/names_tf2scout.tex" ),
	Asset( "ATLAS", "images/names_tf2scout.xml" ),
	
	Asset( "IMAGE", "bigportraits/tf2scout_none.tex" ),
	Asset( "ATLAS", "bigportraits/tf2scout_none.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/tf2scout.fev"),
	Asset("SOUND", "sound/tf2scout.fsb"),
	
	Asset("ATLAS", "images/inventoryimages/tf2scoutcap.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2scoutcap.tex"),
	Asset("ATLAS", "images/inventoryimages/tf2scoutbat.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2scoutbat.tex"),
	Asset("ATLAS", "images/inventoryimages/tf2scoutbag.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2scoutbag.tex"),
	Asset("ATLAS", "images/inventoryimages/tf2sandman.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2sandman.tex"),
	Asset("ATLAS", "images/inventoryimages/tf2hot_dogger.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2hot_dogger.tex"),
	Asset("ATLAS", "images/inventoryimages/tf2madmilk.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2madmilk.tex"),
	Asset("ATLAS", "images/inventoryimages/bonkpunch.xml"),
	Asset("IMAGE", "images/inventoryimages/bonkpunch.tex"),
	Asset("ATLAS", "images/inventoryimages/crit_cola.xml"),
	Asset("IMAGE", "images/inventoryimages/crit_cola.tex"),
	Asset("ATLAS", "images/inventoryimages/holy_mackerel.xml"),
	Asset("IMAGE", "images/inventoryimages/holy_mackerel.tex"),
	Asset("ATLAS", "images/inventoryimages/tf2bostonbasher.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2bostonbasher.tex"),
	
	Asset("IMAGE", "images/map_icons/tf2scoutbag.tex"),
	Asset("ATLAS", "images/map_icons/tf2scoutbag.xml"),
	Asset("IMAGE", "images/map_icons/tf2baseball.tex"),
	Asset("ATLAS", "images/map_icons/tf2baseball.xml"),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local TECH = GLOBAL.TECH
local TUNING = GLOBAL.TUNING
local SpawnPrefab = GLOBAL.SpawnPrefab
local CHARACTER_INGREDIENT = GLOBAL.CHARACTER_INGREDIENT

TUNING.HOMERSTUN = 20

TUNING.SCOUT_RUN_SPEED_BONUS = GetModConfigData("tf2scoutbasespeed")
TUNING.RAMPERTIME = GetModConfigData("Ramper_Time")
TUNING.TF2SCOUTBAT_DAMAGE = GetModConfigData("tf2scoutbatdmg")
TUNING.TF2SCOUTBAT_USES = GetModConfigData("tf2scoutbatuses")
TUNING.SCOUTCAP_SPEED_MULT = GetModConfigData("tf2scouthatspeed")
TUNING.SCOUTBAG_SPEED_MULT = GetModConfigData("tf2scoutbagspeed")

TUNING.TF2SCOUTBBALL_TIMER = GetModConfigData("tf2baseballcharge")
TUNING.TF2SANDMAN_DAMAGE = GetModConfigData("tf2scoutsandmandmg")
TUNING.TF2SANDMAN_USES = GetModConfigData("tf2sandmanuses")
TUNING.TF2SANDMAN_BASEBALL_DAMAGE = GetModConfigData("tf2baseballsandmandmg")

TUNING.MADMILKED_DURATION = GetModConfigData("tf2milkduration")
TUNING.BONKINVULN_DURATION = GetModConfigData("tf2bonkpunchduration")
TUNING.CRITCOLA_DURATION = GetModConfigData("tf2critcoladuration")

TUNING.TF2BOSTONBASHER_DAMAGE = GetModConfigData("tf2bbasherdmg")
TUNING.TF2BOSTONBASHER_USES = GetModConfigData("tf2bbasheruses")
TUNING.TF2BOSTONBASHER_BLEEDTIME = GetModConfigData("tf2bostonbasherbleedtime")
TUNING.TF2BOSTONBASHER_BLEEDDMG = GetModConfigData("tf2bostonbasherbleeddmg")
TUNING.TF2HOLYMACKEREL_DAMAGE = GetModConfigData("tf2holymacdmg")
TUNING.TF2HOLYMACKEREL_USES = GetModConfigData("tf2holymacuses")
TUNING.TF2HOTDOGGER_HUNGERSECONDS = GetModConfigData("tf2hotdoggerhungersecs")

STRINGS.CHARACTER_TITLES.tf2scout = "The Fast-Running Scrapper"
STRINGS.CHARACTER_NAMES.tf2scout = "Jeremy"
STRINGS.NAMES.TF2SCOUT = "Scout"
STRINGS.CHARACTER_DESCRIPTIONS.tf2scout = "*Gains more speed running, drains speed standing\n*Brings his own Scout arsenal\n*Can Jump"
STRINGS.CHARACTER_QUOTES.tf2scout = "\"Grass grows, birds fly, sun shines, and brother, I hurt people.\""
STRINGS.CHARACTERS.TF2SCOUT = require "speech_tf2scout"

local recipe_difficulty = GetModConfigData("Scouthat_Difficulty")
if recipe_difficulty == "default" then
local tf2scoutcap = AddRecipe("tf2scoutcap", {Ingredient("strawhat", 1), Ingredient("stinger", 2), Ingredient("charcoal", 2)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutcap.xml", "tf2scoutcap.tex")
tf2scoutcap.sortkey = -3
elseif recipe_difficulty == "easy" then 
local tf2scoutcap = AddRecipe("tf2scoutcap", {Ingredient("stinger", 1), Ingredient("charcoal", 2)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutcap.xml", "tf2scoutcap.tex")
tf2scoutcap.sortkey = -3
elseif recipe_difficulty == "hard" then 
local tf2scoutcap = AddRecipe("tf2scoutcap", {Ingredient("strawhat", 1), Ingredient("stinger", 3), Ingredient("charcoal", 4)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutcap.xml", "tf2scoutcap.tex")
tf2scoutcap.sortkey = -3
elseif recipe_difficulty == "harder" then 
local tf2scoutcap = AddRecipe("tf2scoutcap", {Ingredient("strawhat", 1), Ingredient("stinger", 4), Ingredient("charcoal", 5)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutcap.xml", "tf2scoutcap.tex")
tf2scoutcap.sortkey = -3
end

local recipe_difficulty = GetModConfigData("Scoutbat_Difficulty")
if recipe_difficulty == "default" then
local tf2scoutbat = AddRecipe("tf2scoutbat", {Ingredient("marble", 3), Ingredient("rope", 1), Ingredient("rocks", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbat.xml")
tf2scoutbat.sortkey = -7
elseif recipe_difficulty == "easy" then 
local tf2scoutbat = AddRecipe("tf2scoutbat", {Ingredient("marble", 2), Ingredient("rope", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbat.xml")
tf2scoutbat.sortkey = -7
elseif recipe_difficulty == "hard" then 
local tf2scoutbat = AddRecipe("tf2scoutbat", {Ingredient("marble", 3), Ingredient("rope", 2), Ingredient("rocks", 2)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbat.xml")
tf2scoutbat.sortkey = -7
elseif recipe_difficulty == "harder" then 
local tf2scoutbat = AddRecipe("tf2scoutbat", {Ingredient("marble", 5), Ingredient("rope", 4), Ingredient("rocks", 4)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbat.xml")
tf2scoutbat.sortkey = -7
end

local recipe_difficulty = GetModConfigData("Scoutbag_Difficulty")
if recipe_difficulty == "default" then
local tf2scoutbag = AddRecipe("tf2scoutbag", {Ingredient("pigskin", 2), Ingredient("twigs", 4)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbag.xml")
tf2scoutbag.sortkey = -2
elseif recipe_difficulty == "easy" then 
local tf2scoutbag = AddRecipe("tf2scoutbag", {Ingredient("pigskin", 1), Ingredient("twigs", 2)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbag.xml")
tf2scoutbag.sortkey = -2
elseif recipe_difficulty == "hard" then 
local tf2scoutbag = AddRecipe("tf2scoutbag", {Ingredient("pigskin", 4), Ingredient("twigs", 4)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbag.xml")
tf2scoutbag.sortkey = -2
elseif recipe_difficulty == "harder" then 
local tf2scoutbag = AddRecipe("tf2scoutbag", {Ingredient("pigskin", 6), Ingredient("twigs", 6)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2scoutbag.xml")
tf2scoutbag.sortkey = -2
end

local recipe_difficulty = GetModConfigData("ScoutBonk_Difficulty")
if recipe_difficulty == "default" then
local tf2bonkrecipe = AddRecipe("bonkpunch", {Ingredient(CHARACTER_INGREDIENT.HEALTH, 25), Ingredient("red_cap", 5), Ingredient("nightmarefuel", 7)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/bonkpunch.xml")
tf2bonkrecipe.sortkey = -4
elseif recipe_difficulty == "easy" then 
local tf2bonkrecipe = AddRecipe("bonkpunch", {Ingredient("berries", 5), Ingredient("red_cap", 5), Ingredient("nightmarefuel", 5)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/bonkpunch.xml")
tf2bonkrecipe.sortkey = -4
elseif recipe_difficulty == "hard" then 
local tf2bonkrecipe = AddRecipe("bonkpunch", {Ingredient(CHARACTER_INGREDIENT.HEALTH, 30), Ingredient("red_cap", 7), Ingredient("nightmarefuel", 10)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/bonkpunch.xml")
tf2bonkrecipe.sortkey = -4
elseif recipe_difficulty == "harder" then 
local tf2bonkrecipe = AddRecipe("bonkpunch", {Ingredient(CHARACTER_INGREDIENT.HEALTH, 35), Ingredient("red_cap", 8), Ingredient("nightmarefuel", 12)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_THREE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/bonkpunch.xml")
tf2bonkrecipe.sortkey = -4
end

local recipe_difficulty = GetModConfigData("ScoutCritCola_Difficulty")
if recipe_difficulty == "default" then
local tf2critcolarecipe = AddRecipe("crit_cola", {Ingredient("bonkpunch", 1, "images/inventoryimages/bonkpunch.xml"), Ingredient("monstermeat", 5), Ingredient("nightmarefuel", 5)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_THREE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/crit_cola.xml")
tf2critcolarecipe.sortkey = -3
elseif recipe_difficulty == "easy" then 
local tf2critcolarecipe = AddRecipe("crit_cola", {Ingredient("berries", 3), Ingredient("monstermeat", 3), Ingredient("nightmarefuel", 5)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/crit_cola.xml")
tf2critcolarecipe.sortkey = -3
elseif recipe_difficulty == "hard" then 
local tf2critcolarecipe = AddRecipe("crit_cola", {Ingredient("bonkpunch", 1, "images/inventoryimages/bonkpunch.xml"), Ingredient("monstermeat", 8), Ingredient("nightmarefuel", 7)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_THREE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/crit_cola.xml")
tf2critcolarecipe.sortkey = -3
elseif recipe_difficulty == "harder" then 
local tf2critcolarecipe = AddRecipe("crit_cola", {Ingredient("bonkpunch", 2, "images/inventoryimages/bonkpunch.xml"), Ingredient("monstermeat", 10), Ingredient("nightmarefuel", 10)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.MAGIC_THREE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/crit_cola.xml")
tf2critcolarecipe.sortkey = -3
end

local recipe_difficulty = GetModConfigData("ScoutSandman_Difficulty")
if recipe_difficulty == "default" then
local tf2sandmanbatrecipe = AddRecipe("tf2sandman", {Ingredient("log", 4), Ingredient("tf2scoutbat", 1, "images/inventoryimages/tf2scoutbat.xml"), Ingredient("silk", 4)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2sandman.xml")
tf2sandmanbatrecipe.sortkey = -6
elseif recipe_difficulty == "easy" then 
local tf2sandmanbatrecipe = AddRecipe("tf2sandman", {Ingredient("log", 2), Ingredient("twigs", 4), Ingredient("silk", 2)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2sandman.xml")
tf2sandmanbatrecipe.sortkey = -6
elseif recipe_difficulty == "hard" then 
local tf2sandmanbatrecipe = AddRecipe("tf2sandman", {Ingredient("log", 5), Ingredient("tf2scoutbat", 1, "images/inventoryimages/tf2scoutbat.xml"), Ingredient("lightbulb", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2sandman.xml")
tf2sandmanbatrecipe.sortkey = -6
elseif recipe_difficulty == "harder" then 
local tf2sandmanbatrecipe = AddRecipe("tf2sandman", {Ingredient("log", 7), Ingredient("tf2scoutbat", 2, "images/inventoryimages/tf2scoutbat.xml"), Ingredient("trinket_3", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2sandman.xml")
tf2sandmanbatrecipe.sortkey = -6
end

local recipe_difficulty = GetModConfigData("ScoutBBasher_Difficulty")
if recipe_difficulty == "default" then
local tf2bostonbasherrecipe = AddRecipe("tf2bostonbasher", {Ingredient("tentaclespike", 1), Ingredient("tf2sandman", 1, "images/inventoryimages/tf2sandman.xml"), Ingredient("twigs", 4)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2bostonbasher.xml")
tf2bostonbasherrecipe.sortkey = -5
elseif recipe_difficulty == "easy" then 
local tf2bostonbasherrecipe = AddRecipe("tf2bostonbasher", {Ingredient("twigs", 5), Ingredient("tentaclespike", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2bostonbasher.xml")
tf2bostonbasherrecipe.sortkey = -5
elseif recipe_difficulty == "hard" then 
local tf2bostonbasherrecipe = AddRecipe("tf2bostonbasher", {Ingredient("tentaclespike", 2), Ingredient("tf2sandman", 1, "images/inventoryimages/tf2sandman.xml"), Ingredient("logs", 5)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2bostonbasher.xml")
tf2bostonbasherrecipe.sortkey = -5
elseif recipe_difficulty == "harder" then 
local tf2bostonbasherrecipe = AddRecipe("tf2bostonbasher", {Ingredient("tentaclespike", 2), Ingredient("tf2sandman", 1, "images/inventoryimages/tf2sandman.xml"), Ingredient("nightmarefuel", 6)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2bostonbasher.xml")
tf2bostonbasherrecipe.sortkey = -5
end

local recipe_difficulty = GetModConfigData("HolyMack_Difficulty")
if recipe_difficulty == "default" then
local tf2mackerelrecipe = AddRecipe("holy_mackerel", {Ingredient("fish", 1), Ingredient("papyrus", 2), Ingredient("rope", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/holy_mackerel.xml")
tf2mackerelrecipe.sortkey = -2
elseif recipe_difficulty == "easy" then 
local tf2mackerelrecipe = AddRecipe("holy_mackerel", {Ingredient("fish", 1), Ingredient("papyrus", 1), Ingredient("rope", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_NONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/holy_mackerel.xml")
tf2mackerelrecipe.sortkey = -2
elseif recipe_difficulty == "hard" then 
local tf2mackerelrecipe = AddRecipe("holy_mackerel", {Ingredient("fish", 1), Ingredient("papyrus", 3), Ingredient("rope", 2)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/holy_mackerel.xml")
tf2mackerelrecipe.sortkey = -2
elseif recipe_difficulty == "harder" then 
local tf2mackerelrecipe = AddRecipe("holy_mackerel", {Ingredient("fish", 1), Ingredient("papyrus", 4), Ingredient("tf2scoutbat", 1, "images/inventoryimages/tf2scoutbat.xml")}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/holy_mackerel.xml")
tf2mackerelrecipe.sortkey = -2
end

local recipe_difficulty = GetModConfigData("Madmilk_Difficulty")
if recipe_difficulty == "default" then
local tf2madmilk = AddRecipe("tf2madmilk", {Ingredient("goatmilk", 1), Ingredient("nightmarefuel", 2)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2madmilk.xml")
tf2madmilk.sortkey = -1
elseif recipe_difficulty == "easy" then 
local tf2madmilk = AddRecipe("tf2madmilk", {Ingredient("goatmilk", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2madmilk.xml")
tf2madmilk.sortkey = -1
elseif recipe_difficulty == "hard" then 
local tf2madmilk = AddRecipe("tf2madmilk", {Ingredient("goatmilk", 2), Ingredient("nightmarefuel", 5)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2madmilk.xml")
tf2madmilk.sortkey = -1
elseif recipe_difficulty == "harder" then 
local tf2madmilk = AddRecipe("tf2madmilk", {Ingredient("goatmilk", 2), Ingredient("nightmarefuel", 10), Ingredient("ice", 4)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.SCIENCE_TWO, nil, nil, nil, nil, "tf2scout", "images/inventoryimages/tf2madmilk.xml")
tf2madmilk.sortkey = -1
end

--Everyone can craft it
AddRecipe("tf2hot_dogger", {Ingredient("meat", 1), Ingredient("papyrus", 4), Ingredient("rope", 4)}, GLOBAL.RECIPETABS.DRESS, GLOBAL.TECH.SCIENCE_ONE, nil, nil, nil, nil, nil, "images/inventoryimages/tf2hot_dogger.xml")
--tf2hotdoggerrecipe.sortkey = 0

modimport("scripts/strings.lua")

AddPrefabPostInit("tf2scoutbag", function(inst) --Extra Equipslots auto-compatibility
if not GLOBAL.TheWorld.ismastersim then 
inst.OnEntityReplicated = function(inst) inst.replica.container:WidgetSetup("backpack") end	
return inst
end

local XSLOTS_ADDED = GLOBAL.KnownModIndex:IsModEnabled("workshop-375850593")
for k,v in pairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
	XSLOTS_ADDED = XSLOTS_ADDED or v == "workshop-375850593"
end

if XSLOTS_ADDED then
inst.components.equippable.equipslot = EQUIPSLOTS.BACK
else
inst.components.equippable.equipslot = EQUIPSLOTS.BODY
end

end)

------------- Scouts Jump SG ---------------------------------

local state_freejump_pre = GLOBAL.State{ name = "freejump_pre",
	tags = { "doing", "busy", "canrotate", "nomorph" },

	onenter = function(inst)
		inst.components.locomotor:Stop()
		inst.AnimState:PlayAnimation("jump_pre")
		inst.sg:SetTimeout(GLOBAL.FRAMES*18)
	end,
	
	events =
	{
		GLOBAL.EventHandler("animover", function(inst)
			if GLOBAL.TheWorld.ismastersim then
				inst:PerformBufferedAction()
			end
		        if not GLOBAL.TheWorld.ismastersim then
				inst:PerformPreviewBufferedAction()
			end
		end),
	},
	
	onupdate = function(inst)
		if not GLOBAL.TheWorld.ismastersim then
			if inst:HasTag("doing") then
				if inst.entity:FlattenMovementPrediction() then
					inst.sg:GoToState("idle", "noanim")
				end
			elseif inst.bufferedaction == nil then
				inst.sg:GoToState("idle", true)
			end
		end
	end,

	ontimeout = function(inst)
		if not GLOBAL.TheWorld.ismastersim then  -- client
			inst:ClearBufferedAction()
		end
		inst.sg:GoToState("idle")
	end,

	onexit = function(inst)
		if inst.bufferedaction == inst.sg.statemem.action then
			inst:ClearBufferedAction()
		end
		inst.sg.statemem.action = nil
	end,
}
AddStategraphState("wilson", state_freejump_pre)
AddStategraphState("wilson_client", state_freejump_pre)

AddStategraphState("wilson", GLOBAL.State{ name = "freejump",
	tags = { "doing", "busy" },

	onenter = function(inst)

		inst.Physics:ClearCollisionMask()
		inst.Physics:CollidesWith(GLOBAL.COLLISION.GROUND)
		inst.Physics:CollidesWith(GLOBAL.COLLISION.GIANTS)
	
		inst.AnimState:PlayAnimation("jumpout")
		
		inst.sg.statemem.action = inst.bufferedaction
		inst.sg:SetTimeout(30 * GLOBAL.FRAMES)
	end,

	timeline =
	{

		GLOBAL.TimeEvent(15.2 * GLOBAL.FRAMES, function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/movement/bodyfall_dirt")
		end),
		GLOBAL.TimeEvent(18 * GLOBAL.FRAMES, function(inst)
			inst.Physics:Stop()
		end),
	},

	events =
	{
		GLOBAL.EventHandler("animqueueover", function(inst)
			local x,y,z = inst.Transform:GetWorldPosition()
			if inst.AnimState:AnimDone() then
				GLOBAL.ChangeToCharacterPhysics(inst)
				inst.Transform:SetPosition(x,0,z)
				inst.sg:GoToState("idle")
			end
		end),
	},
	
	ontimeout = function(inst)
		if not GLOBAL.TheWorld.ismastersim then  -- client
			inst:ClearBufferedAction()
		end
		GLOBAL.ChangeToCharacterPhysics(inst)
		local x,y,z = inst.Transform:GetWorldPosition()
		inst.Transform:SetPosition(x,0,z)
		inst.sg:GoToState("idle")
	end,
	
	onexit = function(inst)
		GLOBAL.ChangeToCharacterPhysics(inst)
		local x,y,z = inst.Transform:GetWorldPosition()
		inst.Transform:SetPosition(x,0,z)
		if inst.bufferedaction == inst.sg.statemem.action then
			inst:ClearBufferedAction()
		end
		inst.sg.statemem.action = nil
	end,
})

-- Make special actions -------------------------------------------------

AddComponentPostInit("playeractionpicker", function(self)
    local old = self.SortActionList
    function self:SortActionList(actions, target, useitem)
        if #actions == 0 then
            return actions
        end
        local a = 0
        local t = 0
        local c = 0
        for k, v in pairs(actions) do
            if self.inst:HasTag("bonked") and v == GLOBAL.ACTIONS.ATTACK then
                a = 1
                break
            end
            if self.inst:HasTag("bonked") and v == GLOBAL.ACTIONS.TOSS then
                t = 1
                break
            end
            if self.inst:HasTag("bonked") and v == GLOBAL.ACTIONS.CASTSPELL then
                t = 1
                break
            end
        end

        if a == 1 or t == 1 or c == 1 then
            return {}
        else
            return old(self, actions, target, useitem)
        end

    end
end)

local SCOUTDRINK = GLOBAL.Action({ priority=10, rmb=true, distance=10, mount_valid=false })	
SCOUTDRINK.str = "Drink"
SCOUTDRINK.id = "SCOUTDRINK"
SCOUTDRINK.fn = function(act)
    local obj = act.target or act.invobject
    if obj ~= nil and obj:HasTag("scoutdrink") and obj.components.edible ~= nil and act.doer.components.eater ~= nil then
        return act.doer.components.eater:Eat(obj)
    end
end

AddAction(SCOUTDRINK)

AddComponentAction("INVENTORY", "edible", function(inst, doer, actions, right)
    if inst:HasTag("scoutdrink") then
        table.insert(actions, ACTIONS.SCOUTDRINK)
    end
end)

local scoutdrink_handler = ActionHandler(ACTIONS.SCOUTDRINK, function(inst) 
	if inst:HasTag("tf2scout") then
	    return "quickeat"
	end
	if not inst:HasTag("tf2scout") then
	    return "quickeat"
	end
end)

AddStategraphActionHandler("wilson", scoutdrink_handler)
AddStategraphActionHandler("wilson_client", scoutdrink_handler)

local SCOUTJUMP = GLOBAL.Action({ priority=10, rmb=true, distance=10, mount_valid=false })	
SCOUTJUMP.str = "Jump"
SCOUTJUMP.id = "SCOUTJUMP"
SCOUTJUMP.fn = function(act)
    if act.doer:HasTag("tf2scout") then
	if act.doer.components.scoutjump:SJump(act.pos, act.doer) then
	    return true
	end
    end
end

AddAction(SCOUTJUMP)

local scoutjump_handler = ActionHandler(ACTIONS.SCOUTJUMP, function(inst, action)
    local xm, ym, zm = action.pos:Get()
    local passable = GLOBAL.TheWorld.Map:IsPassableAtPoint(xm, ym, zm)

    if inst:HasTag("tf2scout") and passable == true then
	inst:ForceFacePoint(xm, ym, zm)
	return "freejump_pre"
    end
end)

local function scout_jump_text(inst, doer, pos, actions, right)
    local xjp, yjp, zjp = pos:Get()
    local xs, ys, zs = doer.Transform:GetWorldPosition()
    local dist = math.sqrt((xjp - xs)*(xjp - xs) + (zjp - zs)*(zjp - zs))
    local rightrect = doer.replica.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and doer.replica.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).components.reticule ~= nil or nil

	if right and rightrect == nil and doer:HasTag("tf2scout") and dist <= 10 and not (doer.replica.rider:IsRiding() or doer.replica.inventory:IsHeavyLifting() or doer:HasTag("bonked")) then

		table.insert(actions, GLOBAL.ACTIONS.SCOUTJUMP)

	end
end

AddComponentAction('POINT', 'equippable', scout_jump_text)

AddStategraphActionHandler("wilson", scoutjump_handler)
AddStategraphActionHandler("wilson_client", scoutjump_handler)

AddMinimapAtlas("images/map_icons/tf2scout.xml")
AddMinimapAtlas("images/map_icons/tf2scoutbag.xml")
AddMinimapAtlas("images/map_icons/tf2baseball.xml")
AddModCharacter("tf2scout", "MALE")