local ScoutJump = Class(function(self, inst)
    self.inst = inst
    self.onjumpedfn = nil
    self.jumptask = nil
end)

function ScoutJump:SpawnEffect(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("sand_puff_large_back").Transform:SetPosition(x, y - .1, z)
    SpawnPrefab("sand_puff_large_front").Transform:SetPosition(x, y, z)
end

local function OnJumped(caster, self, pt)
    if caster.components.health ~= nil then
        caster.components.health:SetInvincible(false)
    end
    local x1, y1, z1 = pt:Get()
    local x2, y2, z2 = caster.Transform:GetWorldPosition()
    local dist = math.sqrt((x1 - x2)*(x1 - x2) + (z1 - z2)*(z1 - z2))

    if dist <= 1  then
        caster.Physics:SetMotorVel(0.5, 0, 0)
    end
    if dist >= 2 and dist <= 3 then
        caster.Physics:SetMotorVel(4, 0, 0)
    end
    if dist > 3 and dist <= 4 then
        caster.Physics:SetMotorVel(6, 0, 0)
    end
    if dist > 4 and dist <= 5 then
        caster.Physics:SetMotorVel(8, 0, 0)
    end
    if dist > 5 and dist <= 6 then
        caster.Physics:SetMotorVel(9, 0, 0)
    end
    if dist > 6 and dist <= 7 then
        caster.Physics:SetMotorVel(10, 0, 0)
    end
    if dist > 7 and dist <= 8 then
        caster.Physics:SetMotorVel(12, 0, 0)
    end
    if dist > 8 and dist <= 9 then
        caster.Physics:SetMotorVel(13, 0, 0)
    end
    if dist > 9 then
        caster.Physics:SetMotorVel(16, 0, 0)
    end

    caster.sg:GoToState("freejump")
    self:SpawnEffect(caster)
end

function ScoutJump:SJump(pt, caster)

    if self.jumptask ~= nil then
        self.jumptask:Cancel()
    end

    if caster.components.health ~= nil then
        caster.components.health:SetInvincible(true)
    end

    self.jumptask = caster:DoTaskInTime(0, OnJumped, self, pt)

    if self.onjumpedfn ~= nil then
        self.onjumpedfn(self.inst, pt, caster)
    end

    return true
end

return ScoutJump
