local assets =
{
    Asset("ANIM", "anim/tf2baseball.zip"),
}

local prefabs =
{
}
local function IsBat(item)
    return item.prefab == "tf2sandman"
end

local function OnPickup(inst)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if owner and owner:HasTag("tf2scout") then
        local hassandman = owner.components.inventory:FindItem(IsBat) or owner.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) or nil
        if hassandman ~= nil and hassandman:HasTag("empty") then
	    hassandman:PushEvent("recharged")
        end
    end

    inst:DoTaskInTime(0, function()
        inst:Remove()
    end)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("tf2baseball")
    inst.AnimState:SetBuild("tf2baseball")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:PushAnimation("idle", false)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPickup)

    inst:DoTaskInTime(TUNING.TF2SCOUTBBALL_TIMER - 1, function() --15 second recharge; minus 1 for delay animation
        local x, y, z = inst.Transform:GetWorldPosition()
	SpawnPrefab("sand_puff").Transform:SetPosition(x, y, z)
	inst:Remove()
    end)
	
	inst.MiniMapEntity:SetIcon("tf2baseball.tex")

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.BASEBALL = "A Baseball"
STRINGS.NAMES.BASEBALL = "Baseball"

return Prefab("baseball", fn, assets, prefabs)