local assets =
{

    Asset("ANIM", "anim/bonkpunch.zip"),
    Asset("ANIM", "anim/tf2bonk_trail.zip"),

    Asset("ATLAS", "images/inventoryimages/bonkpunch.xml"),
    Asset("IMAGE", "images/inventoryimages/bonkpunch.tex"),

}

local function Bonk_Use(inst, eater)
    if eater:HasTag("bonked") then
	return
    end
    if eater:HasTag("player") then
	eater.bonktime = TUNING.BONKINVULN_DURATION
	eater:AddTag("bonked")
	eater.components.health:SetInvincible(true)
	eater.components.inventory:Close()
        eater.AnimState:SetMultColour( 200/255, 50/255, 50/255, 1 )

	if not eater:HasTag("tf2scout") then
    	    eater.components.sanity:DoDelta(-10) --20
    	    eater.components.health:DoDelta(-5) --10
	    eater.bonktime = eater.bonktime / 2
	end

	eater.bonk_trail = function(eater)
	    local mounted = eater.components.rider ~= nil and eater.components.rider:IsRiding() or nil
	    if not eater.entity:IsVisible() or mounted ~= nil then
		return
	    end
	    local x, y, z = eater.Transform:GetWorldPosition()
	    if eater.sg ~= nil and eater.sg:HasStateTag("moving") then
	        local theta = -eater.Transform:GetRotation() * DEGREES
		local speed = eater.components.locomotor:GetRunSpeed() * .1
		x = x - speed * math.cos(theta)
		z = z - speed * math.sin(theta)
		eater.bonkedfx = SpawnPrefab("bonktrailfx")
		eater.bonkedfx.Transform:SetPosition(x, 0, z)

	    end
	end
        eater.components.combat:BlankOutAttacks(eater.bonktime)

        eater.bonk_trailtask = eater:DoPeriodicTask(3 * FRAMES, eater.bonk_trail, 1 * FRAMES)
	eater.bonktask = eater:DoTaskInTime(eater.bonktime, function()
	    eater.components.health:SetInvincible(false)
	    eater.components.inventory:Open()
	    eater:RemoveTag("bonked")
	    eater.AnimState:SetMultColour( 1, 1, 1, 1 )
	    eater.bonktask = nil
	    eater.bonk_trailtask:Cancel()
	    eater.bonk_trailtask = nil
	end)
    end
end

local function init()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bonkpunch")
    inst.AnimState:SetBuild("bonkpunch")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("bonkpunch")
    inst:AddTag("scoutdrink")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bonkpunch.xml"
    inst.components.inventoryitem.imagename = "bonkpunch"

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = -5
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = -10
    inst.components.edible.foodtype = FOODTYPE.GOODIES
    inst.components.edible:SetOnEatenFn(Bonk_Use)

    MakeHauntableLaunch(inst)

    return inst
end

local function replay(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function bonktrailfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("tf2bonk_trail")
    inst.AnimState:SetBuild("tf2bonk_trail")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour( 1,1,1,0 )
    inst.entity:SetPristine()

    inst:AddTag("NOCLICK")
    inst:AddTag("FX")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    inst:DoTaskInTime(13 * FRAMES, ErodeAway)
    inst:ListenForEvent("animover", replay)
    --inst:ListenForEvent("animover", inst.Remove)

    return inst
end

STRINGS.BONKPUNCH = "Scout's Bonk Atomic Punch"
STRINGS.NAMES.BONKPUNCH = "Bonk! Atomic Punch"
STRINGS.RECIPE_DESC.BONKPUNCH = "Full'a radiation for growin' superpowers."

return Prefab("common/inventory/bonkpunch", init, assets),
	Prefab("bonktrailfx", bonktrailfn, assets)