local assets =
{

    Asset("ANIM", "anim/crit_cola.zip"),
    Asset("ANIM", "anim/tf2weapon_crit.zip"),

    Asset("ATLAS", "images/inventoryimages/crit_cola.xml"),
    Asset("IMAGE", "images/inventoryimages/crit_cola.tex"),
	
}

local function Cola_Use(inst, eater)
    if eater:HasTag("crited") then
	return
    end
    if eater:HasTag("player") then
	eater.crittime = TUNING.CRITCOLA_DURATION
	eater:AddTag("crited")
	eater.healthabsorb = eater.components.health.absorb or 0
	eater.combatmult = eater.components.combat.damagemultiplier or 1
	eater.components.health.absorb = eater.healthabsorb - .10
	eater.components.combat.damagemultiplier = eater.combatmult + .35

	if not eater:HasTag("tf2scout") then
    	    eater.components.sanity:DoDelta(-10) --20
    	    eater.components.health:DoDelta(-5) --10
	    eater.components.health.absorb = eater.healthabsorb - .15
	    eater.crittime = eater.crittime - 5
	end

	local critfx = SpawnPrefab("tf2shockfx")
	critfx.Transform:SetScale(.80, 0.5, .80)
	critfx.entity:AddFollower()
	critfx.Follower:FollowSymbol(eater.GUID, "swap_body", 0, 0, 0)

	eater.crittask = eater:DoTaskInTime(eater.crittime, function()
	    eater:RemoveTag("crited")
	end)

        eater.critcolabuff = SpawnPrefab("critcolafx")
        eater.critcolabuff.Transform:SetScale(.50, .50, .50)
        local follower = eater.critcolabuff.entity:AddFollower()
        follower:FollowSymbol(eater.GUID, "swap_object", 0, 0, 0)
        eater.critcolabuff:Hide()
        eater.critcolabuff.persists = false

	eater.drinktask = eater:DoPeriodicTask(0, function()
	    if eater.critcolabuff ~= nil and eater.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) == nil then
		eater.critcolabuff:Hide()
	    end
	    if eater.critcolabuff ~= nil and eater.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) ~= nil then
		eater.critcolabuff:Show()
	    end
	    if not eater:HasTag("crited") or eater:HasTag("playerghost") then
	        eater.components.health.absorb = eater.healthabsorb
    	        eater.components.combat.damagemultiplier = eater.combatmult
	        eater:RemoveTag("crited")
	        eater.critcolabuff:Remove()
	        eater.drinktask:Cancel()
	        eater.drinktask = nil
	        eater.crittask = nil
	    end
	end)
    end
end

local function init()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("crit_cola")
    inst.AnimState:SetBuild("crit_cola")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("critcola")
    inst:AddTag("scoutdrink")

    inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("inspectable")
	
    inst:AddComponent("tradable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/crit_cola.xml"
    inst.components.inventoryitem.imagename = "crit_cola"

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = -5
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = -10
    inst.components.edible.foodtype = FOODTYPE.GOODIES
    inst.components.edible:SetOnEatenFn(Cola_Use)
	
    MakeHauntableLaunch(inst)
	
    return inst
end

local function replay(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function critcolafxfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("tf2weapon_crit")
    inst.AnimState:SetBuild("tf2weapon_crit")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour( 255/255,50/255,50/255,1.5 )

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    inst:ListenForEvent("animover", replay)

    return inst
end

local function tf2shockfxfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst:AddTag("NOCLICK")
    inst:AddTag("FX")

    inst.AnimState:SetBank("goosemoose_nest_fx")
    inst.AnimState:SetBuild("goosemoose_nest_fx")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour( 10/255, 10/255, 200/255, 0 )

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    inst:ListenForEvent("animover", inst.Remove)

    return inst
end

STRINGS.CRIT_COLA = "Bonk! Crit-a-Cola"
STRINGS.NAMES.CRIT_COLA = "Crit-a-Cola"
STRINGS.RECIPE_DESC.CRIT_COLA = "Packs a Crit punch."

return Prefab("common/inventory/crit_cola", init, assets),
	Prefab("tf2shockfx", tf2shockfxfn, assets),
	Prefab("critcolafx", critcolafxfn, assets)