local assets =
{
	Asset("ANIM", "anim/holy_mackerel.zip"),
	Asset("ANIM", "anim/swap_holy_mackerel.zip"),

	Asset("ATLAS", "images/inventoryimages/holy_mackerel.xml"),
	Asset("IMAGE", "images/inventoryimages/holy_mackerel.tex"),
}

local function fishhits(inst, owner, target)
if inst.components.talker then
    if owner and owner.fishhit == nil then
	owner.fishhit = 0
    end
    if owner and owner.fishhit == 0 then
        inst.components.talker.colour = Vector3(172, 196, 193)
        inst.components.talker.font = TITLEFONT
        inst.components.talker.fontsize = 28
        inst.components.talker.offset = Vector3(0,-520,0)
    end
    if owner and owner.fishhit ~= nil then
	owner.fishhit = owner.fishhit + 1
    end
    if owner and owner.fishhit and owner.fishhit >= 20 then
        inst.components.talker.fontsize = 32
        inst.components.talker.colour = Vector3(149/255, 191/255, 242/255) -- Blue
        inst.components.talker.offset = Vector3(0,-525,0)
    end
    if owner and owner.fishhit and owner.fishhit >= 40 then
        inst.components.talker.fontsize = 36
        inst.components.talker.colour = Vector3(59/255, 222/255, 99/255) -- Green
        inst.components.talker.offset = Vector3(0,-530,0)
    end
    if owner and owner.fishhit and owner.fishhit >= 60 then
        inst.components.talker.fontsize = 40
        inst.components.talker.colour = Vector3(255/255, 196/255, 45/255) -- Yellow
        inst.components.talker.offset = Vector3(0,-535,0)
    end
    if owner and owner.fishhit and owner.fishhit >= 80 then
        inst.components.talker.fontsize = 44
        inst.components.talker.colour = Vector3(255/255, 165/255, 79/255) -- Orange
        inst.components.talker.offset = Vector3(0,-540,0)
    end
    if owner and owner.fishhit and owner.fishhit >= 100 then
        inst.components.talker.fontsize = 50
        inst.components.talker.colour = Vector3(255/255, 89/255, 46/255) -- Red
        inst.components.talker.offset = Vector3(0,-545,0)
    end
    if target and target.components.health and target.components.health.currenthealth == 0 and not target:HasTag("structure") then
        inst.components.talker.fontsize = 50
        inst.components.talker.colour = Vector3(255/255, 89/255, 46/255) -- Red
        inst.components.talker.offset = Vector3(0,-545,0)
        inst.components.talker:Say("FISH KILL!")
	owner.fishhit = 0
	return
    end
    inst.components.talker:Say("FISH HIT "..string.format(owner.fishhit).." !")
end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_holy_mackerel", "holy_mackerel")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
    owner.fishhit = 0
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("holy_mackerel")
    inst.AnimState:SetBuild("holy_mackerel")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("dull")

    inst:AddComponent("talker")
    inst.components.talker.symbol = "swap_object"
    inst.components.talker.font = TITLEFONT
    inst.components.talker.fontsize = 50
    inst.components.talker.colour = Vector3(255/255, 255/255, 255/255) -- Blue
    inst.components.talker.offset = Vector3(0,-545,0)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TF2HOLYMACKEREL_DAMAGE)
    inst.components.weapon:SetOnAttack(fishhits)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "holy_mackerel"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/holy_mackerel.xml"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TF2HOLYMACKEREL_USES)
    inst.components.finiteuses:SetUses(TUNING.TF2HOLYMACKEREL_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.HOLY_MACKEREL = "Holy Mackerel"
STRINGS.NAMES.HOLY_MACKEREL = "Holy Mackerel"
STRINGS.RECIPE_DESC.HOLY_MACKEREL = "Weaponized Fish."

return Prefab("common/inventory/holy_mackerel", fn, assets)