local assets =
{
	Asset("ANIM", "anim/bostonbasher.zip"),
	Asset("ANIM", "anim/swap_bostonbasher.zip"),

	Asset("ATLAS", "images/inventoryimages/tf2bostonbasher.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2bostonbasher.tex"),
}

local function OnMissOther(inst, data)
    local owner = data.weapon.components.inventoryitem ~= nil and data.weapon.components.inventoryitem.owner or nil
    if owner and owner ~= nil then
	if not (owner:HasTag("bbashed") or owner:HasTag("bonked")) then
	    owner:AddTag("bbashed")
	    owner.bleeddebuff = function()
	        if not (owner.components.health == nil or owner.components.health:IsDead() or owner.components.health.invincible == true) then
		   owner:PushEvent("attacked", { attacker = nil, damage = TUNING.TF2BOSTONBASHER_BLEEDDMG })
		   owner.components.health:DoDelta(-TUNING.TF2BOSTONBASHER_BLEEDDMG)
	        end
	    end
            owner.bleed_task = owner:DoPeriodicTask(1, owner.bleeddebuff)
	    owner.endbleedtask = owner:DoTaskInTime(TUNING.TF2BOSTONBASHER_BLEEDTIME, function()
		owner:RemoveTag("bbashed")
	        owner.bleed_task:Cancel()
	        owner.bleed_task = nil
	    end)
	end
    end
end

local function OnHitOther(inst, data)
    local target = data.target
    local owner = data.weapon.components.inventoryitem ~= nil and data.weapon.components.inventoryitem.owner or nil
    if target and target ~= nil then
	if not (target:HasTag("bbashed")
	    or target:HasTag("bonked")
		or target:HasTag("chess")
		    or target:HasTag("shadowcreature")
		        or target:HasTag("tree")
			    or target:HasTag("birchnutdrake")
				or target:HasTag("birchnutroot")
				    or target:HasTag("birchnut")
				        or target:HasTag("structure")) then
	    target:AddTag("bbashed")
	    target.bleeddebuff = function()
		if not (target.components.health == nil or target.components.health:IsDead() or target.components.health.invincible == true) then
		   target:PushEvent("attacked", { attacker = owner, damage = TUNING.TF2BOSTONBASHER_BLEEDDMG })
		   target.components.health:DoDelta(-TUNING.TF2BOSTONBASHER_BLEEDDMG)
	        end
	    end
            target.bleed_task = target:DoPeriodicTask(1, target.bleeddebuff)
	    target.endbleedtask = target:DoTaskInTime(TUNING.TF2BOSTONBASHER_BLEEDTIME, function()
		target:RemoveTag("bbashed")
	        target.bleed_task:Cancel()
	        target.bleed_task = nil
	    end)
	end
    end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_bostonbasher", "bostonbasher")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

    owner:ListenForEvent("onattackother", OnHitOther)
    owner:ListenForEvent("onmissother", OnMissOther)
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

    owner:RemoveEventCallback("onattackother", OnHitOther)
    owner:RemoveEventCallback("onmissother", OnMissOther)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst:AddTag("sharp")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:SetBank("bostonbasher")
    inst.AnimState:SetBuild("bostonbasher")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TF2BOSTONBASHER_DAMAGE)
    inst.components.weapon:SetRange(1)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("inventoryitem")

    inst.components.inventoryitem.imagename = "tf2bostonbasher"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2bostonbasher.xml"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TF2BOSTONBASHER_USES)
    inst.components.finiteuses:SetUses(TUNING.TF2BOSTONBASHER_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.TF2BOSTONBASHER = "Scout's Boston Basher"
STRINGS.NAMES.TF2BOSTONBASHER = "Boston Basher"
STRINGS.RECIPE_DESC.TF2BOSTONBASHER = "Bash your enemies or your self!"

return Prefab("common/inventory/tf2bostonbasher", fn, assets)