local assets =
{ 
    Asset("ANIM", "anim/tf2hot_dogger.zip"),
    Asset("ANIM", "anim/tf2hot_dogger_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/tf2hot_dogger.xml"),
    Asset("IMAGE", "images/inventoryimages/tf2hot_dogger.tex"),
}

local prefabs = 
{
}

local function hungerburn(inst, owner)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if owner ~= nil and inst.components.equippable and inst.components.equippable:IsEquipped() then
	local percent = inst.components.perishable:GetPercent()
	if percent >= .75 and owner.oldhungerburnrate then
	    owner.components.hunger.burnrate = owner.components.hunger.burnrate / 2 
	end
	if percent >= .50 and percent < .75 and owner.oldhungerburnrate then
	    owner.components.hunger.burnrate = owner.components.hunger.burnrate / 1.6 
	end
	if percent > .25 and percent < .50 and owner.oldhungerburnrate then
	    owner.components.hunger.burnrate = owner.components.hunger.burnrate / 1.4 
	end
	if percent <= .25 and owner.oldhungerburnrate then
	    owner.components.hunger.burnrate = owner.components.hunger.burnrate / 1.25
	end
    end
end

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", "tf2hot_dogger_swap", "swap_hat")	
	
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAIR_HAT")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
        
    if owner:HasTag("player") then
	owner.AnimState:Hide("HEAD")
	owner.AnimState:Show("HEAD_HAT")
    end

    if inst._feedtask == nil and owner.components.hunger then
	owner.oldhungerburnrate = owner.components.hunger.burnrate
	owner:ListenForEvent("perishchange", hungerburn)
        inst._feedtask = inst:DoPeriodicTask(TUNING.TF2HOTDOGGER_HUNGERSECONDS, function(inst)
	    local percent = inst.components.perishable:GetPercent()
	    if percent >= .75 then
		owner.components.hunger:DoDelta(5)
	    end
	    if percent >= .50 and percent < .75 then
		owner.components.hunger:DoDelta(4)
	    end
	    if percent > .25 and percent < .50 then
		owner.components.hunger:DoDelta(2)
	    end
	    if percent < .25 then
		owner.components.hunger:DoDelta(1)
	    end
	end)
    end

end
	
local function OnUnequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_hat")
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAIR_HAT")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAT")
    end

    if inst._feedtask ~= nil then
	owner:RemoveEventCallback("perishchange", hungerburn)
        inst._feedtask:Cancel()
        inst._feedtask = nil
    end

    if owner.components.hunger and owner.oldhungerburnrate then
        owner.components.hunger.burnrate = owner.oldhungerburnrate
    end
end
	
local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("tf2hot_dogger")
    inst.AnimState:SetBuild("tf2hot_dogger")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")
    inst:AddTag("show_spoilage")
    inst:AddTag("icebox_valid")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "tf2hot_dogger"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2hot_dogger.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED) --10 days
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.TF2HOT_DOGGER = "The Hot Dogger"
STRINGS.NAMES.TF2HOT_DOGGER = "Hot Dogger"
STRINGS.RECIPE_DESC.TF2HOT_DOGGER = "Can't go hungry with hot dogs."

return  Prefab("common/inventory/tf2hot_dogger", fn, assets, prefabs)