local assets =
{
	Asset("ANIM", "anim/tf2sandman.zip"),
	Asset("ANIM", "anim/swap_tf2sandman.zip"),

	Asset("ATLAS", "images/inventoryimages/tf2sandman.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2sandman.tex"),

	Asset("ATLAS", "images/inventoryimages/tf2sandman_charged.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2sandman_charged.tex"),
}


local function onattack_sandman(inst, attacker, target)
    local x, y, z = target.Transform:GetWorldPosition()
    local rck = SpawnPrefab("mining_fx")
    rck.Transform:SetPosition(x, y, z)
end

local function baseball(inst, target)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if owner and owner:HasTag("tf2scout") then
    owner.components.talker:Say(GetString(owner, "ANNOUNCE_SANDMAN_SWING"))
	end
	
    if inst.components.inventoryitem.owner ~= nil then
	local x1, y1, z1 = target.Transform:GetWorldPosition()
	local x2, y2, z2 = inst.components.inventoryitem.owner.Transform:GetWorldPosition()
	local dist = math.sqrt((x1 - x2)*(x1 - x2) + (z1 - z2)*(z1 - z2))
--[[	if dist >= 12 and dist < 14 then
	    TUNING.HOMERSTUN = 6
	end
	if dist >= 14 and dist < 16 then
	    TUNING.HOMERSTUN = 8
	end --]]
	if dist >= 16 and dist < 18 then
	    TUNING.HOMERSTUN = 10
	end
	if dist >= 18 then
	    TUNING.HOMERSTUN = 12
	end
	if dist > 16 then 
	    inst.components.weapon:SetProjectile("baseballprohr")

	end
	if dist <= 16 then 
	    inst.components.weapon:SetProjectile("baseballprojectile")
	end
    end

    inst:AddTag("empty")
    inst.components.fueled.currentfuel = 0
    inst.components.weapon:LaunchProjectile(inst, target)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/use_axe_tree")
    inst.components.weapon:SetProjectile()
    inst:RemoveComponent("spellcaster")
    inst.components.inventoryitem.imagename = "tf2sandman"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2sandman.xml"
    inst.components.inventoryitem:ChangeImageName("tf2sandman")
    inst.components.finiteuses:Use(10)

    inst.reloadtask = inst:DoTaskInTime(TUNING.TF2SCOUTBBALL_TIMER, function()
	inst:PushEvent("recharged")
    end)
end

local function reset(inst)
    if inst.reloadtask and inst.reloadtask ~= nil then
        inst.reloadtask:Cancel()
        inst.reloadtask = nil
    end

	local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if owner then
        owner.components.talker:Say(GetString(owner, "ANNOUNCE_BASEBALL_RETURNED"))
    end
	
    inst:RemoveTag("empty")
    inst.components.fueled.currentfuel = 1
    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canonlyuseonworkable = false
    inst.components.spellcaster.canonlyuseoncombat = true
    inst.components.spellcaster.quickcast = true
    inst.components.spellcaster:SetSpellFn(baseball)
    inst.components.inventoryitem.imagename = "tf2sandman_charged"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2sandman_charged.xml"
    inst.components.inventoryitem:ChangeImageName("tf2sandman_charged")
end

local function onload(inst)
    if inst.components.fueled.currentfuel ~= 1 then
        inst.reloadtask = inst:DoTaskInTime(TUNING.TF2SCOUTBBALL_TIMER, function()
	    inst:PushEvent("recharged")
        end)
    end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_tf2sandman", "tf2sandman")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst:AddTag("dull")
    inst:AddTag("quickcast")

    inst.spelltype = "SANDMAN"

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:SetBank("tf2sandman")
    inst.AnimState:SetBuild("tf2sandman")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TF2SANDMAN_DAMAGE) --The damage the bat does standalone
    inst.components.weapon:SetRange(1)
    inst.components.weapon:SetOnAttack(onattack_sandman)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "tf2sandman_charged"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2sandman_charged.xml"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TF2SANDMAN_USES)
    inst.components.finiteuses:SetUses(TUNING.TF2SANDMAN_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canonlyuseonworkable = false
    inst.components.spellcaster.canonlyuseoncombat = true
    inst.components.spellcaster.quickcast = true
    inst.components.spellcaster:SetSpellFn(baseball)

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.MAGIC
    inst.components.fueled:InitializeFuelLevel(1)

    inst:ListenForEvent("recharged", reset)

    inst.OnLoad = onload

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.TF2SANDMAN = "The Sandman"
STRINGS.NAMES.TF2SANDMAN = "Sandman"
STRINGS.RECIPE_DESC.TF2SANDMAN = "Smacks baseballs at things."

return Prefab("common/inventory/tf2sandman", fn, assets)