local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}

local prefabs = { "tf2scoutcap", "tf2scoutbag", "tf2scoutbat" }
local start_inv = { }

local function SetRampingSpeed(inst)
    inst.speedup = .351 / TUNING.RAMPERTIME
    if inst.timeinmotion == nil then
	inst.timeinmotion = 0
    end
    if inst.components.rider:IsRiding() then
	inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "tf2scout_speed")
	inst.timeinmotion = 0
	return
    end
    if inst.sg ~= nil and inst.sg:HasStateTag("moving") and inst.timeinmotion <= TUNING.RAMPERTIME -1  then
	inst.timeinmotion = inst.timeinmotion + 1
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "tf2scout_speed", 1 + (inst.timeinmotion * inst.speedup))
    end
    if inst.sg ~= nil and not inst.sg:HasStateTag("moving") and inst.timeinmotion >= 1 then
	if inst.timeinmotion == 1 then
	    inst.timeinmotion = inst.timeinmotion - 1
	end
	if inst.timeinmotion >= 2 then
	    inst.timeinmotion = inst.timeinmotion - 2
	end
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "tf2scout_speed", 1 + (inst.timeinmotion * inst.speedup))
    end
end

local function IsValidVictim(victim)
    return victim ~= nil
        and not (victim:HasTag("structure") or
                 victim:HasTag("wall"))
        and victim.components.health ~= nil
        and victim.components.combat ~= nil
end

local function onkilled(inst, data)
    local hand = inst.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
    local victim = data.victim

    if hand then
if not (hand:HasTag("tf2scoutbat") or hand:HasTag("tf2sandman") or hand:HasTag("holy_mackerel") or hand:HasTag("batbat") or hand:HasTag("hambat") or hand:HasTag("ruins_bat")) then
    if IsValidVictim(victim) then
        inst.components.talker:Say(GetString(inst, "ANNOUNCE_SCOUT_KILL"))
    end
end
if hand:HasTag("tf2scoutbat") or hand:HasTag("tf2sandman") or hand:HasTag("holy_mackerel") or hand:HasTag("batbat") or hand:HasTag("hambat") or hand:HasTag("ruins_bat") then
    if IsValidVictim(victim) then
inst.components.talker:Say(GetString(inst, "ANNOUNCE_SCOUT_BAT_KILL"))
    end
end
    end
end

local function OnEat(inst, food)
    if food.prefab == "bonkpunch" then
inst.components.talker:Say(GetString(inst, "ANNOUNCE_BONK_DRINK"))
    end
    if food.prefab == "crit_cola" then
inst.components.talker:Say(GetString(inst, "ANNOUNCE_CRITACOLA_DRINK"))
    end
end

local function onbecamehuman(inst)
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED + TUNING.SCOUT_RUN_SPEED_BONUS
end

local function onbecamehumantalker(inst)
	inst:DoTaskInTime(3,function()
	inst.components.talker:Say(GetString(inst, "ANNOUNCE_SCOUT_RESURRECTION"))
	end)
end

local function onbecameghost(inst)
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED --6
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local function equipscoutstuff(inst)

    local scoutcap = SpawnPrefab("tf2scoutcap")
    inst.components.inventory:Equip(scoutcap)
    local scoutbag = SpawnPrefab("tf2scoutbag")
    inst.components.inventory:Equip(scoutbag)
    local scoutbat = SpawnPrefab("tf2scoutbat")
    inst.components.inventory:Equip(scoutbat)
end

local common_postinit = function(inst) 
    inst.soundsname = "tf2scout"
	
    inst:AddTag("tf2scout")
    inst:AddComponent("scoutjump")

    inst.MiniMapEntity:SetIcon( "tf2scout.tex" )
end

local master_postinit = function(inst)

    -- Stats	
    inst.components.health:SetMaxHealth(125)
    inst.components.hunger:SetMax(150)
    inst.components.sanity:SetMax(175)
	
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED + TUNING.SCOUT_RUN_SPEED_BONUS --5%
    inst.components.locomotor.slowmultiplier = .54 --10% slower
    inst.components.locomotor.fastmultiplier = 1.17 --10% less faster
	
	inst:ListenForEvent("killed", onkilled)
	inst.components.eater:SetOnEatFn(OnEat)
	inst:ListenForEvent("ms_respawnedfromghost", onbecamehumantalker)

    inst.OnLoad = onload
    inst.OnNewSpawn = equipscoutstuff

    inst.ramper = inst:DoPeriodicTask(0, function()
    if TUNING.RAMPERTIME and TUNING.RAMPERTIME == 0 then
	inst.ramper:Cancel()
	inst.ramper = nil
        return
    end
	SetRampingSpeed(inst)
    end)
end

return MakePlayerCharacter("tf2scout", prefabs, assets, common_postinit, master_postinit, start_inv)