local ctn = require("containers")

local assets =
{
    Asset("ANIM", "anim/swap_tf2scoutbag.zip"),
    Asset("ANIM", "anim/ui_icepack_2x3.zip"),

    Asset("ATLAS", "images/inventoryimages/tf2scoutbag.xml"),
    Asset("IMAGE", "images/inventoryimages/tf2scoutbag.tex"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "swap_tf2scoutbag", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_tf2scoutbag", "swap_body")
    inst.components.container:Open(owner)
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")
    inst.components.container:Close(owner)
end

local function onburnt(inst)
    if inst.components.container then
        inst.components.container:DropEverything()
        inst.components.container:Close()
        inst:RemoveComponent("container")
    end

    local ash = SpawnPrefab("ash")
    ash.Transform:SetPosition(inst.Transform:GetWorldPosition())

    inst:Remove()
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("tf2scoutbag")
    inst.AnimState:SetBuild("swap_tf2scoutbag")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("backpack")

    inst.foleysound = "dontstarve/movement/foley/backpack"

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then	
	inst.OnEntityReplicated = function(inst) inst.replica.container:WidgetSetup("backpack") end	
	return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("backpack")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2scoutbag.xml"
    inst.components.inventoryitem.imagename = "tf2scoutbag"
    inst.components.inventoryitem.cangoincontainer = false

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.walkspeedmult = TUNING.SCOUTBAG_SPEED_MULT --1% faster

    inst.MiniMapEntity:SetIcon("tf2scoutbag.tex")

    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    inst.components.burnable:SetOnBurntFn(onburnt)

    MakeHauntableLaunchAndDropFirstItem(inst)

    return inst
end

STRINGS.TF2SCOUTBAG = "Scout's Baseball Bag"
STRINGS.NAMES.TF2SCOUTBAG = "Scout's Bag"
STRINGS.RECIPE_DESC.TF2SCOUTBAG = "Puts the duffel in your shuffle."

return Prefab("common/inventory/tf2scoutbag", fn, assets)