local assets =
{
	Asset("ANIM", "anim/tf2scoutbat.zip"),
	Asset("ANIM", "anim/swap_tf2scoutbat.zip"),

	Asset("ATLAS", "images/inventoryimages/tf2scoutbat.xml"),
	Asset("IMAGE", "images/inventoryimages/tf2scoutbat.tex"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_tf2scoutbat", "tf2scoutbat")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst:AddTag("dull")
	inst:AddTag("metal")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:SetBank("tf2scoutbat")
    inst.AnimState:SetBuild("tf2scoutbat")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TF2SCOUTBAT_DAMAGE)
    inst.components.weapon:SetRange(1)
--	inst.components.weapon:SetOnAttack(onattack_tf2bat)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("inventoryitem")

    inst.components.inventoryitem.imagename = "tf2scoutbat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2scoutbat.xml"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TF2SCOUTBAT_USES)
    inst.components.finiteuses:SetUses(TUNING.TF2SCOUTBAT_USES)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.TF2SCOUTBAT = "Scout's Baseball Bat"
STRINGS.NAMES.TF2SCOUTBAT = "Scout's Bat"
STRINGS.RECIPE_DESC.TF2SCOUTBAT = "Caves in a skull with no clumps of hair."

return Prefab("common/inventory/tf2scoutbat", fn, assets)