local assets =
{ 
    Asset("ANIM", "anim/tf2scoutcap.zip"),
    Asset("ANIM", "anim/tf2scoutcap_swap.zip"),  

    Asset("ATLAS", "images/inventoryimages/tf2scoutcap.xml"),
    Asset("IMAGE", "images/inventoryimages/tf2scoutcap.tex"),
}

local prefabs = 
{
}

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "tf2scoutcap_swap", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAIR_HAT")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")

    if owner:HasTag("player") then
	owner.AnimState:Hide("HEAD")
	owner.AnimState:Show("HEAD_HAT")
    end
end

local function OnUnequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_hat")
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAIR_HAT")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
	owner.AnimState:Show("HEAD")
	owner.AnimState:Hide("HEAD_HAT")
    end
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("tf2scoutcap")
    inst.AnimState:SetBuild("tf2scoutcap")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	
    inst:AddComponent("insulator")
    inst.components.insulator:SetSummer()
    inst.components.insulator:SetInsulation(TUNING.INSULATION_SMALL)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "tf2scoutcap"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tf2scoutcap.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	inst.components.equippable.walkspeedmult = TUNING.SCOUTCAP_SPEED_MULT --2% faster

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.TF2SCOUTCAP = "Scout's Baseball Cap"
STRINGS.NAMES.TF2SCOUTCAP = "Scout's Cap"
STRINGS.RECIPE_DESC.TF2SCOUTCAP = "A self-described beautiful hat."

return  Prefab("common/inventory/tf2scoutcap", fn, assets, prefabs)