﻿if (!chrome) chrome = {};
(function() {
    if (!chrome.extension) chrome.extension = {};
    if (!chrome.extension.getURL) chrome.extension.getURL = function (path) { return "/EnhancedSteam/" + path };
    var defaultSettings =
        "{\"language\":\"schinese\",\"highlight_owned_color\":\"#5c7836\",\"highlight_wishlist_color\":\"#1c3788\",\"highlight_coupon_color\":\"#a26426\",\"highlight_inv_gift_color\":\"#800040\",\"highlight_inv_guestpass_color\":\"#008080\",\"highlight_notinterested_color\":\"#4f4f4f\",\"tag_owned_color\":\"#5c7836\",\"tag_wishlist_color\":\"#1c3788\",\"tag_coupon_color\":\"#a26426\",\"tag_inv_gift_color\":\"#800040\",\"tag_inv_guestpass_color\":\"#008080\",\"tag_notinterested_color\":\"#4f4f4f\",\"highlight_owned\":true,\"highlight_wishlist\":true,\"highlight_coupon\":false,\"highlight_inv_gift\":false,\"highlight_inv_guestpass\":false,\"highlight_notinterested\":false,\"highlight_excludef2p\":false,\"tag_owned\":false,\"tag_wishlist\":false,\"tag_coupon\":false,\"tag_inv_gift\":false,\"tag_inv_guestpass\":false,\"tag_notinterested\":true,\"tag_short\":false,\"hide_owned\":false,\"hidetmsymbols\":false,\"showlowestprice\":true,\"showlowestprice_onwishlist\":true,\"showlowestpricecoupon\":true,\"showallstores\":true,\"stores\":{\"steam\":true,\"amazonus\":true,\"impulse\":true,\"gamersgate\":true,\"direct2drive\":true,\"origin\":true,\"uplay\":true,\"indiegalastore\":true,\"gamesplanet\":true,\"indiegamestand\":true,\"gog\":true,\"nuuvem\":true,\"dlgamer\":true,\"humblestore\":true,\"squenix\":true,\"bundlestars\":true,\"fireflower\":true,\"humblewidgets\":true,\"newegg\":true,\"coinplay\":true,\"wingamestore\":true,\"macgamestore\":true,\"gamebillet\":true,\"silagames\":true,\"itchio\":true,\"gamejolt\":true,\"paradox\":true},\"override_price\":\"auto\",\"showregionalprice\":\"mouse\",\"regional_countries\":[\"cn\",\"us\",\"gb\",\"eu1\",\"ru\",\"br\",\"au\",\"jp\"],\"showtotal\":true,\"showmarkettotal\":true,\"showsteamrepapi\":true,\"showmcus\":true,\"showoc\":true,\"showhltb\":true,\"showpcgw\":true,\"showclient\":true,\"showsteamcardexchange\":false,\"showsteamdb\":true,\"showastatslink\":true,\"showwsgf\":true,\"show_keylol_links\":true,\"show_package_info\":false,\"show_sysreqcheck\":false,\"show_steamchart_info\":true,\"show_steamspy_info\":true,\"show_early_access\":true,\"show_alternative_linux_icon\":false,\"show_itad_button\":false,\"skip_got_steam\":false,\"hideinstallsteambutton\":false,\"hideaboutmenu\":false,\"showemptywishlist\":true,\"version_show\":false,\"replaceaccountname\":false,\"showfakeccwarning\":true,\"showlanguagewarning\":true,\"showlanguagewarninglanguage\":\"Schinese\",\"homepage_tab_selection\":\"remember\",\"send_age_info\":true,\"html5video\":true,\"contscroll\":true,\"showdrm\":true,\"show_acrtag_info\":false,\"regional_hideworld\":false,\"showinvnav\":true,\"showesbg\":true,\"quickinv\":true,\"quickinv_diff\":-0.01,\"showallachievements\":false,\"showachinstore\":true,\"showcomparelinks\":false,\"hideactivelistings\":false,\"hidespamcomments\":false,\"spamcommentregex\":\"[\\\\u2500-\\\\u25FF]\",\"wlbuttoncommunityapp\":true,\"removeguideslanguagefilter\":false,\"disablelinkfilter\":false,\"show1clickgoo\":true,\"show_profile_link_images\":\"gray\",\"profile_steamrepcn\":true,\"profile_steamgifts\":true,\"profile_steamtrades\":true,\"profile_steamrep\":true,\"profile_steamdbcalc\":true,\"profile_astats\":true,\"profile_backpacktf\":true,\"profile_astatsnl\":true,\"profile_permalink\":true,\"profile_custom\":false,\"profile_custom_name\":\"Google\",\"profile_custom_url\":\"google.com/search?q=[ID]\",\"profile_custom_icon\":\"www.google.com/images/branding/product/ico/googleg_lodp.ico\",\"steamcardexchange\":true,\"purchase_dates\":true,\"add_wallet_balance\":true,\"add_to_cart_wishlist\":true,\"show_badge_progress\":true,\"show_wishlist_link\":true,\"show_wishlist_count\":true}";
    if (!chrome.storage) {
        var storage = {
            set: (items, callback) => {
                var store = JSON.parse(window.localStorage.getItem("EnhancedSteamStorage") || defaultSettings);
                Object.assign(store, items);
                window.localStorage.setItem("EnhancedSteamStorage", JSON.stringify(store));
                if (callback) callback();
            },
            remove: (keys, callback) => {
                var store = JSON.parse(window.localStorage.getItem("EnhancedSteamStorage") || defaultSettings);
                if (typeof keys === "string") {
                    delete store[keys];
                } else {
                    for (var i = 0; i < keys.length; ++i) {
                        delete store[keys[i]];
                    }
                }
                window.localStorage.setItem("EnhancedSteamStorage", JSON.stringify(store));
                if (callback) callback();
            },
            get: (keys, callback) => {
                if (typeof keys === "function") {
                    callback = keys;
                    keys = null;
                }
                var store = JSON.parse(window.localStorage.getItem("EnhancedSteamStorage") || defaultSettings);
                var items = {};
                if (keys === null || keys === undefined) {
                    items = store;
                } else if (typeof keys === "string") {
                    items[keys] = store[keys];
                } else if (Array.isArray(keys)) {
                    for (var i = 0; i < keys.length; ++i) {
                        items[keys[i]] = store[keys[i]];
                    }
                } else {
                    for (var key in keys) {
                        if (!keys.hasOwnProperty(key)) return;
                        items[key] = store[key] === null || store[key] === undefined ? keys[key] : store[key];
                    }
                }
                callback(items);
            }
        }
        chrome.storage = {
            local: storage,
            sync: storage
        }
    }
})();