/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import java.util.regex.Pattern;

public class DockerUtil {
    private static final Pattern ID_PATTERN = Pattern.compile("[0-9a-f]+");
    private static final int ID_SHORT_LENGTH = 12;
    private static final String ID_PREFIX = "sha256:";

    public static String shortedId(String id) {
        if (id.length() > 12) {
            if (id.startsWith(ID_PREFIX) && ID_PATTERN.matcher(id.substring(ID_PREFIX.length())).matches()) {
                return id.substring(0, 12 + ID_PREFIX.length());
            }
            if (ID_PATTERN.matcher(id).matches()) {
                return id.substring(0, 12);
            }
        }
        return id;
    }

    public static boolean isStartedStatus(String status) {
        return status == null || status.startsWith("Up");
    }

    public static boolean isStoppedStatus(String status) {
        return status != null && (status.startsWith("Exited") || status.startsWith("Created"));
    }
}

