/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.config;

import com.dmarcotte.handlebars.config.Property;
import com.dmarcotte.handlebars.config.PropertyAccessor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbConfig {
    public static boolean isAutoGenerateCloseTagEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.AUTO_GENERATE_CLOSE_TAG);
    }

    public static void setAutoGenerateCloseTagEnabled(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.AUTO_GENERATE_CLOSE_TAG, enabled);
    }

    public static boolean isAutocompleteMustachesEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.AUTOCOMPLETE_MUSTACHES);
    }

    public static void setAutocompleteMustachesEnabled(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.AUTOCOMPLETE_MUSTACHES, enabled);
    }

    public static boolean isFormattingEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.FORMATTER);
    }

    public static void setFormattingEnabled(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.FORMATTER, enabled);
    }

    public static boolean isAutoCollapseBlocksEnabled() {
        return HbConfig.getBooleanPropertyValue(Property.AUTO_COLLAPSE_BLOCKS);
    }

    public static void setAutoCollapseBlocks(boolean enabled) {
        HbConfig.setBooleanPropertyValue(Property.AUTO_COLLAPSE_BLOCKS, enabled);
    }

    @NotNull
    public static Language getCommenterLanguage() {
        Language id = Language.findLanguageByID((String)HbConfig.getStringPropertyValue(Property.COMMENTER_LANGUAGE_ID));
        Object object = id == null ? HTMLLanguage.INSTANCE : id;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/config/HbConfig", "getCommenterLanguage"));
        }
        return object;
    }

    public static void setCommenterLanguage(Language language) {
        if (language == null) {
            HbConfig.setStringPropertyValue(Property.COMMENTER_LANGUAGE_ID, null);
        } else {
            HbConfig.setStringPropertyValue(Property.COMMENTER_LANGUAGE_ID, language.getID());
        }
    }

    public static String getRawOpenHtmlAsHandlebarsValue(Project project) {
        return HbConfig.getStringPropertyValue(Property.SHOULD_OPEN_HTML, project);
    }

    public static boolean shouldOpenHtmlAsHandlebars(Project project) {
        String value = HbConfig.getRawOpenHtmlAsHandlebarsValue(project);
        return "enabled".equals(value);
    }

    public static boolean setShouldOpenHtmlAsHandlebars(boolean value, Project project) {
        HbConfig.setBooleanPropertyValue(Property.SHOULD_OPEN_HTML, value, project);
        return true;
    }

    private static String getStringPropertyValue(Property property, Project project) {
        return new PropertyAccessor(HbConfig.getProperties(project)).getPropertyValue(property);
    }

    @NotNull
    private static PropertiesComponent getProperties(@Nullable Project project) {
        PropertiesComponent propertiesComponent = project == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project);
        if (propertiesComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/dmarcotte/handlebars/config/HbConfig", "getProperties"));
        }
        return propertiesComponent;
    }

    private static void setStringPropertyValue(@NotNull Property property, @Nullable String value, @Nullable Project project) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/dmarcotte/handlebars/config/HbConfig", "setStringPropertyValue"));
        }
        new PropertyAccessor(HbConfig.getProperties(project)).setPropertyValue(property, value);
    }

    private static String getStringPropertyValue(Property property) {
        return HbConfig.getStringPropertyValue(property, null);
    }

    private static void setStringPropertyValue(Property property, String value) {
        HbConfig.setStringPropertyValue(property, value, null);
    }

    private static boolean getBooleanPropertyValue(Property property) {
        return "enabled".equals(HbConfig.getStringPropertyValue(property));
    }

    private static void setBooleanPropertyValue(@NotNull Property property, boolean enabled, @Nullable Project project) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/dmarcotte/handlebars/config/HbConfig", "setBooleanPropertyValue"));
        }
        HbConfig.setStringPropertyValue(property, enabled ? "enabled" : "disabled", project);
    }

    private static void setBooleanPropertyValue(Property property, boolean enabled) {
        HbConfig.setBooleanPropertyValue(property, enabled, null);
    }
}

